/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes;

import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.AppointmentPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.text.DateFormat;
import java.util.GregorianCalendar;
import javax.swing.JComponent;
import javax.swing.border.Border;

public abstract class HourLabelsPanel
extends OrientablePanel {
    private static final Dimension LABEL_DIMENTION = new Dimension(PLAFChanger.getFontSize() * 5 - 10, AppointmentPanel.QUARTER_LABEL_HEIGHT * 4);
    private Border border;

    public HourLabelsPanel(Border border) {
        super(new GridLayout(0, 1, 0, 0));
        this.border = border;
        this.init();
        this.buildUI();
    }

    protected abstract void init();

    protected abstract JComponent getLabel(GregorianCalendar var1, DateFormat var2);

    private void buildUI() {
        this.setBackground(ColorConstants.TIME_PANEL_COLOR);
        GregorianCalendar gregorianCalendar = GWCalendarUtils.getToday();
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        DateFormat dateFormat = this.getTimeFormat();
        for (int i = 0; i < 24; ++i) {
            JComponent jComponent = this.getLabel(gregorianCalendar, dateFormat);
            jComponent.setPreferredSize(LABEL_DIMENTION);
            jComponent.setMinimumSize(LABEL_DIMENTION);
            jComponent.setMaximumSize(LABEL_DIMENTION);
            jComponent.setBorder(this.border);
            this.add(jComponent);
            gregorianCalendar.add(10, 1);
        }
    }

    protected DateFormat getTimeFormat() {
        return GWCalendarUtils.getTimeFormat();
    }

    public static int getPanelWidth() {
        return HourLabelsPanel.LABEL_DIMENTION.width;
    }
}

