/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar;

import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarModelListener;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.DayCell;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;

public class CalendarModel {
    protected GregorianCalendar data;
    protected DayCell[] dayCells = new DayCell[42];
    private DayCell[] labelCells = new DayCell[7];
    private ArrayList listeners;
    protected String userGuid;

    public CalendarModel() {
        this(new GregorianCalendar());
    }

    public CalendarModel(GregorianCalendar gregorianCalendar) {
        this.listeners = new ArrayList();
        this.setDate(gregorianCalendar);
    }

    public CalendarModel(GregorianCalendar gregorianCalendar, String string) {
        this.userGuid = string;
        this.listeners = new ArrayList();
        this.setDate(gregorianCalendar);
    }

    protected void init() {
        this.initLabelCells();
        this.initDayCells();
    }

    public void setUserGuid(String string) {
        this.userGuid = string;
    }

    protected void initDayCells() {
        GregorianCalendar gregorianCalendar = GWCalendarUtils.initCalendar(this.data);
        for (int i = 0; i < this.dayCells.length; ++i) {
            DayCell dayCell = new DayCell();
            dayCell.setIndex(i);
            this.dayCells[i] = dayCell;
            gregorianCalendar.add(5, 1);
            if (gregorianCalendar.get(2) != this.data.get(2)) continue;
            if (gregorianCalendar.get(7) == 1 || gregorianCalendar.get(7) == 7) {
                dayCell.setForeground(ColorConstants.clrDaysHoly);
            } else {
                dayCell.setForeground(ColorConstants.clrDaysWork);
            }
            String string = "" + gregorianCalendar.get(5);
            dayCell.setText(string);
            dayCell.setTime(gregorianCalendar.getTime());
        }
    }

    private void initLabelCells() {
        int n = this.data.getFirstDayOfWeek();
        for (int i = 0; i < this.labelCells.length; ++i) {
            int n2 = i + n - 1;
            if (n2 >= 7) {
                n2 %= 7;
            }
            DayCell dayCell = new DayCell();
            dayCell.setIndex(i);
            dayCell.setText(GWCalendarUtils.dayShortestNames[n2]);
            dayCell.setForeground(ColorConstants.clrDaysWork);
            if (n == 1) {
                if (i == 0 || i == 6) {
                    dayCell.setForeground(ColorConstants.clrDaysHoly);
                }
            } else if (UIUtils.getComponentOrientation().isLeftToRight()) {
                if (i == 5 || i == 6) {
                    dayCell.setForeground(ColorConstants.clrDaysHoly);
                }
            } else if (i == 0 || i == 1) {
                dayCell.setForeground(ColorConstants.clrDaysHoly);
            }
            this.labelCells[i] = dayCell;
        }
    }

    public DayCell getLabelCell(int n) {
        return this.labelCells[n];
    }

    public DayCell getDayCell(int n) {
        return this.dayCells[n];
    }

    public DayCell getDayCell(Point point) {
        for (int i = 0; i < this.dayCells.length; ++i) {
            DayCell dayCell = this.dayCells[i];
            if (!dayCell.contains(point)) continue;
            return dayCell;
        }
        return null;
    }

    public int getCellIndex(DayCell dayCell) {
        if (dayCell != null) {
            return dayCell.getIndex();
        }
        return -1;
    }

    public int size() {
        return this.dayCells.length;
    }

    public int labelsSize() {
        return this.labelCells.length;
    }

    public DayCell getFirstCell() {
        int n = 0;
        DayCell dayCell = this.dayCells[n];
        while (dayCell.getTime() == null) {
            dayCell = this.dayCells[++n];
        }
        return dayCell;
    }

    public DayCell getLastCell() {
        int n = this.dayCells.length - 1;
        DayCell dayCell = this.dayCells[n];
        while (dayCell.getTime() == null) {
            dayCell = this.dayCells[--n];
        }
        return dayCell;
    }

    public DayCell getCurrentCell() {
        String string = GWCalendarUtils.getDateFormat().format(this.data.getTime());
        for (int i = 0; i < this.dayCells.length; ++i) {
            String string2;
            DayCell dayCell = this.dayCells[i];
            Date date = dayCell.getTime();
            if (date == null || !string.equals(string2 = GWCalendarUtils.getDateFormat().format(dayCell.getTime()))) continue;
            return dayCell;
        }
        return null;
    }

    public void removeModelListener(CalendarModelListener calendarModelListener) {
        this.listeners.remove(calendarModelListener);
    }

    public void addModelListener(CalendarModelListener calendarModelListener) {
        this.listeners.add(calendarModelListener);
    }

    protected void fireModelChenged(CalendarEvent calendarEvent) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            CalendarModelListener calendarModelListener = (CalendarModelListener)this.listeners.get(i);
            calendarModelListener.modelChanged(calendarEvent);
        }
    }

    public GregorianCalendar getDate() {
        return (GregorianCalendar)this.data.clone();
    }

    public void setDate(GregorianCalendar gregorianCalendar) {
        int n = GWCalendarUtils.getChangeMask(this.data, gregorianCalendar);
        if (this.data == null) {
            this.data = (GregorianCalendar)gregorianCalendar.clone();
        } else {
            this.data.setTime(gregorianCalendar.getTime());
        }
        CalendarEvent calendarEvent = new CalendarEvent(n, gregorianCalendar);
        if (calendarEvent.isMonthChanged() || calendarEvent.isYearChanged()) {
            this.init();
        }
        this.fireModelChenged(calendarEvent);
    }
}

