/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar;

import com.appframework.components.customizedbutton.ToolBarButton;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarComponent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarModel;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarModelListener;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateValueChangeListener;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBar;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class MonthlyCalendar
extends JComponent
implements CalendarModelListener {
    public static final Color ACTIVE_HEADER_COLOR = Color.BLUE;
    public static final Color INACTIVE_HEADER_COLOR = Color.GRAY;
    public static final Color FOOTER_COLOR = Color.WHITE;
    public static final int DEFAULT_HEADER_HEIGHT = PLAFChanger.getFontSize() + 10;
    public static final int DEFAULT_FOOTER_HEIGHT = PLAFChanger.getFontSize() + 6;
    public final Border inactiveBorder = new LineBorder(Color.GRAY, 1);
    public final Border activeBorder = new LineBorder(Color.BLACK, 1);
    protected CalendarComponent calendar;
    private int headerHeight;
    protected int footerHeight;
    private Border currentBorder = this.inactiveBorder;
    private JLabel headerLabel;
    private JPanel header;
    protected JLabel footerLabel;
    protected JPanel footer;
    private ArrayList listeners;
    private boolean allowNavigation;
    private Dimension size;

    public MonthlyCalendar(CalendarModel calendarModel, ListSelectionModel listSelectionModel, boolean bl, int n, int n2) {
        if (calendarModel == null) {
            throw new IllegalArgumentException("Calendar data model can not be null");
        }
        this.setLayout(new BorderLayout());
        this.headerHeight = n;
        this.footerHeight = n2;
        this.listeners = new ArrayList();
        this.allowNavigation = bl;
        calendarModel.addModelListener(this);
        this.createCalendar(calendarModel, listSelectionModel);
        this.add((Component)this.calendar, "Center");
        this.initHeader();
        this.add((Component)this.header, "North");
        if (this.allowNavigation) {
            this.initFooter();
            this.add((Component)this.footer, "South");
        }
        CalendarMouseListener calendarMouseListener = new CalendarMouseListener();
        this.addMouseListener(calendarMouseListener);
        KeyboardListener keyboardListener = new KeyboardListener();
        this.addKeyListener(keyboardListener);
        FocuseListener focuseListener = new FocuseListener();
        this.addFocusListener(focuseListener);
        this.setFocusable(true);
        this.setBorder(this.currentBorder);
    }

    public MonthlyCalendar(CalendarModel calendarModel, ListSelectionModel listSelectionModel, boolean bl) {
        this(calendarModel, listSelectionModel, bl, DEFAULT_HEADER_HEIGHT, DEFAULT_FOOTER_HEIGHT);
    }

    protected void createCalendar(CalendarModel calendarModel, ListSelectionModel listSelectionModel) {
        this.calendar = new CalendarComponent(calendarModel, listSelectionModel);
    }

    public MonthlyCalendar(GregorianCalendar gregorianCalendar, boolean bl, boolean bl2) {
        this(new CalendarModel(gregorianCalendar), null, bl, bl2);
    }

    public MonthlyCalendar(CalendarModel calendarModel, ListSelectionModel listSelectionModel, boolean bl, boolean bl2) {
        this(calendarModel, listSelectionModel, bl, DEFAULT_HEADER_HEIGHT, bl2 ? DEFAULT_FOOTER_HEIGHT : 0);
    }

    private void initSize() {
        Insets insets = this.currentBorder.getBorderInsets(this);
        int n = this.calendar.getPreferredSize().width + insets.left + insets.right;
        int n2 = this.calendar.getPreferredSize().height + this.headerHeight + insets.top + insets.bottom;
        if (this.allowNavigation) {
            n2 += this.footerHeight;
        }
        this.size = new Dimension(n, n2);
    }

    protected void initFooter() {
        this.footer = new OrientablePanel(new BorderLayout());
        this.footer.setOpaque(true);
        this.footer.setBackground(FOOTER_COLOR);
        this.footerLabel = new OrientableLabel();
        this.footerLabel.setHorizontalAlignment(0);
        this.footerLabel.setVerticalAlignment(0);
        this.footerLabel.addMouseListener(new TodayMouserListener());
        Font font = this.footerLabel.getFont();
        Font font2 = new Font(font.getName(), 0, font.getSize());
        this.footerLabel.setFont(font2);
        this.footerLabel.setPreferredSize(new Dimension(this.calendar.getPreferredSize().width, DEFAULT_FOOTER_HEIGHT));
        this.footerLabel.setIconTextGap(4);
        this.footerLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.footerLabel.setIcon(ImageResources.ACT_GOTO_TODAY);
        this.footerLabel.setText(StringResources.TODAY + ": " + GWCalendarUtils.getDateFormat().format(GWCalendarUtils.getToday().getTime()));
        this.footer.add((Component)this.footerLabel, "Center");
    }

    private void initHeader() {
        this.header = new OrientablePanel(new BorderLayout());
        this.header.setOpaque(true);
        this.header.setBackground(INACTIVE_HEADER_COLOR);
        this.headerLabel = new OrientableLabel();
        this.headerLabel.setForeground(Color.WHITE);
        this.headerLabel.setHorizontalAlignment(0);
        this.headerLabel.setVerticalAlignment(0);
        Font font = this.headerLabel.getFont();
        Font font2 = new Font(font.getName(), 1, font.getSize());
        this.headerLabel.setFont(font2);
        this.headerLabel.setPreferredSize(new Dimension(this.calendar.getPreferredSize().width, this.headerHeight));
        this.header.add((Component)this.headerLabel, "Center");
        this.updateHeaderLabel();
        if (this.allowNavigation) {
            this.initNavigationButtons();
        }
    }

    private void initNavigationButtons() {
        this.header.add((Component)this.getLessMoreButtons(1), "Before");
        this.header.add((Component)this.getLessMoreButtons(2), "After");
    }

    private JComponent getLessMoreButtons(int n) {
        GWToolBar gWToolBar = new GWToolBar(new BorderLayout(1, 1));
        gWToolBar.setBorder(null);
        gWToolBar.setOpaque(false);
        Insets insets = new Insets(2, 2, 2, 2);
        ToolBarButton toolBarButton = new ToolBarButton();
        ImageIcon imageIcon = UIUtils.getComponentOrientation().isLeftToRight() ? ImageResources.ACT_LESS_WHITE : ImageResources.ACT_MORE_WHITE;
        toolBarButton.setIcon(imageIcon);
        toolBarButton.setOpaque(false);
        ((AbstractButton)toolBarButton).setMargin(insets);
        toolBarButton.addActionListener(new NavigationAction(-n));
        gWToolBar.add((Component)toolBarButton, "Before");
        toolBarButton = new ToolBarButton();
        imageIcon = UIUtils.getComponentOrientation().isLeftToRight() ? ImageResources.ACT_MORE_WHITE : ImageResources.ACT_LESS_WHITE;
        toolBarButton.setIcon(imageIcon);
        toolBarButton.setOpaque(false);
        ((AbstractButton)toolBarButton).setMargin(insets);
        toolBarButton.addActionListener(new NavigationAction(n));
        gWToolBar.add((Component)toolBarButton, "After");
        return gWToolBar;
    }

    public Dimension getPreferredSize() {
        return this.size;
    }

    public void setBorder(Border border) {
        if (this.currentBorder == null) {
            return;
        }
        if (!this.currentBorder.equals(this.getBorder())) {
            this.initSize();
            super.setBorder(this.currentBorder);
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, this.size.width, this.size.height);
    }

    protected void handleFocus(boolean bl) {
        this.currentBorder = bl ? this.activeBorder : this.inactiveBorder;
        this.header.setBackground(bl ? ACTIVE_HEADER_COLOR : INACTIVE_HEADER_COLOR);
        this.setBorder(this.currentBorder);
    }

    protected void handleClick(Point point, boolean bl, boolean bl2) {
        Point point2 = SwingUtilities.convertPoint(this, point, this.calendar);
        this.calendar.handleClick(point2, bl);
    }

    public void modelChanged(CalendarEvent calendarEvent) {
        if (calendarEvent.isMonthChanged() || calendarEvent.isYearChanged()) {
            this.calendar.update();
            this.updateHeaderLabel();
        }
        this.calendar.updateSelection();
        this.fireValueChanged(new DateChangeEvent(calendarEvent.getDate(), this));
    }

    protected void fireValueChanged(DateChangeEvent dateChangeEvent) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            DateValueChangeListener dateValueChangeListener = (DateValueChangeListener)this.listeners.get(i);
            dateValueChangeListener.valueChanged(dateChangeEvent);
        }
    }

    public void addValueChangeListener(DateValueChangeListener dateValueChangeListener) {
        this.listeners.add(dateValueChangeListener);
    }

    public void removeValueChangeListener(DateValueChangeListener dateValueChangeListener) {
        this.listeners.remove(dateValueChangeListener);
    }

    private void updateHeaderLabel() {
        String string = GWCalendarUtils.monthNames[this.calendar.getModel().getDate().get(2)];
        int n = this.calendar.getModel().getDate().get(1);
        String string2 = PLAFChanger.isAsianLang() ? n + " " + string : string + " " + n;
        this.headerLabel.setText(string2);
    }

    private void handleKey(int n, boolean bl) {
        this.calendar.handleKey(n, bl, this.allowNavigation);
    }

    public GregorianCalendar getDate() {
        return this.calendar.getModel().getDate();
    }

    public void setDate(GregorianCalendar gregorianCalendar) {
        this.calendar.getModel().setDate(gregorianCalendar);
    }

    public void gotoToday() {
        this.calendar.gotoToday();
    }

    private class TodayMouserListener
    extends MouseAdapter {
        private TodayMouserListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            MonthlyCalendar monthlyCalendar = MonthlyCalendar.this;
            if (!monthlyCalendar.isFocusOwner()) {
                monthlyCalendar.grabFocus();
            }
            monthlyCalendar.gotoToday();
        }
    }

    private class NavigationAction
    extends AbstractAction {
        int shift;

        public NavigationAction(int n) {
            this.shift = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MonthlyCalendar monthlyCalendar = MonthlyCalendar.this;
            if (!monthlyCalendar.isFocusOwner()) {
                monthlyCalendar.grabFocus();
            }
            monthlyCalendar.calendar.navigate(this.shift, true);
        }
    }

    private class CalendarMouseListener
    extends MouseAdapter {
        private CalendarMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            MonthlyCalendar monthlyCalendar = MonthlyCalendar.this;
            if (!monthlyCalendar.isFocusOwner()) {
                monthlyCalendar.grabFocus();
            }
            monthlyCalendar.handleClick(mouseEvent.getPoint(), mouseEvent.isShiftDown(), OS.isDoubleClick(mouseEvent));
        }
    }

    private class FocuseListener
    implements FocusListener {
        private FocuseListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            MonthlyCalendar.this.handleFocus(true);
        }

        public void focusLost(FocusEvent focusEvent) {
            MonthlyCalendar.this.handleFocus(false);
        }
    }

    private class KeyboardListener
    extends KeyAdapter {
        private KeyboardListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            MonthlyCalendar.this.handleKey(keyEvent.getKeyCode(), keyEvent.isShiftDown());
        }
    }
}

