/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector;

import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.MonthlyCalendar;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateDocumentHandler;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateSelectorPopup;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateTextField;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateValueChangeListener;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBar;
import com.novell.gw.jclient.application.resources.ImageResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class DateSelector
extends GWToolBar
implements DateValueChangeListener {
    protected DateTextField dateField;
    protected AbstractButton pickerButton;
    private MonthlyCalendar calendar;
    private DateSelectorPopup popup;
    private ArrayList listeners;
    private GregorianCalendar oldDate;

    public DateSelector() {
        this(GWCalendarUtils.getToday());
    }

    public DateSelector(GregorianCalendar gregorianCalendar) {
        if (gregorianCalendar == null) {
            throw new IllegalArgumentException("Date can not be NULL");
        }
        this.listeners = new ArrayList();
        this.init();
        this.setDate(gregorianCalendar);
        this.setBorder(null);
    }

    public void setDate(GregorianCalendar gregorianCalendar) {
        this.removeListeners();
        this.calendar.setDate(gregorianCalendar);
        this.dateField.setDate(gregorianCalendar);
        this.addListeners();
    }

    public GregorianCalendar getDate() {
        this.dateField.commit();
        return this.dateField.getDate();
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        this.dateField = new DateTextField(GWCalendarUtils.getDateFormat(), new DateDocumentHandler());
        this.dateField.addKeyListener(new DatePickerListener());
        this.add((Component)this.dateField, "Center");
        this.initPickerButton();
        this.add((Component)this.pickerButton, "After");
        this.calendar = new MonthlyCalendar(GWCalendarUtils.getToday(), true, true);
    }

    private void addListeners() {
        this.calendar.addValueChangeListener(this);
        this.dateField.addValueChangeListener(this);
    }

    private void removeListeners() {
        this.calendar.removeValueChangeListener(this);
        this.dateField.removeValueChangeListener(this);
    }

    protected void initPickerButton() {
        this.pickerButton = UIUtils.createToolButton(new DatePickerAction());
        this.pickerButton.setIcon(ImageResources.ACT_DATEPICKER);
    }

    private void initPopup() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window instanceof JFrame) {
            this.popup = new DateSelectorPopup((JFrame)window, this.calendar);
        }
        if (window instanceof JDialog) {
            this.popup = new DateSelectorPopup((JDialog)window, this.calendar);
        }
    }

    protected void showPopup(Component component) {
        if (this.popup == null) {
            this.initPopup();
        }
        if (this.popup != null) {
            int n = component.getLocationOnScreen().x - this.calendar.getPreferredSize().width;
            int n2 = component.getLocationOnScreen().y + component.getHeight();
            this.popup.setLocation(n, n2);
            this.popup.show();
        }
    }

    protected void handleKey(int n) {
        switch (n) {
            case 40: {
                this.showPopup(this.pickerButton);
            }
        }
    }

    public void valueChanged(DateChangeEvent dateChangeEvent) {
        GregorianCalendar gregorianCalendar = dateChangeEvent.getDate();
        if (dateChangeEvent.getSource() instanceof DateTextField) {
            this.calendar.setDate(gregorianCalendar);
        } else if (dateChangeEvent.getSource() instanceof MonthlyCalendar) {
            this.dateField.setDate(gregorianCalendar);
        }
        if (!gregorianCalendar.equals(this.oldDate)) {
            this.oldDate = gregorianCalendar;
            this.fireDateChanged(new DateChangeEvent(gregorianCalendar, this));
        }
    }

    private void fireDateChanged(DateChangeEvent dateChangeEvent) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            DateValueChangeListener dateValueChangeListener = (DateValueChangeListener)this.listeners.get(i);
            dateValueChangeListener.valueChanged(dateChangeEvent);
        }
    }

    public void addDateChangeListener(DateValueChangeListener dateValueChangeListener) {
        this.listeners.add(dateValueChangeListener);
    }

    public void removeDateChangeListener(DateValueChangeListener dateValueChangeListener) {
        this.listeners.remove(dateValueChangeListener);
    }

    public JTextComponent getTextComponent() {
        return this.dateField;
    }

    public void setIcon(ImageIcon imageIcon) {
        this.pickerButton.setIcon(imageIcon);
    }

    private class DatePickerListener
    extends KeyAdapter {
        private DatePickerListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            DateSelector.this.handleKey(n);
        }
    }

    private class DatePickerAction
    extends AbstractAction {
        private DatePickerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!DateSelector.this.dateField.isFocusOwner()) {
                DateSelector.this.dateField.grabFocus();
            }
            Component component = (Component)actionEvent.getSource();
            DateSelector.this.showPopup(component);
        }
    }
}

