/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector;

import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DocumentChangeHandler;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DurationFormat;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.controls.timepicker.DurationChangeEvent;
import com.novell.gw.jclient.application.controls.timepicker.DurationChangeListener;
import com.novell.gw.jclient.application.controls.timepicker.MutableTextField;
import com.novell.gw.jclient.bl.om.items.TimeDuration;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.apache.log4j.Logger;

public class DurationTextField
extends OrientableTextField
implements MutableTextField {
    private static final Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$gwcalendar$monthlycalendar$selector$DurationTextField == null ? (class$com$novell$gw$jclient$application$controls$gwcalendar$monthlycalendar$selector$DurationTextField = DurationTextField.class$("com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DurationTextField")) : class$com$novell$gw$jclient$application$controls$gwcalendar$monthlycalendar$selector$DurationTextField));
    private ArrayList listeners;
    private DurationFormat format;
    private DocumentChangeHandler documentHandler;
    private TimeDuration duration = new TimeDuration(0, 0);
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$gwcalendar$monthlycalendar$selector$DurationTextField;

    public DurationTextField(DurationFormat durationFormat, DocumentChangeHandler documentChangeHandler) {
        this(durationFormat, documentChangeHandler, new TimeDuration(0, 0));
    }

    public DurationTextField(DurationFormat durationFormat, DocumentChangeHandler documentChangeHandler, TimeDuration timeDuration) {
        if (durationFormat == null) {
            throw new IllegalArgumentException("Date format can not be NULL");
        }
        if (documentChangeHandler == null) {
            throw new IllegalArgumentException("Document handler can not be NULL");
        }
        this.format = durationFormat;
        this.documentHandler = documentChangeHandler;
        this.listeners = new ArrayList();
        this.setDocument(new TextDocument());
        this.addFocusListener(new CommitFocusListener());
        this.setDuration(timeDuration);
    }

    public void setDuration(TimeDuration timeDuration) {
        if (timeDuration == null) {
            throw new IllegalArgumentException("Duration can not be NULL");
        }
        if (timeDuration.getDuration() <= 0) {
            timeDuration = new TimeDuration(timeDuration.getStartMinutes(), timeDuration.getStartMinutes() + this.documentHandler.getDefaultShift());
        }
        if (!this.duration.equals(timeDuration)) {
            this.duration = timeDuration;
            this.refreshText();
            this.fireDurationChanged(new DurationChangeEvent(null, this.duration, this));
        }
    }

    private void refreshText() {
        String string = this.format.format(this.duration);
        this.setText(string);
    }

    private void handleFocusLost() {
        this.commit();
    }

    public void commit() {
        String string = this.getText();
        try {
            TimeDuration timeDuration = this.format.parse(this.duration.getStartMinutes(), string);
            this.setDuration(timeDuration);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.refreshText();
    }

    protected boolean handleChange(String string) {
        if (this.documentHandler.canHandle(string)) {
            this.handleChange(this.documentHandler.getField(string), this.documentHandler.getShift(string));
            return true;
        }
        return false;
    }

    private void handleChange(int n, int n2) {
        this.unselectAll();
        this.commit();
        TimeDuration timeDuration = new TimeDuration(this.duration.getStartMinutes(), this.duration.getEndMinutes() + n2);
        this.setDuration(timeDuration);
        this.selectAll();
    }

    private void unselectAll() {
        this.setCaretPosition(0);
        this.moveCaretPosition(0);
    }

    public TimeDuration getDuration() {
        return this.duration;
    }

    private void fireDurationChanged(DurationChangeEvent durationChangeEvent) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            DurationChangeListener durationChangeListener = (DurationChangeListener)this.listeners.get(i);
            durationChangeListener.valueChanged(durationChangeEvent);
        }
    }

    public void addDurationChangeListener(DurationChangeListener durationChangeListener) {
        this.listeners.add(durationChangeListener);
    }

    public void removeDurationChangeListener(DurationChangeListener durationChangeListener) {
        this.listeners.remove(durationChangeListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class TextDocument
    extends PlainDocument {
        private TextDocument() {
        }

        public void replace(int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (!DurationTextField.this.handleChange(string)) {
                super.replace(n, n2, string, attributeSet);
            }
        }
    }

    private class CommitFocusListener
    implements FocusListener {
        private CommitFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            DurationTextField.this.handleFocusLost();
        }
    }
}

