/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector;

import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.autodate.AutoDateDialog;
import com.novell.gw.jclient.application.controls.autodate.RecurringModel;
import com.novell.gw.jclient.application.controls.autodate.SetDateDialog;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.MonthlyCalendar;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateDocumentHandler;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateSelectorPopup;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateTextField;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateValueChangeListener;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.RecuringDateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.RecuringDateChangeListener;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.RecuringDateTextField;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.RecuringMonthlyCalendar;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBar;
import com.novell.gw.jclient.application.resources.ImageResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.GregorianCalendar;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class RecuringDateSelector
extends GWToolBar
implements DateValueChangeListener {
    private AutoDateDialog autoDateDialog;
    private SetDateDialog setDateDialog;
    private RecurringModel model;
    protected RecuringMonthlyCalendar calendar;
    private DateSelectorPopup popup;
    private ArrayList recuringListeners = new ArrayList();
    private ArrayList dataListeners = new ArrayList();
    protected GregorianCalendar oldDate;
    private Comparator comparator;
    protected RecuringDateTextField dateField;
    protected AbstractButton pickerButton;

    public RecuringDateSelector() {
        this.model = new RecurringModel();
        this.comparator = new CalendarComparator();
        this.init();
    }

    public void setDate(GregorianCalendar gregorianCalendar) {
        this.setDates(new GregorianCalendar[]{gregorianCalendar});
    }

    public void setDates(GregorianCalendar[] gregorianCalendarArray) {
        this.model.setDates(gregorianCalendarArray);
        if (!this.model.isEmpty()) {
            this.removeListeners();
            GregorianCalendar gregorianCalendar = gregorianCalendarArray[0];
            this.calendar.setDate(gregorianCalendar);
            this.dateField.setDate(gregorianCalendar);
            this.dateField.setRecuring(this.model.isRecuring());
            this.addListeners();
            this.fireRecuringDateChanged(new RecuringDateChangeEvent(gregorianCalendarArray, this));
            this.fireDateChanged(new DateChangeEvent(gregorianCalendar, this));
        }
    }

    public GregorianCalendar getDate() {
        GregorianCalendar[] gregorianCalendarArray = this.getDates();
        if (gregorianCalendarArray != null && gregorianCalendarArray.length > 0) {
            return gregorianCalendarArray[0];
        }
        return (GregorianCalendar)GregorianCalendar.getInstance();
    }

    public GregorianCalendar[] getDates() {
        if (!this.model.isRecuring()) {
            this.dateField.commit();
        }
        GregorianCalendar[] gregorianCalendarArray = this.model.getDates();
        Arrays.sort(gregorianCalendarArray, this.comparator);
        return gregorianCalendarArray;
    }

    public boolean isRecuring() {
        return this.model.isRecuring();
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(null);
        this.dateField = new RecuringDateTextField(GWCalendarUtils.getDateFormat(), new DateDocumentHandler());
        this.dateField.addKeyListener(new DatePickerListener());
        this.add((Component)this.dateField, "Center");
        this.initPickerButton();
        this.add((Component)this.pickerButton, "After");
        this.calendar = new RecuringMonthlyCalendar(GWCalendarUtils.getToday(), true);
        this.calendar.addRecuringLabelListener(new RecuringLabelMouseListener());
    }

    private void addListeners() {
        this.calendar.addValueChangeListener(this);
        this.dateField.addValueChangeListener(this);
    }

    private void removeListeners() {
        this.calendar.removeValueChangeListener(this);
        this.dateField.removeValueChangeListener(this);
    }

    protected void initPickerButton() {
        this.pickerButton = UIUtils.createToolButton(new DatePickerAction());
        this.pickerButton.setIcon(ImageResources.ACT_DATEPICKER);
    }

    private void initAutoDateDialog() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window instanceof JFrame) {
            this.autoDateDialog = new AutoDateDialog((JFrame)window);
        }
    }

    private void initSetDateDialog() {
        Window window = SwingUtilities.windowForComponent(this);
        if (window instanceof JFrame) {
            this.setDateDialog = new SetDateDialog((JFrame)window);
        } else if (window instanceof JDialog) {
            this.setDateDialog = new SetDateDialog((JDialog)window);
        }
    }

    public void showAutodateDialog() {
        if (this.autoDateDialog == null) {
            this.initAutoDateDialog();
        }
        if (this.autoDateDialog != null) {
            GregorianCalendar[] gregorianCalendarArray = this.model.getDates();
            if (!this.model.isRecuring()) {
                gregorianCalendarArray = new GregorianCalendar[]{};
            }
            this.autoDateDialog.setSelectedDates(gregorianCalendarArray);
            this.autoDateDialog.showMe();
            if (this.autoDateDialog.isActionCompleteSuccessfully()) {
                this.setDates(this.autoDateDialog.getSelectedDates());
            }
        }
    }

    public void showSetDateDialog() {
        if (this.setDateDialog == null) {
            this.initSetDateDialog();
        }
        if (this.setDateDialog != null) {
            GregorianCalendar[] gregorianCalendarArray = this.getDates();
            GregorianCalendar gregorianCalendar = gregorianCalendarArray.length > 0 ? gregorianCalendarArray[0].clone() : GWCalendarUtils.getToday();
            this.setDateDialog.setSelectedDate(gregorianCalendar);
            this.setDateDialog.show();
            if (this.setDateDialog.isActionCompleteSuccessfully()) {
                this.setDates(new GregorianCalendar[]{this.setDateDialog.getSelectedDate()});
            }
        }
    }

    private void initPopup() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window instanceof JFrame) {
            this.popup = new DateSelectorPopup((JFrame)window, (MonthlyCalendar)this.calendar);
        }
    }

    protected void showPopup(Component component) {
        if (this.popup == null) {
            this.initPopup();
        }
        if (this.popup != null) {
            int n = component.getLocationOnScreen().x - this.calendar.getPreferredSize().width;
            int n2 = component.getLocationOnScreen().y + component.getHeight();
            this.popup.setLocation(n, n2);
            this.popup.show();
        }
    }

    protected void handleKey(int n) {
        switch (n) {
            case 40: {
                if (this.model.isRecuring()) {
                    this.showAutodateDialog();
                    break;
                }
                this.showPopup(this.pickerButton);
            }
        }
    }

    public void valueChanged(DateChangeEvent dateChangeEvent) {
        GregorianCalendar gregorianCalendar = dateChangeEvent.getDate();
        if (dateChangeEvent.getSource() instanceof DateTextField) {
            this.calendar.setDate(gregorianCalendar);
        } else if (dateChangeEvent.getSource() instanceof MonthlyCalendar) {
            this.dateField.setDate(gregorianCalendar);
        }
        if (!gregorianCalendar.equals(this.oldDate)) {
            this.oldDate = gregorianCalendar;
            this.setDates(new GregorianCalendar[]{gregorianCalendar});
        }
    }

    private void fireRecuringDateChanged(RecuringDateChangeEvent recuringDateChangeEvent) {
        for (int i = 0; i < this.recuringListeners.size(); ++i) {
            RecuringDateChangeListener recuringDateChangeListener = (RecuringDateChangeListener)this.recuringListeners.get(i);
            recuringDateChangeListener.valueChanged(recuringDateChangeEvent);
        }
    }

    public void addRecuringDateChangeListener(RecuringDateChangeListener recuringDateChangeListener) {
        this.recuringListeners.add(recuringDateChangeListener);
    }

    public void removeRecuringDateChangeListener(RecuringDateChangeListener recuringDateChangeListener) {
        this.recuringListeners.remove(recuringDateChangeListener);
    }

    public Component getTextComponent() {
        return this.dateField;
    }

    private void fireDateChanged(DateChangeEvent dateChangeEvent) {
        for (int i = 0; i < this.dataListeners.size(); ++i) {
            DateValueChangeListener dateValueChangeListener = (DateValueChangeListener)this.dataListeners.get(i);
            dateValueChangeListener.valueChanged(dateChangeEvent);
        }
    }

    public void addDateChangeListener(DateValueChangeListener dateValueChangeListener) {
        this.dataListeners.add(dateValueChangeListener);
    }

    public void removeDateChangeListener(DateValueChangeListener dateValueChangeListener) {
        this.dataListeners.remove(dateValueChangeListener);
    }

    private class CalendarComparator
    implements Comparator {
        private CalendarComparator() {
        }

        public int compare(Object object, Object object2) {
            long l;
            GregorianCalendar gregorianCalendar = (GregorianCalendar)object;
            GregorianCalendar gregorianCalendar2 = (GregorianCalendar)object2;
            long l2 = gregorianCalendar.getTimeInMillis();
            if (l2 == (l = gregorianCalendar2.getTimeInMillis())) {
                return 0;
            }
            return l2 > l ? 1 : -1;
        }
    }

    private class RecuringLabelMouseListener
    extends MouseAdapter {
        private RecuringLabelMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            RecuringDateSelector recuringDateSelector = RecuringDateSelector.this;
            recuringDateSelector.showAutodateDialog();
        }
    }

    private class DatePickerListener
    extends KeyAdapter {
        private DatePickerListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            RecuringDateSelector recuringDateSelector = RecuringDateSelector.this;
            recuringDateSelector.handleKey(n);
        }
    }

    private class DatePickerAction
    extends AbstractAction {
        private DatePickerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RecuringDateSelector recuringDateSelector = RecuringDateSelector.this;
            if (!recuringDateSelector.dateField.isFocusOwner()) {
                recuringDateSelector.dateField.grabFocus();
            }
            if (recuringDateSelector.model.isRecuring()) {
                recuringDateSelector.showAutodateDialog();
            } else {
                Component component = (Component)actionEvent.getSource();
                recuringDateSelector.showPopup(component);
            }
        }
    }
}

