/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.weekly.weeklyview;

import com.appframework.cache.IDObjectsCollection;
import com.appframework.level.LevelManager;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.novell.gw.engine.ItemList;
import com.novell.gw.jclient.application.controls.gwcalendar.ActiveItemLabel;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendar;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarPopup;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.NavigateCreateItem;
import com.novell.gw.jclient.application.controls.gwcalendar.NavigationCreateItemKeyboardListener;
import com.novell.gw.jclient.application.controls.gwcalendar.TypingWindow;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ActiveCalendarItemPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.AllDayEventsPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.DateWatchPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.NotesPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.TaskPanel;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

public class CalendarBoxesPanel
extends DateWatchPanel
implements NavigateCreateItem {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$gwcalendar$weekly$weeklyview$CalendarBoxesPanel == null ? (class$com$novell$gw$jclient$application$controls$gwcalendar$weekly$weeklyview$CalendarBoxesPanel = CalendarBoxesPanel.class$("com.novell.gw.jclient.application.controls.gwcalendar.weekly.weeklyview.CalendarBoxesPanel")) : class$com$novell$gw$jclient$application$controls$gwcalendar$weekly$weeklyview$CalendarBoxesPanel));
    private Border border = BorderFactory.createLineBorder(ColorConstants.HEADER_BORDER_COLOR);
    private boolean drawBorders = false;
    private ArrayList days = new ArrayList();
    private String type;
    private BoxMouseListener boxMouseListener;
    private LabelMouseClick labelMouseListener;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$gwcalendar$weekly$weeklyview$CalendarBoxesPanel;

    public CalendarBoxesPanel(MVCController mVCController, String string, int n, boolean bl) {
        super(mVCController);
        this.setFocusable(true);
        this.addKeyListener(new NavigationCreateItemKeyboardListener(this));
        this.type = string;
        this.boxMouseListener = new BoxMouseListener();
        this.labelMouseListener = new LabelMouseClick();
        this.drawBorders = bl;
        this.setLayout(new GridLayout(1, 0, 0, 0));
        this.setBackground(Color.white);
        for (int i = 0; i < n; ++i) {
            ActiveCalendarItemPanel activeCalendarItemPanel = this.createBox();
            this.days.add(activeCalendarItemPanel);
            this.add(activeCalendarItemPanel);
        }
    }

    private void loadItemsForDate(GregorianCalendar gregorianCalendar, ItemList itemList) {
        GregorianCalendar gregorianCalendar2 = (GregorianCalendar)gregorianCalendar.clone();
        for (int i = 0; i < this.days.size(); ++i) {
            ActiveCalendarItemPanel activeCalendarItemPanel = (ActiveCalendarItemPanel)this.days.get(i);
            activeCalendarItemPanel.setItems(gregorianCalendar2, itemList, this.getType());
            activeCalendarItemPanel.setShowItems(true, this.getType());
            gregorianCalendar2.add(5, 1);
        }
    }

    public void loadItemsForDate(GregorianCalendar gregorianCalendar, ItemList itemList, TimeInterval timeInterval) {
        if (timeInterval == null) {
            this.loadItemsForDate(gregorianCalendar, itemList);
        } else {
            GregorianCalendar gregorianCalendar2 = (GregorianCalendar)gregorianCalendar.clone();
            for (int i = 0; i < this.days.size(); ++i) {
                ActiveCalendarItemPanel activeCalendarItemPanel = (ActiveCalendarItemPanel)this.days.get(i);
                if (timeInterval.contains(gregorianCalendar2)) {
                    activeCalendarItemPanel.setItems(gregorianCalendar2, itemList, this.getType());
                    activeCalendarItemPanel.setShowItems(true, this.getType());
                }
                gregorianCalendar2.add(5, 1);
            }
        }
    }

    private ActiveCalendarItemPanel getPanelForDate(Date date) {
        Iterator iterator = this.days.iterator();
        while (iterator.hasNext()) {
            ActiveCalendarItemPanel activeCalendarItemPanel = (ActiveCalendarItemPanel)iterator.next();
            if (!GWCalendarUtils.isSameDate(activeCalendarItemPanel.getCurrentDate().getTime(), date)) continue;
            return activeCalendarItemPanel;
        }
        return null;
    }

    public void addBoxAndLoadData(GregorianCalendar gregorianCalendar, IDObjectsCollection iDObjectsCollection) {
        ActiveCalendarItemPanel activeCalendarItemPanel = this.createBox();
        this.days.add(activeCalendarItemPanel);
        this.add(activeCalendarItemPanel);
        activeCalendarItemPanel.setItems(gregorianCalendar, iDObjectsCollection, this.getType());
        activeCalendarItemPanel.setShowItems(true, this.getType());
    }

    private ActiveCalendarItemPanel createBox() {
        ActiveCalendarItemPanel activeCalendarItemPanel = null;
        if ("Task".equals(this.getType())) {
            activeCalendarItemPanel = new TaskPanel(this.getController(), this.labelMouseListener);
        } else if ("Note".equals(this.getType())) {
            activeCalendarItemPanel = new NotesPanel(this.getController(), this.labelMouseListener);
        } else if ("AllDayEvent".equals(this.getType())) {
            activeCalendarItemPanel = new AllDayEventsPanel(this.getController(), this.labelMouseListener);
        }
        if (activeCalendarItemPanel != null) {
            activeCalendarItemPanel.setBorder(this.drawBorders ? this.border : BorderFactory.createEmptyBorder());
            activeCalendarItemPanel.setBackground(Color.white);
            activeCalendarItemPanel.addMouseListener(this.boxMouseListener);
        }
        return activeCalendarItemPanel;
    }

    public void removeBox() {
        int n = this.days.size() - 1;
        if (n == 0) {
            return;
        }
        this.days.remove(n);
        ActiveCalendarItemPanel activeCalendarItemPanel = (ActiveCalendarItemPanel)this.getComponent(n);
        activeCalendarItemPanel.removeMouseListener(this.boxMouseListener);
        this.remove(activeCalendarItemPanel);
        LevelManager.getInstance().release(activeCalendarItemPanel.getController().getLevel());
    }

    private void navigate(int n, int n2) {
        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.getCurrentDate().clone();
        gregorianCalendar.add(n, n2);
        this.adjustCurrentTime(gregorianCalendar.getTime());
        this.selectFirstLabel(gregorianCalendar.getTime());
    }

    public void navigateUP() {
        ActiveCalendarItemPanel activeCalendarItemPanel = this.getCurrentPanel();
        if (activeCalendarItemPanel == null) {
            return;
        }
        ArrayList arrayList = activeCalendarItemPanel.getLabels(this.getType());
        int n = this.getSelectedItemIndex(arrayList);
        if (n > 0) {
            ActiveItemLabel activeItemLabel = (ActiveItemLabel)arrayList.get(n - 1);
            activeItemLabel.select();
        }
    }

    public void navigateDOWN() {
        ActiveCalendarItemPanel activeCalendarItemPanel = this.getCurrentPanel();
        if (activeCalendarItemPanel == null) {
            return;
        }
        ArrayList arrayList = activeCalendarItemPanel.getLabels(this.getType());
        int n = this.getSelectedItemIndex(arrayList);
        if (arrayList.size() > 0 && n < arrayList.size() - 1) {
            ActiveItemLabel activeItemLabel = (ActiveItemLabel)arrayList.get(n + 1);
            activeItemLabel.select();
        }
    }

    public void navigateLEFT() {
        this.navigate(5, -1);
    }

    public void navigateRIGHT() {
        this.navigate(5, 1);
    }

    public void quickCreateItem(char c) {
        ActiveCalendarItemPanel activeCalendarItemPanel = this.getCurrentPanel();
        if (activeCalendarItemPanel != null) {
            Point point = new Point(0, 0);
            SwingUtilities.convertPointToScreen(point, activeCalendarItemPanel);
            int n = this.getParent() instanceof JViewport ? this.getParent().getHeight() : activeCalendarItemPanel.getHeight();
            Dimension dimension = new Dimension(activeCalendarItemPanel.getWidth(), n);
            TypingWindow.getInstance(SwingUtilities.windowForComponent(this)).show(this.getType(), (GregorianCalendar)this.getCurrentDate().clone(), String.valueOf(c), point, dimension, this.getController());
        }
    }

    public void setCurrentDate(Date date) {
        super.setCurrentDate(date);
    }

    private void selectFirstLabel(Date date) {
        if (this.isFocusOwner()) {
            ActiveCalendarItemPanel activeCalendarItemPanel = this.getPanelForDate(date);
            if (activeCalendarItemPanel == null) {
                return;
            }
            ArrayList arrayList = activeCalendarItemPanel.getLabels(this.getType());
            if (arrayList != null && arrayList.size() > 0) {
                ActiveItemLabel activeItemLabel = (ActiveItemLabel)arrayList.get(0);
                activeItemLabel.select();
                this.scrollRectToVisible(activeItemLabel.getBounds());
            } else {
                this.clearSelectedItem();
            }
        }
    }

    private void clearSelectedItem() {
        logger.debug((Object)("--- clear selected item. parent panel: [" + this + "]"));
        this.getController().processCommand(new Command(470));
    }

    private int getSelectedItemIndex(List list) {
        int n = -1;
        for (int i = 0; i < list.size(); ++i) {
            ActiveItemLabel activeItemLabel = (ActiveItemLabel)list.get(i);
            if (!activeItemLabel.isSelected()) continue;
            n = i;
        }
        return n;
    }

    private void handleClick(Point point) {
        Date date = this.getDateAtPoint(point);
        if (date != null && !GWCalendarUtils.isSameDate(this.getCurrentDate().getTime(), date)) {
            this.adjustCurrentTime(date);
            ActiveCalendarItemPanel activeCalendarItemPanel = this.getCurrentPanel();
            if (activeCalendarItemPanel == null) {
                return;
            }
            if (this.getSelectedItemIndex(activeCalendarItemPanel.getLabels(this.getType())) == -1) {
                this.selectFirstLabel(date);
            }
        }
    }

    private ActiveCalendarItemPanel getCurrentPanel() {
        return this.getPanelForDate(this.getCurrentDate().getTime());
    }

    private Date getDateAtPoint(Point point) {
        Component component = this.getComponentAt(point);
        if (component instanceof ActiveCalendarItemPanel) {
            ActiveCalendarItemPanel activeCalendarItemPanel = (ActiveCalendarItemPanel)component;
            GregorianCalendar gregorianCalendar = (GregorianCalendar)activeCalendarItemPanel.getCurrentDate().clone();
            gregorianCalendar.set(10, this.getCurrentDate().get(10));
            gregorianCalendar.set(12, this.getCurrentDate().get(12));
            gregorianCalendar.set(9, this.getCurrentDate().get(9));
            return gregorianCalendar.getTime();
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class LabelMouseClick
    extends MouseAdapter {
        private LabelMouseClick() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!CalendarBoxesPanel.this.isFocusOwner()) {
                CalendarBoxesPanel.this.grabFocus();
            }
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, (Component)mouseEvent.getSource());
            SwingUtilities.convertPointFromScreen(point, CalendarBoxesPanel.this);
            CalendarBoxesPanel.this.handleClick(point);
        }
    }

    private class BoxMouseListener
    extends MouseAdapter {
        private BoxMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (OS.isDoubleClick(mouseEvent)) {
                ActiveCalendarItemPanel activeCalendarItemPanel = (ActiveCalendarItemPanel)mouseEvent.getSource();
                GWCalendar.createNewCalendarItem(CalendarBoxesPanel.this.getType(), activeCalendarItemPanel.getCurrentDate().getTime(), CalendarBoxesPanel.this.getController(), true);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.doPopup(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!CalendarBoxesPanel.this.isFocusOwner()) {
                CalendarBoxesPanel.this.grabFocus();
            }
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, (Component)mouseEvent.getSource());
            SwingUtilities.convertPointFromScreen(point, CalendarBoxesPanel.this);
            CalendarBoxesPanel.this.handleClick(point);
            this.doPopup(mouseEvent);
        }

        private void doPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                GWCalendarPopup gWCalendarPopup = this.createPopup(mouseEvent);
                gWCalendarPopup.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private GWCalendarPopup createPopup(MouseEvent mouseEvent) {
            ActiveCalendarItemPanel activeCalendarItemPanel = (ActiveCalendarItemPanel)mouseEvent.getSource();
            MVCController mVCController = activeCalendarItemPanel.getController();
            return new GWCalendarPopup(CalendarBoxesPanel.this.getType(), activeCalendarItemPanel.getCurrentDate().getTime(), mVCController);
        }
    }
}

