/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.weekly.weeklyview;

import com.novell.gw.jclient.application.controls.gwcalendar.CalendarView;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

public class DayHeaderPanel
extends OrientablePanel {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$gwcalendar$itemsboxes$DayLabelsPanel == null ? (class$com$novell$gw$jclient$application$controls$gwcalendar$itemsboxes$DayLabelsPanel = DayHeaderPanel.class$("com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.DayLabelsPanel")) : class$com$novell$gw$jclient$application$controls$gwcalendar$itemsboxes$DayLabelsPanel));
    protected Border labelBorder;
    private GregorianCalendar gcCurrentDay = GWCalendarUtils.getToday();
    private GregorianCalendar gcStartDay = GWCalendarUtils.getToday();
    private DayLabelContainerAdapter dayLabelContainerAdapter;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$gwcalendar$itemsboxes$DayLabelsPanel;

    public DayHeaderPanel(int n) {
        super(new GridLayout(1, 0, 0, 0));
        this.init();
        this.dayLabelContainerAdapter = new DayLabelContainerAdapter();
        this.setDaysCount(n);
        this.setPreferredSize(CalendarView.HEADER_LABEL_SIZE);
        this.addComponentListener(new DayLabelComponentAdapter());
    }

    protected void init() {
        this.labelBorder = BorderFactory.createLineBorder(ColorConstants.HEADER_BORDER_COLOR);
    }

    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(dimension);
        super.setMinimumSize(dimension);
    }

    public void setTitles(Date date, Date date2) {
        this.gcStartDay.setTime(date);
        if (date2 == null) {
            this.gcCurrentDay.setTime(new Date(0L));
        } else {
            this.gcCurrentDay.setTime(date2);
        }
        GregorianCalendar gregorianCalendar = GWCalendarUtils.getToday();
        gregorianCalendar.setTime(date);
        boolean bl = this.isShortTitle();
        for (int i = 0; i < this.getComponentCount(); ++i) {
            JLabel jLabel = this.getLabel(i);
            if (jLabel == null) {
                return;
            }
            this.setTextToLabel(jLabel, gregorianCalendar, bl);
            gregorianCalendar.add(5, 1);
        }
    }

    protected JLabel getLabel(int n) {
        return (JLabel)this.getComponent(n);
    }

    private boolean isShortTitle() {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer("Mon 23/12/04");
        Graphics graphics = this.getGraphics();
        if (graphics != null && graphics.getFontMetrics().getStringBounds(stringBuffer.toString(), graphics).getWidth() > (double)(this.getWidth() / this.getComponentCount() - 10)) {
            bl = true;
        }
        return bl;
    }

    protected void setTextToLabel(JLabel jLabel, GregorianCalendar gregorianCalendar, boolean bl) {
        if (GWCalendarUtils.isSameDate(gregorianCalendar, this.gcCurrentDay)) {
            jLabel.setBackground(ColorConstants.CURRENT_DAY_COLOR);
            jLabel.setForeground(Color.white);
        } else {
            if (GWCalendarUtils.isSameDate(gregorianCalendar, GWCalendarUtils.getToday())) {
                jLabel.setBackground(ColorConstants.TODAY_COLOR);
            } else {
                jLabel.setBackground(this.getBackground());
            }
            jLabel.setForeground(Color.black);
        }
        if (gregorianCalendar.get(7) == 1 || gregorianCalendar.get(7) == 7) {
            jLabel.setForeground(Color.red);
        }
        StringBuffer stringBuffer = new StringBuffer(GWCalendarUtils.dayMediumNames[gregorianCalendar.get(7) - 1]);
        stringBuffer.append(" ").append(GWCalendarUtils.getDateFormat().format(gregorianCalendar.getTime()));
        jLabel.setText(stringBuffer.toString());
    }

    public void addLabel() {
        JLabel jLabel = new JLabel(" ");
        jLabel.setHorizontalAlignment(0);
        jLabel.setBorder(this.labelBorder);
        jLabel.setOpaque(true);
        this.add(jLabel);
    }

    public void removeLabel() {
        if (this.getComponentCount() < 1) {
            return;
        }
        this.remove(this.getComponentCount() - 1);
        this.validate();
    }

    public void setDaysCount(int n) {
        this.removeContainerListener(this.dayLabelContainerAdapter);
        this.removeAll();
        for (int i = 0; i < n; ++i) {
            this.addLabel();
        }
        this.addContainerListener(this.dayLabelContainerAdapter);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DayLabelComponentAdapter
    extends ComponentAdapter {
        private DayLabelComponentAdapter() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            DayHeaderPanel.this.setTitles(DayHeaderPanel.this.gcStartDay.getTime(), DayHeaderPanel.this.gcCurrentDay.getTime());
        }
    }

    private class DayLabelContainerAdapter
    extends ContainerAdapter {
        private DayLabelContainerAdapter() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
            DayHeaderPanel.this.setTitles(DayHeaderPanel.this.gcStartDay.getTime(), DayHeaderPanel.this.gcCurrentDay.getTime());
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            DayHeaderPanel.this.setTitles(DayHeaderPanel.this.gcStartDay.getTime(), DayHeaderPanel.this.gcCurrentDay.getTime());
        }
    }
}

