/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwtooltips;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class GWToolTipManager
extends MouseAdapter
implements MouseMotionListener {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$gwtooltips$GWToolTipManager == null ? (class$com$novell$gw$jclient$application$controls$gwtooltips$GWToolTipManager = GWToolTipManager.class$("com.novell.gw.jclient.application.controls.gwtooltips.GWToolTipManager")) : class$com$novell$gw$jclient$application$controls$gwtooltips$GWToolTipManager));
    private static final GWToolTipManager instance = new GWToolTipManager();
    protected Timer enterTimer = new Timer(750, new insideTimerAction());
    protected Timer exitTimer;
    protected Timer insideTimer;
    String toolTipText;
    Point preferredLocation;
    JComponent insideComponent;
    MouseEvent mouseEvent;
    boolean showImmediately;
    transient Popup tipWindow;
    private Window window;
    JToolTip tip;
    private Rectangle popupRect = null;
    private Rectangle popupFrameRect = null;
    boolean enabled = true;
    private boolean tipShowing = false;
    private KeyStroke postTip;
    private KeyStroke hideTip;
    private Action postTipAction;
    private Action hideTipAction;
    private FocusListener focusChangeListener = null;
    private MouseMotionListener moveBeforeEnterListener = null;
    protected boolean lightWeightPopupEnabled = true;
    protected boolean heavyWeightPopupEnabled = false;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$gwtooltips$GWToolTipManager;

    GWToolTipManager() {
        this.enterTimer.setRepeats(false);
        this.exitTimer = new Timer(500, new outsideTimerAction());
        this.exitTimer.setRepeats(false);
        this.insideTimer = new Timer(4000, new stillInsideTimerAction());
        this.insideTimer.setRepeats(false);
        this.postTip = KeyStroke.getKeyStroke(112, 2);
        this.postTipAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GWToolTipManager.this.tipWindow != null) {
                    GWToolTipManager.this.hideTipWindow();
                    GWToolTipManager.this.insideComponent = null;
                } else {
                    GWToolTipManager.this.hideTipWindow();
                    GWToolTipManager.this.enterTimer.stop();
                    GWToolTipManager.this.exitTimer.stop();
                    GWToolTipManager.this.insideTimer.stop();
                    GWToolTipManager.this.insideComponent = (JComponent)actionEvent.getSource();
                    if (GWToolTipManager.this.insideComponent != null) {
                        GWToolTipManager.this.toolTipText = GWToolTipManager.this.insideComponent.getToolTipText();
                        GWToolTipManager.this.preferredLocation = new Point(10, GWToolTipManager.this.insideComponent.getHeight() + 10);
                        GWToolTipManager.this.showTipWindow();
                        if (GWToolTipManager.this.focusChangeListener == null) {
                            GWToolTipManager.this.focusChangeListener = GWToolTipManager.this.createFocusChangeListener();
                        }
                        GWToolTipManager.this.insideComponent.addFocusListener(GWToolTipManager.this.focusChangeListener);
                    }
                }
            }
        };
        this.hideTip = KeyStroke.getKeyStroke(27, 0);
        this.hideTipAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                GWToolTipManager.this.hideTipWindow();
                JComponent jComponent = (JComponent)actionEvent.getSource();
                jComponent.removeFocusListener(GWToolTipManager.this.focusChangeListener);
                GWToolTipManager.this.preferredLocation = null;
                GWToolTipManager.this.insideComponent = null;
            }

            public boolean isEnabled() {
                return GWToolTipManager.this.tipShowing;
            }
        };
        this.moveBeforeEnterListener = new MoveBeforeEnterListener();
    }

    public static GWToolTipManager getInstance() {
        return instance;
    }

    void showTipWindow() {
        if (this.insideComponent == null || !this.insideComponent.isShowing()) {
            return;
        }
        if (this.enabled) {
            Point point = this.insideComponent.getLocationOnScreen();
            Point point2 = new Point();
            Rectangle rectangle = this.insideComponent.getGraphicsConfiguration().getBounds();
            boolean bl = true;
            this.hideTipWindow();
            this.tip = this.insideComponent.createToolTip();
            this.tip.setTipText(this.toolTipText);
            Dimension dimension = this.tip.getPreferredSize();
            if (this.preferredLocation != null) {
                point2.x = point.x + this.preferredLocation.x;
                point2.y = point.y + this.preferredLocation.y;
                if (!bl) {
                    point2.x -= dimension.width;
                }
            } else {
                point2.x = point.x + this.mouseEvent.getX();
                point2.y = point.y + this.mouseEvent.getY() + 20;
                if (!bl && point2.x - dimension.width >= 0) {
                    point2.x -= dimension.width;
                }
            }
            if (!this.heavyWeightPopupEnabled) {
                if (this.popupRect == null) {
                    this.popupRect = new Rectangle();
                }
                this.popupRect.setBounds(point2.x, point2.y, dimension.width, dimension.height);
                int n = this.getPopupFitHeight(this.popupRect, this.insideComponent);
                int n2 = this.getPopupFitWidth(this.popupRect, this.insideComponent);
                if (n > 0) {
                    point2.y -= n;
                }
                if (n2 > 0) {
                    point2.x -= n2;
                }
            }
            if (point2.x < rectangle.x) {
                point2.x = rectangle.x;
            } else if (point2.x - rectangle.x + dimension.width > rectangle.width) {
                point2.x = rectangle.x + Math.max(0, rectangle.width - dimension.width);
            }
            if (point2.y < rectangle.y) {
                point2.y = rectangle.y;
            } else if (point2.y - rectangle.y + dimension.height > rectangle.height) {
                point2.y = rectangle.y + Math.max(0, rectangle.height - dimension.height);
            }
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            this.tipWindow = popupFactory.getPopup(this.insideComponent, this.tip, point2.x, point2.y);
            this.tipWindow.show();
            Window window = SwingUtilities.windowForComponent(this.insideComponent);
            this.window = SwingUtilities.windowForComponent(this.tip);
            if (this.window != null && this.window != window) {
                this.window.addMouseListener(this);
            }
            this.insideTimer.start();
            this.tipShowing = true;
        }
    }

    public void hideTipWindow() {
        if (this.tipWindow != null) {
            if (this.window != null) {
                this.window.removeMouseListener(this);
                this.window = null;
            }
            this.tipWindow.hide();
            this.tipWindow = null;
            this.tipShowing = false;
            this.tip.getUI().uninstallUI(this.tip);
            this.tip = null;
            this.insideTimer.stop();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.initiateToolTip(mouseEvent);
    }

    private void initiateToolTip(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.window) {
            return;
        }
        JComponent jComponent = (JComponent)mouseEvent.getSource();
        jComponent.removeMouseMotionListener(this.moveBeforeEnterListener);
        this.exitTimer.stop();
        Point point = mouseEvent.getPoint();
        if (point.x < 0 || point.x >= jComponent.getWidth() || point.y < 0 || point.y >= jComponent.getHeight()) {
            return;
        }
        if (this.insideComponent != null) {
            this.enterTimer.stop();
        }
        jComponent.addMouseMotionListener(this);
        boolean bl = this.insideComponent == jComponent;
        this.insideComponent = jComponent;
        if (this.tipWindow != null) {
            this.mouseEvent = mouseEvent;
            this.enterTimer.start();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        Window window;
        boolean bl = true;
        if (this.insideComponent == null) {
            // empty if block
        }
        if (this.window != null && mouseEvent.getSource() == this.window) {
            Container container = this.insideComponent.getTopLevelAncestor();
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, this.window);
            point.x -= container.getX();
            point.y -= container.getY();
            point = SwingUtilities.convertPoint(null, point, this.insideComponent);
            bl = point.x < 0 || point.x >= this.insideComponent.getWidth() || point.y < 0 || point.y >= this.insideComponent.getHeight();
        } else if (mouseEvent.getSource() == this.insideComponent && this.tipWindow != null && (window = SwingUtilities.getWindowAncestor(this.insideComponent)) != null) {
            Point point = SwingUtilities.convertPoint(this.insideComponent, mouseEvent.getPoint(), window);
            Rectangle rectangle = this.insideComponent.getTopLevelAncestor().getBounds();
            point.x += rectangle.x;
            point.y += rectangle.y;
            Point point2 = new Point(0, 0);
            SwingUtilities.convertPointToScreen(point2, this.tip);
            rectangle.x = point2.x;
            rectangle.y = point2.y;
            rectangle.width = this.tip.getWidth();
            rectangle.height = this.tip.getHeight();
            bl = point.x < rectangle.x || point.x >= rectangle.x + rectangle.width || point.y < rectangle.y || point.y >= rectangle.y + rectangle.height;
        }
        if (bl) {
            this.enterTimer.stop();
            if (this.insideComponent != null) {
                this.insideComponent.removeMouseMotionListener(this);
            }
            this.insideComponent = null;
            this.toolTipText = null;
            this.mouseEvent = null;
            this.hideTipWindow();
            this.exitTimer.restart();
        }
    }

    public void stopToolTip() {
        this.hideTipWindow();
        this.enterTimer.stop();
        this.showImmediately = false;
        this.insideComponent = null;
        this.mouseEvent = null;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.hideTipWindow();
        this.enterTimer.stop();
        this.showImmediately = false;
        this.insideComponent = null;
        this.mouseEvent = null;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.tipShowing) {
            this.checkForTipChange(mouseEvent);
        } else if (this.showImmediately) {
            JComponent jComponent = (JComponent)mouseEvent.getSource();
            this.toolTipText = jComponent.getToolTipText(mouseEvent);
            if (this.toolTipText != null) {
                this.preferredLocation = jComponent.getToolTipLocation(mouseEvent);
                this.mouseEvent = mouseEvent;
                this.insideComponent = jComponent;
                this.exitTimer.stop();
                this.showTipWindow();
            }
        } else {
            this.insideComponent = (JComponent)mouseEvent.getSource();
            this.mouseEvent = mouseEvent;
            this.toolTipText = null;
            this.enterTimer.restart();
        }
    }

    private void checkForTipChange(MouseEvent mouseEvent) {
        JComponent jComponent = (JComponent)mouseEvent.getSource();
        String string = jComponent.getToolTipText(mouseEvent);
        Point point = jComponent.getToolTipLocation(mouseEvent);
        if (string != null || point != null) {
            this.mouseEvent = mouseEvent;
            if ((string != null && string.equals(this.toolTipText) || string == null) && (point != null && point.equals(this.preferredLocation) || point == null)) {
                if (this.tipWindow != null) {
                    this.insideTimer.restart();
                } else {
                    this.enterTimer.restart();
                }
            } else {
                this.toolTipText = string;
                this.preferredLocation = point;
                if (this.showImmediately) {
                    this.hideTipWindow();
                    this.showTipWindow();
                    this.exitTimer.stop();
                } else {
                    this.enterTimer.restart();
                }
            }
        } else {
            this.toolTipText = null;
            this.preferredLocation = null;
            this.mouseEvent = null;
            this.insideComponent = null;
            this.hideTipWindow();
            this.enterTimer.stop();
            this.exitTimer.restart();
        }
    }

    static Frame frameForComponent(Component component) {
        while (!(component instanceof Frame)) {
            component = component.getParent();
        }
        return (Frame)component;
    }

    private FocusListener createFocusChangeListener() {
        return new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                GWToolTipManager.this.hideTipWindow();
                GWToolTipManager.this.insideComponent = null;
                JComponent jComponent = (JComponent)focusEvent.getSource();
                jComponent.removeFocusListener(GWToolTipManager.this.focusChangeListener);
            }
        };
    }

    private int getPopupFitWidth(Rectangle rectangle, Component component) {
        if (component != null) {
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                if (container instanceof JFrame || container instanceof JDialog || container instanceof JWindow) {
                    return this.getWidthAdjust(container.getBounds(), rectangle);
                }
                if (!(container instanceof JApplet) && !(container instanceof JInternalFrame)) continue;
                if (this.popupFrameRect == null) {
                    this.popupFrameRect = new Rectangle();
                }
                Point point = container.getLocationOnScreen();
                this.popupFrameRect.setBounds(point.x, point.y, container.getBounds().width, container.getBounds().height);
                return this.getWidthAdjust(this.popupFrameRect, rectangle);
            }
        }
        return 0;
    }

    private int getPopupFitHeight(Rectangle rectangle, Component component) {
        if (component != null) {
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                if (container instanceof JFrame || container instanceof JDialog || container instanceof JWindow) {
                    return this.getHeightAdjust(container.getBounds(), rectangle);
                }
                if (!(container instanceof JApplet) && !(container instanceof JInternalFrame)) continue;
                if (this.popupFrameRect == null) {
                    this.popupFrameRect = new Rectangle();
                }
                Point point = container.getLocationOnScreen();
                this.popupFrameRect.setBounds(point.x, point.y, container.getBounds().width, container.getBounds().height);
                return this.getHeightAdjust(this.popupFrameRect, rectangle);
            }
        }
        return 0;
    }

    private int getHeightAdjust(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle2.y >= rectangle.y && rectangle2.y + rectangle2.height <= rectangle.y + rectangle.height) {
            return 0;
        }
        return rectangle2.y + rectangle2.height - (rectangle.y + rectangle.height) + 5;
    }

    private int getWidthAdjust(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle2.x >= rectangle.x && rectangle2.x + rectangle2.width <= rectangle.x + rectangle.width) {
            return 0;
        }
        return rectangle2.x + rectangle2.width - (rectangle.x + rectangle.width) + 5;
    }

    public void registerComponent(JComponent jComponent) {
        jComponent.removeMouseListener(this);
        jComponent.addMouseListener(this);
        jComponent.removeMouseMotionListener(this.moveBeforeEnterListener);
        jComponent.addMouseMotionListener(this.moveBeforeEnterListener);
        InputMap inputMap = jComponent.getInputMap(0);
        ActionMap actionMap = jComponent.getActionMap();
        if (inputMap != null && actionMap != null) {
            inputMap.put(this.postTip, "postTip");
            inputMap.put(this.hideTip, "hideTip");
            actionMap.put("postTip", this.postTipAction);
            actionMap.put("hideTip", this.hideTipAction);
        }
    }

    public void unregisterComponent(JComponent jComponent) {
        jComponent.removeMouseListener(this);
        jComponent.removeMouseMotionListener(this.moveBeforeEnterListener);
        InputMap inputMap = jComponent.getInputMap(0);
        ActionMap actionMap = jComponent.getActionMap();
        if (inputMap != null && actionMap != null) {
            inputMap.remove(this.postTip);
            inputMap.remove(this.hideTip);
            actionMap.remove("postTip");
            actionMap.remove("hideTip");
        }
    }

    public static void setToolTipText(JComponent jComponent, String string) {
        String string2 = jComponent.getToolTipText();
        jComponent.putClientProperty("ToolTipText", string);
        if (string != null) {
            if (string2 == null) {
                instance.registerComponent(jComponent);
            }
        } else {
            instance.unregisterComponent(jComponent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class MoveBeforeEnterListener
    extends MouseMotionAdapter {
        private MoveBeforeEnterListener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            GWToolTipManager.this.initiateToolTip(mouseEvent);
        }
    }

    protected class stillInsideTimerAction
    implements ActionListener {
        protected stillInsideTimerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GWToolTipManager.this.hideTipWindow();
            GWToolTipManager.this.enterTimer.stop();
            GWToolTipManager.this.showImmediately = false;
            GWToolTipManager.this.insideComponent = null;
            GWToolTipManager.this.mouseEvent = null;
        }
    }

    protected class outsideTimerAction
    implements ActionListener {
        protected outsideTimerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GWToolTipManager.this.showImmediately = false;
        }
    }

    protected class insideTimerAction
    implements ActionListener {
        protected insideTimerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (GWToolTipManager.this.insideComponent != null && GWToolTipManager.this.insideComponent.isShowing()) {
                if (GWToolTipManager.this.toolTipText == null && GWToolTipManager.this.mouseEvent != null) {
                    GWToolTipManager.this.toolTipText = GWToolTipManager.this.insideComponent.getToolTipText(GWToolTipManager.this.mouseEvent);
                    GWToolTipManager.this.preferredLocation = GWToolTipManager.this.insideComponent.getToolTipLocation(GWToolTipManager.this.mouseEvent);
                }
                if (GWToolTipManager.this.toolTipText != null) {
                    GWToolTipManager.this.showImmediately = false;
                    GWToolTipManager.this.showTipWindow();
                } else {
                    GWToolTipManager.this.insideComponent = null;
                    GWToolTipManager.this.toolTipText = null;
                    GWToolTipManager.this.preferredLocation = null;
                    GWToolTipManager.this.mouseEvent = null;
                    GWToolTipManager.this.hideTipWindow();
                }
            }
        }
    }
}

