/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwtooltips;

import com.appframework.utils.UIUtils;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.controls.gwtooltips.GWToolTip;
import com.novell.gw.jclient.application.controls.gwtooltips.GWToolTipSet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolTipUI;
import org.apache.log4j.Logger;

public class GWToolTipUI
extends ToolTipUI {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$gwtooltips$GWToolTipUI == null ? (class$com$novell$gw$jclient$application$controls$gwtooltips$GWToolTipUI = GWToolTipUI.class$("com.novell.gw.jclient.application.controls.gwtooltips.GWToolTipUI")) : class$com$novell$gw$jclient$application$controls$gwtooltips$GWToolTipUI));
    static GWToolTipUI SINGLETON = new GWToolTipUI();
    int inset = 4;
    private Font plainF;
    private FontMetrics plainFM;
    private Font boldF;
    private FontMetrics boldFM;
    private int fontH = 0;
    private int leftMargin = 0;
    private Dimension dimPreferred = new Dimension(200, 200);
    private int maxW = 0;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$gwtooltips$GWToolTipUI;

    private GWToolTipUI() {
    }

    public static void initialize() {
        String string = "ToolTipUI";
        Class<?> clazz = SINGLETON.getClass();
        String string2 = clazz.getName();
        UIManager.put(string, string2);
        UIManager.put(string2, clazz);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return SINGLETON;
    }

    public void installUI(JComponent jComponent) {
        LookAndFeel.installColorsAndFont(jComponent, "ToolTip.background", "ToolTip.foreground", "ToolTip.font");
        LookAndFeel.installBorder(jComponent, "ToolTip.border");
    }

    public void uninstallUI(JComponent jComponent) {
        LookAndFeel.uninstallBorder(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        this.plainF = jComponent.getFont();
        BufferedImage bufferedImage = new BufferedImage(100, 100, 6);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setFont(this.plainF);
        this.plainFM = graphics.getFontMetrics();
        this.boldF = Utils.deriveFont(this.plainF, 1);
        graphics.setFont(this.boldF);
        this.boldFM = graphics.getFontMetrics();
        this.fontH = this.plainFM.getHeight();
        this.maxW = 0;
        if (this.isMultiLine(jComponent)) {
            return this.getMultilineSize(jComponent);
        }
        String string = ((JToolTip)jComponent).getTipText();
        if (string == null) {
            string = "";
        }
        int n = this.plainFM.stringWidth(string);
        this.dimPreferred = new Dimension(n + this.inset * 2, this.fontH + this.inset * 2);
        return this.dimPreferred;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.dimPreferred;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.dimPreferred;
    }

    private Dimension getMultilineSize(JComponent jComponent) {
        int n;
        int n2 = Toolkit.getDefaultToolkit().getScreenSize().width;
        String string = ((JToolTip)jComponent).getTipText();
        if (string == null) {
            string = "";
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        ArrayList arrayList = this.getArrayList(jComponent);
        for (n = 0; n < arrayList.size(); ++n) {
            GWToolTipSet gWToolTipSet = (GWToolTipSet)arrayList.get(n);
            n3 = this.boldFM.stringWidth(gWToolTipSet.getKey());
            if (n3 > n4) {
                n4 = n3;
            }
            if ((n5 = this.plainFM.stringWidth(gWToolTipSet.getValue())) <= n6) continue;
            n6 = n5;
        }
        n = 0;
        int n7 = 0;
        n = n4 + n6 + this.inset * 4;
        if (n > n2 / 2) {
            n = n2 / 2;
        }
        this.leftMargin = n4 + this.inset * 3;
        BufferedImage bufferedImage = new BufferedImage(n - this.leftMargin - this.inset, 2000, 2);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setFont(this.plainF);
        for (int i = 0; i < arrayList.size(); ++i) {
            GWToolTipSet gWToolTipSet = (GWToolTipSet)arrayList.get(i);
            int n8 = this.drawStringIntoRect(graphics, gWToolTipSet.getValue(), this.plainFM.getAscent() + this.inset, n, jComponent.getBounds().width) + this.inset;
            n7 += n8;
        }
        this.maxW += this.inset;
        this.dimPreferred = new Dimension(this.maxW, n7 += this.inset);
        return this.dimPreferred;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n = this.plainFM.getAscent();
        if (this.isMultiLine(jComponent)) {
            graphics.setColor(Color.black);
            int n2 = n + this.inset;
            int n3 = 0;
            ArrayList arrayList = this.getArrayList(jComponent);
            for (int i = 0; i < arrayList.size(); ++i) {
                GWToolTipSet gWToolTipSet = (GWToolTipSet)arrayList.get(i);
                graphics.setFont(this.boldF);
                int n4 = this.inset;
                if (!UIUtils.getComponentOrientation().isLeftToRight()) {
                    n4 = jComponent.getBounds().width - this.inset - SwingUtilities.computeStringWidth(this.boldFM, gWToolTipSet.getKey());
                }
                graphics.drawString(gWToolTipSet.getKey(), n4, n2);
                graphics.setFont(this.plainF);
                n3 = this.drawStringIntoRect(graphics, gWToolTipSet.getValue(), n2, this.maxW, jComponent.getBounds().width);
                n2 = n3 + this.plainFM.getAscent() + this.inset * 2;
            }
        } else {
            String string = ((JToolTip)jComponent).getTipText();
            if (string != null) {
                graphics.setColor(Color.black);
                graphics.drawString(string, this.inset, n + this.inset);
            }
        }
    }

    private int drawStringIntoRect(Graphics graphics, String string, int n, int n2, int n3) {
        int n4 = n;
        int n5 = this.leftMargin;
        int n6 = this.plainFM.charWidth(' ');
        int n7 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            n7 = this.plainFM.stringWidth(string2);
            if (n5 + n7 >= n2) {
                n4 += this.plainFM.getHeight();
                n5 = this.leftMargin;
            }
            int n8 = UIUtils.getComponentOrientation().isLeftToRight() ? n5 : n3 - n5 - n7;
            graphics.drawString(string2, n8, n4);
            if ((n5 += n7 + n6) <= this.maxW) continue;
            this.maxW = n5;
        }
        return n4;
    }

    private ArrayList getArrayList(JComponent jComponent) {
        String string = ((JToolTip)jComponent).getTipText();
        ArrayList arrayList = GWToolTip.getArrayList(string);
        return arrayList;
    }

    private boolean isMultiLine(JComponent jComponent) {
        return this.getArrayList(jComponent).size() > 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

