/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemedit;

import com.appframework.AppAction;
import com.appframework.event.AppEvent;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.novell.gw.ab.Recipient;
import com.novell.gw.ab.ResourceContact;
import com.novell.gw.jclient.application.actions.item.ActionShowAppointmentAs;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.TitleValueContainer;
import com.novell.gw.jclient.application.controls.busysearch.GWBusySearch;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateSelector;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateValueChangeListener;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DurationTextField;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DurationTimeDocumentHandler;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DurationTimeFormat;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.RecuringDateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.RecuringDateSelector;
import com.novell.gw.jclient.application.controls.itemedit.ItemEditPanel;
import com.novell.gw.jclient.application.controls.itemedit.RecurringItemEditPanel;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.controls.textcomponent.EditableTextComponent;
import com.novell.gw.jclient.application.controls.timepicker.DurationChangeEvent;
import com.novell.gw.jclient.application.controls.timepicker.DurationChangeListener;
import com.novell.gw.jclient.application.controls.timepicker.TimeDurationSelector;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.TimeDuration;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.FocusManager;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

public class AppointmentEditPanel
extends RecurringItemEditPanel {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$itemedit$AppointmentEditPanel == null ? (class$com$novell$gw$jclient$application$controls$itemedit$AppointmentEditPanel = AppointmentEditPanel.class$("com.novell.gw.jclient.application.controls.itemedit.AppointmentEditPanel")) : class$com$novell$gw$jclient$application$controls$itemedit$AppointmentEditPanel));
    private JPanel pnlStartDate;
    private TimeDurationSelector dsDuration;
    private RecuringDateSelector dsStartDate;
    private TimeDurationSelector dsDurationStored;
    private RecuringDateSelector dsStartDateStored;
    private JPanel pnlEndDate;
    private JLabel lbDuration;
    private DurationTextField tfDuration;
    private DateSelector dsEndDate;
    private JCheckBox cbAllDayEvent;
    private JLabel lbPlace;
    private OrientableTextField tfLocation;
    private EditableTextComponent etcLocation;
    private EditableTextComponent etcSubject;
    private boolean allDayEventMode = false;
    private ListButton cbxShowAs;
    private JMenu mnuShowAppointmentAs = null;
    private boolean showAsChangedByUser;
    private boolean startDateValueEdited = false;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$itemedit$AppointmentEditPanel;

    public AppointmentEditPanel(MVCController mVCController, boolean bl) {
        super(mVCController, "ATTACHLIST_SPLITPOS_APPOINTMENT_EDIT", bl);
        this.focusTraversalPolicy = new AppointmentFocusPolicy();
    }

    public AbstractItem getGWItemComposition() {
        AppointmentItem appointmentItem = (AppointmentItem)this.newItem;
        appointmentItem.setLocation(this.tfLocation.getText());
        appointmentItem.setSubject(this.tfSubject.getText());
        appointmentItem.setAllDayEvent(this.isAllDayEventMode());
        appointmentItem.setShowAsLevel(this.getShowAsLevel(), false);
        if (!this.isAllDayEventMode()) {
            Date[] dateArray = GWCalendarUtils.CalendarToDate(this.rsStartDate.getDates());
            appointmentItem.setStartDates(dateArray);
            appointmentItem.setEndDate(dateArray[0]);
            TimeDuration timeDuration = this.dsDuration.getDuration();
            appointmentItem.changeTimeStart(timeDuration.getStartMinutes());
            appointmentItem.changeTimeEnd(timeDuration.getEndMinutes());
        } else {
            Object object;
            for (int i = 0; i < this.dsStartDate.getDates().length; ++i) {
                object = this.dsStartDate.getDates()[i];
                GWCalendarUtils.clearTime((GregorianCalendar)object);
            }
            Date[] dateArray = GWCalendarUtils.CalendarToDate(this.dsStartDate.getDates());
            if (this.dsStartDate.isRecuring()) {
                appointmentItem.setStartDates(dateArray);
                appointmentItem.setEndDate(dateArray[0]);
            } else {
                object = this.dsEndDate.getDate();
                GWCalendarUtils.clearTime((GregorianCalendar)object);
                appointmentItem.setStartDates(dateArray);
                appointmentItem.setEndDate(((Calendar)object).getTime());
            }
            object = this.dsDuration.getDuration();
            appointmentItem.changeTimeStart(((TimeDuration)object).getStartMinutes());
            appointmentItem.changeTimeEnd(((TimeDuration)object).getEndMinutes());
        }
        return super.getGWItemComposition();
    }

    public void setGWItemComposition(AbstractItem abstractItem) {
        super.setGWItemComposition(abstractItem);
        AppointmentItem appointmentItem = (AppointmentItem)this.newItem;
        this.setShowAsLevel(appointmentItem.getShowAsLevel());
        this.tfCC.setRecipients(appointmentItem.getCcRecipients());
        this.tfTo.setRecipients(appointmentItem.getToRecipients());
        this.tfBC.setRecipients(appointmentItem.getBcRecipients());
        this.tfLocation.setText(appointmentItem.getLocation());
        this.tfSubject.setText(appointmentItem.getSubject());
        this.getController().getActionList().getAction("All Day Event").setSelected(appointmentItem.isAllDayEvent());
        this.setAppointmentDatesToUI(appointmentItem);
    }

    private int getShowAsLevel() {
        String string = this.cbxShowAs.getText();
        int n = 210;
        if (string.equals(StringResources.BUSY)) {
            n = 210;
        } else if (string.equals(StringResources.FREE)) {
            n = 160;
        } else if (string.equals(StringResources.TENTATIVE)) {
            n = 190;
        } else if (string.equals(StringResources.OUT_OF_OFFICE)) {
            n = 251;
        }
        return n;
    }

    private void setShowAsLevel(int n) {
        JMenu jMenu;
        JFrame jFrame;
        String string = StringResources.BUSY;
        switch (n) {
            case 210: {
                string = StringResources.BUSY;
                break;
            }
            case 160: {
                string = StringResources.FREE;
                break;
            }
            case 190: {
                string = StringResources.TENTATIVE;
                break;
            }
            case 251: {
                string = StringResources.OUT_OF_OFFICE;
            }
        }
        this.cbxShowAs.setText(string);
        JRadioButtonMenuItem jRadioButtonMenuItem = this.getMenuItem(this.cbxShowAs.getPopupMenu(), string);
        if (jRadioButtonMenuItem != null) {
            jRadioButtonMenuItem.setSelected(true);
        }
        if (this.mnuShowAppointmentAs == null && (jFrame = this.getParentFrame(this)) != null && (jMenu = this.getActionsMenu(jFrame.getJMenuBar())) != null) {
            this.mnuShowAppointmentAs = this.getShowAppointmentAs(jMenu);
        }
        if (this.mnuShowAppointmentAs != null && (jRadioButtonMenuItem = this.getMenuItem(this.mnuShowAppointmentAs.getPopupMenu(), string)) != null) {
            jRadioButtonMenuItem.setSelected(true);
        }
    }

    private void setAppointmentDatesToUI(AppointmentItem appointmentItem) {
        this.setAllDayEventMode(appointmentItem.isAllDayEvent());
        if (!this.isAllDayEventMode()) {
            Date[] dateArray = appointmentItem.getStartDates();
            this.rsStartDate.setDates(GWCalendarUtils.DateToCalendar(dateArray));
            GregorianCalendar gregorianCalendar = GWCalendarUtils.getToday();
            gregorianCalendar.setTime(appointmentItem.getStartDate());
            int n = GWCalendarUtils.getMinutes(gregorianCalendar);
            GregorianCalendar gregorianCalendar2 = GWCalendarUtils.getToday();
            gregorianCalendar2.setTime(appointmentItem.getEndDate());
            int n2 = (int)(gregorianCalendar2.getTimeInMillis() - gregorianCalendar.getTimeInMillis()) / 60000 + n;
            TimeDuration timeDuration = new TimeDuration(n, n2);
            this.dsDuration.setDuration(timeDuration);
            this.tfDuration.setDuration(timeDuration);
        } else {
            Date[] dateArray = appointmentItem.getStartDates();
            this.dsStartDate.setDates(GWCalendarUtils.DateToCalendar(dateArray));
            GregorianCalendar gregorianCalendar = GWCalendarUtils.getToday();
            gregorianCalendar.setTime(appointmentItem.getStartDate());
            GregorianCalendar gregorianCalendar3 = GWCalendarUtils.getToday();
            gregorianCalendar3.setTime(appointmentItem.getEndDate());
            gregorianCalendar3.add(10, -24);
            this.dsStartDate.setDate(gregorianCalendar);
            this.dsEndDate.setDate(gregorianCalendar3);
        }
    }

    public void handle_ACTION_BUSYSEARCH_PERFORMED(AppEvent appEvent) {
        GWBusySearch gWBusySearch = (GWBusySearch)appEvent.getData();
        this.tfTo.clear();
        this.tfTo.setRecipients(gWBusySearch.getRecipientsList().getSelectedRecipients(1));
        this.tfCC.clear();
        this.tfCC.setRecipients(gWBusySearch.getRecipientsList().getSelectedRecipients(2));
        this.tfBC.clear();
        this.tfBC.setRecipients(gWBusySearch.getRecipientsList().getSelectedRecipients(4));
        AppointmentItem appointmentItem = (AppointmentItem)this.newItem;
        appointmentItem.setStartDates(new Date[]{gWBusySearch.getAppointmentTime().getStartDateAsDate()});
        appointmentItem.setEndDate(gWBusySearch.getAppointmentTime().getEndDateAsDate());
        this.setAllDayEventMode(false);
        this.setAppointmentDatesToUI(appointmentItem);
        logger.debug((Object)"busy search finished!");
    }

    protected boolean handle_ACTION_SET_ALL_DAY_EVENT(boolean bl) {
        this.setAllDayEventMode(bl);
        return true;
    }

    private void fillLocationField() {
        List list = this.tfTo.getRecipients();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            Recipient recipient = (Recipient)list.get(i);
            if (!(recipient.getAddressable() instanceof ResourceContact)) continue;
            stringBuffer.append(recipient.getAddressable().getDisplayName()).append(' ');
        }
        if (stringBuffer.length() > 0) {
            this.tfLocation.setText(stringBuffer.toString());
        }
    }

    protected void build() {
        super.build();
        this.contentPanel.setLayout(new BorderLayout());
        this.tfLocation = new OrientableTextField();
        this.tfLocation.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                AppointmentEditPanel.this.fillLocationField();
            }
        });
        this.etcLocation = this.createEditableTextComponent(this.tfLocation);
        this.cbAllDayEvent = (JCheckBox)this.getController().getActionList().getAction("All Day Event").getToolBarComponent();
        this.tfSubject = new OrientableTextField();
        this.pnlStartDate = new OrientablePanel();
        this.rsStartDate = new RecuringDateSelector();
        this.rsStartDate.addRecuringDateChangeListener(this);
        this.dsDuration = new TimeDurationSelector();
        this.dsStartDate = new RecuringDateSelector();
        this.dsStartDate.addRecuringDateChangeListener(this);
        this.dsStartDate.addDateChangeListener(new AllDayEventStartDateChangedListener());
        this.dsDurationStored = new TimeDurationSelector();
        this.dsStartDateStored = new RecuringDateSelector();
        this.pnlEndDate = new OrientablePanel();
        this.tfDuration = new DurationTextField(new DurationTimeFormat(), new DurationTimeDocumentHandler());
        this.dsEndDate = new DateSelector();
        this.cbxShowAs = new ListButton();
        this.cbxShowAs.setPopupActions(new AppAction[]{this.getController().getActionList().getAction("Show Appointment As Busy"), this.getController().getActionList().getAction("Show Appointment As Free"), this.getController().getActionList().getAction("Show Appointment As Out Of Office"), this.getController().getActionList().getAction("Show Appointment As Tentative")});
        this.dsEndDate.addDateChangeListener(new AllDayEventStartDateChangedListener());
        this.dsDuration.addTextField(this.tfDuration);
        DurationTimeChangeListener durationTimeChangeListener = new DurationTimeChangeListener(this.tfDuration, this.dsDuration);
        this.tfDuration.addDurationChangeListener(durationTimeChangeListener);
        this.dsDuration.addDurationChangeListener(durationTimeChangeListener);
        this.lbFrom = new OrientableLabel(StringResources.FROM_C);
        this.lbTo = new JMnemonicLabel(StringResources.TO_C, (Component)((Object)this.tfTo));
        this.lbCC = new JMnemonicLabel(StringResources.CC_C, (Component)((Object)this.tfCC));
        this.lbBC = new JMnemonicLabel(StringResources.BC_C, (Component)((Object)this.tfBC));
        this.lbPlace = new JMnemonicLabel(StringResources.PLACE_C, this.tfLocation);
        this.lbStartDate = new JMnemonicLabel();
        this.lbDuration = new JMnemonicLabel();
        this.lbSubject = new JMnemonicLabel(StringResources.SUBJECT_C, this.tfSubject);
        OrientablePanel orientablePanel = new OrientablePanel(new BorderLayout());
        orientablePanel.setBorder(new EmptyBorder(10, 10, 0, 10));
        orientablePanel.add((Component)this.messageEditor, "Center");
        OrientablePanel orientablePanel2 = new OrientablePanel(new BorderLayout());
        orientablePanel2.setBorder(new EmptyBorder(0, 10, 0, 10));
        orientablePanel2.add((Component)this.attachmentList, "Center");
        this.messageSplit.setBottomComponent(orientablePanel2);
        this.messageSplit.setTopComponent(orientablePanel);
        this.rebuildStartDatePanel(this.isAllDayEventMode());
        this.rebuildEndDatePanel(this.isAllDayEventMode());
        this.createAddressPane();
        this.contentPanel.add((Component)this.addressPane, "North");
        this.contentPanel.add((Component)this.messageSplit, "Center");
    }

    public void initShowAsHandler(JFrame jFrame) {
        JMenu jMenu = this.getActionsMenu(jFrame.getJMenuBar());
        if (jMenu != null) {
            this.mnuShowAppointmentAs = this.getShowAppointmentAs(jMenu);
            if (this.mnuShowAppointmentAs != null) {
                FixShowAsActionListener fixShowAsActionListener = new FixShowAsActionListener();
                int n = this.mnuShowAppointmentAs.getItemCount();
                for (int i = 0; i < n; ++i) {
                    JMenuItem jMenuItem = this.mnuShowAppointmentAs.getItem(i);
                    jMenuItem.addActionListener(fixShowAsActionListener);
                }
            }
        }
    }

    public void switchToPostedMode() {
        super.switchToPostedMode();
        this.addressPane.removeAll();
        TitleValueContainer titleValueContainer = new TitleValueContainer(this.addressPane);
        titleValueContainer.getInsets().bottom = 8;
        titleValueContainer.getInsets().top = 0;
        titleValueContainer.buildRow(this.lbFrom, this.tfFrom, 0);
        titleValueContainer.buildRow(this.lbSubject, this.tfSubject, 1);
        titleValueContainer.buildRow(this.lbPlace, this.buildLocationPane(), 2);
        titleValueContainer.buildRow(this.lbStartDate, this.pnlStartDate, 3);
        titleValueContainer.buildRow(this.lbDuration, this.pnlEndDate, 4);
    }

    private void createAddressPane() {
        this.addressPane = new OrientablePanel(new GridBagLayout());
        this.addressPane.setBorder(new EmptyBorder(10, 10, 0, 10));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 10);
        this.addressPane.add((Component)this.lbFrom, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        gridBagConstraints.weightx = 1.0;
        this.addressPane.add((Component)this.tfFrom, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(0, 15, 8, 25);
        gridBagConstraints.weightx = 0.0;
        this.addressPane.add((Component)this.lbCC, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 1.0;
        this.addressPane.add((Component)this.etcCC, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        this.addressPane.add((Component)this.lbTo, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.addressPane.add((Component)this.etcTo, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 15, 8, 25);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        this.addressPane.add((Component)this.lbBC, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 1.0;
        this.addressPane.add((Component)this.etcBC, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 10);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        this.addressPane.add((Component)this.lbPlace, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.addressPane.add((Component)this.buildLocationPane(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        this.addressPane.add((Component)this.lbStartDate, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this.addressPane.add((Component)this.pnlStartDate, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        this.addressPane.add((Component)this.lbDuration, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 1;
        this.addressPane.add((Component)this.pnlEndDate, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.addressPane.add((Component)this.lbSubject, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.etcSubject = this.createEditableTextComponent(this.tfSubject);
        this.addressPane.add((Component)this.etcSubject, gridBagConstraints);
    }

    private void rebuildStartDatePanel(boolean bl) {
        if (!bl) {
            this.pnlStartDate.removeAll();
            this.pnlStartDate.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 0;
            this.pnlStartDate.add((Component)this.rsStartDate, gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.ipadx = 10;
            this.pnlStartDate.add((Component)this.dsDuration, gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 2;
            this.pnlStartDate.add((Component)this.cbAllDayEvent, gridBagConstraints);
            this.refreshStartDateLabel();
            this.lbStartDate.setLabelFor(this.dsDuration);
        } else {
            this.pnlStartDate.removeAll();
            this.pnlStartDate.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 0;
            this.pnlStartDate.add((Component)this.dsStartDate, gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 1;
            this.pnlStartDate.add((Component)this.cbAllDayEvent, gridBagConstraints);
            this.refreshStartDateLabel();
            this.lbStartDate.setLabelFor(this.dsStartDate);
        }
        this.pnlStartDate.repaint();
    }

    private void refreshStartDateLabel() {
        if (this.isRecurring()) {
            this.lbStartDate.setText(StringResources.AUTO_DATE_C);
        } else {
            this.lbStartDate.setText(StringResources.START_DATE_C);
        }
    }

    private boolean isRecurring() {
        return this.dsStartDate.isRecuring() && this.isAllDayEventMode() || this.rsStartDate.isRecuring() && !this.isAllDayEventMode();
    }

    private void rebuildEndDatePanel(boolean bl) {
        this.pnlEndDate.removeAll();
        this.pnlEndDate.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.right = 5;
        if (!bl || this.isRecurring()) {
            this.pnlEndDate.add((Component)this.tfDuration, gridBagConstraints);
            this.lbDuration.setText(StringResources.DURATION_C);
            this.lbDuration.setLabelFor(this.tfDuration);
        } else {
            this.pnlEndDate.add((Component)this.dsEndDate, gridBagConstraints);
            this.lbDuration.setText(StringResources.END_DATE_C);
            this.lbDuration.setLabelFor(this.dsEndDate);
        }
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        this.pnlEndDate.add((Component)this.cbxShowAs, gridBagConstraints);
        this.pnlEndDate.repaint();
    }

    private JPanel buildLocationPane() {
        OrientablePanel orientablePanel = new OrientablePanel(new BorderLayout());
        orientablePanel.add((Component)this.etcLocation, "Center");
        return orientablePanel;
    }

    public void valueChanged(RecuringDateChangeEvent recuringDateChangeEvent) {
        this.refreshStartDateLabel();
        super.valueChanged(recuringDateChangeEvent);
    }

    public boolean isAllDayEventMode() {
        return this.allDayEventMode;
    }

    private void setAllDayEventMode(boolean bl) {
        Object object;
        if (!this.isRecurring() && bl) {
            this.dsEndDate.setDate((GregorianCalendar)this.rsStartDate.getDate().clone());
        }
        this.allDayEventMode = bl;
        if (bl) {
            if (this.rsStartDate.getDates().length > 0) {
                this.dsStartDate.setDates(this.rsStartDate.getDates());
            }
            if (!this.isRecurring()) {
                this.dsStartDateStored.setDates(this.dsStartDate.getDates());
            }
            this.dsDurationStored.setDuration(this.dsDuration.getDuration());
            object = new TimeDuration(0, 1440);
            this.dsDuration.setDuration((TimeDuration)object);
        } else {
            this.dsDuration.setDuration(this.dsDurationStored.getDuration());
            if (!this.startDateValueEdited && !this.isRecurring() && this.dsStartDateStored.getDates().length > 0) {
                this.dsStartDate.setDates(this.dsStartDateStored.getDates());
            }
            if (this.dsStartDate.getDates().length > 0) {
                this.rsStartDate.setDates(this.dsStartDate.getDates());
            }
        }
        this.rebuildStartDatePanel(bl);
        this.rebuildEndDatePanel(bl);
        object = new Command(1150, bl);
        this.getController().processCommand((Command)object);
        if (!this.showAsChangedByUser) {
            int n = this.allDayEventMode ? 160 : 210;
            this.setShowAsLevel(n);
        }
        this.startDateValueEdited = false;
    }

    private void fixShowAsValue(JRadioButtonMenuItem jRadioButtonMenuItem) {
        String string = jRadioButtonMenuItem.getText();
        this.cbxShowAs.setText(string);
        this.fixPopup(this.cbxShowAs.getPopupMenu(), jRadioButtonMenuItem);
    }

    private void setShowAsValue(JRadioButtonMenuItem jRadioButtonMenuItem, ActionEvent actionEvent) {
        JMenu jMenu;
        Serializable serializable;
        this.showAsChangedByUser = true;
        String string = this.cbxShowAs.getText();
        ActionShowAppointmentAs actionShowAppointmentAs = null;
        if (string.equalsIgnoreCase(StringResources.BUSY)) {
            actionShowAppointmentAs = (ActionShowAppointmentAs)this.getController().getActionList().getAction("Show Appointment As Busy");
        } else if (string.equalsIgnoreCase(StringResources.FREE)) {
            actionShowAppointmentAs = (ActionShowAppointmentAs)this.getController().getActionList().getAction("Show Appointment As Free");
        } else if (string.equalsIgnoreCase(StringResources.OUT_OF_OFFICE)) {
            actionShowAppointmentAs = (ActionShowAppointmentAs)this.getController().getActionList().getAction("Show Appointment As Out Of Office");
        } else if (string.equalsIgnoreCase(StringResources.TENTATIVE)) {
            actionShowAppointmentAs = (ActionShowAppointmentAs)this.getController().getActionList().getAction("Show Appointment As Tentative");
        }
        if (actionShowAppointmentAs != null) {
            serializable = (AppointmentItem)this.newItem;
            serializable.setShowAsLevel(actionShowAppointmentAs.getAcceptLevel(), false);
            actionShowAppointmentAs.setSelected(true);
        }
        if ((serializable = this.getActionsMenu(this.getParentFrame(this).getJMenuBar())) != null && (jMenu = this.getShowAppointmentAs((JMenu)serializable)) != null) {
            this.fixPopup(jMenu.getPopupMenu(), jRadioButtonMenuItem);
        }
    }

    private void fixPopup(JPopupMenu jPopupMenu, JRadioButtonMenuItem jRadioButtonMenuItem) {
        int n = jPopupMenu.getComponentCount();
        for (int i = 0; i < n; ++i) {
            JRadioButtonMenuItem jRadioButtonMenuItem2 = (JRadioButtonMenuItem)jPopupMenu.getComponent(i);
            if (!jRadioButtonMenuItem2.getAction().equals(jRadioButtonMenuItem.getAction())) continue;
            jRadioButtonMenuItem2.setSelected(true);
            break;
        }
    }

    private JMenu getShowAppointmentAs(JMenu jMenu) {
        if (this.mnuShowAppointmentAs != null) {
            return this.mnuShowAppointmentAs;
        }
        JMenu jMenu2 = null;
        if (jMenu != null) {
            int n = jMenu.getItemCount();
            for (int i = 0; i < n; ++i) {
                JMenuItem jMenuItem = jMenu.getItem(i);
                if (jMenuItem == null || !jMenuItem.getText().equals(StringResources.MENU_SHOW_APPOINTMENT_AS)) continue;
                jMenu2 = (JMenu)jMenuItem;
                break;
            }
        }
        return jMenu2;
    }

    private JMenu getActionsMenu(JMenuBar jMenuBar) {
        JMenu jMenu = null;
        if (jMenuBar != null) {
            int n = jMenuBar.getMenuCount();
            for (int i = 0; i < n; ++i) {
                JMenu jMenu2 = jMenuBar.getMenu(i);
                if (!jMenu2.getText().equals(StringResources.ACTIONS)) continue;
                jMenu = jMenu2;
                break;
            }
        }
        return jMenu;
    }

    public JRadioButtonMenuItem getMenuItem(JPopupMenu jPopupMenu, String string) {
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        if (string != null) {
            int n = jPopupMenu.getComponentCount();
            for (int i = 0; i < n; ++i) {
                JRadioButtonMenuItem jRadioButtonMenuItem2 = (JRadioButtonMenuItem)jPopupMenu.getComponent(i);
                if (!string.equals(jRadioButtonMenuItem2.getText())) continue;
                jRadioButtonMenuItem = jRadioButtonMenuItem2;
                break;
            }
        }
        return jRadioButtonMenuItem;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ListButton
    extends OrientableButton {
        private JPopupMenu popupMenu = new JPopupMenu();

        public ListButton() {
            this.initUI();
        }

        private void initUI() {
            this.setIcon(ImageResources.ADV_FILTER_UP_DOWN);
            this.setHorizontalTextPosition(10);
            this.addActionListener(new ShowPopupAction());
        }

        public JPopupMenu getPopupMenu() {
            return this.popupMenu;
        }

        public void setPopupActions(AppAction[] appActionArray) {
            if (appActionArray != null) {
                this.popupMenu.removeAll();
                ButtonGroup buttonGroup = new ButtonGroup();
                String string = "";
                int n = appActionArray.length;
                for (int i = 0; i < n; ++i) {
                    JMenuItem jMenuItem = appActionArray[i].getMenuItem();
                    this.popupMenu.add(jMenuItem);
                    jMenuItem.addActionListener(new FixSelectionAction(jMenuItem.getText()));
                    if (i == 0) {
                        string = jMenuItem.getText();
                        jMenuItem.setSelected(true);
                    }
                    buttonGroup.add(jMenuItem);
                }
                this.setText(string);
            }
        }

        public void setPopup(JPopupMenu jPopupMenu) {
            if (jPopupMenu != null) {
                this.popupMenu = jPopupMenu;
                String string = "";
                int n = jPopupMenu.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    JMenuItem jMenuItem = (JMenuItem)this.popupMenu.getComponent(i);
                    jMenuItem.addActionListener(new FixSelectionAction(jMenuItem.getText()));
                    if (i != 0) continue;
                    string = jMenuItem.getText();
                }
                this.setText(string);
            }
        }

        private class FixSelectionAction
        implements ActionListener {
            private String label = "[menu item]";

            public FixSelectionAction(String string) {
                this.label = string;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)actionEvent.getSource();
                ListButton.this.setText(this.label);
                jRadioButtonMenuItem.setSelected(true);
                AppointmentEditPanel.this.setShowAsValue(jRadioButtonMenuItem, actionEvent);
            }
        }

        private class ShowPopupAction
        implements ActionListener {
            private ShowPopupAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ListButton.this.popupMenu.show(ListButton.this, 0, 0);
            }
        }
    }

    private class AllDayEventStartDateChangedListener
    implements DateValueChangeListener {
        private AllDayEventStartDateChangedListener() {
        }

        public void valueChanged(DateChangeEvent dateChangeEvent) {
            RecuringDateSelector recuringDateSelector = AppointmentEditPanel.this.dsStartDate;
            DateSelector dateSelector = AppointmentEditPanel.this.dsEndDate;
            if (dateChangeEvent.getSource() == recuringDateSelector && recuringDateSelector.getDate().getTimeInMillis() > dateSelector.getDate().getTimeInMillis()) {
                dateSelector.setDate((GregorianCalendar)recuringDateSelector.getDate().clone());
            }
            if (dateChangeEvent.getSource() == dateSelector && dateSelector.getDate().getTimeInMillis() < recuringDateSelector.getDate().getTimeInMillis() && !AppointmentEditPanel.this.isRecurring()) {
                recuringDateSelector.setDate((GregorianCalendar)dateSelector.getDate().clone());
            }
            AppointmentEditPanel.this.refreshStartDateLabel();
            AppointmentEditPanel.this.rebuildEndDatePanel(AppointmentEditPanel.this.isAllDayEventMode());
            AppointmentEditPanel.this.startDateValueEdited = true;
        }
    }

    private class AppointmentFocusPolicy
    extends ItemEditPanel.ItemComposerTraversalPolicy {
        private AppointmentFocusPolicy() {
        }

        public Component getComponentAfter(Container container, Component component) {
            AppointmentEditPanel appointmentEditPanel = AppointmentEditPanel.this;
            Component component2 = FocusManager.getCurrentManager().getPermanentFocusOwner();
            if (!component.hasFocus()) {
                return component2;
            }
            if (component.equals(appointmentEditPanel.tfTo.getComponent())) {
                return appointmentEditPanel.tfLocation;
            }
            if (component.equals(appointmentEditPanel.tfSubject) && !this.isPostedCompose || component.equals(appointmentEditPanel.cbxShowAs) && this.isPostedCompose) {
                return appointmentEditPanel.messageEditor.getComponent();
            }
            if (component.equals(AppointmentEditPanel.this.messageEditor.getComponent())) {
                return appointmentEditPanel.attachmentList.getListContent();
            }
            if (component.equals(appointmentEditPanel.tfCC.getComponent())) {
                return appointmentEditPanel.tfBC.getComponent();
            }
            if (component.equals(appointmentEditPanel.tfBC.getComponent())) {
                return appointmentEditPanel.tfTo.getComponent();
            }
            return super.getComponentAfter(container, component);
        }

        public Component getComponentBefore(Container container, Component component) {
            AppointmentEditPanel appointmentEditPanel = AppointmentEditPanel.this;
            if (component.equals(appointmentEditPanel.tfTo.getComponent())) {
                return appointmentEditPanel.tfBC.getComponent();
            }
            if (component.equals(appointmentEditPanel.tfBC.getComponent())) {
                return appointmentEditPanel.tfCC.getComponent();
            }
            if (this.isPostedCompose && component.equals(appointmentEditPanel.tfSubject)) {
                return appointmentEditPanel.attachmentList.getListContent();
            }
            if (!this.isPostedCompose && component.equals(appointmentEditPanel.tfLocation)) {
                return appointmentEditPanel.tfTo.getComponent();
            }
            if (ControlsUtils.isComponentInContainer(appointmentEditPanel.attachmentList, component)) {
                return appointmentEditPanel.messageEditor.getComponent();
            }
            return super.getComponentBefore(container, component);
        }

        public Component getDefaultComponent(Container container) {
            return AppointmentEditPanel.this.getComponentForFocus();
        }
    }

    private class FixShowAsActionListener
    implements ActionListener {
        private FixShowAsActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)actionEvent.getSource();
            AppointmentEditPanel.this.fixShowAsValue(jRadioButtonMenuItem);
        }
    }

    private class DurationTimeChangeListener
    implements DurationChangeListener {
        private DurationTextField durationField;
        private TimeDurationSelector durationSelector;

        public DurationTimeChangeListener(DurationTextField durationTextField, TimeDurationSelector timeDurationSelector) {
            this.durationField = durationTextField;
            this.durationSelector = timeDurationSelector;
        }

        public void valueChanged(DurationChangeEvent durationChangeEvent) {
            Object object = durationChangeEvent.getSource();
            TimeDuration timeDuration = durationChangeEvent.getDuration();
            if (object == this.durationSelector) {
                this.durationField.setDuration(timeDuration);
            } else {
                this.durationSelector.setDuration(timeDuration);
            }
        }
    }
}

