/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview;

import com.appframework.ActionList;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.OS;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.controls.itemview.EmbededParentViewController;
import com.novell.gw.jclient.application.controls.itemview.SensitiveLabel;
import com.novell.gw.jclient.application.controls.itemview.UneditableTextField;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.options.EnvironmentOptions;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class EmbededParentView
extends OrientablePanel
implements MVCView {
    public static final Color DEFAULT_COLOR = new Color(255, 255, 230);
    public static final Color DEFAULT_TEXT_COLOR = Color.BLACK;
    public static final String DEFAULT_TEXT_SIZE = String.valueOf(PLAFChanger.getFontSize());
    public static final Boolean DEFAULT_HIDE_SYSTEM_ATTACHMENTS = Boolean.TRUE;
    private EmbededParentViewController controller;
    private AbstractItem gwItem;
    private JLabel lbParentMessage;
    private SensitiveLabel lbSubject;
    private SensitiveLabel lbFrom;
    private UneditableTextField tfSubject;
    private UneditableTextField tfFrom;
    private JPopupMenu popupMenu;
    private boolean built;

    public EmbededParentView(MVCController mVCController) {
        this.controller = new EmbededParentViewController(this, mVCController);
        this.build();
    }

    private void build() {
        this.lbParentMessage = new OrientableLabel(StringResources.PARENT_MESSAGE);
        this.lbParentMessage.setIcon(ImageResources.ICON_SHOW_PARENT_MESSAGE);
        this.lbParentMessage.setFont(Utils.deriveFont(this.lbParentMessage.getFont(), 1));
        this.lbParentMessage.setCursor(Cursor.getPredefinedCursor(12));
        this.lbParentMessage.addMouseListener(new ParentMessageMouseListener());
        this.lbSubject = new SensitiveLabel(StringResources.SUBJECT_C, null);
        this.lbFrom = new SensitiveLabel(StringResources.FROM_C, null);
        this.tfFrom = new UneditableTextField(this.lbFrom);
        this.tfSubject = new UneditableTextField(this.lbSubject);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        this.add((Component)this.lbParentMessage, gridBagConstraints);
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        OrientablePanel orientablePanel = new OrientablePanel();
        orientablePanel.setOpaque(false);
        BoxLayout boxLayout = new BoxLayout(orientablePanel, 2);
        orientablePanel.setLayout(boxLayout);
        orientablePanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this.lbSubject.setAlignmentX(1.0f);
        this.tfSubject.setAlignmentX(1.0f);
        orientablePanel.add(this.lbSubject);
        orientablePanel.add(this.tfSubject);
        gridBagConstraints.insets = new Insets(0, 10, 0, 5);
        Dimension dimension = EmbededParentView.getTextDimention(this.lbSubject, StringResources.FROM_C);
        dimension = new Dimension(dimension.width + 20, dimension.height);
        this.lbSubject.setMinimumSize(dimension);
        this.lbSubject.setPreferredSize(dimension);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)orientablePanel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.anchor = 22;
        this.add((Component)this.lbFrom, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 20;
        this.add((Component)this.tfFrom, gridBagConstraints);
        this.built = true;
        this.popupMenu = new PropertiesPopupMenu();
        this.addMouseListener(new RClickMouseListener());
        EnvironmentOptions environmentOptions = OptionManager.getInstance().getEnvironmentOptions();
        this.setBackground(environmentOptions.getEmbHeaderColor());
        this.setForeground(environmentOptions.getEmbHeaderTextColor());
        try {
            this.setFontSize(Float.parseFloat(environmentOptions.getEmbHeaderTextSize()));
        }
        catch (NumberFormatException numberFormatException) {
            this.setFontSize(12.0f);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.built) {
            this.lbFrom.setBackground(color);
            this.lbSubject.setBackground(color);
            this.tfFrom.setBackground(color);
            this.tfSubject.setBackground(color);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.built) {
            this.lbParentMessage.setForeground(color);
            this.lbFrom.setForeground(color);
            this.lbSubject.setForeground(color);
            this.tfFrom.setForeground(color);
            this.tfSubject.setForeground(color);
        }
    }

    public void setFontSize(float f) {
        Font font = Utils.deriveFontForSize(this.getFont(), f);
        Font font2 = Utils.deriveFont(font, 1);
        this.lbParentMessage.setFont(font2);
        this.tfFrom.setFont(font);
        this.tfSubject.setFont(font);
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this.popupMenu = jPopupMenu;
    }

    public Insets getInsets() {
        return new Insets(3, 3, 3, 3);
    }

    public void setController(MVCController mVCController) {
        this.controller = (EmbededParentViewController)mVCController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object object) {
        if (object instanceof AbstractItem && this.gwItem != object) {
            this.gwItem = (AbstractItem)object;
            this.updateView();
        }
    }

    public Object getMVCModel() {
        return null;
    }

    private void updateView() {
        if (this.gwItem != null) {
            this.tfSubject.setText(this.gwItem.getSubject());
            this.tfFrom.setText(this.gwItem.getNativeItem().getFromText());
            Dimension dimension = EmbededParentView.getTextDimention(this.tfFrom, this.gwItem.getNativeItem().getFromText());
            this.tfFrom.setPreferredSize(dimension);
            this.tfFrom.setMinimumSize(dimension);
            this.tfSubject.setCaretPosition(0);
            this.validate();
        }
    }

    private static Dimension getTextDimention(JComponent jComponent, String string) {
        int n = SwingUtilities.computeStringWidth(jComponent.getFontMetrics(jComponent.getFont()), string);
        int n2 = 0;
        Dimension dimension = new Dimension(n + n2, jComponent.getPreferredSize().height);
        return dimension;
    }

    private class PropertiesPopupMenu
    extends JPopupMenu {
        public PropertiesPopupMenu() {
            ActionList actionList = EmbededParentView.this.controller.getActionList();
            this.add(actionList.getAction("change emb header color").getMenuItem());
            this.add(actionList.getAction("change emb header text color").getMenuItem());
        }
    }

    private class RClickMouseListener
    extends MouseAdapter {
        private RClickMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.doPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.doPopup(mouseEvent);
        }

        private void doPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && EmbededParentView.this.popupMenu != null) {
                EmbededParentView.this.popupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class ParentMessageMouseListener
    extends MouseAdapter {
        private ParentMessageMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (OS.isLeftMouseButton(mouseEvent)) {
                Command command = new Command(60);
                EmbededParentView.this.getController().processCommand(command);
            }
        }
    }
}

