/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview;

import com.appframework.utils.Utils;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class UnderlinableLabel
extends JLabel
implements FocusListener {
    private Rectangle paintIconR = new Rectangle();
    private Rectangle paintTextR = new Rectangle();
    private Rectangle paintViewR = new Rectangle();
    private Insets paintViewInsets = new Insets(0, 0, 0, 0);

    public UnderlinableLabel() {
        this.setFont(Utils.deriveFont(this.getFont(), 1));
        this.setFocusable(true);
        this.addFocusListener(this);
    }

    public void paint(Graphics graphics) {
        if (this.isFocusOwner()) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Insets insets = this.getInsets(this.paintViewInsets);
            this.paintViewR.x = insets.left;
            this.paintViewR.y = insets.top;
            this.paintViewR.width = this.getWidth() - (insets.left + insets.right);
            this.paintViewR.height = this.getHeight() - (insets.top + insets.bottom);
            this.paintIconR.height = 0;
            this.paintIconR.width = 0;
            this.paintIconR.y = 0;
            this.paintIconR.x = 0;
            this.paintTextR.height = 0;
            this.paintTextR.width = 0;
            this.paintTextR.y = 0;
            this.paintTextR.x = 0;
            SwingUtilities.layoutCompoundLabel(this, fontMetrics, this.getText(), this.getIcon(), this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), this.paintViewR, this.paintIconR, this.paintTextR, this.getIconTextGap());
            graphics.setColor(this.getForeground());
            graphics.drawLine(this.paintTextR.x, this.paintTextR.y + this.paintTextR.height - 1, this.paintTextR.x + this.paintTextR.width, this.paintTextR.y + this.paintTextR.height - 1);
        }
        super.paint(graphics);
    }

    public void focusGained(FocusEvent focusEvent) {
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.repaint();
    }
}

