/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview;

import com.novell.gw.jclient.application.controls.itemview.Underlinable;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalTextFieldUI;

public class UneditableTextField
extends OrientableTextField {
    private boolean manualSelected;

    public UneditableTextField(Underlinable underlinable) {
        this.setEditable(false);
        if ("com.sun.java.swing.plaf.gtk.GTKLookAndFeel".equals(UIManager.getLookAndFeel().getClass().getName())) {
            this.setUI(new MetalTextFieldUI());
        }
        this.setBorder(null);
        this.addFocusListener(new UnderlineFocusListener(underlinable));
    }

    protected void handleFocus(boolean bl) {
        if (bl && this.manualSelected) {
            this.manualSelected = false;
        } else {
            this.setSelectionStart(0);
            this.setSelectionEnd(0);
            this.manualSelected = false;
        }
    }

    public void setManualSelected(boolean bl) {
        this.manualSelected = bl;
    }

    private class UnderlineFocusListener
    implements FocusListener {
        private Underlinable underlinable;

        public UnderlineFocusListener(Underlinable underlinable) {
            this.underlinable = underlinable;
        }

        public void focusGained(FocusEvent focusEvent) {
            if (this.underlinable != null) {
                this.underlinable.setUnderlined(true);
            }
            UneditableTextField.this.handleFocus(true);
        }

        public void focusLost(FocusEvent focusEvent) {
            if (this.underlinable != null) {
                this.underlinable.setUnderlined(false);
            }
            UneditableTextField.this.handleFocus(false);
            UneditableTextField.this.repaint();
        }
    }
}

