/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview.contentviewer;

import com.appframework.components.htmleditor.HTMLExternalTextViewer;
import com.appframework.components.htmleditor.HTMLTextPane;
import com.appframework.components.htmleditor.HTMLTextViewer;
import com.appframework.components.htmleditor.HTMLViewer;
import com.appframework.components.htmleditor.hyperlink.HTMLUtils;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.itemview.contentviewer.HTMLViewerHyperlinkListener;
import com.novell.gw.jclient.application.controls.itemview.imageviewer.ImageViewer;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.exceptions.GWException;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.apache.log4j.Logger;

public class ContentViewer
extends JComponent {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$itemview$contentviewer$ContentViewer == null ? (class$com$novell$gw$jclient$application$controls$itemview$contentviewer$ContentViewer = ContentViewer.class$("com.novell.gw.jclient.application.controls.itemview.contentviewer.ContentViewer")) : class$com$novell$gw$jclient$application$controls$itemview$contentviewer$ContentViewer));
    private HTMLViewer messageViewer;
    private ImageViewer imageViewer;
    private static final String MESSAGE_VIEWER = "MESSAGE_VIEWER";
    private static final String IMAGE_VIEWER = "IMAGE_VIEWER";
    private CardLayout cardLayout = new CardLayout();
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$itemview$contentviewer$ContentViewer;

    public ContentViewer(MVCController mVCController) {
        this.setLayout(this.cardLayout);
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        RtfLinkController rtfLinkController = new RtfLinkController(mVCController);
        if (GWClient.USE_EXTERNAL_HTML_VIEWER()) {
            this.messageViewer = new HTMLExternalTextViewer(mVCController);
            this.messageViewer.setMode(2);
            ((HTMLExternalTextViewer)this.messageViewer).addRTFViewerMouseListeners(rtfLinkController, rtfLinkController);
        } else {
            this.messageViewer = new HTMLTextViewer();
            ((HTMLTextViewer)this.messageViewer).addHyperlinkListener(new HTMLViewerHyperlinkListener(mVCController));
            ((HTMLTextViewer)this.messageViewer).addHyperlinkListener(new HTMLViewerStatusbarHyperlinkListener(mVCController));
            this.messageViewer.getTextComponent().addMouseListener(rtfLinkController);
            this.messageViewer.getTextComponent().addMouseMotionListener(rtfLinkController);
        }
        this.messageViewer.setDragEnabled(true);
        this.messageViewer.setPreferredSize(new Dimension(1, 20));
        this.messageViewer.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.messageViewer, MESSAGE_VIEWER);
        this.imageViewer = new ImageViewer();
        this.imageViewer.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.imageViewer, IMAGE_VIEWER);
        this.showPanel(MESSAGE_VIEWER);
    }

    private void showPanel(String string) {
        if (string.equals(MESSAGE_VIEWER)) {
            if (!this.messageViewer.isVisible()) {
                this.cardLayout.show(this, MESSAGE_VIEWER);
            }
        } else if (string.equals(IMAGE_VIEWER) && !this.imageViewer.isVisible()) {
            this.cardLayout.show(this, IMAGE_VIEWER);
        }
    }

    public void clear() {
        this.messageViewer.clear();
        this.imageViewer.clear();
    }

    public void setupImage(String string) {
        this.imageViewer.setImage(string);
        this.showPanel(IMAGE_VIEWER);
    }

    public void setupHTMLPage(String string) {
        GWException gWException = new GWException("\n Client can not load message body: \n\n Message body file : \n" + string);
        if (string == null || string.equals("")) {
            String string2 = "<html><body><b>" + HTMLUtils.normalizeTextToHTML(StringResources.HTML_ONLY_WARNING, false) + "</b></body></html>";
            this.messageViewer.setMode(1);
            this.messageViewer.setStyledText(string2);
        } else {
            try {
                File file = new File(string);
                if (!file.exists() || file.isDirectory()) {
                    logger.error((Object)gWException, (Throwable)gWException);
                    ErrorDialog.processGWException(gWException);
                } else {
                    this.messageViewer.setMode(1);
                    this.messageViewer.setPage(file.toURL());
                }
            }
            catch (Exception exception) {
                logger.error((Object)exception);
                exception.printStackTrace();
            }
        }
        this.showPanel(MESSAGE_VIEWER);
    }

    public void setupText(String string) {
        this.setupMessage(ControlsUtils.getPage(string));
    }

    public void setupMessage(String string) {
        this.messageViewer.setMode(2);
        this.messageViewer.setPlainText(string);
        this.messageViewer.setCaretPosition(0);
        this.showPanel(MESSAGE_VIEWER);
    }

    public void setupRTF(String string) {
        this.setupRTFMessage(ControlsUtils.getPage(string));
    }

    public void setupRTFMessage(String string) {
        this.messageViewer.setMode(2);
        this.messageViewer.setStyledText(string);
        this.messageViewer.setCaretPosition(0);
        this.showPanel(MESSAGE_VIEWER);
    }

    public void zoom(boolean bl) {
        this.messageViewer.zoom(bl);
    }

    public void resetZoom() {
        this.messageViewer.resetZoom();
    }

    public int getViewMode() {
        return this.messageViewer.getMode();
    }

    public JComponent getTextComponent() {
        return this.messageViewer;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class RtfLinkController
    extends MouseAdapter
    implements MouseMotionListener {
        private MVCController controller;

        public RtfLinkController(MVCController mVCController) {
            this.controller = mVCController;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            Document document;
            Point point;
            int n;
            JTextPane jTextPane = (JTextPane)mouseEvent.getSource();
            if ((!jTextPane.isEditable() && jTextPane instanceof HTMLTextPane && ((HTMLTextPane)jTextPane).getMode() == 2 || ((HTMLTextPane)jTextPane).getMode() == 3) && (n = jTextPane.viewToModel(point = new Point(mouseEvent.getX(), mouseEvent.getY()))) >= 0 && (document = jTextPane.getDocument()) instanceof DefaultStyledDocument) {
                DefaultStyledDocument defaultStyledDocument = (DefaultStyledDocument)document;
                Element element = defaultStyledDocument.getCharacterElement(n);
                AttributeSet attributeSet = element.getAttributes();
                String string = (String)attributeSet.getAttribute("hyperlink");
                if (string != null) {
                    jTextPane.setCursor(Cursor.getPredefinedCursor(12));
                    Command command = new Command(630, string);
                    this.controller.processCommand(command);
                } else {
                    jTextPane.setCursor(Cursor.getDefaultCursor());
                    Command command = new Command(630, "");
                    this.controller.processCommand(command);
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            DefaultStyledDocument defaultStyledDocument;
            Element element;
            AttributeSet attributeSet;
            String string;
            Document document;
            Point point;
            int n;
            if (mouseEvent.isPopupTrigger() || mouseEvent.getClickCount() == 1 && SwingUtilities.isRightMouseButton(mouseEvent)) {
                return;
            }
            JTextPane jTextPane = (JTextPane)mouseEvent.getSource();
            if ((!jTextPane.isEditable() && jTextPane instanceof HTMLTextPane && ((HTMLTextPane)jTextPane).getMode() == 2 || ((HTMLTextPane)jTextPane).getMode() == 3) && (n = jTextPane.viewToModel(point = new Point(mouseEvent.getX(), mouseEvent.getY()))) >= 0 && (document = jTextPane.getDocument()) instanceof DefaultStyledDocument && (string = (String)(attributeSet = (element = (defaultStyledDocument = (DefaultStyledDocument)document).getCharacterElement(n)).getAttributes()).getAttribute("hyperlink")) != null) {
                new HTMLViewerHyperlinkListener(this.controller).processURL(string);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }
    }

    private class HTMLViewerStatusbarHyperlinkListener
    implements HyperlinkListener {
        private MVCController controller;

        public HTMLViewerStatusbarHyperlinkListener(MVCController mVCController) {
            this.controller = mVCController;
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType().toString().equals(HyperlinkEvent.EventType.ENTERED.toString())) {
                URL uRL = hyperlinkEvent.getURL();
                String string = "";
                if (uRL != null) {
                    string = uRL.toString();
                }
                Command command = new Command(630, string);
                this.controller.processCommand(command);
            } else if (hyperlinkEvent.getEventType().toString().equals(HyperlinkEvent.EventType.EXITED.toString())) {
                Command command = new Command(630, "");
                this.controller.processCommand(command);
            }
        }
    }
}

