/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview.imageviewer;

import com.novell.gw.jclient.application.controls.itemview.imageviewer.ImageLoadException;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.bl.om.PathManager;
import com.sun.media.jai.codec.ByteArraySeekableStream;
import com.sun.media.jai.codec.FileSeekableStream;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.SeekableStream;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import org.apache.log4j.Logger;

public class ImageReader {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$itemview$imageviewer$ImageReader == null ? (class$com$novell$gw$jclient$application$controls$itemview$imageviewer$ImageReader = ImageReader.class$("com.novell.gw.jclient.application.controls.itemview.imageviewer.ImageReader")) : class$com$novell$gw$jclient$application$controls$itemview$imageviewer$ImageReader));
    private static String DEFAULT_IMAGE_FILE = "images/ci.png";
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$itemview$imageviewer$ImageReader;

    public static PlanarImage readImage(String string) throws ImageLoadException {
        try {
            RenderedImage renderedImage;
            Object object;
            Object object2;
            RenderedOp renderedOp = null;
            File file = new File(string);
            boolean bl = file.exists();
            if (System.getProperty("JAI_IMAGE_READER_USE_CODECS") == null) {
                if (bl) {
                    renderedOp = JAI.create((String)"fileload", (Object)string);
                } else {
                    object2 = new ByteArraySeekableStream(ImageResources.loadImageStream(string));
                    renderedOp = JAI.create((String)"stream", (Object)object2);
                }
            } else {
                object2 = null;
                object2 = bl ? new FileSeekableStream(string) : new ByteArraySeekableStream(ImageResources.loadImageStream(string));
                String[] stringArray = ImageCodec.getDecoderNames((SeekableStream)object2);
                object = ImageCodec.createImageDecoder((String)stringArray[0], (SeekableStream)object2, null);
                renderedImage = object.decodeAsRenderedImage();
                renderedOp = PlanarImage.wrapRenderedImage((RenderedImage)renderedImage);
            }
            if (renderedOp.getColorModel() instanceof IndexColorModel) {
                object2 = (IndexColorModel)renderedOp.getColorModel();
                int n = ((IndexColorModel)object2).getMapSize();
                object = new byte[3][n];
                ((IndexColorModel)object2).getReds((byte[])object[0]);
                ((IndexColorModel)object2).getGreens((byte[])object[1]);
                ((IndexColorModel)object2).getBlues((byte[])object[2]);
                renderedImage = new LookupTableJAI((byte[][])object);
                renderedOp = JAI.create((String)"lookup", (RenderedImage)renderedOp, (Object)renderedImage);
            }
            return renderedOp;
        }
        catch (Exception exception) {
            logger.debug((Object)exception, (Throwable)exception);
            logger.error((Object)exception);
            File file = new File(string);
            if (file.exists()) {
                file.delete();
            }
            throw new ImageLoadException("Error opening image [" + string + "] :" + exception.getMessage());
        }
    }

    public static PlanarImage getDefaultImage() {
        try {
            StringBuffer stringBuffer = new StringBuffer(PathManager.getInstance().getTempFolderPath());
            stringBuffer.append(File.separator);
            stringBuffer.append("ci.png");
            String string = stringBuffer.toString();
            File file = new File(string);
            if (!file.exists()) {
                byte[] byArray = ImageResources.loadImageStream(DEFAULT_IMAGE_FILE);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(byArray);
                fileOutputStream.flush();
                fileOutputStream.close();
            }
            return ImageReader.readImage(string);
        }
        catch (Exception exception) {
            logger.debug((Object)exception, (Throwable)exception);
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

