/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview.imageviewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.swing.Icon;

public class ImageViewIcon
implements Icon {
    protected RenderedImage im;
    protected SampleModel sampleModel;
    protected ColorModel colorModel;
    protected int minX;
    protected int minY;
    protected int width;
    protected int height;
    protected Rectangle imageBounds;
    protected int minTileX;
    protected int maxTileX;
    protected int minTileY;
    protected int maxTileY;
    protected int tileWidth;
    protected int tileHeight;
    protected int tileGridXOffset;
    protected int tileGridYOffset;
    protected int originX;
    protected int originY;
    private Color backgroundColor = null;

    public ImageViewIcon(RenderedImage renderedImage, Color color) {
        Object object;
        int n = renderedImage.getMinX();
        int n2 = renderedImage.getMinY();
        if (n < 0 || n2 < 0) {
            object = new ParameterBlock();
            ((ParameterBlock)object).addSource(renderedImage);
            ((ParameterBlock)object).add((float)Math.max(-n, 0));
            ((ParameterBlock)object).add((float)Math.max(-n2, 0));
            ((ParameterBlock)object).add(new InterpolationNearest());
            renderedImage = JAI.create((String)"translate", (ParameterBlock)object, null);
        }
        this.im = renderedImage;
        this.sampleModel = renderedImage.getSampleModel();
        this.colorModel = renderedImage.getColorModel();
        if (this.colorModel == null) {
            this.colorModel = PlanarImage.createColorModel((SampleModel)renderedImage.getSampleModel());
        }
        if (this.colorModel == null) {
            throw new IllegalArgumentException("ImageViewIcon is unable to display supplied RenderedImage.");
        }
        if (this.colorModel.getTransparency() != 1) {
            object = renderedImage.getProperty("background_color");
            this.backgroundColor = object instanceof Color ? (Color)object : color;
        }
        this.minX = renderedImage.getMinX();
        this.minY = renderedImage.getMinY();
        this.width = renderedImage.getWidth();
        this.height = renderedImage.getHeight();
        this.imageBounds = new Rectangle(this.minX, this.minY, this.width, this.height);
        this.minTileX = renderedImage.getMinTileX();
        this.maxTileX = renderedImage.getMinTileX() + renderedImage.getNumXTiles() - 1;
        this.minTileY = renderedImage.getMinTileY();
        this.maxTileY = renderedImage.getMinTileY() + renderedImage.getNumYTiles() - 1;
        this.tileWidth = renderedImage.getTileWidth();
        this.tileHeight = renderedImage.getTileHeight();
        this.tileGridXOffset = renderedImage.getTileGridXOffset();
        this.tileGridYOffset = renderedImage.getTileGridYOffset();
        this.originY = 0;
        this.originX = 0;
    }

    public int getIconWidth() {
        return this.im.getWidth();
    }

    public int getIconHeight() {
        return this.im.getHeight();
    }

    public RenderedImage getImage() {
        return this.im;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = null;
        if (!(graphics instanceof Graphics2D)) {
            System.err.println("ImageViewIcon: not a Graphics2D.");
            return;
        }
        graphics2D = (Graphics2D)graphics;
        Rectangle rectangle = graphics.getClipBounds();
        int n3 = n;
        int n4 = n2;
        Rectangle rectangle2 = new Rectangle(this.minX + n3, this.minY + n4, this.width, this.height);
        if (rectangle == null) {
            rectangle = new Rectangle(0, 0, component.getWidth(), component.getHeight());
        }
        int n5 = PlanarImage.XToTileX((int)(rectangle.x - n3), (int)this.tileGridXOffset, (int)this.tileWidth);
        n5 = Math.max(n5, this.minTileX);
        n5 = Math.min(n5, this.maxTileX);
        int n6 = PlanarImage.XToTileX((int)(rectangle.x + rectangle.width - 1 - n3), (int)this.tileGridXOffset, (int)this.tileWidth);
        n6 = Math.max(n6, this.minTileX);
        n6 = Math.min(n6, this.maxTileX);
        int n7 = PlanarImage.YToTileY((int)(rectangle.y - n4), (int)this.tileGridYOffset, (int)this.tileHeight);
        n7 = Math.max(n7, this.minTileY);
        n7 = Math.min(n7, this.maxTileY);
        int n8 = PlanarImage.YToTileY((int)(rectangle.y + rectangle.height - 1 - n4), (int)this.tileGridYOffset, (int)this.tileHeight);
        n8 = Math.max(n8, this.minTileY);
        n8 = Math.min(n8, this.maxTileY);
        graphics2D.clip(rectangle2);
        if (this.backgroundColor != null) {
            graphics2D.setColor(this.backgroundColor);
        }
        for (int i = n7; i <= n8; ++i) {
            for (int j = n5; j <= n6; ++j) {
                int n9 = PlanarImage.tileXToX((int)j, (int)this.tileGridXOffset, (int)this.tileWidth);
                int n10 = PlanarImage.tileYToY((int)i, (int)this.tileGridYOffset, (int)this.tileHeight);
                Raster raster = this.im.getTile(j, i);
                DataBuffer dataBuffer = raster.getDataBuffer();
                Point point = new Point(0, 0);
                WritableRaster writableRaster = Raster.createWritableRaster(this.sampleModel, dataBuffer, point);
                BufferedImage bufferedImage = new BufferedImage(this.colorModel, writableRaster, false, null);
                AffineTransform affineTransform = AffineTransform.getTranslateInstance(n9 + n3, n10 + n4);
                if (this.backgroundColor != null) {
                    graphics2D.fillRect(n9 + n3, n10 + n4, this.tileWidth, this.tileHeight);
                }
                graphics2D.drawImage(bufferedImage, affineTransform, null);
            }
        }
    }
}

