/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview.imageviewer;

import com.appframework.utils.OS;
import com.novell.gw.jclient.application.controls.itemview.imageviewer.ImageLoadException;
import com.novell.gw.jclient.application.controls.itemview.imageviewer.ImageReader;
import com.novell.gw.jclient.application.controls.itemview.imageviewer.ImageViewIcon;
import com.novell.gw.jclient.application.controls.itemview.imageviewer.ImageViewLabel;
import com.novell.gw.jclient.application.controls.menus.GWMenu;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.resources.ImageResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class ImageViewer
extends JComponent {
    private static final int MEMORY_IMAGE_CACHE = 8000000;
    public static final int SIZE_ORIGINAL = 0;
    public static final int SIZE_FIT_BOTH = 1;
    public static final int SIZE_FIT_HEIGHT = 2;
    public static final int SIZE_FIT_WIDTH = 3;
    public static final int ROTATION_NONE = 0;
    public static final int ROTATION_90 = 1;
    public static final int ROTATION_180 = 2;
    public static final int ROTATION_270 = 3;
    public static final int ZOOM_IN = 0;
    public static final int ZOOM_OUT = 1;
    public static final int ZOOM_RESET = 2;
    private static final int MAX_ZOOM = 90;
    private static final int MIN_ZOOM = -40;
    ImageViewIcon imageIcon = null;
    PlanarImage image = null;
    float fitScale = 1.0f;
    float zoomScale = 1.0f;
    float rotationAngle = 0.0f;
    ImageViewLabel imageLabel = null;
    JScrollPane scrollPane = null;
    ImageViewPopupMenu popup;
    int currentZoom = 0;
    private Point pressPoint;
    private int pressedMouseButton = 0;

    public ImageViewer() {
        JAI.getDefaultInstance().getTileCache().setMemoryCapacity(8000000L);
        this.setBorder(null);
        this.setLayout(new BorderLayout());
        this.imageLabel = new ImageViewLabel();
        this.imageLabel.setVerticalAlignment(0);
        this.imageLabel.setHorizontalAlignment(0);
        this.scrollPane = new OrientableScrollPane(this.imageLabel, 20, 30);
        this.scrollPane.setBorder(null);
        this.add((Component)this.scrollPane, "Center");
        this.imageLabel.addMouseListener(new PopupListener());
        this.imageLabel.addMouseListener(new ImageMouseListener());
        this.imageLabel.addMouseMotionListener(new ImageDragListener());
        this.popup = new ImageViewPopupMenu();
        JScrollBar jScrollBar = this.scrollPane.getHorizontalScrollBar();
        jScrollBar.addMouseWheelListener(new HorizontalBarWheelMouseListener());
    }

    public void setImage(String string) {
        if (this.image != null) {
            this.clear();
        }
        try {
            this.image = ImageReader.readImage(string);
        }
        catch (ImageLoadException imageLoadException) {
            this.image = ImageReader.getDefaultImage();
        }
        if (this.image != null) {
            this.setupImageIcon(this.image);
        }
    }

    private void setupImageIcon(PlanarImage planarImage) {
        this.imageIcon = new ImageViewIcon((RenderedImage)planarImage, this.getBackground());
        this.imageLabel.setIcon(this.imageIcon);
        this.repaint();
        this.revalidate();
    }

    public void clear() {
        if (this.image == null) {
            return;
        }
        this.image.dispose();
        this.fitScale = 1.0f;
        this.zoomScale = 1.0f;
        this.rotationAngle = 0.0f;
        this.imageLabel.setIcon(null);
        this.repaint();
    }

    public void fitImage(int n) {
        if (this.image == null) {
            return;
        }
        switch (n) {
            case 1: {
                this.fitScale = Math.min((float)this.scrollPane.getVisibleRect().getHeight() / (float)this.image.getHeight(), (float)this.scrollPane.getVisibleRect().getWidth() / (float)this.image.getWidth());
                this.currentZoom = 0;
                this.zoomScale = 1.0f;
                break;
            }
            case 2: {
                this.fitScale = (float)this.scrollPane.getVisibleRect().getHeight() / (float)this.image.getHeight();
                this.currentZoom = 0;
                this.zoomScale = 1.0f;
                break;
            }
            case 3: {
                this.fitScale = (float)this.scrollPane.getVisibleRect().getWidth() / (float)this.image.getWidth();
                this.currentZoom = 0;
                this.zoomScale = 1.0f;
                break;
            }
            case 0: {
                this.fitScale = 1.0f;
                this.currentZoom = 0;
                this.zoomScale = 1.0f;
                break;
            }
        }
        this.applyTransformation();
    }

    private void rotateImage(int n) {
        if (this.image == null) {
            return;
        }
        switch (n) {
            case 1: {
                this.rotationAngle += 1.5707964f;
                break;
            }
            case 2: {
                this.rotationAngle += (float)Math.PI;
                break;
            }
            case 3: {
                this.rotationAngle += 4.712389f;
                break;
            }
            case 0: {
                this.rotationAngle = 0.0f;
                break;
            }
        }
        this.applyTransformation();
    }

    private void zoomImage(int n) {
        if (this.image == null) {
            return;
        }
        switch (n) {
            case 0: {
                this.zoomIn();
                break;
            }
            case 1: {
                this.zoomOut();
                break;
            }
            case 2: {
                this.currentZoom = 0;
                break;
            }
        }
        this.zoomScale = (float)Math.abs(this.currentZoom) / 10.0f + 1.0f;
        if (this.currentZoom < 0) {
            this.zoomScale = 1.0f / this.zoomScale;
        }
        this.applyTransformation();
    }

    private void zoomIn() {
        this.currentZoom += 10;
        if (this.currentZoom >= 90) {
            this.currentZoom = 90;
        }
    }

    private void zoomOut() {
        this.currentZoom -= 10;
        if (this.currentZoom <= -40) {
            this.currentZoom = -40;
        }
    }

    private void applyTransformation() {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(this.image);
        parameterBlock.add(this.fitScale);
        parameterBlock.add(this.fitScale);
        parameterBlock.add(0.0f);
        parameterBlock.add(0.0f);
        parameterBlock.add(new InterpolationBilinear());
        RenderedOp renderedOp = JAI.create((String)"scale", (ParameterBlock)parameterBlock, null);
        parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedOp);
        parameterBlock.add(this.zoomScale);
        parameterBlock.add(this.zoomScale);
        parameterBlock.add(0.0f);
        parameterBlock.add(0.0f);
        parameterBlock.add(new InterpolationBilinear());
        renderedOp = JAI.create((String)"scale", (ParameterBlock)parameterBlock, null);
        parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedOp);
        parameterBlock.add(0.0f);
        parameterBlock.add(0.0f);
        parameterBlock.add(this.rotationAngle);
        parameterBlock.add(new InterpolationNearest());
        renderedOp = JAI.create((String)"Rotate", (ParameterBlock)parameterBlock, null);
        this.setupImageIcon((PlanarImage)renderedOp);
    }

    private class HorizontalBarWheelMouseListener
    implements MouseWheelListener {
        private HorizontalBarWheelMouseListener() {
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            int n = ImageViewer.this.scrollPane.getHorizontalScrollBar().getValue();
            ImageViewer.this.scrollPane.getHorizontalScrollBar().setValue(n + 3 * mouseWheelEvent.getWheelRotation());
        }
    }

    private class ImageDragListener
    extends MouseMotionAdapter {
        private ImageDragListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (ImageViewer.this.pressedMouseButton == 1) {
                Point point = mouseEvent.getPoint();
                ImageViewer.this.setCursor(new Cursor(12));
                int n = ImageViewer.this.scrollPane.getHorizontalScrollBar().getValue() - (int)((double)(point.x - ((ImageViewer)ImageViewer.this).pressPoint.x) / 1.5);
                int n2 = ImageViewer.this.scrollPane.getVerticalScrollBar().getValue() - (int)((double)(point.y - ((ImageViewer)ImageViewer.this).pressPoint.y) / 1.5);
                ImageViewer.this.scrollPane.getHorizontalScrollBar().setValue(n);
                ImageViewer.this.scrollPane.getVerticalScrollBar().setValue(n2);
                ImageViewer.this.pressPoint = point;
            }
        }
    }

    private class ImageMouseListener
    extends MouseAdapter {
        private ImageMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                ImageViewer.this.setCursor(new Cursor(12));
                ImageViewer.this.pressPoint = mouseEvent.getPoint();
            }
            ImageViewer.this.pressedMouseButton = mouseEvent.getButton();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ImageViewer.this.setCursor(new Cursor(0));
            ImageViewer.this.pressedMouseButton = 0;
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.doPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.doPopup(mouseEvent);
        }

        private void doPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                ImageViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    class ZoomAction
    extends AbstractAction {
        int zoom = 0;
        boolean selected = false;
        JMenuItem item;

        public ZoomAction(int n) {
            this.zoom = n;
            this.item = new JMenuItem(this);
            String string = "";
            ImageIcon imageIcon = null;
            switch (this.zoom) {
                case 0: {
                    string = "In";
                    imageIcon = ImageResources.ACT_ZOOM_IN;
                    break;
                }
                case 1: {
                    string = "Out";
                    imageIcon = ImageResources.ACT_ZOOM_OUT;
                    break;
                }
                case 2: {
                    string = "Reset";
                    imageIcon = ImageResources.ACT_ZOOM_RESET;
                    this.selected = true;
                    break;
                }
            }
            this.item.setSelected(this.selected);
            this.putValue("Name", string);
            this.putValue("SmallIcon", imageIcon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImageViewer.this.zoomImage(this.zoom);
        }

        public JMenuItem getMenuItem() {
            return this.item;
        }
    }

    class RotateAction
    extends AbstractAction {
        int rotation = 0;
        JMenuItem item;
        boolean selected = false;

        public RotateAction(int n) {
            this.rotation = n;
            this.item = new JMenuItem(this);
            String string = "";
            ImageIcon imageIcon = null;
            switch (this.rotation) {
                case 0: {
                    string = "None";
                    imageIcon = ImageResources.ACT_ROTATE_NONE;
                    this.selected = true;
                    break;
                }
                case 1: {
                    string = "90";
                    imageIcon = ImageResources.ACT_ROTATE_90;
                    break;
                }
                case 2: {
                    string = "180";
                    imageIcon = ImageResources.ACT_ROTATE_180;
                    break;
                }
                case 3: {
                    string = "270";
                    imageIcon = ImageResources.ACT_ROTATE_270;
                    break;
                }
            }
            this.item.setSelected(this.selected);
            this.putValue("Name", string);
            this.putValue("SmallIcon", imageIcon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImageViewer.this.rotateImage(this.rotation);
        }

        public JMenuItem getMenuItem() {
            return this.item;
        }
    }

    class FitAction
    extends AbstractAction {
        int fit = 1;
        JMenuItem item;
        boolean selected = false;

        public FitAction(int n) {
            this.fit = n;
            this.item = OS.createMenuItemForAction(this, false);
            String string = "";
            ImageIcon imageIcon = null;
            switch (this.fit) {
                case 1: {
                    string = "Fit to Window";
                    imageIcon = ImageResources.ACT_FIT_TOWINDOW;
                    break;
                }
                case 2: {
                    string = "Fit to Window Height";
                    imageIcon = ImageResources.ACT_FIT_TOHEIGHT;
                    break;
                }
                case 3: {
                    string = "Fit to Window Width";
                    imageIcon = ImageResources.ACT_FIT_TOWIDTH;
                    break;
                }
                case 0: {
                    string = "Original Size";
                    imageIcon = ImageResources.ACT_FIT_ORIGINAL;
                    this.selected = true;
                    break;
                }
            }
            this.item.setSelected(this.selected);
            this.putValue("Name", string);
            this.putValue("SmallIcon", imageIcon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImageViewer.this.fitImage(this.fit);
        }

        public JMenuItem getMenuItem() {
            return this.item;
        }
    }

    class ImageViewPopupMenu
    extends JPopupMenu {
        public ImageViewPopupMenu() {
            GWMenu gWMenu = new GWMenu("Size");
            gWMenu.setIcon(ImageResources.ACT_FIT);
            FitAction fitAction = new FitAction(0);
            FitAction fitAction2 = new FitAction(1);
            FitAction fitAction3 = new FitAction(2);
            FitAction fitAction4 = new FitAction(3);
            gWMenu.add(fitAction.getMenuItem());
            gWMenu.add(fitAction2.getMenuItem());
            gWMenu.add(fitAction3.getMenuItem());
            gWMenu.add(fitAction4.getMenuItem());
            this.add(gWMenu);
            GWMenu gWMenu2 = new GWMenu("Rotation");
            gWMenu2.setIcon(ImageResources.ACT_ROTATION);
            RotateAction rotateAction = new RotateAction(0);
            RotateAction rotateAction2 = new RotateAction(1);
            RotateAction rotateAction3 = new RotateAction(2);
            RotateAction rotateAction4 = new RotateAction(3);
            gWMenu2.add(rotateAction.getMenuItem());
            gWMenu2.add(rotateAction2.getMenuItem());
            gWMenu2.add(rotateAction3.getMenuItem());
            gWMenu2.add(rotateAction4.getMenuItem());
            this.add(gWMenu2);
            GWMenu gWMenu3 = new GWMenu("Zoom");
            gWMenu3.setIcon(ImageResources.ACT_ZOOM);
            ZoomAction zoomAction = new ZoomAction(0);
            ZoomAction zoomAction2 = new ZoomAction(1);
            ZoomAction zoomAction3 = new ZoomAction(2);
            gWMenu3.add(zoomAction.getMenuItem());
            gWMenu3.add(zoomAction2.getMenuItem());
            gWMenu3.add(zoomAction3.getMenuItem());
            this.add(gWMenu3);
        }
    }
}

