/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemview.itemviewer;

import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.level.LevelManager;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.MVCController;
import com.novell.gw.engine.MachineSettings;
import com.novell.gw.jclient.application.actions.ActionHTMLText;
import com.novell.gw.jclient.application.actions.ActionPlainText;
import com.novell.gw.jclient.application.controls.itemview.itemviewer.ItemViewer;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AddToCheckListTableItem;
import com.novell.gw.jclient.bl.om.items.ItemDescription;

public class ItemViewerController
extends MVCController {
    ItemViewer itemViewer;
    private AbstractFolder selectedFolder;

    public ItemViewerController(ItemViewer itemViewer, MVCController mVCController) {
        super(mVCController.getLevel());
        this.itemViewer = itemViewer;
    }

    protected void initListeners() {
        Level level = LevelManager.getInstance().getFrameLevel(this.getLevel());
        AppEventListener appEventListener = new ATTACHMENT_SELECTED_listener();
        AppEventListenerDescriptor appEventListenerDescriptor = new AppEventListenerDescriptor(level, 50, appEventListener);
        this.addListenerDescriptor(appEventListenerDescriptor);
        appEventListener = new GWITEM_SELECTED_listener();
        appEventListenerDescriptor = new AppEventListenerDescriptor(level, 20, appEventListener);
        this.addListenerDescriptor(appEventListenerDescriptor);
        appEventListener = new FOLDER_SELECTED_listener();
        appEventListenerDescriptor = new AppEventListenerDescriptor(level, 10, appEventListener);
        this.addListenerDescriptor(appEventListenerDescriptor);
        appEventListener = new NO_ITEMS_SELECTED_listener();
        appEventListenerDescriptor = new AppEventListenerDescriptor(level, 470, appEventListener);
        this.addListenerDescriptor(appEventListenerDescriptor);
        appEventListener = new MULTIPLE_ITEMS_SELECTED_listener();
        appEventListenerDescriptor = new AppEventListenerDescriptor(level, 430, appEventListener);
        this.addListenerDescriptor(appEventListenerDescriptor);
        appEventListener = new ACTION_PLAIN_TEXT_PERFORMED_listener();
        appEventListenerDescriptor = new AppEventListenerDescriptor(level, 780, appEventListener);
        this.addListenerDescriptor(appEventListenerDescriptor);
        appEventListener = new ACTION_HTML_TEXT_PERFORMED_listener();
        appEventListenerDescriptor = new AppEventListenerDescriptor(level, 790, appEventListener);
        this.addListenerDescriptor(appEventListenerDescriptor);
        appEventListener = new ACTION_SWITCH_ATTACHMENT_WINDOW_listener();
        appEventListenerDescriptor = new AppEventListenerDescriptor(level, 890, appEventListener);
        this.addListenerDescriptor(appEventListenerDescriptor);
        appEventListener = new ACTION_HIDE_SYSTEM_ATTACHMENTS_listener();
        appEventListenerDescriptor = new AppEventListenerDescriptor(level, 940, appEventListener);
        this.addListenerDescriptor(appEventListenerDescriptor);
        appEventListener = new OPEN_MESSAGE_ATTACHMENT_listener();
        appEventListenerDescriptor = new AppEventListenerDescriptor(level, 920, appEventListener);
        this.addListenerDescriptor(appEventListenerDescriptor);
        appEventListener = new OPEN_PARENT_MESSAGE_listener();
        appEventListenerDescriptor = new AppEventListenerDescriptor(level, 60, appEventListener);
        this.addListenerDescriptor(appEventListenerDescriptor);
        appEventListener = new ZOOM_RESET_listener();
        appEventListenerDescriptor = new AppEventListenerDescriptor(level, 1250, appEventListener);
        this.addListenerDescriptor(appEventListenerDescriptor);
        appEventListener = new ZOOM_IN_listener();
        appEventListenerDescriptor = new AppEventListenerDescriptor(level, 1230, appEventListener);
        this.addListenerDescriptor(appEventListenerDescriptor);
        appEventListener = new ZOOM_OUT_listener();
        appEventListenerDescriptor = new AppEventListenerDescriptor(level, 1240, appEventListener);
        this.addListenerDescriptor(appEventListenerDescriptor);
    }

    public void updatePlainHTML() {
        MachineSettings.TextOption textOption = OptionManager.getInstance().getTextOption();
        AbstractItem abstractItem = this.getItemViewer().getCurrentItem();
        if (abstractItem.isHTMLMessage() && !textOption.isHTMLDisallowed()) {
            ActionHTMLText actionHTMLText = (ActionHTMLText)this.getActionList().getAction("HTML Text");
            actionHTMLText.setEnabled(true);
            ActionPlainText actionPlainText = (ActionPlainText)this.getActionList().getAction("Plain Text");
            actionPlainText.setEnabled(abstractItem.hasBodyText());
            if (this.getItemViewer().getViewMode() == 1) {
                actionHTMLText.setSelected(true);
            } else {
                actionPlainText.setSelected(true);
            }
        } else {
            ActionHTMLText actionHTMLText = (ActionHTMLText)this.getActionList().getAction("HTML Text");
            actionHTMLText.setEnabled(false);
            ActionPlainText actionPlainText = (ActionPlainText)this.getActionList().getAction("Plain Text");
            actionPlainText.setEnabled(true);
            actionHTMLText.setSelected(false);
            actionPlainText.setSelected(true);
        }
    }

    private void turnOff() {
        ActionHTMLText actionHTMLText = (ActionHTMLText)this.getActionList().getAction("HTML Text");
        actionHTMLText.setSelected(false);
        actionHTMLText.setEnabled(false);
        ActionPlainText actionPlainText = (ActionPlainText)this.getActionList().getAction("Plain Text");
        actionPlainText.setSelected(false);
        actionPlainText.setEnabled(false);
    }

    private ItemViewer getItemViewer() {
        return this.itemViewer;
    }

    private class ZOOM_OUT_listener
    extends AppEventListener {
        private ZOOM_OUT_listener() {
        }

        public void handle(AppEvent appEvent) {
            ItemViewerController.this.getItemViewer().zoom(false);
        }
    }

    private class ZOOM_IN_listener
    extends AppEventListener {
        private ZOOM_IN_listener() {
        }

        public void handle(AppEvent appEvent) {
            ItemViewerController.this.getItemViewer().zoom(true);
        }
    }

    private class ZOOM_RESET_listener
    extends AppEventListener {
        private ZOOM_RESET_listener() {
        }

        public void handle(AppEvent appEvent) {
            ItemViewerController.this.getItemViewer().resetZoom();
        }
    }

    private class OPEN_PARENT_MESSAGE_listener
    extends AppEventListener {
        private OPEN_PARENT_MESSAGE_listener() {
        }

        public void handle(AppEvent appEvent) {
            ItemViewerController.this.getItemViewer().openParentMessage();
        }
    }

    private class OPEN_MESSAGE_ATTACHMENT_listener
    extends AppEventListener {
        private OPEN_MESSAGE_ATTACHMENT_listener() {
        }

        public void handle(AppEvent appEvent) {
            ItemViewerController.this.getItemViewer().setEmbededMessage((AbstractItem)appEvent.getData());
        }
    }

    private class ACTION_HIDE_SYSTEM_ATTACHMENTS_listener
    extends AppEventListener {
        private ACTION_HIDE_SYSTEM_ATTACHMENTS_listener() {
        }

        public void handle(AppEvent appEvent) {
            ItemViewerController.this.getItemViewer().setHideSystemAttachments();
        }
    }

    private class ACTION_SWITCH_ATTACHMENT_WINDOW_listener
    extends AppEventListener {
        private ACTION_SWITCH_ATTACHMENT_WINDOW_listener() {
        }

        public void handle(AppEvent appEvent) {
            ItemViewerController.this.getItemViewer().setShowAttachments();
        }
    }

    private class ACTION_HTML_TEXT_PERFORMED_listener
    extends AppEventListener {
        private ACTION_HTML_TEXT_PERFORMED_listener() {
        }

        public void handle(AppEvent appEvent) {
            ItemViewerController.this.getItemViewer().setupHTMLView();
            ActionHTMLText actionHTMLText = (ActionHTMLText)ItemViewerController.this.getActionList().getAction("HTML Text");
            actionHTMLText.setSelected(true);
        }
    }

    private class ACTION_PLAIN_TEXT_PERFORMED_listener
    extends AppEventListener {
        private ACTION_PLAIN_TEXT_PERFORMED_listener() {
        }

        public void handle(AppEvent appEvent) {
            ItemViewerController.this.getItemViewer().setupPlainTextMessage();
            ActionPlainText actionPlainText = (ActionPlainText)ItemViewerController.this.getActionList().getAction("Plain Text");
            actionPlainText.setSelected(true);
        }
    }

    private class MULTIPLE_ITEMS_SELECTED_listener
    extends AppEventListener {
        private MULTIPLE_ITEMS_SELECTED_listener() {
        }

        public void handle(AppEvent appEvent) {
            ItemViewerController.this.getItemViewer().setItem(null, true);
            ItemViewerController.this.getItemViewer().setEmbededParentViewVisible(false);
            ItemViewerController.this.turnOff();
        }
    }

    private class NO_ITEMS_SELECTED_listener
    extends AppEventListener {
        private NO_ITEMS_SELECTED_listener() {
        }

        public void handle(AppEvent appEvent) {
            if (appEvent.getData() instanceof AddToCheckListTableItem) {
                ItemViewerController.this.getItemViewer().setItem(null, true);
                ItemViewerController.this.getItemViewer().setEmbededParentViewVisible(false);
                ItemViewerController.this.turnOff();
            }
        }
    }

    private class FOLDER_SELECTED_listener
    extends AppEventListener {
        private FOLDER_SELECTED_listener() {
        }

        public void handle(AppEvent appEvent) {
            if (!appEvent.getData().equals(ItemViewerController.this.selectedFolder)) {
                ItemViewerController.this.getItemViewer().setItem(null, true);
                ItemViewerController.this.getItemViewer().setEmbededParentViewVisible(false);
                ItemViewerController.this.turnOff();
                ItemViewerController.this.selectedFolder = (AbstractFolder)appEvent.getData();
            }
        }
    }

    private class GWITEM_SELECTED_listener
    extends AppEventListener {
        private GWITEM_SELECTED_listener() {
        }

        public void handle(AppEvent appEvent) {
            AbstractItem abstractItem;
            AbstractItem abstractItem2 = ((ItemDescription)appEvent.getData()).getItem();
            if (abstractItem2.equals(abstractItem = ItemViewerController.this.getItemViewer().getContainerItem()) && !abstractItem2.isDraft() && !abstractItem2.isPersonal()) {
                return;
            }
            ItemViewerController.this.getItemViewer().setItem(abstractItem2, true);
            ItemViewerController.this.getItemViewer().setEmbededParentViewVisible(false);
        }
    }

    private class ATTACHMENT_SELECTED_listener
    extends AppEventListener {
        private ATTACHMENT_SELECTED_listener() {
        }

        public void handle(AppEvent appEvent) {
            Object object = appEvent.getData();
            ItemViewerController.this.getItemViewer().setAttachment(object);
            if (object instanceof AbstractItem) {
                ItemViewerController.this.updatePlainHTML();
            } else {
                ItemViewerController.this.turnOff();
            }
        }
    }
}

