/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.popedit;

import com.appframework.utils.OS;
import com.novell.gw.ab.AddressBookManager;
import com.novell.gw.ab.Addressable;
import com.novell.gw.ab.Contact;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.application.ExtendedGWTable;
import com.novell.gw.jclient.application.controls.ColoredScrollPane;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.ContactDetailsDialog;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class DisambiguationDialog
extends GWDialog {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$popedit$DisambiguationDialog == null ? (class$com$novell$gw$jclient$application$controls$popedit$DisambiguationDialog = DisambiguationDialog.class$("com.novell.gw.jclient.application.controls.popedit.DisambiguationDialog")) : class$com$novell$gw$jclient$application$controls$popedit$DisambiguationDialog));
    private ContactTableModel contactTableModel;
    private ExtendedGWTable tableContacts;
    private AbstractAction editAction = new EditAction();
    private AbstractAction deleteAction = new DeleteAction();
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$popedit$DisambiguationDialog;

    public DisambiguationDialog(JFrame jFrame, List list) throws HeadlessException {
        super(jFrame);
        this.init(list);
    }

    public DisambiguationDialog(JDialog jDialog, List list) throws HeadlessException {
        super(jDialog);
        this.init(list);
    }

    private void init(List list) {
        this.setTitle(StringResources.SELECT_AN_ENTRY);
        this.contactTableModel = new ContactTableModel(list);
        this.buildUI();
    }

    private void buildUI() {
        this.tableContacts = new ExtendedGWTable(this.contactTableModel);
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout(10, 5));
        jPanel.add((Component)new JLabel(StringResources.SELECT_ONE), "North");
        jPanel.add((Component)new ColoredScrollPane(this.tableContacts), "Center");
        OrientablePanel orientablePanel = new OrientablePanel(new GridLayout(0, 1, 0, 5));
        orientablePanel.add(this.btnOK);
        orientablePanel.add(this.btnCancel);
        orientablePanel.add(new OrientableButton(this.editAction));
        orientablePanel.add(new OrientableButton(this.deleteAction));
        OrientablePanel orientablePanel2 = new OrientablePanel(new BorderLayout());
        orientablePanel2.add((Component)orientablePanel, "North");
        jPanel.add((Component)orientablePanel2, "After");
        jPanel.setPreferredSize(new Dimension(570, 240));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 20, 10));
        this.tableContacts.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (OS.isDoubleClick(mouseEvent)) {
                    DisambiguationDialog.this.btnOK.doClick();
                }
            }
        });
        this.tableContacts.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    DisambiguationDialog.this.btnOK.doClick();
                } else if (keyEvent.getKeyCode() == OptionManager.getInstance().getGeneralOptions().getItemDeleteKey()) {
                    DisambiguationDialog.this.deleteAction.actionPerformed(null);
                }
            }
        });
        this.tableContacts.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DisambiguationDialog.this.processSelection();
            }
        });
        if (this.tableContacts.getRowCount() > 0) {
            this.tableContacts.setRowSelectionInterval(0, 0);
        }
    }

    private void processSelection() {
        int n = this.tableContacts.getSelectedRow();
        boolean bl = n == -1;
        this.btnOK.setEnabled(!bl);
        this.editAction.setEnabled(!bl && this.tableContacts.getSelectedRowCount() == 1);
    }

    public Contact getSelectedContact() {
        int n = this.tableContacts.getSelectedRow();
        return n == -1 ? null : this.contactTableModel.getItemList().get(n);
    }

    public List getSelectedContacts() {
        ArrayList arrayList = new ArrayList();
        int[] nArray = this.tableContacts.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            arrayList.add(this.contactTableModel.getItemList().get(n));
        }
        return arrayList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            super(StringResources.DELETE);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            List list = DisambiguationDialog.this.getSelectedContacts();
            try {
                boolean bl = GWEngineUtils.deleteContacts(list, DisambiguationDialog.this);
                if (bl) {
                    for (int i = 0; i < list.size(); ++i) {
                        Contact contact = (Contact)list.get(i);
                        DisambiguationDialog.this.contactTableModel.deleteContact(contact);
                        if (DisambiguationDialog.this.contactTableModel.getRowCount() != 0) continue;
                        this.setEnabled(false);
                    }
                }
            }
            catch (EngineException engineException) {
                logger.error((Object)engineException);
            }
        }
    }

    private class EditAction
    extends AbstractAction {
        public EditAction() {
            super(StringResources.EDIT);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Contact contact = DisambiguationDialog.this.getSelectedContact();
            ContactDetailsDialog contactDetailsDialog = ContactDetailsDialog.createContactDetailsDialog(DisambiguationDialog.this, (Addressable)contact);
            contactDetailsDialog.showMe();
        }
    }

    private class ContactTableModel
    extends AbstractTableModel {
        public final int[] columnsIDS = new int[]{3, 9};
        private List contactsList;

        public ContactTableModel(List list) {
            this.contactsList = list;
        }

        public String getColumnName(int n) {
            return AddressBookManager.getPropertyLabel((int)this.columnsIDS[n]);
        }

        public int getRowCount() {
            return this.contactsList.size();
        }

        public int getColumnCount() {
            return this.columnsIDS.length;
        }

        public Object getValueAt(int n, int n2) {
            String string = ((Contact)this.contactsList.get(n)).getStringValue(this.columnsIDS[n2]);
            return string == null ? "" : string;
        }

        public List getItemList() {
            return Collections.unmodifiableList(this.contactsList);
        }

        public void deleteContact(Contact contact) {
            int n = this.contactsList.indexOf(contact);
            if (n != -1) {
                this.contactsList.remove(contact);
                this.fireTableRowsDeleted(n, n);
            }
        }
    }
}

