/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.popedit;

import com.appframework.ActionList;
import com.appframework.mvc.LocalCommand;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.OS;
import com.novell.gw.ab.Addressable;
import com.novell.gw.ab.Contact;
import com.novell.gw.ab.Recipient;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.popedit.ComboEditImpl;
import com.novell.gw.jclient.application.controls.popedit.PEListModel;
import com.novell.gw.jclient.application.controls.popedit.PLMultiplePopupMenu;
import com.novell.gw.jclient.application.controls.popedit.PLPopupMenu;
import com.novell.gw.jclient.application.controls.popedit.PopupListController;
import com.novell.gw.jclient.application.options.OptionManager;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

class PopupList
extends JList
implements MVCView,
ClipboardOwner {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$popedit$PopupList == null ? (class$com$novell$gw$jclient$application$controls$popedit$PopupList = PopupList.class$("com.novell.gw.jclient.application.controls.popedit.PopupList")) : class$com$novell$gw$jclient$application$controls$popedit$PopupList));
    private PLPopupMenu menu;
    private PLMultiplePopupMenu multipleMenu;
    private PopupListController controller;
    private PEListModel model;
    private JTextComponent tcNCC;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$popedit$PopupList;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$popedit$ComboEditImpl$CustomPopupMenu;

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public PopupList(MVCController mVCController, JTextComponent jTextComponent) {
        this.tcNCC = jTextComponent;
        this.controller = new PopupListController(this, mVCController);
        this.setCellRenderer(new PLRenderer());
        this.menu = new PLPopupMenu(mVCController.getActionList());
        this.multipleMenu = new PLMultiplePopupMenu(mVCController.getActionList());
        this.setBorder(null);
        this.model = new PEListModel();
        this.setModel(this.model);
        this.addMouseListener(new PELMouseListener());
        this.addListSelectionListener(new PLListSelectionListener());
        this.addKeyListener(new PLKeyListener());
        this.setDragEnabled(true);
        this.setTransferHandler(new PLTransferHandler());
        this.setFocusTraversalKeysEnabled(false);
    }

    public void addRecipient(Recipient recipient) {
        int n = this.model.addRecipient(recipient);
        this.selectAtIndex(n);
    }

    public void selectAtIndex(int n) {
        if (n >= 0) {
            this.clearSelection();
            this.setSelectedIndex(n);
            this.ensureIndexIsVisible(n);
        }
    }

    public void addRecipients(List list) {
        this.model.addRecipients(list);
    }

    public List getRecipients() {
        List list = this.model.getRecipients();
        return list;
    }

    private int selectNearestRow(int n) {
        int n2 = this.getModel().getSize();
        if (n2 > 0) {
            if (n <= --n2) {
                this.setSelectedIndex(n);
            } else {
                n = n2;
                this.setSelectedIndex(n);
            }
        }
        return n;
    }

    public void removeRecipient(Collection collection) {
        int n = this.model.removeRecipient(collection);
        n = this.selectNearestRow(n);
        this.ensureIndexIsVisible(n);
        if (this.model.getSize() == 0) {
            ComboEditImpl.CustomPopupMenu customPopupMenu = (ComboEditImpl.CustomPopupMenu)SwingUtilities.getAncestorOfClass(class$com$novell$gw$jclient$application$controls$popedit$ComboEditImpl$CustomPopupMenu == null ? (class$com$novell$gw$jclient$application$controls$popedit$ComboEditImpl$CustomPopupMenu = PopupList.class$("com.novell.gw.jclient.application.controls.popedit.ComboEditImpl$CustomPopupMenu")) : class$com$novell$gw$jclient$application$controls$popedit$ComboEditImpl$CustomPopupMenu, this);
            customPopupMenu.dismiss();
        }
    }

    public void removeAllRecipients() {
        this.model.removeAllRecipients();
    }

    public void setController(MVCController mVCController) {
        if (!(mVCController instanceof PopupListController)) {
            throw new IllegalArgumentException();
        }
        this.controller = (PopupListController)mVCController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object object) {
    }

    public Object getMVCModel() {
        return null;
    }

    private String getDisplayName(Addressable addressable) {
        return addressable.getExternalDisplayName();
    }

    public String getFormattedString() {
        StringBuffer stringBuffer = new StringBuffer();
        List list = this.model.getRecipients();
        for (int i = 0; i < list.size(); ++i) {
            Recipient recipient = (Recipient)list.get(i);
            stringBuffer.append(this.getDisplayName(recipient.getAddressable()) + ";");
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.substring(0, stringBuffer.length() - 1);
        }
        return "";
    }

    public void selectPrevRow() {
        int n = this.getSelectedIndex();
        if (--n < 0) {
            n = this.getModel().getSize() - 1;
        }
        if (n >= 0) {
            this.setSelectedIndex(n);
            this.ensureIndexIsVisible(n);
        }
    }

    public void selectNextRow() {
        int n = this.getSelectedIndex();
        if (++n > this.getModel().getSize() - 1) {
            n = 0;
        }
        if (n >= 0) {
            this.setSelectedIndex(n);
            this.ensureIndexIsVisible(n);
        }
    }

    private void copySelectedItemsToClipboard() {
        String string = this.getContentForClipboard();
        this.getToolkit().getSystemClipboard().setContents(new StringSelection(string), this);
    }

    private String getContentForClipboard() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getSelectedValues().length;
        for (int i = 0; i < n; ++i) {
            String string = this.getDisplayName(((Recipient)this.getSelectedValues()[i]).getAddressable());
            stringBuffer.append(string);
            stringBuffer.append(System.getProperty("line.separator"));
        }
        return stringBuffer.toString();
    }

    public void cut() {
        this.copyToClipboard();
        if (this.getSelectedValues().length > 0) {
            this.removeRecipient(Arrays.asList(this.getSelectedValues()));
        }
    }

    public void copyToClipboard() {
        StringSelection stringSelection = new StringSelection(this.getContentForClipboard());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, this);
    }

    public void selectAll() {
        this.addSelectionInterval(0, this.model.getSize() - 1);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PLRenderer
    extends OrientableLabel
    implements ListCellRenderer {
        public PLRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Addressable addressable = ((Recipient)object).getAddressable();
            this.setText(PopupList.this.getDisplayName(addressable));
            if (addressable instanceof Contact) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }

    private class PLKeyListener
    extends KeyAdapter {
        private PLKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = OptionManager.getInstance().getGeneralOptions().getItemDeleteKey();
            if (keyEvent.getKeyCode() == n) {
                ActionList actionList = PopupList.this.getController().getActionList();
                actionList.performAction("CE_Delete");
            } else if (keyEvent.getKeyCode() == 9) {
                Window window = ControlsUtils.getWindowForComponent(PopupList.this.tcNCC);
                window.toFront();
                window.transferFocusDownCycle();
            }
        }
    }

    private class PLListSelectionListener
    implements ListSelectionListener {
        private PLListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            JList jList = (JList)listSelectionEvent.getSource();
            LocalCommand localCommand = new LocalCommand(440, PopupList.this.getController().getParentController());
            if (jList.getSelectedIndices().length == 1) {
                ArrayList arrayList = new ArrayList(1);
                arrayList.add(jList.getSelectedValue());
                localCommand.setCommandObject(arrayList);
            } else if (jList.getModel().getSize() > 0) {
                localCommand.setCommandObject(Arrays.asList(jList.getSelectedValues()));
            }
            PopupList.this.getController().processCommand(localCommand);
        }
    }

    private class PELMouseListener
    extends MouseAdapter {
        private PELMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.doPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.doPopup(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (OS.isLeftMouseButton(mouseEvent) && !OS.isMacOS()) {
                PopupList.this.grabFocus();
            }
            if (OS.isDoubleClick(mouseEvent)) {
                PopupList.this.getController().getActionList().performAction("CE_Edit");
            }
        }

        private void doPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                int n;
                int n2;
                PopupList popupList = PopupList.this;
                int n3 = popupList.locationToIndex(mouseEvent.getPoint());
                int[] nArray = popupList.getSelectedIndices();
                boolean bl = true;
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    n = nArray[n2];
                    if (n != n3) continue;
                    bl = false;
                }
                if (bl) {
                    popupList.clearSelection();
                    popupList.setSelectedIndex(n3);
                }
                n2 = mouseEvent.getX();
                n = mouseEvent.getY();
                if (PopupList.this.getSelectedIndices().length > 1) {
                    popupList.multipleMenu.show(PopupList.this, n2, n);
                    popupList.multipleMenu.pack();
                } else {
                    popupList.menu.show(PopupList.this, n2, n);
                    popupList.menu.pack();
                }
            }
        }
    }

    private class PLTransferHandler
    extends TransferHandler
    implements UIResource {
        private PLTransferHandler() {
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                PopupList.this.tcNCC.paste();
            }
            return true;
        }

        public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) {
            if ((n & 3) > 0) {
                clipboard.setContents(new StringSelection(PopupList.this.getContentForClipboard()), PopupList.this);
                super.exportToClipboard(jComponent, clipboard, n);
            }
            if (n == 2 && PopupList.this.getSelectedValues().length > 0) {
                PopupList.this.removeRecipient(Arrays.asList(PopupList.this.getSelectedValues()));
            }
        }

        protected Transferable createTransferable(JComponent jComponent) {
            StringSelection stringSelection = new StringSelection(PopupList.this.getContentForClipboard());
            return stringSelection;
        }

        public int getSourceActions(JComponent jComponent) {
            return 3;
        }

        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            if (n == 2) {
                PopupList.this.removeRecipient(Arrays.asList(PopupList.this.getSelectedValues()));
            }
        }
    }
}

