/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.standardgwitemtable;

import com.appframework.utils.OS;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwtooltips.GWToolTip;
import com.novell.gw.jclient.application.controls.standardgwitemtable.Colors;
import com.novell.gw.jclient.application.controls.standardgwitemtable.ImagesColumnPanel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.CalendarFolder;
import com.novell.gw.jclient.bl.om.folders.TrashFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.TableItem;
import com.novell.gw.jclient.bl.om.options.EnvironmentOptions;
import java.awt.Color;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.apache.log4j.Logger;

public class GWTableCellRendererUtils {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$standardgwitemtable$GWTableCellRendererUtils == null ? (class$com$novell$gw$jclient$application$controls$standardgwitemtable$GWTableCellRendererUtils = GWTableCellRendererUtils.class$("com.novell.gw.jclient.application.controls.standardgwitemtable.GWTableCellRendererUtils")) : class$com$novell$gw$jclient$application$controls$standardgwitemtable$GWTableCellRendererUtils));
    public static Color whiteColor = new Color(254, 254, 254);
    public static Color lightColor = new Color(237, 243, 254);
    public static Color selectedColor = new Color(61, 128, 223);
    private static int ROW_HEIGHT = 18;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$standardgwitemtable$GWTableCellRendererUtils;

    public static Colors getCellColors(JTable jTable, boolean bl, boolean bl2, int n) {
        Color color = jTable.getForeground();
        Color color2 = jTable.getBackground();
        if (bl) {
            EnvironmentOptions environmentOptions = OptionManager.getInstance().getEnvironmentOptions();
            if (bl2) {
                if (OS.isMacOS()) {
                    color = whiteColor;
                    color2 = selectedColor;
                } else {
                    color = jTable.getSelectionForeground();
                    color2 = jTable.getSelectionBackground();
                }
            } else {
                color = environmentOptions.getColorOptions().getInactiveSelectionForeground();
                color2 = environmentOptions.getColorOptions().getInactiveSelectionBackground();
            }
        } else if (OS.isMacOS()) {
            color2 = n % 2 == 0 ? lightColor : whiteColor;
        }
        return new Colors(color, color2);
    }

    public static void setFontsAndToolTips(TableItem tableItem, JComponent jComponent) {
        Font font = jComponent.getFont();
        if (tableItem instanceof AbstractItem) {
            AbstractItem abstractItem = (AbstractItem)tableItem;
            if (OptionManager.getInstance().getGeneralOptions().isSmartToolTipEnabled()) {
                jComponent.setToolTipText(GWToolTip.getString(abstractItem));
            } else {
                jComponent.setToolTipText(null);
            }
            if (!abstractItem.isStatusRead() || abstractItem.isSentItem() && abstractItem.getSentItemStatus() == 3) {
                if ((font.getStyle() & 1) == 0) {
                    jComponent.setFont(font.deriveFont(1));
                }
            } else if ((font.getStyle() & 1) != 0) {
                jComponent.setFont(font.deriveFont(0));
            }
        } else if ((font.getStyle() & 1) != 0) {
            jComponent.setFont(font.deriveFont(0));
        }
    }

    public static void setItemIcons(TableItem tableItem, ImagesColumnPanel imagesColumnPanel) {
        if (tableItem instanceof AbstractItem) {
            int n = 0;
            AbstractItem abstractItem = (AbstractItem)tableItem;
            ImageIcon imageIcon = null;
            if (abstractItem.isSentItem()) {
                switch (abstractItem.getSentItemStatus()) {
                    case 0: {
                        imageIcon = ImageResources.ICON_ITEM_UNDELIVERABLE;
                        break;
                    }
                    case 1: {
                        imageIcon = ImageResources.ICON_ITEM_REJECTED;
                        break;
                    }
                    case 2: {
                        imageIcon = ImageResources.ICON_ITEM_STATUS;
                        break;
                    }
                    case 3: {
                        imageIcon = ImageResources.ICON_ITEM_PENDING;
                    }
                }
                imagesColumnPanel.setLabelImage(n, imageIcon);
            }
            imagesColumnPanel.setLabelImage(++n, ControlsUtils.getImageForTableItem(tableItem));
            ++n;
            imageIcon = null;
            if (abstractItem.isDelegated() && abstractItem.isForwarded() && abstractItem.isReplied()) {
                imageIcon = ImageResources.ICON_ITEM_DELEGATED_FORWARDED_REPLIED;
            } else if (abstractItem.isDelegated() && abstractItem.isForwarded()) {
                imageIcon = ImageResources.ICON_ITEM_DELEGATED_FORWARDED;
            } else if (abstractItem.isDelegated() && abstractItem.isReplied()) {
                imageIcon = ImageResources.ICON_ITEM_DELEGATED_REPLIED;
            } else if (abstractItem.isForwarded() && abstractItem.isReplied()) {
                imageIcon = ImageResources.ICON_ITEM_FORWARDED_REPLIED;
            } else if (abstractItem.isReplied()) {
                imageIcon = ImageResources.ICON_ITEM_REPLIED;
            } else if (abstractItem.isForwarded()) {
                imageIcon = ImageResources.ICON_ITEM_FORWARDED;
            } else if (abstractItem.isDelegated()) {
                imageIcon = ImageResources.ICON_ITEM_DELEGATED;
            } else if (abstractItem.isDraft()) {
                imageIcon = ImageResources.ICON_ITEM_DRAFT;
            }
            if (abstractItem.isSentItem()) {
                imagesColumnPanel.setLabelImage(n, ImageResources.ITM_SENT);
            }
            ++n;
            if (abstractItem.isPersonal()) {
                imagesColumnPanel.setLabelImage(n, ImageResources.ICON_POSTED);
            } else {
                imagesColumnPanel.setLabelImage(n, imageIcon);
            }
            ++n;
            if (abstractItem.hasPaperClipAttachments()) {
                imagesColumnPanel.setLabelImage(n, ImageResources.ICON_ATTACHMENT_SMALL);
            } else {
                imagesColumnPanel.setLabelImage(n, null);
            }
        } else if (tableItem instanceof AbstractFolder) {
            AbstractFolder abstractFolder = (AbstractFolder)tableItem;
            ImageIcon imageIcon = null;
            imagesColumnPanel.setLabelImage(1, ControlsUtils.getImageForTableItem(tableItem));
            if (abstractFolder instanceof CalendarFolder) {
                if (abstractFolder.hasUnopenedItems()) {
                    imageIcon = ImageResources.ICON_CLOCK_CAL_ITEMS;
                }
            } else if (abstractFolder.hasUnopenedItems() && !(abstractFolder instanceof TrashFolder)) {
                imageIcon = ImageResources.ICON_UNOPENED_ITEMS_SMALL;
            }
            if (imageIcon != null) {
                imagesColumnPanel.setLabelImage(2, imageIcon);
            }
        } else {
            logger.debug((Object)"unknown item");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

