/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.standardgwitemtable;

import com.appframework.ApplicationFrame;
import com.appframework.cache.IDObjectsCollection;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.level.LevelManager;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.standardgwitemtable.CheckListTableModel;
import com.novell.gw.jclient.application.controls.standardgwitemtable.ChecklistQueryTableModel;
import com.novell.gw.jclient.application.controls.standardgwitemtable.EmptyItemListTableModel;
import com.novell.gw.jclient.application.controls.standardgwitemtable.ItemListTable;
import com.novell.gw.jclient.application.controls.standardgwitemtable.ItemListTableModel;
import com.novell.gw.jclient.application.controls.standardgwitemtable.QueryTableModel;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.filter.Filter;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.ContactsFolder;
import com.novell.gw.jclient.bl.om.folders.QueryFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.ItemDescription;
import com.novell.gw.jclient.bl.om.items.TableItem;
import java.awt.Window;
import javax.swing.FocusManager;
import javax.swing.SwingUtilities;

public class ItemListTableController
extends MVCController {
    public ItemListTableController(MVCView mVCView, MVCController mVCController) {
        super(mVCView, mVCController);
    }

    protected void initListeners() {
        Level level = LevelManager.getInstance().getFrameLevel(this.getLevel());
        AppEventListener appEventListener = new OPEN_FOLDER_Listener();
        AppEventListenerDescriptor appEventListenerDescriptor = new AppEventListenerDescriptor(level, 1090, appEventListener);
        this.addListenerDescriptor(appEventListenerDescriptor);
        appEventListener = new QUICKVIEWERPANE_SHOW_Listener();
        appEventListenerDescriptor = new AppEventListenerDescriptor(level, 350, appEventListener);
        this.addListenerDescriptor(appEventListenerDescriptor);
        appEventListener = new SELECT_TABLEITEM_Listener();
        appEventListenerDescriptor = new AppEventListenerDescriptor(level, 870, appEventListener);
        this.addListenerDescriptor(appEventListenerDescriptor);
        appEventListener = new FILTER_CHANGED_Listener();
        appEventListenerDescriptor = new AppEventListenerDescriptor(level, 400, appEventListener);
        this.addListenerDescriptor(appEventListenerDescriptor);
        appEventListener = new COLUMN_STRUCTURE_CHANGED_Listener();
        appEventListenerDescriptor = new AppEventListenerDescriptor(level, 1010, appEventListener);
        this.addListenerDescriptor(appEventListenerDescriptor);
        appEventListener = new FOLDER_SETTINGS_CHANGED_Listener();
        appEventListenerDescriptor = new AppEventListenerDescriptor(level, 1210, appEventListener);
        this.addListenerDescriptor(appEventListenerDescriptor);
        appEventListener = new COLUMN_SORT_CHANGED_Listener();
        appEventListenerDescriptor = new AppEventListenerDescriptor(level, 1020, appEventListener);
        this.addListenerDescriptor(appEventListenerDescriptor);
        appEventListener = new GRAB_TABLE_FOCUS_Listener();
        appEventListenerDescriptor = new AppEventListenerDescriptor(level, 1080, appEventListener);
        this.addListenerDescriptor(appEventListenerDescriptor);
        appEventListener = new WINDOW_CLOSED_Listener();
        appEventListenerDescriptor = new AppEventListenerDescriptor(level, 490, appEventListener);
        this.addListenerDescriptor(appEventListenerDescriptor);
    }

    public ItemListTable getTable() {
        return (ItemListTable)this.getMVCView();
    }

    private void doSelectFolder(AbstractFolder abstractFolder) {
        ItemListTableModel itemListTableModel;
        this.clear();
        if (abstractFolder instanceof ContactsFolder) {
            itemListTableModel = new EmptyItemListTableModel();
        } else {
            if (abstractFolder instanceof QueryFolder) {
                ItemListTableModel itemListTableModel2 = abstractFolder.getFolderDisplaySettings().getViewMode() == 7 ? new ChecklistQueryTableModel((QueryFolder)abstractFolder, (MVCController)this) : new QueryTableModel((QueryFolder)abstractFolder, (MVCController)this);
                this.getActionList().performAction("start query folder");
                this.getTable().updateModel(itemListTableModel2);
                return;
            }
            itemListTableModel = abstractFolder.getFolderDisplaySettings().getViewMode() == 7 ? new CheckListTableModel(abstractFolder, this) : (abstractFolder.getFolderDisplaySettings().getViewMode() == 1 ? new ItemListTableModel(abstractFolder, this) : new ItemListTableModel(abstractFolder, this));
        }
        this.getTable().updateModel(itemListTableModel);
    }

    private void clear() {
        ItemListTableModel itemListTableModel = (ItemListTableModel)this.getTable().getModel();
        itemListTableModel.dispose();
    }

    private class GRAB_TABLE_FOCUS_Listener
    extends AppEventListener {
        private GRAB_TABLE_FOCUS_Listener() {
        }

        public void handle(AppEvent appEvent) {
            this.adjustFocus();
        }

        private void adjustFocus() {
            Window window;
            Window window2;
            if (!ItemListTableController.this.getTable().isFocusOwner() && (window2 = SwingUtilities.getWindowAncestor(ItemListTableController.this.getTable())) == (window = FocusManager.getCurrentManager().getFocusedWindow())) {
                ItemListTableController.this.getTable().grabFocus();
            }
        }
    }

    private class WINDOW_CLOSED_Listener
    extends AppEventListener {
        private WINDOW_CLOSED_Listener() {
        }

        public void handle(AppEvent appEvent) {
            ApplicationFrame applicationFrame = (ApplicationFrame)appEvent.getData();
            if (applicationFrame.getController() == null) {
                return;
            }
            Level level = applicationFrame.getController().getLevel();
            Level level2 = LevelManager.getInstance().getFrameLevel(ItemListTableController.this.getLevel());
            if (level2.equals(level)) {
                ItemListTableController.this.clear();
            }
        }
    }

    private class COLUMN_SORT_CHANGED_Listener
    extends AppEventListener {
        private COLUMN_SORT_CHANGED_Listener() {
        }

        public void handle(AppEvent appEvent) {
            ItemListTableController.this.getTable().handleColumnsSortChanged((AbstractFolder)appEvent.getData());
        }
    }

    private class FOLDER_SETTINGS_CHANGED_Listener
    extends AppEventListener {
        private FOLDER_SETTINGS_CHANGED_Listener() {
        }

        public void handle(AppEvent appEvent) {
            AbstractFolder abstractFolder = ((ItemListTableModel)ItemListTableController.this.getTable().getModel()).getFolder();
            int n = (Integer)appEvent.getData();
            if (abstractFolder != null && abstractFolder.getFolderDisplaySettings().getId() == n) {
                ItemListTableController.this.getTable().handleColumnsStructureChanged(abstractFolder);
            }
        }
    }

    private class COLUMN_STRUCTURE_CHANGED_Listener
    extends AppEventListener {
        private COLUMN_STRUCTURE_CHANGED_Listener() {
        }

        public void handle(AppEvent appEvent) {
            ItemListTableController.this.getTable().handleColumnsStructureChanged((AbstractFolder)appEvent.getData());
        }
    }

    private class FILTER_CHANGED_Listener
    extends AppEventListener {
        private FILTER_CHANGED_Listener() {
        }

        public void handle(AppEvent appEvent) {
            Filter filter = (Filter)appEvent.getData();
            ItemListTableController.this.getTable().setFilter(filter);
        }
    }

    private class SELECT_TABLEITEM_Listener
    extends AppEventListener {
        private SELECT_TABLEITEM_Listener() {
        }

        public void handle(AppEvent appEvent) {
            TableItem tableItem = (TableItem)appEvent.getData();
            ItemListTable itemListTable = ItemListTableController.this.getTable();
            itemListTable.selectTableItem(tableItem);
        }
    }

    private class QUICKVIEWERPANE_SHOW_Listener
    extends AppEventListener {
        private QUICKVIEWERPANE_SHOW_Listener() {
        }

        public void handle(AppEvent appEvent) {
            TableItem tableItem = ItemListTableController.this.getTable().getSelectedItem();
            if (tableItem != null && tableItem instanceof AbstractItem) {
                ItemDescription itemDescription = new ItemDescription((AbstractItem)tableItem);
                Command command = new Command(20, itemDescription);
                ItemListTableController.this.processCommand(command);
            }
        }
    }

    private class OPEN_FOLDER_Listener
    extends AppEventListener {
        private OPEN_FOLDER_Listener() {
        }

        public void handle(AppEvent appEvent) {
            AbstractFolder abstractFolder = (AbstractFolder)appEvent.getData();
            ItemListTableModel itemListTableModel = (ItemListTableModel)ItemListTableController.this.getTable().getModel();
            boolean bl = abstractFolder.equals(itemListTableModel.getFolder());
            IDObjectsCollection iDObjectsCollection = ItemListTableController.this.getTable().getSelectedItems();
            if (!bl || iDObjectsCollection.size() == 0) {
                String string;
                TableItem tableItem;
                iDObjectsCollection.clearAll();
                if (!(abstractFolder instanceof QueryFolder) && (tableItem = GWCommandManager.getInstance(string = ControlsUtils.getUserGuid(ItemListTableController.this.getTable().getController())).getFirstItem(abstractFolder)) != null) {
                    iDObjectsCollection.addIDObject(tableItem);
                }
            }
            if (!bl || appEvent.getAttribute("FORCE_REFRESH") != null) {
                ItemListTableController.this.doSelectFolder(abstractFolder);
            }
            ItemListTableController.this.getTable().setSelextedItems(iDObjectsCollection);
        }
    }
}

