/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.standardgwitemtable;

import com.appframework.ApplicationFrame;
import com.appframework.filter.FiltersFactory;
import com.appframework.mvc.MVCController;
import com.novell.gw.engine.Item;
import com.novell.gw.engine.ItemList;
import com.novell.gw.engine.ItemListListener;
import com.novell.gw.engine.TransferItems;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.standardgwitemtable.GWTableCellRendererUtils;
import com.novell.gw.jclient.application.controls.standardgwitemtable.ImagesColumnPanel;
import com.novell.gw.jclient.application.controls.standardgwitemtable.ItemListColumnsModel;
import com.novell.gw.jclient.application.controls.standardgwitemtable.ItemListTableUtils;
import com.novell.gw.jclient.application.controls.standardgwitemtable.TableModelItemListListener;
import com.novell.gw.jclient.application.controls.standardgwitemtable.filter.EmptyFilter;
import com.novell.gw.jclient.application.controls.standardgwitemtable.filter.FilterFeedbackDialog;
import com.novell.gw.jclient.bl.eng_impl.utils.APIUtils;
import com.novell.gw.jclient.bl.eng_impl.utils.ColumnInfo;
import com.novell.gw.jclient.bl.eng_impl.utils.ColumnInfos;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.filter.Filter;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.TableItem;
import com.novell.gw.jclient.bl.om.items.UnknownTableItem;
import com.novell.gw.message.Message;
import java.awt.Component;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class ItemListTableModel
extends AbstractTableModel {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$standardgwitemtable$ItemListTableModel == null ? (class$com$novell$gw$jclient$application$controls$standardgwitemtable$ItemListTableModel = ItemListTableModel.class$("com.novell.gw.jclient.application.controls.standardgwitemtable.ItemListTableModel")) : class$com$novell$gw$jclient$application$controls$standardgwitemtable$ItemListTableModel));
    protected ItemListColumnsModel columns;
    protected ColumnInfos columnsInfos;
    protected AbstractFolder folder;
    protected ItemList itemList;
    protected TableModelItemListListener itemListListener;
    private Filter filter;
    protected MVCController controller;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$standardgwitemtable$ItemListTableModel;

    protected ItemListTableModel(MVCController mVCController) {
        this.setFilter(mVCController);
        this.controller = mVCController;
    }

    public ItemListTableModel(AbstractFolder abstractFolder, MVCController mVCController) {
        this.folder = abstractFolder;
        this.controller = mVCController;
        this.updateColumnInfos();
        this.columns = new ItemListColumnsModel(this.folder, this.getColumnInfos(), this.getImageColumnWidth());
        String string = ControlsUtils.getUserGuid(this.controller);
        this.itemListListener = new TableModelItemListListener(this, string);
        this.itemList = this.folder.getItemList();
        this.itemList.setFilter(new EmptyFilter().getItemListFilter());
        this.itemList.addItemListListener((ItemListListener)this.itemListListener);
        this.setFilter(mVCController);
        this.checkSort();
    }

    private void setFilter(MVCController mVCController) {
        if (mVCController == null) {
            this.setFilter(new EmptyFilter());
        } else {
            this.setFilter(FiltersFactory.getInstance().getFilter(mVCController));
        }
    }

    private void updateColumnInfos() {
        ColumnInfos columnInfos = this.columnsInfos = this.folder != null ? this.folder.getFolderDisplaySettings().getColumnInfos() : this.columnsInfos;
        if (this.columns != null) {
            this.columns.setColumnInfos(this.columnsInfos);
        }
    }

    public ColumnInfos getColumnInfos() {
        return this.columnsInfos;
    }

    public int getColumnCount() {
        return this.columns.getColumnCount();
    }

    public ItemListColumnsModel getColumnsModel() {
        return this.columns;
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return "";
        }
        int n2 = this.getColumnsModel().getColumnModelIndex(n);
        return this.getColumnInfos().getColumnInfoAt(n2).getName();
    }

    protected int getImageColumnWidth() {
        return 56;
    }

    protected Object getImageColumnValue(TableItem tableItem, int n) {
        ImagesColumnPanel imagesColumnPanel = new ImagesColumnPanel(0, ItemListTableUtils.IMAGES_COLUMN_COUNT, tableItem);
        GWTableCellRendererUtils.setItemIcons(tableItem, imagesColumnPanel);
        return imagesColumnPanel;
    }

    public String getType() {
        return this.folder != null ? this.folder.getType() : "";
    }

    public void updateColumns() {
        this.updateColumnInfos();
        this.columns = new ItemListColumnsModel(this.folder, this.getColumnInfos(), this.getImageColumnWidth());
        this.fireTableStructureChanged();
    }

    private void checkSort() {
        ColumnInfo columnInfo = this.getColumnInfos().getSorted();
        if (columnInfo != null && !"CheckList".equals(this.getType())) {
            int n = columnInfo.getFieldID();
            boolean bl = APIUtils.isSortAscending(columnInfo.getSortOrder().getID());
            if (this.itemList.getSortField() != n || this.itemList.isSortAscending() != bl) {
                this.sort();
            }
        }
    }

    public int getRowCount() {
        if (this.itemList != null) {
            return this.itemList.getSize();
        }
        return 0;
    }

    public int getIndex(TableItem tableItem) {
        if (this.itemList != null && tableItem.getNativeObject() != null) {
            return this.itemList.indexOf(tableItem.getNativeObject());
        }
        return -1;
    }

    public TableItem getItemAt(int n) {
        if (this.itemList != null && n >= 0 && n < this.itemList.getSize()) {
            try {
                Item item = this.itemList.getItemAt(n);
                String string = ControlsUtils.getUserGuid(this.controller);
                return GWCommandManager.getInstance(string).getTableItem(item);
            }
            catch (Exception exception) {
                logger.error((Object)exception, (Throwable)exception);
            }
        }
        return new UnknownTableItem(null);
    }

    public void dispose() {
        if (this.itemList != null) {
            logger.debug((Object)"dispose entered");
            this.itemList.removeItemListListener((ItemListListener)this.itemListListener);
            this.itemList = null;
            this.filter = null;
            logger.debug((Object)"dispose exited");
        }
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
        if (this.itemList != null) {
            int n = this.getFoldersCount(this.itemList);
            int n2 = this.itemList.getSize() - n;
            this.itemList.setFilter(this.filter.getItemListFilter());
            int n3 = this.itemList.getSize() - n;
            if (n2 > 0 && n3 == 0) {
                ApplicationFrame applicationFrame = null;
                Component component = this.controller.getActionList().getOwnerComponent();
                if (component instanceof ApplicationFrame) {
                    applicationFrame = (ApplicationFrame)component;
                }
                new FilterFeedbackDialog(applicationFrame, this.controller).setVisible(true);
            }
        }
    }

    private int getFoldersCount(ItemList itemList) {
        int n;
        if (itemList.getSize() > 0) {
            Item item;
            for (n = 0; n < itemList.getSize() && !((item = itemList.getItemAt(n)) instanceof Message); ++n) {
            }
        }
        return n;
    }

    public TransferItems getTransferItems(int[] nArray) {
        if (this.itemList != null) {
            return this.itemList.getTransferItems(nArray);
        }
        return null;
    }

    public boolean canDeleteItemsAt(int[] nArray) {
        if (this.itemList != null) {
            return this.itemList.canDeleteItemsAt(nArray);
        }
        return false;
    }

    public Object getValueAt(int n, int n2) {
        Object object = null;
        TableItem tableItem = this.getItemAt(n);
        if (n2 < 0) {
            object = "";
        } else if (n2 == 0) {
            object = this.getImageColumnValue(tableItem, n);
        } else if (tableItem instanceof AbstractItem) {
            AbstractItem abstractItem = (AbstractItem)tableItem;
            int n3 = this.getColumnInfos().getColumnInfoAt(n2).getFieldID();
            object = abstractItem.getNativeItem().getValue(n3, this.folder.getNativeFolder());
        } else if (tableItem instanceof AbstractFolder && n2 == 1) {
            object = tableItem.getSubject();
        }
        return object == null ? "" : object;
    }

    public void sort() {
        this.updateColumnInfos();
        ColumnInfo columnInfo = this.getColumnInfos().getSorted();
        int n = columnInfo.getFieldID();
        boolean bl = columnInfo.isSortedAscending();
        logger.debug((Object)("SORTING [" + n + ":" + bl + "]....."));
        this.itemList.sort(n, bl);
    }

    public Filter getFilter() {
        return this.filter;
    }

    public AbstractFolder getFolder() {
        return this.folder;
    }

    public ItemList getItemList() {
        return this.itemList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

