/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.standardgwitemtable.filter;

import com.appframework.utils.UIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class ComponentWithMenu
extends JComponent {
    private JComponent cContent;
    private ALMouseMotionListener mouseMotionListener;
    private ALMouseListener mouseListener;

    public ComponentWithMenu(JComponent jComponent, JPopupMenu jPopupMenu) {
        this.setLayout(new BorderLayout());
        this.cContent = jComponent;
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.cContent);
        this.add((Component)jPanel, "Center");
        this.mouseMotionListener = new ALMouseMotionListener(jPopupMenu);
        this.mouseListener = new ALMouseListener(jComponent, jPopupMenu);
        this.addMouseMotionListener(this.mouseMotionListener);
        this.addMouseListener(this.mouseListener);
        this.setComponentOrientation(UIUtils.getComponentOrientation());
    }

    public static void initComponent(JComponent jComponent, JPopupMenu jPopupMenu) {
        ComponentWithMenu.removeListeners(jComponent);
        jComponent.addMouseMotionListener(new ALMouseMotionListener(jPopupMenu));
        jComponent.addMouseListener(new ALMouseListener(jComponent, jPopupMenu));
    }

    private static void removeListeners(JComponent jComponent) {
        MouseListener[] mouseListenerArray = jComponent.getMouseListeners();
        for (int i = 0; i < mouseListenerArray.length; ++i) {
            MouseListener mouseListener = mouseListenerArray[i];
            if (!(mouseListener instanceof ALMouseListener)) continue;
            jComponent.removeMouseListener(mouseListener);
        }
        MouseMotionListener[] mouseMotionListenerArray = jComponent.getMouseMotionListeners();
        for (int i = 0; i < mouseMotionListenerArray.length; ++i) {
            MouseMotionListener mouseMotionListener = mouseMotionListenerArray[i];
            if (!(mouseMotionListener instanceof ALMouseListener)) continue;
            jComponent.removeMouseMotionListener(mouseMotionListener);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.cContent.setFont(font);
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this.mouseListener.setPopupMenu(jPopupMenu);
        this.mouseMotionListener.setPopupMenu(jPopupMenu);
    }

    private static class ALMouseListener
    extends MouseAdapter {
        private JComponent component;
        private JPopupMenu popupMenu;

        public ALMouseListener(JComponent jComponent, JPopupMenu jPopupMenu) {
            this.component = jComponent;
            this.popupMenu = jPopupMenu;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = this.component.getWidth() - this.popupMenu.getWidth() / 2;
            this.popupMenu.show(this.component, n, this.component.getHeight());
            mouseEvent.getComponent().setCursor(new Cursor(0));
        }

        public void setPopupMenu(JPopupMenu jPopupMenu) {
            this.popupMenu = jPopupMenu;
        }
    }

    private static class ALMouseMotionListener
    extends MouseMotionAdapter {
        private JPopupMenu popupMenu;

        public ALMouseMotionListener(JPopupMenu jPopupMenu) {
            this.popupMenu = jPopupMenu;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (!this.popupMenu.isVisible()) {
                mouseEvent.getComponent().setCursor(new Cursor(12));
            } else {
                mouseEvent.getComponent().setCursor(new Cursor(0));
            }
        }

        public void setPopupMenu(JPopupMenu jPopupMenu) {
            this.popupMenu = jPopupMenu;
        }
    }
}

