/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.storageswitcher;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.components.multyactionlabel.CombinedCheckedIcon;
import com.appframework.components.multyactionlabel.ShiftedIcon;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.engine.EngineException;
import com.novell.gw.engine.ProxyHistoryEntry;
import com.novell.gw.engine.ProxyHistoryList;
import com.novell.gw.jclient.application.actions.StorageMode;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.itemview.UnderlinableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.storageswitcher.StorageSwitcherController;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;

public class StorageSwitcher
extends JComponent
implements MVCView {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$storageswitcher$StorageSwitcher == null ? (class$com$novell$gw$jclient$application$controls$storageswitcher$StorageSwitcher = StorageSwitcher.class$("com.novell.gw.jclient.application.controls.storageswitcher.StorageSwitcher")) : class$com$novell$gw$jclient$application$controls$storageswitcher$StorageSwitcher));
    private MVCController controller;
    private static final int MODE_ONLINE = 0;
    private static final int MODE_CACHING = 1;
    private static final int MODE_ARCHIVE = 2;
    private static final int MODE_PROXY = 3;
    private static final int MODE_BACKUP = 4;
    private JPopupMenu popup;
    private JMenuItem itemUser;
    private JMenuItem itemArchive;
    private JMenuItem itemBackup;
    private JMenuItem itemOnline;
    private JMenuItem itemCaching;
    private JMenuItem itemProxy;
    private int mode;
    private Component filler;
    private JLabel arrowLabel;
    private UnderlinableLabel clickLabel;
    private PopupListener popupListener;
    private static final int ICON_SHIFT = 12;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$storageswitcher$StorageSwitcher;

    public StorageSwitcher(ActionList actionList) {
        this.setDoubleBuffered(true);
        this.setOpaque(false);
        this.controller = new StorageSwitcherController(this, actionList);
        this.popupListener = new PopupListener();
        this.clickLabel = new UnderlinableLabel();
        this.clickLabel.setForeground(Color.WHITE);
        this.clickLabel.setIcon(ImageResources.ICON_STORAGE_SWITCH);
        this.clickLabel.addMouseListener(this.popupListener);
        this.arrowLabel = new OrientableLabel(ImageResources.ICON_DOWN_ARROW);
        this.arrowLabel.setFocusable(false);
        if (UIUtils.getComponentOrientation().isLeftToRight()) {
            this.arrowLabel.setHorizontalTextPosition(2);
        } else {
            this.arrowLabel.setHorizontalTextPosition(4);
        }
        this.arrowLabel.setIconTextGap(0);
        this.arrowLabel.addMouseListener(this.popupListener);
        this.filler = Box.createRigidArea(new Dimension(0, 0));
        this.filler.setFocusable(false);
        this.setLayout(new BoxLayout(this, 0));
        if (UIUtils.getComponentOrientation().isLeftToRight()) {
            this.add(this.clickLabel);
            this.add(this.filler);
            this.add(this.arrowLabel);
        } else {
            this.add(Box.createHorizontalGlue());
            this.add(this.arrowLabel);
            this.add(this.filler);
            this.add(this.clickLabel);
        }
        AppAction appAction = actionList.getAction("Show User Store");
        AppAction appAction2 = actionList.getAction("Show Archive Store");
        AppAction appAction3 = actionList.getAction("Switch Backup Store");
        AppAction appAction4 = actionList.getAction("Online");
        AppAction appAction5 = actionList.getAction("Caching");
        AppAction appAction6 = actionList.getAction("Proxy");
        this.itemUser = OS.createMenuItem(appAction);
        this.itemUser.setIcon(StorageSwitcher.getImageIcon(appAction.getAppActionModel().getIcon()));
        this.itemOnline = OS.createMenuItem(appAction4);
        this.itemOnline.setIcon(new ShiftedIcon(12, StorageSwitcher.getImageIcon(appAction4.getAppActionModel().getIcon())));
        this.itemCaching = OS.createMenuItem(appAction5);
        this.itemCaching.setIcon(new ShiftedIcon(12, StorageSwitcher.getImageIcon(appAction5.getAppActionModel().getIcon())));
        this.itemArchive = OS.createMenuItem(appAction2);
        this.itemArchive.setIcon(StorageSwitcher.getImageIcon(appAction2.getAppActionModel().getIcon()));
        this.itemBackup = OS.createMenuItem(appAction3);
        this.itemBackup.setIcon(StorageSwitcher.getImageIcon(appAction3.getAppActionModel().getIcon()));
        this.itemProxy = OS.createMenuItem(appAction6);
        this.itemProxy.setIcon(StorageSwitcher.getImageIcon(appAction6.getAppActionModel().getIcon()));
        appAction.putValue("Name", EngineCommandManager.getUserInfo().getFromText());
        int n = EngineCommandManager.getCurrentMode();
        if (6 == n) {
            this.setMode(1);
        } else if (1 == n) {
            this.setMode(0);
        }
        this.setCursor(Cursor.getPredefinedCursor(12));
        String string = ControlsUtils.getUserGuid(this.controller);
        if (GWCommandManager.getInstance(string).isArchive()) {
            this.setMode(2);
        } else if (GWCommandManager.getInstance(string).isBackupDB()) {
            this.setMode(4);
        } else if (!string.equals(EngineCommandManager.getUserInfo().getGuid())) {
            this.setProxyMode();
        }
    }

    public static ImageIcon getImageIcon(ImageIcon imageIcon) {
        if (OS.isMacOS()) {
            return imageIcon;
        }
        return new CombinedCheckedIcon(imageIcon);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.clickLabel.setFont(font);
    }

    private void addProxyHistory(JPopupMenu jPopupMenu) {
        ProxyHistoryList proxyHistoryList = EngineCommandManager.getProxyHistoryList();
        for (int i = 0; i < proxyHistoryList.size(); ++i) {
            ProxyHistoryEntry proxyHistoryEntry = proxyHistoryList.get(i);
            String string = proxyHistoryEntry.getDisplayName();
            String string2 = proxyHistoryEntry.getGuid();
            if (string2.equals(EngineCommandManager.getUserInfo().getGuid())) continue;
            ProxyUserAction proxyUserAction = new ProxyUserAction(proxyHistoryEntry);
            JMenuItem jMenuItem = OS.createMenuItemForAction(proxyUserAction, true);
            jMenuItem.setIcon(new ShiftedIcon(12, StorageSwitcher.getImageIcon(ImageResources.ICON_ADDRESS_BOOK_USER)));
            String string3 = ControlsUtils.getUserGuid(this.controller);
            String string4 = GWCommandManager.getInstance(string3).getCurrentDataStore().getUserFields().getDisplayName();
            jMenuItem.setSelected(string.equals(string4));
            jPopupMenu.add(jMenuItem);
        }
    }

    private int getUserMode() {
        int n = EngineCommandManager.getCurrentMode();
        if (n == 1) {
            return 0;
        }
        if (n == 6) {
            return 1;
        }
        logger.error((Object)("unsopported client mode: " + n + ". Defaults to ONLINE"));
        return 0;
    }

    public void setController(MVCController mVCController) {
        this.controller = mVCController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object object) {
    }

    public Object getMVCModel() {
        return null;
    }

    private void setMode(int n) {
        switch (n) {
            case 0: {
                this.clickLabel.setText(StringResources.ONLINE);
                this.itemOnline.setSelected(true);
                this.itemCaching.setSelected(false);
                break;
            }
            case 1: {
                this.clickLabel.setText(StringResources.CACHING);
                this.itemOnline.setSelected(false);
                this.itemCaching.setSelected(true);
                break;
            }
            case 2: {
                this.clickLabel.setText(StringResources.ARCHIVE);
                break;
            }
            case 4: {
                this.clickLabel.setText(StringResources.BACKUP);
                break;
            }
            case 3: {
                this.clickLabel.setText(StringResources.PROXY);
                this.itemUser.setSelected(false);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.mode = n;
    }

    void switchStoreMode(StorageMode storageMode) {
        if (storageMode.isNormal()) {
            this.setMode(this.getUserMode());
        } else if (storageMode.isArchive()) {
            this.setMode(2);
        } else if (storageMode.isBackup()) {
            this.setMode(4);
        }
    }

    public void updateMode() {
        if (EngineCommandManager.getCurrentMode() == 1) {
            this.setMode(0);
        } else if (EngineCommandManager.getCurrentMode() == 6) {
            this.setMode(1);
        }
    }

    public void setProxyMode() {
        this.setMode(3);
    }

    private JPopupMenu getPopupMenu() {
        this.popup = new JPopupMenu();
        this.popup.add(this.itemUser);
        if (this.mode != 3) {
            if (this.mode != 2 && this.mode != 4) {
                this.popup.add(this.itemOnline);
                this.popup.add(this.itemCaching);
            }
            this.popup.addSeparator();
            if (this.mode != 4) {
                this.popup.add(this.itemArchive);
            }
            if (this.mode != 2) {
                this.popup.add(this.itemBackup);
            }
            if (this.mode == 0) {
                this.itemUser.setSelected(true);
                this.itemArchive.setSelected(false);
                this.itemBackup.setSelected(false);
            } else if (this.mode == 1) {
                this.itemUser.setSelected(true);
                this.itemArchive.setSelected(false);
                this.itemBackup.setSelected(false);
            } else if (this.mode == 2) {
                this.itemUser.setSelected(false);
                this.itemArchive.setSelected(true);
                this.itemBackup.setSelected(false);
            }
            if (this.mode == 4) {
                this.itemUser.setSelected(false);
                this.itemArchive.setSelected(false);
                this.itemBackup.setSelected(true);
            }
        }
        if (this.mode != 2 && this.mode != 4) {
            this.popup.addSeparator();
            this.popup.add(this.itemProxy);
            this.addProxyHistory(this.popup);
        }
        return this.popup;
    }

    private void showPopup() {
        ControlsUtils.getWindowForComponent(this).getBounds();
        Rectangle rectangle = this.getBounds();
        Dimension dimension = this.getPopupMenu().getPreferredSize();
        this.popup.show(this, rectangle.width - dimension.width - 6, rectangle.height);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ProxyUserAction
    extends AbstractAction {
        private ProxyHistoryEntry entry;

        public ProxyUserAction(ProxyHistoryEntry proxyHistoryEntry) {
            super(proxyHistoryEntry.getDisplayName());
            this.entry = proxyHistoryEntry;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string = ControlsUtils.getUserGuid(StorageSwitcher.this.controller);
                String string2 = GWCommandManager.getInstance(string).performProxy(this.entry);
                StorageSwitcher.this.getController().processCommand(new Command(750, string2));
                StorageSwitcher.this.getController().getActionList().performAction("Refresh");
            }
            catch (EngineException engineException) {
                JOptionPane.showMessageDialog(StorageSwitcher.this, EngineException.getErrorString((int)engineException.getErrorCode()), StringResources.NOVELL_GROUPWISE, 2);
                logger.error((Object)engineException);
            }
        }
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            StorageSwitcher storageSwitcher = StorageSwitcher.this;
            if (!storageSwitcher.clickLabel.isFocusOwner()) {
                storageSwitcher.clickLabel.requestFocus();
            }
            storageSwitcher.showPopup();
        }
    }
}

