/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.timepicker;

import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateValueChangeListener;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.TimeDocumentHandler;
import com.novell.gw.jclient.application.controls.timepicker.DurationChangeEvent;
import com.novell.gw.jclient.application.controls.timepicker.DurationChangeListener;
import com.novell.gw.jclient.application.controls.timepicker.MutableTextField;
import com.novell.gw.jclient.application.controls.timepicker.TimePicker;
import com.novell.gw.jclient.application.controls.timepicker.TimeTextField;
import com.novell.gw.jclient.application.controls.timepicker.TimeTextFormat;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBar;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.bl.om.items.TimeDuration;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class TimeDurationSelector
extends GWToolBar
implements DateValueChangeListener {
    private TimeTextField startTimeField;
    private AbstractButton pickerButton;
    private TimePicker timePicker;
    private TimeDuration duration;
    private ArrayList listeners = new ArrayList();
    private boolean adjusting;
    private ArrayList textFields = new ArrayList();

    public TimeDurationSelector() {
        this(new TimeDuration(GWCalendarUtils.getMinutes(GWCalendarUtils.getToday()), GWCalendarUtils.getMinutes(GWCalendarUtils.getToday()) + 60));
    }

    private TimeDurationSelector(TimeDuration timeDuration) {
        this.init();
        this.setDuration(timeDuration);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(null);
        this.startTimeField = new TimeTextField(new TimeTextFormat(), new TimeDocumentHandler());
        this.startTimeField.addKeyListener(new TimePickerListener());
        this.startTimeField.addValueChangeListener(this);
        this.addTextField(this.startTimeField);
        this.add((Component)this.startTimeField, "Center");
        this.initPickerButton();
        this.add((Component)this.pickerButton, "After");
    }

    private void initPickerButton() {
        this.pickerButton = UIUtils.createToolButton(new TimePickerAction());
        this.pickerButton.setIcon(ImageResources.ACT_TIMEPICKER);
    }

    private void initPicker() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window instanceof JFrame) {
            this.timePicker = new TimePicker((JFrame)window);
        }
    }

    private void showPicker() {
        if (this.timePicker == null) {
            this.initPicker();
        }
        if (this.timePicker != null) {
            this.commitChanges();
            UIUtils.centerWindow((Window)this.timePicker, this.timePicker.getOwner());
            this.timePicker.setDuration(this.duration);
            this.timePicker.show();
            if (this.timePicker.isCompleteSuccessfully()) {
                this.setDuration(this.timePicker.getDuration());
            }
        }
    }

    public void addTextField(MutableTextField mutableTextField) {
        this.textFields.add(mutableTextField);
    }

    private void commitChanges() {
        for (int i = 0; i < this.textFields.size(); ++i) {
            MutableTextField mutableTextField = (MutableTextField)this.textFields.get(i);
            mutableTextField.commit();
        }
    }

    public void valueChanged(DateChangeEvent dateChangeEvent) {
        if (!this.adjusting) {
            GregorianCalendar gregorianCalendar = dateChangeEvent.getDate();
            int n = GWCalendarUtils.getMinutes(gregorianCalendar);
            this.duration.updateStartMinutes(n);
            DurationChangeEvent durationChangeEvent = new DurationChangeEvent(dateChangeEvent.getDate(), this.duration, this);
            this.fireDurationChanged(durationChangeEvent);
        }
    }

    public void setDuration(TimeDuration timeDuration) {
        if (timeDuration == null) {
            throw new IllegalArgumentException("Duration can not be null");
        }
        if (!timeDuration.equals(this.duration)) {
            this.duration = timeDuration;
            GregorianCalendar gregorianCalendar = GWCalendarUtils.getZero(GWCalendarUtils.getToday());
            gregorianCalendar.add(12, timeDuration.getStartMinutes());
            this.adjusting = true;
            this.startTimeField.setTime(gregorianCalendar);
            this.adjusting = false;
            DurationChangeEvent durationChangeEvent = new DurationChangeEvent(this.startTimeField.getTime(), this.duration, this);
            this.fireDurationChanged(durationChangeEvent);
        }
    }

    private void handleKey(int n) {
        switch (n) {
            case 40: {
                this.showPicker();
            }
        }
    }

    public JTextComponent getTextComponent() {
        return this.startTimeField;
    }

    public TimeDuration getDuration() {
        this.commitChanges();
        return this.duration;
    }

    private void fireDurationChanged(DurationChangeEvent durationChangeEvent) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            DurationChangeListener durationChangeListener = (DurationChangeListener)this.listeners.get(i);
            durationChangeListener.valueChanged(durationChangeEvent);
        }
    }

    public void addDurationChangeListener(DurationChangeListener durationChangeListener) {
        this.listeners.add(durationChangeListener);
    }

    public void removeDurationChangeListener(DurationChangeListener durationChangeListener) {
        this.listeners.remove(durationChangeListener);
    }

    private class TimePickerListener
    extends KeyAdapter {
        private TimePickerListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            TimeDurationSelector.this.handleKey(n);
        }
    }

    private class TimePickerAction
    extends AbstractAction {
        private TimePickerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!TimeDurationSelector.this.startTimeField.isFocusOwner()) {
                TimeDurationSelector.this.startTimeField.grabFocus();
            }
            TimeDurationSelector.this.showPicker();
        }
    }
}

