/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.timepicker;

import com.novell.gw.jclient.application.controls.BasicDialog;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.options.ColorsOptions;
import com.novell.gw.jclient.application.options.fonts.FontOptions;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.TimeDuration;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class TimePicker
extends BasicDialog {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$timepicker$TimePicker == null ? (class$com$novell$gw$jclient$application$controls$timepicker$TimePicker = TimePicker.class$("com.novell.gw.jclient.application.controls.timepicker.TimePicker")) : class$com$novell$gw$jclient$application$controls$timepicker$TimePicker));
    private LeftSlider sldStartTime;
    private JSlider sldEndTime;
    private JPanel sliders;
    public static final int SLIDER_HEIGHT = 24 * PLAFChanger.getFontSize() + 300;
    private Hashtable htblLabels;
    private JPanel pnlButtons;
    private JButton btnOK;
    private JButton btnCancel;
    private JLabel lblStartTime;
    private JLabel lblEndTime;
    private JLabel lblDurationHour;
    private JLabel lblDurationMinute;
    private GregorianCalendar startTime;
    private GregorianCalendar endTime;
    private int duration;
    private boolean isMinutesVisible = true;
    public static final int SHOW_MINUTES = 0;
    public static final int DONT_SHOW_MINUTES = 1;
    private int maxTicks = 95;
    private int step = 15;
    private boolean completeSuccessfully = false;
    private StartTimeListener startChangeListener;
    private EndTimeListener endChangeListener;
    private static final int END_TIME_SLIDER_INSET = PLAFChanger.getFontSize() / 2 - 6;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$timepicker$TimePicker;

    public TimePicker(JFrame jFrame) {
        super((Frame)jFrame, true);
        this.buildUI();
    }

    private void initTime() {
        this.startTime = GWCalendarUtils.getZero(GWCalendarUtils.getToday());
        this.endTime = GWCalendarUtils.getZero(GWCalendarUtils.getToday());
    }

    private void scrollToVisible() {
        Rectangle rectangle = this.sldStartTime.getColoredRectangle();
        rectangle.height += 100;
        this.sliders.scrollRectToVisible(rectangle);
    }

    private void buildUI() {
        this.setTitle(StringResources.TIME_INPUT);
        this.getContentPane().setLayout(new BorderLayout());
        this.init();
        this.buildButtons();
        this.getContentPane().add((Component)this.pnlButtons, "After");
        this.buildSliderLabels();
        this.buildStartTimeSlider();
        this.buildEndTimeSlider();
        this.buildSliderPanel();
        this.initChangeListeners();
        this.setDefaultButton(this.btnOK);
        this.setCancelButton(this.btnCancel);
        this.pack();
    }

    private void init() {
        if (this.isMinutesVisible) {
            this.maxTicks = 96;
            this.step = 15;
        } else {
            this.maxTicks = 23;
            this.step = 60;
        }
    }

    private void buildSliderPanel() {
        this.sliders = new JPanel(new FlowLayout(1, 0, 0));
        this.sliders.addHierarchyListener(new VisibilityChangeListener());
        this.sliders.setPreferredSize(new Dimension((this.sldStartTime.getPreferredSize().width + this.sldEndTime.getPreferredSize().width) * 2, SLIDER_HEIGHT));
        this.sliders.add(this.sldStartTime);
        this.sliders.add(this.sldEndTime);
        OrientableScrollPane orientableScrollPane = new OrientableScrollPane(this.sliders);
        orientableScrollPane.setHorizontalScrollBarPolicy(31);
        this.getContentPane().add((Component)orientableScrollPane, "Center");
    }

    private void addChangeListeners() {
        this.sldStartTime.addChangeListener(this.startChangeListener);
        this.sldEndTime.addChangeListener(this.endChangeListener);
    }

    private void removeChangeListeners() {
        this.sldStartTime.removeChangeListener(this.startChangeListener);
        this.sldEndTime.removeChangeListener(this.endChangeListener);
    }

    private void initChangeListeners() {
        this.startChangeListener = new StartTimeListener();
        this.endChangeListener = new EndTimeListener();
    }

    private void buildStartTimeSlider() {
        this.sldStartTime = new LeftSlider(1, 0, this.maxTicks, 15);
        this.sldStartTime.setSnapToTicks(true);
        this.sldStartTime.setInverted(true);
        if (this.isMinutesVisible) {
            this.sldStartTime.setMajorTickSpacing(4);
            this.sldStartTime.setMinorTickSpacing(1);
        } else {
            this.sldStartTime.setMajorTickSpacing(1);
        }
        this.sldStartTime.setPaintTicks(true);
        this.sldStartTime.setPaintLabels(true);
        this.sldStartTime.setLabelTable(this.htblLabels);
        this.sldStartTime.getWidthOfWidestLabel();
        Dimension dimension = new Dimension(this.sldStartTime.getWidthOfWidestLabel() + 40, SLIDER_HEIGHT);
        this.sldStartTime.setMinimumSize(dimension);
        this.sldStartTime.setPreferredSize(dimension);
        this.sldStartTime.setSize(dimension);
        this.sldStartTime.setValue(-1);
        this.sldStartTime.addMouseMotionListener(new DoAutoscrollAdapter());
    }

    private void buildEndTimeSlider() {
        this.sldEndTime = new JSlider(1, 0, this.maxTicks, 1);
        this.sldEndTime.setSnapToTicks(true);
        Dimension dimension = new Dimension(this.sldEndTime.getPreferredSize().width + 20, SLIDER_HEIGHT);
        this.sldEndTime.setSize(dimension);
        this.sldEndTime.setMinimumSize(dimension);
        this.sldEndTime.setPreferredSize(dimension);
        this.sldEndTime.setInverted(true);
        this.sldEndTime.setBorder(BorderFactory.createEmptyBorder(END_TIME_SLIDER_INSET, 0, END_TIME_SLIDER_INSET, 0));
        if (this.isMinutesVisible) {
            this.sldEndTime.setMajorTickSpacing(4);
            this.sldEndTime.setMinorTickSpacing(1);
        } else {
            this.sldEndTime.setMajorTickSpacing(1);
        }
        this.sldEndTime.setPaintTicks(true);
        this.sldEndTime.setPaintLabels(false);
        this.sldEndTime.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.sldEndTime.setValue(-1);
        this.sldEndTime.addMouseMotionListener(new DoAutoscrollAdapter());
    }

    private void buildSliderLabels() {
        this.htblLabels = new Hashtable(24);
        GregorianCalendar gregorianCalendar = GWCalendarUtils.getToday();
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        int n = 0;
        for (int i = 0; i < 24; ++i) {
            OrientableLabel orientableLabel = new OrientableLabel(GWCalendarUtils.getTimeFormat().format(gregorianCalendar.getTime()));
            orientableLabel.setFont(FontOptions.getFontFor(160));
            n = this.isMinutesVisible ? i * 4 : i;
            this.htblLabels.put(new Integer(n), orientableLabel);
            gregorianCalendar.add(10, 1);
        }
    }

    private void buildButtons() {
        Insets insets;
        Insets insets2;
        this.pnlButtons = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(20, 10, 5, 10);
        this.btnOK = new JButton(new BtnOKAction());
        this.pnlButtons.add((Component)this.btnOK, gridBagConstraints);
        this.btnCancel = new JButton(new BtnCancelAction());
        gridBagConstraints.insets = new Insets(5, 10, 20, 10);
        gridBagConstraints.gridy = 1;
        this.pnlButtons.add((Component)this.btnCancel, gridBagConstraints);
        OrientableLabel orientableLabel = new OrientableLabel(StringResources.START_TIME_C);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = insets2 = new Insets(10, 10, 0, 10);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridy = 2;
        this.pnlButtons.add((Component)orientableLabel, gridBagConstraints);
        this.lblStartTime = new OrientableLabel();
        gridBagConstraints.insets = insets = new Insets(0, 35, 0, 10);
        gridBagConstraints.gridy = 3;
        this.pnlButtons.add((Component)this.lblStartTime, gridBagConstraints);
        OrientableLabel orientableLabel2 = new OrientableLabel(StringResources.END_TIME_C);
        gridBagConstraints.insets = insets2;
        gridBagConstraints.gridy = 4;
        this.pnlButtons.add((Component)orientableLabel2, gridBagConstraints);
        this.lblEndTime = new OrientableLabel();
        gridBagConstraints.insets = insets;
        gridBagConstraints.gridy = 5;
        this.pnlButtons.add((Component)this.lblEndTime, gridBagConstraints);
        OrientableLabel orientableLabel3 = new OrientableLabel(StringResources.DURATION_C);
        gridBagConstraints.insets = insets2;
        gridBagConstraints.gridy = 6;
        this.pnlButtons.add((Component)orientableLabel3, gridBagConstraints);
        this.lblDurationHour = new OrientableLabel();
        gridBagConstraints.insets = insets;
        gridBagConstraints.gridy = 7;
        this.pnlButtons.add((Component)this.lblDurationHour, gridBagConstraints);
        this.lblDurationMinute = new OrientableLabel();
        gridBagConstraints.gridy = 8;
        if (this.isMinutesVisible) {
            this.pnlButtons.add((Component)this.lblDurationMinute, gridBagConstraints);
        }
        gridBagConstraints.gridy = 9;
        gridBagConstraints.weighty = 1.0;
        this.pnlButtons.add((Component)new OrientableLabel(), gridBagConstraints);
    }

    private void refreshView(boolean bl) {
        Object object;
        int n;
        int n2;
        int n3;
        int n4 = GWCalendarUtils.getMinutes(this.startTime);
        if (bl) {
            this.sldStartTime.setValue(n4 / this.step);
            n3 = 7;
            n2 = this.getHeight() - n3 * 2;
            n = n2 * this.sldStartTime.getValue() / this.maxTicks;
            object = new Rectangle(0, n -= n3, 1, 1);
            this.sliders.scrollRectToVisible((Rectangle)object);
        }
        this.lblStartTime.setText(GWCalendarUtils.getTimeFormat().format(this.startTime.getTime()));
        n3 = GWCalendarUtils.getMinutes(this.endTime);
        if (bl) {
            this.sldEndTime.setValue(n3 / this.step);
        }
        this.lblEndTime.setText(GWCalendarUtils.getTimeFormat().format(this.endTime.getTime()));
        this.duration = n3 - n4;
        n2 = this.duration / 60;
        n = this.duration % 60;
        this.lblDurationHour.setText("" + n2 + " " + StringResources.HOUR_S);
        object = n + " " + StringResources.MINUTE_S;
        if (n < 10) {
            object = n + "   " + StringResources.MINUTE_S;
        }
        this.lblDurationMinute.setText((String)object);
        this.sliders.repaint();
    }

    public void setDuration(TimeDuration timeDuration) {
        this.initTime();
        this.startTime.add(12, timeDuration.getStartMinutes());
        this.endTime.add(12, timeDuration.getEndMinutes());
        this.duration = timeDuration.getDuration();
        this.removeChangeListeners();
        this.refreshView(true);
        this.addChangeListeners();
    }

    public TimeDuration getDuration() {
        return new TimeDuration(GWCalendarUtils.getMinutes(this.startTime), GWCalendarUtils.getMinutes(this.endTime));
    }

    private void setCompleteSuccessfully(boolean bl) {
        this.completeSuccessfully = bl;
    }

    public boolean isCompleteSuccessfully() {
        return this.completeSuccessfully;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class VisibilityChangeListener
    implements HierarchyListener {
        private VisibilityChangeListener() {
        }

        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if ((hierarchyEvent.getChangeFlags() & 4L) == 0L || !TimePicker.this.isShowing()) {
                return;
            }
            TimePicker.this.scrollToVisible();
        }
    }

    private class BtnCancelAction
    extends AbstractAction {
        public BtnCancelAction() {
            super(StringResources.CANCEL);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TimePicker.this.setCompleteSuccessfully(false);
            TimePicker.this.hide();
        }
    }

    private class BtnOKAction
    extends AbstractAction {
        public BtnOKAction() {
            super(StringResources.OK);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TimePicker.this.setCompleteSuccessfully(true);
            TimePicker.this.hide();
        }
    }

    private class LeftSlider
    extends JSlider {
        int OFFSET_Y = PLAFChanger.isGTKLAF() ? 17 : 0;
        int THUMB_WIDTH = PLAFChanger.isGTKLAF() ? UIManager.getInt("Slider.thumbWidth") : PLAFChanger.getFontSize() + 2;
        int TRACK_BORDER = PLAFChanger.isGTKLAF() ? 1 : UIManager.getInt("Slider.trackBorder");
        int UPPER_Y = (int)((float)PLAFChanger.getFontSize() / 2.0f + 1.0f);
        int DELTA_Y = PLAFChanger.isGTKLAF() ? 1 : 0;
        int LEFT_X = 33;
        int max = 0;
        private MouseListener originMouseListener;
        private boolean isDragging = false;
        private int dY = 0;
        private int rectHeigth = 0;

        public LeftSlider(int n, int n2, int n3, int n4) {
            super(n, n2, n3, n4);
            this.max = n3 == 0 ? 1 : n3;
            MouseListener[] mouseListenerArray = this.getMouseListeners();
            this.originMouseListener = mouseListenerArray[0];
            this.removeMouseListener(this.originMouseListener);
            this.addMouseListener(new SlideMouseAdapter());
            this.addMouseMotionListener(new SliderMouseMotionAdapter());
            this.setOpaque(false);
        }

        public int getWidthOfWidestLabel() {
            Dictionary dictionary = this.getLabelTable();
            int n = 0;
            if (dictionary != null) {
                Enumeration enumeration = dictionary.keys();
                while (enumeration.hasMoreElements()) {
                    JLabel jLabel = (JLabel)dictionary.get(enumeration.nextElement());
                    int n2 = SwingUtilities.computeStringWidth(jLabel.getFontMetrics(jLabel.getFont()), jLabel.getText());
                    n = Math.max(n2, n);
                }
            }
            return n;
        }

        public void paint(Graphics graphics) {
            Rectangle rectangle = this.getColoredRectangle();
            graphics.setColor(ColorsOptions.clrSliderSelection);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(ColorsOptions.clrSliderSelBorder);
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y);
            graphics.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            super.paint(graphics);
        }

        private Rectangle getColoredRectangle() {
            int n = this.getHeight() - this.OFFSET_Y - this.DELTA_Y - this.UPPER_Y * 2 - 1;
            double d = (double)n / (double)this.max;
            int n2 = (int)((double)(this.OFFSET_Y + this.UPPER_Y) + (double)this.getValue() * d);
            int n3 = (int)((double)(TimePicker.this.sldEndTime.getValue() - this.getValue()) * d);
            return new Rectangle(this.LEFT_X, n2, this.getWidth(), n3);
        }

        private class SlideMouseAdapter
        extends MouseAdapter {
            private SlideMouseAdapter() {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (LeftSlider.this.getColoredRectangle().contains(mouseEvent.getPoint())) {
                    return;
                }
                LeftSlider.this.originMouseListener.mouseClicked(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (LeftSlider.this.getColoredRectangle().contains(mouseEvent.getPoint())) {
                    LeftSlider.this.isDragging = true;
                    LeftSlider.this.rectHeigth = TimePicker.this.sldEndTime.getValue() - TimePicker.this.sldStartTime.getValue();
                    LeftSlider.this.dY = mouseEvent.getY() - ((LeftSlider)LeftSlider.this).getColoredRectangle().y;
                    return;
                }
                LeftSlider.this.originMouseListener.mousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                LeftSlider.this.isDragging = false;
                LeftSlider.this.originMouseListener.mouseReleased(mouseEvent);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                LeftSlider.this.originMouseListener.mouseEntered(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                LeftSlider.this.originMouseListener.mouseExited(mouseEvent);
            }
        }

        private class SliderMouseMotionAdapter
        extends MouseMotionAdapter {
            private SliderMouseMotionAdapter() {
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                if (LeftSlider.this.isDragging) {
                    int n = LeftSlider.this.getHeight() - LeftSlider.this.UPPER_Y * 2 - 1;
                    int n2 = mouseEvent.getY() - LeftSlider.this.UPPER_Y - LeftSlider.this.dY;
                    TimePicker.this.sldStartTime.setValue(LeftSlider.this.max * n2 / n);
                    TimePicker.this.sldStartTime.repaint();
                    TimePicker.this.sldEndTime.setValue(LeftSlider.this.max * n2 / n + LeftSlider.this.rectHeigth);
                    TimePicker.this.sldEndTime.repaint();
                }
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                if (LeftSlider.this.getColoredRectangle().contains(mouseEvent.getPoint())) {
                    LeftSlider.this.setCursor(new Cursor(8));
                } else {
                    LeftSlider.this.setCursor(new Cursor(0));
                }
            }
        }
    }

    private class DoAutoscrollAdapter
    extends MouseMotionAdapter {
        private DoAutoscrollAdapter() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Rectangle rectangle = new Rectangle(mouseEvent.getX(), mouseEvent.getY(), 1, 1);
            TimePicker.this.sliders.scrollRectToVisible(rectangle);
        }
    }

    private class EndTimeListener
    implements ChangeListener {
        private EndTimeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            int n = jSlider.getValue();
            int n2 = n * TimePicker.this.step;
            if (n2 == 1440) {
                n2 = 1439;
            }
            GregorianCalendar gregorianCalendar = GWCalendarUtils.getZero(TimePicker.this.startTime);
            gregorianCalendar.add(12, n2);
            TimePicker.this.endTime.setTime(gregorianCalendar.getTime());
            if (n < TimePicker.this.sldStartTime.getValue()) {
                TimePicker.this.sldStartTime.setValue(n);
            } else {
                TimePicker.this.refreshView(false);
            }
        }
    }

    private class StartTimeListener
    implements ChangeListener {
        private StartTimeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            int n = jSlider.getValue();
            int n2 = n * TimePicker.this.step;
            if (n2 == 1440) {
                n2 = 1439;
            }
            GregorianCalendar gregorianCalendar = GWCalendarUtils.getZero(TimePicker.this.startTime);
            gregorianCalendar.add(12, n2);
            TimePicker.this.startTime.setTime(gregorianCalendar.getTime());
            if (n > TimePicker.this.sldEndTime.getValue()) {
                TimePicker.this.sldEndTime.setValue(n);
            } else {
                TimePicker.this.refreshView(false);
            }
        }
    }
}

