/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.toolbars.ext;

import com.appframework.AppAction;
import com.appframework.components.GWBorder;
import com.appframework.components.customizedbutton.AbstractPopupPane;
import com.appframework.components.customizedbutton.ActionWithSepName;
import com.appframework.components.customizedbutton.ToolBarSeparator;
import com.appframework.components.customizedbutton.ToolBarToggleButton;
import com.appframework.components.multyactionlabel.CombinedCheckedIcon;
import com.appframework.resources.ImageResources;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.toolbars.ext.StoredComponent;
import com.novell.gw.jclient.application.controls.toolbars.ext.ToolBarUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.Logger;

public class SuperButton
extends JButton {
    private static Logger logger = Logger.getLogger((Class)(class$com$appframework$components$customizedbutton$AbstractPopupPane == null ? (class$com$appframework$components$customizedbutton$AbstractPopupPane = SuperButton.class$("com.appframework.components.customizedbutton.AbstractPopupPane")) : class$com$appframework$components$customizedbutton$AbstractPopupPane));
    public static final int STATE_UP = 1;
    public static final int STATE_NORMAL = 4;
    public static final int STATE_DOWN = 8;
    protected static final int BUTTON_LEFT_CLICKED = 12;
    protected static final int BUTTON_LEFT_PRESSED = 16;
    protected static final int BUTTON_RIGHT_PRESSED = 20;
    protected JPopupMenu popup = null;
    protected boolean isUnderMouse;
    protected boolean isPopupShowed;
    protected boolean isEnabled = true;
    protected DefaultActionPropertyListener propertyListener = new DefaultActionPropertyListener();
    private volatile ArrayList componentsList = new ArrayList();
    private static final Dimension SUPER_BUTTON_SIZE = new Dimension(14, 28);
    private final int MENU_ITEM_HEIGHT = 22;
    static /* synthetic */ Class class$com$appframework$components$customizedbutton$AbstractPopupPane;

    public SuperButton() {
        this.popup = new JPopupMenu();
        this.setOpaque(false);
        this.build();
    }

    protected void build() {
        this.setIcon(ImageResources.ARROW_MORE);
        this.setBorder(null);
        this.setFocusable(false);
        this.getModel().setArmed(false);
        this.setPreferredSize(SUPER_BUTTON_SIZE);
        this.setMinimumSize(SUPER_BUTTON_SIZE);
        this.setMaximumSize(SUPER_BUTTON_SIZE);
        this.addMouseListener(new RightButtonMouseListener());
    }

    protected void mouseEntered() {
        this.isUnderMouse = true;
        this.changeState(1);
    }

    protected void mouseExited() {
        this.isUnderMouse = false;
        this.changeState(4);
    }

    protected void changeState(int n) {
        if (!this.isPopupShowed && this.isEnabled) {
            if (n == 1 || n == 8) {
                this.updateBorder(n);
            } else if (n == 4) {
                this.updateBorder(n);
            }
        }
    }

    protected void restoreState() {
        if (this.isUnderMouse) {
            this.changeState(1);
        } else {
            this.changeState(4);
        }
    }

    public void addStored(StoredComponent storedComponent) {
        if (!this.containsStored(storedComponent.getComponent())) {
            this.componentsList.add(0, storedComponent);
        }
    }

    private ArrayList sortStoredByIndex() {
        StoredComponent[] storedComponentArray = new StoredComponent[this.componentsList.size()];
        this.componentsList.toArray(storedComponentArray);
        ArrayList<StoredComponent> arrayList = new ArrayList<StoredComponent>();
        for (int i = 0; i < storedComponentArray.length; ++i) {
            int n = -1;
            int n2 = -1;
            for (int j = 0; j < storedComponentArray.length; ++j) {
                StoredComponent storedComponent = storedComponentArray[j];
                if (storedComponent == null || storedComponent.getIndex() <= n2) continue;
                n2 = storedComponent.getIndex();
                n = j;
            }
            if (n < 0) continue;
            arrayList.add(0, storedComponentArray[n]);
            storedComponentArray[n] = null;
        }
        return arrayList;
    }

    protected void processEvent(int n) {
        if (this.isEnabled && n == 20) {
            logger.debug((Object)"process BUTTON_RIGHT_PRESSED");
            if (!this.isPopupShowed) {
                this.setBorder(GWBorder.LOWERED_BORDER);
                this.chooseAction();
            }
        }
    }

    private void chooseAction() {
        ArrayList arrayList = this.sortStoredByIndex();
        if (arrayList.size() > 0) {
            try {
                ToolBarUtils.doDisposeButtons(this.popup);
                this.popup.removeAll();
                this.popup.setBorderPainted(true);
                this.popup.setBorder(GWBorder.RAISED_BORDER);
                this.popup.addPopupMenuListener(new ActionsPopupListener());
                for (int i = 0; i < arrayList.size(); ++i) {
                    JMenuItem jMenuItem;
                    Object object;
                    JComponent jComponent;
                    StoredComponent storedComponent = (StoredComponent)arrayList.get(i);
                    Component component = storedComponent.getComponent();
                    if (component instanceof ToolBarSeparator) {
                        this.popup.addSeparator();
                        continue;
                    }
                    if (component instanceof JToolBar.Separator) {
                        this.popup.addSeparator();
                        continue;
                    }
                    if (component instanceof AbstractPopupPane) {
                        jComponent = (AbstractPopupPane)component;
                        object = ((AbstractPopupPane)jComponent).getActionsList();
                        if (object.size() <= 0) continue;
                        jMenuItem = new JMenu(((AbstractPopupPane)jComponent).getDisplayText());
                        ((JMenu)jMenuItem).setComponentOrientation(UIUtils.getComponentOrientation());
                        for (int j = 0; j < object.size(); ++j) {
                            ActionWithSepName actionWithSepName = (ActionWithSepName)object.get(j);
                            Action action = actionWithSepName.getAction();
                            if (action == null) {
                                ((JMenu)jMenuItem).addSeparator();
                                continue;
                            }
                            JMenuItem jMenuItem2 = OS.createMenuItemForAction(action);
                            jMenuItem2.setAccelerator(null);
                            this.defineSize(jMenuItem2);
                            ((JMenu)jMenuItem).add(jMenuItem2);
                        }
                        this.defineSize(jMenuItem);
                        this.popup.add(jMenuItem);
                        continue;
                    }
                    if (component instanceof JButton) {
                        jComponent = (JButton)component;
                        object = ((AbstractButton)jComponent).getAction();
                        if (object == null) {
                            throw new IllegalArgumentException("ExToolBar can not contain such component");
                        }
                        jMenuItem = OS.createMenuItemForAction((Action)object);
                        jMenuItem.setAccelerator(null);
                        this.defineSize(jMenuItem);
                        this.popup.add(jMenuItem);
                        continue;
                    }
                    if (component instanceof ToolBarToggleButton) {
                        jComponent = (ToolBarToggleButton)component;
                        object = ((AbstractButton)jComponent).getAction();
                        if (object == null) {
                            throw new IllegalArgumentException("ExToolBar can not contain such component");
                        }
                        jMenuItem = null;
                        if (object instanceof AppAction) {
                            jMenuItem = OS.createMenuItem((AppAction)object);
                        } else {
                            jMenuItem = OS.createMenuItemForAction((Action)object);
                            jMenuItem.setIcon(new CombinedCheckedIcon());
                        }
                        ButtonGroup buttonGroup = ((ToolBarToggleButton)jComponent).getGroup();
                        if (buttonGroup != null) {
                            buttonGroup.add(jMenuItem);
                        }
                        jMenuItem.setAccelerator(null);
                        this.defineSize(jMenuItem);
                        this.popup.add(jMenuItem);
                        continue;
                    }
                    throw new IllegalArgumentException("ExToolBar can not contain such component : " + component.getClass().getName());
                }
                this.popup.show(this, 0, this.getHeight());
                this.isPopupShowed = true;
            }
            catch (Exception exception) {
                logger.debug((Object)exception, (Throwable)exception);
                logger.error((Object)exception);
            }
        }
    }

    private void defineSize(JMenuItem jMenuItem) {
        Dimension dimension = new Dimension(jMenuItem.getPreferredSize().width, Math.max(jMenuItem.getPreferredSize().height, 22));
        jMenuItem.setMinimumSize(dimension);
        jMenuItem.setPreferredSize(dimension);
    }

    protected void updateBorder(int n) {
        switch (n) {
            case 1: {
                this.setBorder(GWBorder.RAISED_BORDER);
                break;
            }
            case 8: {
                this.setBorder(GWBorder.LOWERED_BORDER);
                break;
            }
            case 4: {
                this.setBorder(GWBorder.NO_BORDER);
            }
        }
    }

    public StoredComponent getLastStored() {
        if (this.componentsList.size() > 0) {
            return (StoredComponent)this.componentsList.get(0);
        }
        return null;
    }

    public void removeLastStored() {
        if (this.componentsList.size() > 0) {
            this.componentsList.remove(0);
        }
    }

    public int getStoredCount() {
        return this.componentsList.size();
    }

    public boolean containsStored(Component component) {
        for (int i = 0; i < this.componentsList.size(); ++i) {
            StoredComponent storedComponent = (StoredComponent)this.componentsList.get(i);
            if (component != storedComponent.getComponent()) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class ActionsPopupListener
    implements PopupMenuListener {
        protected ActionsPopupListener() {
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            SuperButton.this.isPopupShowed = false;
            SuperButton.this.isUnderMouse = false;
            SuperButton.this.restoreState();
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }
    }

    protected class RightButtonMouseListener
    implements MouseListener {
        protected RightButtonMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            SuperButton.this.mouseEntered();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            SuperButton.this.mouseExited();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                SuperButton.this.getModel().setArmed(false);
                SuperButton.this.processEvent(20);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                SuperButton.this.changeState(1);
            }
        }
    }

    protected class DefaultActionPropertyListener
    implements PropertyChangeListener {
        protected DefaultActionPropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("enabled")) {
                SuperButton.this.setEnabled(true);
                SuperButton.this.isPopupShowed = false;
                SuperButton.this.restoreState();
                SuperButton.this.isEnabled = true;
            }
        }
    }
}

