/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs;

import com.appframework.components.EmptyStringDocumentListener;
import com.novell.gw.jclient.application.actions.edit.text.ActionFindText;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.dialogs.FindTextConditions;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class FindTextDialog
extends GWDialog {
    public JTextField tfFindWhat = new OrientableTextField();
    private JCheckBox cbMatchWhole = new JMnemonicCheckBox(StringResources.MATCH_WHOLE_WORD_ONLY);
    private JCheckBox cbMatchCase = new JMnemonicCheckBox(StringResources.MATCH_CASE);
    private JRadioButton rbUp = new JMnemonicRadioButton(StringResources.UP);
    private JRadioButton rbDown = new JMnemonicRadioButton(StringResources.DOWN);
    private FindTextConditions findTextConditions = new FindTextConditions();
    private ActionFindText actionFindText;

    public FindTextDialog(JFrame jFrame) {
        super(jFrame, false);
        this.setTitle(StringResources.FIND);
        this.buildUI();
    }

    public FindTextDialog(JFrame jFrame, FindTextConditions findTextConditions, ActionFindText actionFindText) {
        this(jFrame);
        this.findTextConditions = findTextConditions;
        this.tfFindWhat.setText(this.findTextConditions.getSearchText());
        this.tfFindWhat.selectAll();
        this.cbMatchWhole.setSelected(this.findTextConditions.isMatchWholeWord());
        this.cbMatchCase.setSelected(this.findTextConditions.isMatchCase());
        if (this.findTextConditions.isUpDirection()) {
            this.rbUp.setSelected(true);
        } else {
            this.rbDown.setSelected(true);
        }
        this.actionFindText = actionFindText;
    }

    private void buildUI() {
        OrientablePanel orientablePanel = new OrientablePanel(new BorderLayout(0, 10));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbDown);
        buttonGroup.add(this.rbUp);
        this.rbDown.setSelected(true);
        OrientablePanel orientablePanel2 = new OrientablePanel();
        orientablePanel2.add(this.rbUp);
        orientablePanel2.add(this.rbDown);
        orientablePanel2.setBorder(BorderFactory.createTitledBorder(StringResources.DIRECTION));
        OrientablePanel orientablePanel3 = new OrientablePanel(new GridLayout(0, 1, 0, 10));
        orientablePanel3.add(this.cbMatchWhole);
        orientablePanel3.add(this.cbMatchCase);
        OrientablePanel orientablePanel4 = new OrientablePanel(new BorderLayout(10, 0));
        orientablePanel4.add((Component)new JMnemonicLabel(StringResources.FIND_WHAT_C, this.tfFindWhat), "Before");
        orientablePanel4.add((Component)this.tfFindWhat, "Center");
        orientablePanel.add((Component)orientablePanel2, "After");
        orientablePanel.add((Component)orientablePanel3, "Before");
        orientablePanel.add((Component)orientablePanel4, "North");
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.removeAll();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        jPanel.add((Component)orientablePanel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 24;
        jPanel.add((Component)this.buildButtonsPanel(), gridBagConstraints);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.setMinimumSize(jPanel.getPreferredSize());
    }

    private JPanel buildButtonsPanel() {
        OrientablePanel orientablePanel = new OrientablePanel(new GridLayout(0, 1, 0, 10));
        JMnemonicButton jMnemonicButton = new JMnemonicButton(new FindNextAction());
        this.tfFindWhat.getDocument().addDocumentListener(new EmptyStringDocumentListener(jMnemonicButton.getAction()));
        this.setDefaultButton(jMnemonicButton);
        orientablePanel.add(jMnemonicButton);
        orientablePanel.add(this.btnCancel);
        return orientablePanel;
    }

    public FindTextConditions getFindTextConditions() {
        this.findTextConditions.setMatchCase(this.cbMatchCase.isSelected());
        this.findTextConditions.setMatchWholeWord(this.cbMatchWhole.isSelected());
        this.findTextConditions.setSearchText(this.tfFindWhat.getText());
        this.findTextConditions.setUpDirection(this.rbUp.isSelected());
        return this.findTextConditions;
    }

    public boolean isMatchWholeWord() {
        return this.cbMatchWhole.isSelected();
    }

    public boolean isMatchCase() {
        return this.cbMatchCase.isSelected();
    }

    public boolean isUpDirection() {
        return this.rbUp.isSelected();
    }

    public String getSearchText() {
        return this.tfFindWhat.getText();
    }

    private class FindNextAction
    extends AbstractAction {
        public FindNextAction() {
            super(StringResources.FIND_NEXT);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FindTextDialog.this.actionFindText.setConditions(FindTextDialog.this.getFindTextConditions());
            FindTextDialog.this.actionFindText.performFindText();
        }
    }
}

