/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs;

import com.appframework.level.LevelManager;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.BasicDialog;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public abstract class GWDialog
extends BasicDialog
implements MVCView {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$dialogs$GWDialog == null ? (class$com$novell$gw$jclient$application$dialogs$GWDialog = GWDialog.class$("com.novell.gw.jclient.application.dialogs.GWDialog")) : class$com$novell$gw$jclient$application$dialogs$GWDialog));
    protected MVCController controller;
    protected JPanel panCenterPanel;
    protected JPanel panTopPanel;
    protected JPanel panLeftPanel;
    protected JPanel panRightPanel;
    protected JPanel panBottomPanel;
    protected JButton btnOK = new OrientableButton(StringResources.OK);
    protected JButton btnCancel = new OrientableButton();
    static /* synthetic */ Class class$com$novell$gw$jclient$application$dialogs$GWDialog;

    public GWDialog() {
        this.buildUI();
    }

    public GWDialog(JFrame jFrame) {
        this(jFrame, true);
    }

    public GWDialog(JFrame jFrame, boolean bl) {
        super((Frame)jFrame, bl);
        this.buildUI();
    }

    public GWDialog(JDialog jDialog) {
        this(jDialog, true);
    }

    public GWDialog(JDialog jDialog, boolean bl) {
        super((Dialog)jDialog, bl);
        this.buildUI();
    }

    public void showMe() {
        this.pack();
        UIUtils.centerWindowOnScreen(this);
        this.setVisible(true);
    }

    private void buildUI() {
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GWDialog.this.setActionCompleteSuccessfully(true);
                GWDialog.this.dispose();
            }
        });
        this.setDefaultButton(this.btnOK);
        this.btnCancel.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                GWDialog.disposeDialog(GWDialog.this);
            }
        });
        this.btnCancel.setText(StringResources.CANCEL);
        this.setCancelButton(this.btnCancel);
        this.addWindowListener(new GWDialogWindowAdapter());
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        jPanel.setComponentOrientation(UIUtils.getComponentOrientation());
        this.setComponentOrientation(UIUtils.getComponentOrientation());
        this.panCenterPanel = new OrientablePanel();
        this.panCenterPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.panCenterPanel, "Center");
        this.panTopPanel = new JPanel();
        this.panBottomPanel = new OrientablePanel();
        this.panLeftPanel = new JPanel();
        this.panRightPanel = new JPanel();
        this.panCenterPanel.add((Component)this.panTopPanel, "North");
        this.panCenterPanel.add((Component)this.panBottomPanel, "South");
        this.panCenterPanel.add((Component)this.panLeftPanel, "Before");
        this.panCenterPanel.add((Component)this.panRightPanel, "After");
    }

    public void setDefaultCancelAction(Action action) {
        this.getRootPane().getInputMap().put(KeyStroke.getKeyStroke(27, 0), action);
        this.getRootPane().getActionMap().put(action, action);
    }

    public static void disposeDialog(GWDialog gWDialog) {
        if (gWDialog != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                gWDialog.dispose();
            } else {
                try {
                    SwingUtilities.invokeAndWait(new RunDisposeDialog(gWDialog));
                }
                catch (Exception exception) {
                    logger.error((Object)exception);
                    logger.debug((Object)exception, (Throwable)exception);
                }
            }
        }
    }

    public void dispose() {
        if (this.getController() != null) {
            LevelManager.getInstance().release(this.getController().getLevel());
        }
        super.dispose();
    }

    public void setController(MVCController mVCController) {
        this.controller = mVCController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object object) {
    }

    public Object getMVCModel() {
        return null;
    }

    protected void handleClose() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class GWDialogWindowAdapter
    extends WindowAdapter {
        GWDialogWindowAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            super.windowClosing(windowEvent);
            if (GWDialog.this.getParent() != null) {
                GWDialog.this.getParent().setEnabled(true);
            }
            GWDialog.disposeDialog(GWDialog.this);
        }

        public void windowClosed(WindowEvent windowEvent) {
            super.windowClosed(windowEvent);
            GWDialog.this.handleClose();
        }
    }

    public static class CancelDialogAction
    extends AbstractAction {
        private GWDialog gwDialog;

        public CancelDialogAction(GWDialog gWDialog) {
            this(StringResources.CANCEL, gWDialog);
        }

        public CancelDialogAction(String string, GWDialog gWDialog) {
            super(string);
            this.gwDialog = gWDialog;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GWDialog.disposeDialog(this.gwDialog);
        }
    }

    private static class RunDisposeDialog
    implements Runnable {
        private GWDialog gwDialog;

        public RunDisposeDialog(GWDialog gWDialog) {
            this.gwDialog = gWDialog;
        }

        public void run() {
            this.gwDialog.dispose();
        }
    }
}

