/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.backup;

import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class BackupProgressDialog
extends JDialog {
    private JLabel lbProgress = new OrientableLabel(" ");
    private JProgressBar pbBackup = new JProgressBar();
    private JButton btnCancel = new OrientableButton(new CancelAction());
    private boolean cancelPressed = false;
    private Object syncObject = new Object();

    public BackupProgressDialog() {
        this.setTitle(StringResources.GROUPWISE_MAILBOX_BACKUP);
        this.buildUI();
    }

    private void buildUI() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.removeAll();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)new OrientableLabel(StringResources.MAILBOX_BACKUP_IN_PROGRESS_D), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.lbProgress, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.pbBackup, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 11;
        jPanel.add((Component)this.btnCancel, gridBagConstraints);
        this.pack();
        this.setDefaultCloseOperation(0);
    }

    public void setProgressString(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doSetProgressString(string);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BackupProgressDialog.this.doSetProgressString(string);
                }
            });
        }
    }

    private void doSetProgressString(String string) {
        this.lbProgress.setText(string);
    }

    public void setProgress(final int n) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doSetProgress(n);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BackupProgressDialog.this.doSetProgress(n);
                }
            });
        }
    }

    private void doSetProgress(int n) {
        this.pbBackup.setValue(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCancelPressed(boolean bl) {
        Object object = this.syncObject;
        synchronized (object) {
            this.cancelPressed = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCancelPressed() {
        Object object = this.syncObject;
        synchronized (object) {
            return this.cancelPressed;
        }
    }

    public void showMe() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doShowMe();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BackupProgressDialog.this.doShowMe();
                }
            });
        }
    }

    private void doShowMe() {
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public void hideMe() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setVisible(false);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BackupProgressDialog.this.setVisible(false);
                }
            });
        }
    }

    public static void main(String[] stringArray) {
        StringResources.initTestStringResources();
        BackupProgressDialog backupProgressDialog = new BackupProgressDialog();
        backupProgressDialog.setDefaultCloseOperation(3);
        backupProgressDialog.showMe();
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(StringResources.CANCEL);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BackupProgressDialog.this.setCancelPressed(true);
            BackupProgressDialog.this.setVisible(false);
        }
    }
}

