/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.folderproperties;

import com.appframework.components.ComponentBorder;
import com.appframework.mvc.MVCController;
import com.novell.gw.folder.FolderSharedList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButton;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.dialogs.folderproperties.SharingPropertyPane;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class FPSharingPane
extends SharingPropertyPane {
    private JRadioButton rbNotShare = new OrientableRadioButton(new UnShareAction());
    private JRadioButton rbShare = new OrientableRadioButton(new ShareWithAction());

    public FPSharingPane(GWDialog gWDialog, MVCController mVCController, AbstractFolder abstractFolder) {
        super(gWDialog, mVCController, abstractFolder);
        this.init();
    }

    public FPSharingPane(GWDialog gWDialog, MVCController mVCController) {
        super(gWDialog, mVCController);
        this.init();
    }

    private void init() {
        GridBagConstraints gridBagConstraints;
        this.add((Component)this.buildTopPane(), "North");
        this.enableShareControls(false);
        this.rbNotShare.setSelected(true);
        if (this.folder != null) {
            if (this.folder.getNativeFolder().isSharedFolder()) {
                this.enableShareControls(true);
                this.rbShare.setSelected(true);
            }
            if (this.folder.getNativeFolder().isSharedFolderReference()) {
                this.isReadOnly = true;
                this.rbShare.setSelected(true);
                this.rbShare.setEnabled(false);
                this.rbNotShare.setEnabled(false);
            }
            if (this.folder.getNativeFolder().isSharedFolder() || this.folder.getNativeFolder().isSharedFolderReference()) {
                gridBagConstraints = this.folder.getNativeFolder().getSharedList();
                if (gridBagConstraints == null) {
                    gridBagConstraints = new FolderSharedList();
                }
                this.tableContactList.setMVCModel(gridBagConstraints);
            }
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridy = 1;
        this.pnlBottom.add((Component)this.rbShare, gridBagConstraints);
        ComponentBorder componentBorder = new ComponentBorder(this.rbShare);
        this.pnlBottom.setBorder(BorderFactory.createCompoundBorder(componentBorder, BorderFactory.createEmptyBorder(0, 10, 10, 10)));
        this.setBorder(BorderFactory.createEmptyBorder(0, 15, 10, 15));
    }

    public boolean isFolderShared() {
        return this.rbShare.isSelected();
    }

    protected JPanel buildTopPane() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbNotShare);
        buttonGroup.add(this.rbShare);
        this.rbShare.setSelected(true);
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        orientablePanel.add((Component)this.rbNotShare, gridBagConstraints);
        return orientablePanel;
    }

    protected class UnShareAction
    extends AbstractAction {
        public UnShareAction() {
            super(StringResources.NOT_SHARED);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FPSharingPane.this.enableShareControls(false);
        }
    }

    private class ShareWithAction
    extends AbstractAction {
        public ShareWithAction() {
            super(StringResources.SHARED_WITH);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FPSharingPane.this.enableShareControls(true);
        }
    }
}

