/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.folderproperties;

import com.appframework.ApplicationFrame;
import com.appframework.cache.IDObjectsCollection;
import com.appframework.cache.IdentifiedObject;
import com.appframework.components.GWTextArea;
import com.appframework.mvc.Command;
import com.appframework.mvc.GlobalCommand;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.engine.DisplaySettings;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.GridBagAdapter;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTabbedPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.dialogs.folderproperties.ColumnsDialog;
import com.novell.gw.jclient.application.dialogs.folderproperties.FPSharingPane;
import com.novell.gw.jclient.application.dialogs.folderproperties.FolderPropertiesDialogController;
import com.novell.gw.jclient.application.dialogs.folderproperties.SettingsNamePane;
import com.novell.gw.jclient.application.dialogs.folderproperties.SharingPropertyPane;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.eng_impl.utils.APIUtils;
import com.novell.gw.jclient.bl.eng_impl.utils.ColumnInfo;
import com.novell.gw.jclient.bl.eng_impl.utils.ColumnInfos;
import com.novell.gw.jclient.bl.eng_impl.utils.FolderDisplaySettings;
import com.novell.gw.jclient.bl.eng_impl.utils.SortOrder;
import com.novell.gw.jclient.bl.eng_impl.utils.ViewType;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.directory.PersonalAddressBook;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.ContactsFolder;
import com.novell.gw.jclient.bl.om.folders.QueryFolder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class FolderPropertiesDialog
extends GWDialog {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$dialogs$folderproperties$FolderPropertiesDialog == null ? (class$com$novell$gw$jclient$application$dialogs$folderproperties$FolderPropertiesDialog = FolderPropertiesDialog.class$("com.novell.gw.jclient.application.dialogs.folderproperties.FolderPropertiesDialog")) : class$com$novell$gw$jclient$application$dialogs$folderproperties$FolderPropertiesDialog));
    private JButton btnOK = new JButton(new OkAction());
    private JButton btnCancel = new JButton(new CancelAction());
    private FPSharingPane pnlSharingProperty;
    private JTabbedPane tabProperties = new OrientableTabbedPane();
    private JCheckBox chkAutoselect;
    private JTextArea taDescription;
    private JComboBox cbAddressBooks;
    private JButton btnDeleteSettings;
    private JButton btnSaveSetingsAs;
    private JButton btnEditColumns;
    private JTextArea taSettingsDescription;
    private JTextArea columnsArea = new GWTextArea(4, 10);
    private JComboBox cbSortColumn;
    private JComboBox cbSortOrder;
    private JComboBox cbDisplaySettings;
    private JComboBox cbViewBy;
    private JCheckBox chkItemTypeMail;
    private JCheckBox chkItemTypeNotes;
    private JCheckBox chkItemTypeAppointments;
    private JCheckBox chkItemTypePhoneMessage;
    private JCheckBox chkItemTypeTasks;
    private JCheckBox chkItemTypeDocuments;
    private JCheckBox chkContactTypePerson;
    private JCheckBox chkContactTypeResource;
    private JCheckBox chkContactTypeGroup;
    private JCheckBox chkContactTypeOrganization;
    private JCheckBox chkReceived;
    private JCheckBox chkPosted;
    private JCheckBox chkSent;
    private JCheckBox chkDraft;
    private JCheckBox chkHideNonCheckListItems;
    private JCheckBox chkOverrideQV;
    private JCheckBox chkShowQV;
    private AbstractFolder folder;
    private FolderDisplaySettings currentSettings;
    private FolderDisplaySettings displaySettings;
    private ColumnInfos columnInfos;
    private List allDisplaySettings;
    private ColumnInfos allColumnInfos;
    private boolean reloadingSettings = false;
    private boolean settingsChanged = false;
    private String userGuid;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$dialogs$folderproperties$FolderPropertiesDialog;

    public FolderPropertiesDialog(ApplicationFrame applicationFrame, AbstractFolder abstractFolder) {
        super(applicationFrame);
        this.folder = abstractFolder;
        this.displaySettings = this.currentSettings = this.folder.getFolderDisplaySettings();
        this.columnInfos = this.currentSettings.getColumnInfos();
        this.setController(new FolderPropertiesDialogController(this, applicationFrame.getController()));
        this.userGuid = applicationFrame.getUserGuid();
        this.initSystemDisplaySettings();
        this.initAllColumnsInfo();
        this.buildUI();
        this.setModal(true);
        this.setDisplayPropertiesToUI();
    }

    public void selectSharingProperties() {
        this.tabProperties.setSelectedComponent(this.pnlSharingProperty);
    }

    private void buildUI() {
        this.setTitle(StringResources.PROPERTIES_C);
        this.tabProperties.addTab(StringResources.GENERAL, this.buildGeneralPane());
        this.tabProperties.addTab(StringResources.DISPLAY, this.buildDisplayPane());
        if (this.folder.canShare()) {
            this.pnlSharingProperty = new FPSharingPane(this, this.getController(), this.folder);
            this.tabProperties.addTab(StringResources.SHARING, this.pnlSharingProperty);
        }
        this.tabProperties.addChangeListener(new TabChangeListener());
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.add((Component)this.tabProperties, "Center");
        OrientablePanel orientablePanel = new OrientablePanel();
        OS.addButtons(orientablePanel, this.btnOK, this.btnCancel);
        jPanel.add((Component)orientablePanel, "South");
        this.setDefaultButton(this.btnOK);
        this.setCancelButton(this.btnCancel);
        this.pack();
    }

    public void showMe() {
        UIUtils.centerWindowOnScreen(this);
        this.setVisible(true);
    }

    private JComponent createTextField(String string) {
        OrientableTextField orientableTextField = new OrientableTextField(string);
        orientableTextField.setBorder(null);
        ((JTextComponent)orientableTextField).setEditable(false);
        orientableTextField.setCaretPosition(0);
        return orientableTextField;
    }

    private JPanel buildDisplayPane() {
        OrientablePanel orientablePanel = new OrientablePanel();
        orientablePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        orientablePanel.setLayout(new BorderLayout());
        JPanel jPanel = this.buildDisplayLeft();
        orientablePanel.add((Component)jPanel, "Center");
        JPanel jPanel2 = this.buildDisplayRight();
        orientablePanel.add((Component)jPanel2, "After");
        return orientablePanel;
    }

    private JPanel buildDisplayRight() {
        this.columnsArea.setEditable(false);
        this.cbViewBy = new ChangableComboBox(APIUtils.getViewTypes(this.folder));
        this.cbSortColumn = new ChangableComboBox(this.allColumnInfos.toArray());
        this.cbSortOrder = new ChangableComboBox(APIUtils.getSortOrders());
        this.btnSaveSetingsAs = new OrientableButton(new SaveAsAction());
        this.btnDeleteSettings = new OrientableButton(new DeleteAction());
        this.btnEditColumns = new OrientableButton(StringResources.EDIT_COLUMNS_D);
        OrientablePanel orientablePanel = new OrientablePanel();
        orientablePanel.setLayout(new GridBagLayout());
        GridBagAdapter gridBagAdapter = new GridBagAdapter(orientablePanel);
        gridBagAdapter.setColumnCount(1);
        gridBagAdapter.setResizableColumn(1);
        gridBagAdapter.setDefaultInsets(new Insets(0, 0, 5, 0));
        gridBagAdapter.setAnchor(21);
        gridBagAdapter.setFill(0);
        gridBagAdapter.addComponent(new OrientableLabel(" "));
        OrientablePanel orientablePanel2 = new OrientablePanel(new GridLayout(1, 2));
        orientablePanel2.add(this.btnSaveSetingsAs);
        orientablePanel2.add(this.btnDeleteSettings);
        gridBagAdapter.addComponent(orientablePanel2);
        gridBagAdapter.addComponent(new OrientableLabel(StringResources.VIEW_BY_C));
        gridBagAdapter.addComponent(this.cbViewBy);
        gridBagAdapter.addComponent(new OrientableLabel(StringResources.SORT_BY_C));
        gridBagAdapter.addComponent(this.cbSortColumn);
        gridBagAdapter.addComponent(new OrientableLabel(StringResources.SORT_ORDER_C));
        gridBagAdapter.addComponent(this.cbSortOrder);
        gridBagAdapter.addComponent(new OrientableLabel(StringResources.COLUMNS_C));
        gridBagAdapter.addComponent(new OrientableScrollPane(this.columnsArea));
        gridBagAdapter.setWidthY(1);
        gridBagAdapter.setFill(0);
        gridBagAdapter.setAnchor(24);
        gridBagAdapter.addComponent(this.btnEditColumns);
        this.btnEditColumns.addActionListener(new EditColumnActionListener());
        gridBagAdapter.setWidthY(1);
        gridBagAdapter.addComponent(new OrientableLabel(" "));
        return orientablePanel;
    }

    private JPanel buildDisplayLeft() {
        this.cbDisplaySettings = new OrientableComboBox();
        this.cbDisplaySettings.setRenderer(new DisplaySettingsRenderer());
        this.loadDisplaySettingComboBoxInfo();
        this.cbDisplaySettings.addItemListener(new ChangeSettingsActionListener());
        this.taSettingsDescription = new ChangableTextArea();
        OrientablePanel orientablePanel = new OrientablePanel();
        orientablePanel.setLayout(new GridBagLayout());
        GridBagAdapter gridBagAdapter = new GridBagAdapter(orientablePanel);
        gridBagAdapter.setColumnCount(1);
        gridBagAdapter.setWidthX(100);
        gridBagAdapter.setDefaultInsets(new Insets(0, 0, 5, 10));
        gridBagAdapter.setAnchor(21);
        gridBagAdapter.setFill(1);
        gridBagAdapter.addComponent(new OrientableLabel(StringResources.SETTING_NAME_C));
        gridBagAdapter.addComponent(this.cbDisplaySettings);
        gridBagAdapter.addComponent(new OrientableLabel(StringResources.DESCRIPTION_C));
        gridBagAdapter.setWidthY(3);
        gridBagAdapter.addComponent(new OrientableScrollPane(this.taSettingsDescription));
        gridBagAdapter.setWidthY(1);
        if (this.folder instanceof ContactsFolder) {
            gridBagAdapter.addComponent(this.buildContactTypePanel());
        } else {
            gridBagAdapter.addComponent(this.buildItemSourcePanel());
            gridBagAdapter.addComponent(this.buildItemTypePanel());
        }
        gridBagAdapter.addComponent(this.buildQuickViewerCheckBoxesPanel());
        return orientablePanel;
    }

    private JPanel buildItemSourcePanel() {
        this.chkReceived = new ChangableCheckBox(StringResources.RECEIVED);
        this.chkPosted = new ChangableCheckBox(StringResources.POSTED);
        this.chkSent = new ChangableCheckBox(StringResources.SENT);
        this.chkDraft = new ChangableCheckBox(StringResources.DRAFT);
        OrientablePanel orientablePanel = new OrientablePanel(new GridLayout(2, 2));
        orientablePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), StringResources.ITEM_SOURCE_C));
        orientablePanel.add(this.chkReceived);
        orientablePanel.add(this.chkPosted);
        orientablePanel.add(this.chkSent);
        orientablePanel.add(this.chkDraft);
        return orientablePanel;
    }

    private JPanel buildItemTypePanel() {
        this.chkItemTypeMail = new ChangableCheckBox(StringResources.MAIL);
        this.chkItemTypeNotes = new ChangableCheckBox(StringResources.REMINDER_NOTES);
        this.chkItemTypeAppointments = new ChangableCheckBox(StringResources.APPOINTMENTS);
        this.chkItemTypePhoneMessage = new ChangableCheckBox(StringResources.PHONE_MESSAGES);
        this.chkItemTypeTasks = new ChangableCheckBox(StringResources.TASKS);
        this.chkItemTypeDocuments = new ChangableCheckBox(StringResources.DOCUMENTS);
        OrientablePanel orientablePanel = new OrientablePanel(new GridLayout(3, 2));
        orientablePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), StringResources.ITEM_TYPE_C));
        orientablePanel.add(this.chkItemTypeMail);
        orientablePanel.add(this.chkItemTypeNotes);
        orientablePanel.add(this.chkItemTypeAppointments);
        orientablePanel.add(this.chkItemTypePhoneMessage);
        orientablePanel.add(this.chkItemTypeTasks);
        orientablePanel.add(this.chkItemTypeDocuments);
        return orientablePanel;
    }

    private JPanel buildContactTypePanel() {
        this.chkContactTypePerson = new ChangableCheckBox(StringResources.PERSON);
        this.chkContactTypeResource = new ChangableCheckBox(StringResources.RESOURCE);
        this.chkContactTypeGroup = new ChangableCheckBox(StringResources.GROUP);
        this.chkContactTypeOrganization = new ChangableCheckBox(StringResources.ORGANIZATION);
        OrientablePanel orientablePanel = new OrientablePanel(new GridLayout(2, 2));
        orientablePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), StringResources.CONTACT_TYPE_C));
        orientablePanel.add(this.chkContactTypePerson);
        orientablePanel.add(this.chkContactTypeResource);
        orientablePanel.add(this.chkContactTypeGroup);
        orientablePanel.add(this.chkContactTypeOrganization);
        return orientablePanel;
    }

    private JPanel buildQuickViewerCheckBoxesPanel() {
        this.chkHideNonCheckListItems = new ChangableCheckBox(StringResources.HIDE_NONCHECKLIST_ITEMS);
        this.chkOverrideQV = new ChangableCheckBox(StringResources.OVERRIDE_QUICKVIEWER_VISIBILITY);
        this.chkShowQV = new ChangableCheckBox(StringResources.SHOW_QUICKVIEWER);
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 0;
        return orientablePanel;
    }

    private JPanel buildGeneralPane() {
        int n;
        Object object;
        OrientablePanel orientablePanel = new OrientablePanel();
        orientablePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        orientablePanel.setLayout(new GridBagLayout());
        GridBagAdapter gridBagAdapter = new GridBagAdapter(orientablePanel);
        gridBagAdapter.setColumnCount(2);
        gridBagAdapter.setResizableColumn(1);
        gridBagAdapter.setAnchor(21);
        gridBagAdapter.setFill(0);
        gridBagAdapter.addComponent(new JLabel(ControlsUtils.getImageForFolder(this.folder)));
        gridBagAdapter.addComponent(this.createTextField(this.folder.getName()));
        gridBagAdapter.setGridWidth(2);
        gridBagAdapter.addComponent(new JSeparator());
        gridBagAdapter.addComponent(new OrientableLabel(StringResources.TYPE_C));
        gridBagAdapter.addComponent(new OrientableLabel(this.folder.getTypeString()));
        gridBagAdapter.addComponent(new OrientableLabel(StringResources.OWNER_C));
        gridBagAdapter.addComponent(new OrientableLabel(this.folder.getNativeFolder().getOwnerName()));
        if (!(this.folder instanceof QueryFolder)) {
            gridBagAdapter.addComponent(new OrientableLabel(StringResources.CONTAINS_C));
            object = this.folder.getCountOFContents();
            int n2 = object.getReceivedCount();
            n = object.getSentCount();
            int n3 = object.getPostedCount();
            int n4 = object.getDraftCount();
            int n5 = object.getChildFoldersCount();
            int n6 = n2 + n + n3 + n4 + n5;
            String string = n6 > 0 ? (!(this.folder instanceof ContactsFolder) ? n2 + " " + StringResources.RECEIVED_ITEMS + ", " + n + " " + StringResources.SENT_ITEMS + ", " + n3 + " " + StringResources.POSTED_ITEMS + ", " + n4 + " " + StringResources.DRAFT_ITEMS + (this.folder.canHaveChildren() ? ", " + n5 + " " + StringResources.FOLDERS : "") : n2 + " " + StringResources.CONTACTS + ", " + n + " " + StringResources.GROUPS + ", " + n3 + " " + StringResources.RESOURCES + ", " + n4 + " " + StringResources.ORGANIZATIONS) : StringResources.FOLDER_IS_EMPTY;
            GWTextArea gWTextArea = new GWTextArea();
            ((JTextComponent)gWTextArea).setEditable(false);
            gWTextArea.setOpaque(false);
            ((JTextComponent)gWTextArea).setText(string);
            gridBagAdapter.addComponent(gWTextArea);
        }
        if (this.folder.getNativeFolder().canSelectFirstUnreadPropertyOption()) {
            gridBagAdapter.addComponent(new JLabel(""));
            this.chkAutoselect = new OrientableCheckBox(StringResources.SELECT_UNREAD_ITEM_WHEN_FOLDER_IS_OPENED);
            this.chkAutoselect.setSelected(this.folder.isSelectFirstUnreadItemState());
            gridBagAdapter.addComponent(this.chkAutoselect);
            gridBagAdapter.addComponent(new JLabel(""));
            object = new GWTextArea();
            ((JTextComponent)object).setEditable(false);
            ((JComponent)object).setOpaque(false);
            ((JTextComponent)object).setText(StringResources.SELECT_UNREAD_ITEM_DESCRIPTION);
            gridBagAdapter.addComponent((Component)object);
        }
        if (this.folder instanceof ContactsFolder) {
            object = null;
            object = EngineCommandManager.getDirectories();
            ArrayList<IdentifiedObject> arrayList = new ArrayList<IdentifiedObject>(((IDObjectsCollection)object).size() - 1);
            for (n = 0; n < ((IDObjectsCollection)object).size(); ++n) {
                if (!(((IDObjectsCollection)object).getIDObjectAt(n) instanceof PersonalAddressBook)) continue;
                arrayList.add(((IDObjectsCollection)object).getIDObjectAt(n));
            }
            this.cbAddressBooks = new OrientableComboBox(arrayList.toArray());
            gridBagAdapter.setGridWidth(2);
            gridBagAdapter.addComponent(new OrientableLabel(StringResources.ADDRESS_BOOK_C));
            this.cbAddressBooks.setSelectedItem(EngineCommandManager.getContactsFolderAddressBook());
            gridBagAdapter.setGridWidth(2);
            gridBagAdapter.addComponent(this.cbAddressBooks);
        }
        gridBagAdapter.setGridWidth(2);
        gridBagAdapter.addComponent(new JSeparator());
        gridBagAdapter.setGridWidth(1);
        gridBagAdapter.addComponent(new JLabel(StringResources.DESCRIPTION_C));
        gridBagAdapter.addComponent(new JLabel(""));
        this.taDescription = new GWTextArea();
        this.taDescription.setText(this.folder.getDescription());
        object = new OrientableScrollPane(this.taDescription);
        gridBagAdapter.setGridHeight(0);
        gridBagAdapter.setGridWidth(0);
        gridBagAdapter.setWidthX(3);
        gridBagAdapter.setWidthY(3);
        gridBagAdapter.addComponent((Component)object);
        gridBagAdapter.setWidthY(100);
        gridBagAdapter.addComponent(new JLabel());
        return orientablePanel;
    }

    private void setDisplayPropertiesToUI() {
        this.setReloadingSettings();
        this.cbDisplaySettings.setSelectedItem(this.displaySettings);
        this.taSettingsDescription.setText(this.displaySettings.getDescription());
        if (this.folder instanceof ContactsFolder) {
            this.chkContactTypePerson.setSelected((this.displaySettings.getContactType() & 1) == 1);
            this.chkContactTypeResource.setSelected((this.displaySettings.getContactType() & 4) == 4);
            this.chkContactTypeGroup.setSelected((this.displaySettings.getContactType() & 2) == 2);
            this.chkContactTypeOrganization.setSelected((this.displaySettings.getContactType() & 8) == 8);
        } else {
            this.chkReceived.setSelected((this.displaySettings.getBoxType() & 1) == 1);
            this.chkPosted.setSelected((this.displaySettings.getBoxType() & 4) == 4);
            this.chkSent.setSelected((this.displaySettings.getBoxType() & 2) == 2);
            this.chkDraft.setSelected((this.displaySettings.getBoxType() & 8) == 8);
            this.chkItemTypeMail.setSelected((this.displaySettings.getItemType() & 1) == 1);
            this.chkItemTypeNotes.setSelected((this.displaySettings.getItemType() & 2) == 2);
            this.chkItemTypeAppointments.setSelected((this.displaySettings.getItemType() & 8) == 8);
            this.chkItemTypePhoneMessage.setSelected((this.displaySettings.getItemType() & 0x10) == 16);
            this.chkItemTypeTasks.setSelected((this.displaySettings.getItemType() & 4) == 4);
            this.chkItemTypeDocuments.setSelected((this.displaySettings.getItemType() & 0x4000) == 16384);
        }
        this.cbViewBy.setSelectedItem(APIUtils.getViewType(this.displaySettings.getViewMode()));
        this.refreshSortColumnAndOption();
        this.refreshColumnInfos();
        this.chkHideNonCheckListItems.setSelected(this.displaySettings.isHideNonChecklist());
        this.chkOverrideQV.setSelected(this.displaySettings.isQuickViewerApplyPerFolder());
        this.chkShowQV.setSelected(this.displaySettings.isQuickViewerVisible());
        this.clearReloadingSettings();
        this.clearSettingsChanged();
    }

    private int getItemTypeFromUI() {
        int n = 0;
        n = this.chkItemTypeMail.isSelected() ? n | 1 : n;
        n = this.chkItemTypeNotes.isSelected() ? n | 2 : n;
        n = this.chkItemTypeAppointments.isSelected() ? n | 8 : n;
        n = this.chkItemTypePhoneMessage.isSelected() ? n | 0x10 : n;
        n = this.chkItemTypeTasks.isSelected() ? n | 4 : n;
        n = this.chkItemTypeDocuments.isSelected() ? n | 0x4000 : n;
        return n;
    }

    private int getContactTypeFromUI() {
        int n = 0;
        n = this.chkContactTypePerson.isSelected() ? n | 1 : n;
        n = this.chkContactTypeResource.isSelected() ? n | 4 : n;
        n = this.chkContactTypeGroup.isSelected() ? n | 2 : n;
        n = this.chkContactTypeOrganization.isSelected() ? n | 8 : n;
        return n;
    }

    private int getBoxTypeFromUI() {
        int n = 0;
        n = this.chkReceived.isSelected() ? n | 1 : n;
        n = this.chkPosted.isSelected() ? n | 4 : n;
        n = this.chkSent.isSelected() ? n | 2 : n;
        n = this.chkDraft.isSelected() ? n | 8 : n;
        return n;
    }

    private int getViewModeFromUI() {
        return ((ViewType)this.cbViewBy.getSelectedItem()).getID();
    }

    private void initSystemDisplaySettings() {
        this.allDisplaySettings = new ArrayList();
        DisplaySettings displaySettings = this.folder.getNativeFolder().getCustomDisplaySettings();
        if (displaySettings != null) {
            this.allDisplaySettings.add(new FolderDisplaySettings(displaySettings));
        }
        Enumeration enumeration = GWCommandManager.getInstance(this.userGuid).getDisplaySettingsEnumeration(this.folder instanceof ContactsFolder ? 1 : 0);
        while (enumeration.hasMoreElements()) {
            FolderDisplaySettings folderDisplaySettings = new FolderDisplaySettings((DisplaySettings)enumeration.nextElement());
            this.allDisplaySettings.add(folderDisplaySettings);
        }
        logger.debug((Object)"");
    }

    private void initAllColumnsInfo() {
        boolean bl = this.folder.getType() == "Contacts";
        this.allColumnInfos = new ColumnInfos(GWCommandManager.getInstance(this.userGuid).getCurrentDataStore().getDisplayColumnFields(bl));
    }

    private void loadDisplaySettingComboBoxInfo() {
        this.setReloadingSettings();
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.cbDisplaySettings.getModel();
        defaultComboBoxModel.removeAllElements();
        for (int i = 0; i < this.allDisplaySettings.size(); ++i) {
            defaultComboBoxModel.addElement(this.allDisplaySettings.get(i));
        }
        this.clearReloadingSettings();
    }

    private boolean isReloadingSettings() {
        return this.reloadingSettings;
    }

    private void setReloadingSettings() {
        this.reloadingSettings = true;
    }

    private void clearReloadingSettings() {
        this.reloadingSettings = false;
    }

    private void refreshColumnInfos() {
        this.columnsArea.setText(this.columnInfos.getColumnsListAsString());
    }

    private void refreshSortColumnAndOption() {
        ColumnInfo columnInfo = this.columnInfos.getSorted();
        if (columnInfo != null) {
            for (int i = 0; i < this.cbSortColumn.getModel().getSize(); ++i) {
                ColumnInfo columnInfo2 = (ColumnInfo)this.cbSortColumn.getModel().getElementAt(i);
                if (!columnInfo.getName().equals(columnInfo2.getName())) continue;
                this.cbSortColumn.setSelectedItem(columnInfo2);
            }
            this.cbSortOrder.setSelectedItem(columnInfo.getSortOrder());
        } else {
            logger.warn((Object)"Sorting column is not defined.");
        }
    }

    public boolean isSettingsChanged() {
        return this.settingsChanged;
    }

    public void setSettingsChanged() {
        if (!this.isReloadingSettings() && !this.settingsChanged) {
            this.settingsChanged = true;
            this.cbDisplaySettings.setSelectedItem(null);
        }
    }

    private void clearSettingsChanged() {
        this.settingsChanged = false;
    }

    public FolderDisplaySettings findDisplaySettings(String string) {
        for (int i = 0; i < this.allDisplaySettings.size(); ++i) {
            FolderDisplaySettings folderDisplaySettings = (FolderDisplaySettings)this.allDisplaySettings.get(i);
            if (!folderDisplaySettings.getName().equals(string)) continue;
            return folderDisplaySettings;
        }
        return null;
    }

    private void updateSettingsInfo(FolderDisplaySettings folderDisplaySettings, String string, int n, int n2, int n3, ColumnInfos columnInfos, boolean bl, boolean bl2, boolean bl3) {
        folderDisplaySettings.setDescription(string);
        folderDisplaySettings.setItemType(n);
        folderDisplaySettings.setBoxType(n2);
        folderDisplaySettings.setViewMode(n3);
        folderDisplaySettings.setColumnInfos(columnInfos);
        this.doUpdateSettings(folderDisplaySettings);
    }

    private void updateSettingsInfo(FolderDisplaySettings folderDisplaySettings, String string, int n, ColumnInfos columnInfos, boolean bl, boolean bl2, boolean bl3) {
        folderDisplaySettings.setDescription(string);
        folderDisplaySettings.setContactType(n);
        folderDisplaySettings.setColumnInfos(columnInfos);
        this.doUpdateSettings(folderDisplaySettings);
    }

    private void doUpdateSettings(FolderDisplaySettings folderDisplaySettings) {
        this.displaySettings = folderDisplaySettings;
        this.columnInfos = this.displaySettings.getColumnInfos();
        this.setDisplayPropertiesToUI();
        if (this.displaySettings.equals(this.currentSettings)) {
            this.fireFolderSettingsChanged();
        }
    }

    private void fireFolderSettingsChanged() {
        GWClient.getApplication().processCommand(new GlobalCommand(1010, this.folder));
        GWClient.getApplication().processCommand(new GlobalCommand(1020, this.folder));
        this.getController().getActionList().performAction("Refresh");
    }

    private void saveNewSettings(String string, String string2, int n, ColumnInfos columnInfos, int n2, int n3, boolean bl, boolean bl2, boolean bl3) throws GWCommandException {
        DisplaySettings displaySettings = new DisplaySettings(GWCommandManager.getInstance(this.userGuid).getCurrentDataStore(), string, string2, n, columnInfos.getNativeColumnInfos(), n2, n3);
        this.doSaveNewSettings(new FolderDisplaySettings(displaySettings));
    }

    private void saveNewSettings(String string, String string2, int n, ColumnInfos columnInfos, boolean bl, boolean bl2, boolean bl3) throws GWCommandException {
        DisplaySettings displaySettings = new DisplaySettings(GWCommandManager.getInstance(this.userGuid).getCurrentDataStore(), string, string2, n, columnInfos.getNativeColumnInfos());
        this.doSaveNewSettings(new FolderDisplaySettings(displaySettings));
    }

    private void doSaveNewSettings(FolderDisplaySettings folderDisplaySettings) {
        this.displaySettings = folderDisplaySettings;
        this.columnInfos = this.displaySettings.getColumnInfos();
        this.initSystemDisplaySettings();
        this.loadDisplaySettingComboBoxInfo();
        this.setDisplayPropertiesToUI();
    }

    private boolean saveChangedSettings() {
        boolean bl = false;
        SettingsNamePane.Options options = SettingsNamePane.showSettingsNamePane(this, this.displaySettings.getName(), this.taSettingsDescription.getText());
        if (options != null) {
            String string = options.getName();
            String string2 = options.getDescription();
            this.columnInfos.setSortColumn(((ColumnInfo)this.cbSortColumn.getSelectedItem()).getFieldID(), (SortOrder)this.cbSortOrder.getSelectedItem());
            ColumnInfos columnInfos = this.columnInfos;
            boolean bl2 = this.chkHideNonCheckListItems.isSelected();
            boolean bl3 = this.chkOverrideQV.isSelected();
            boolean bl4 = this.chkShowQV.isSelected();
            FolderDisplaySettings folderDisplaySettings = this.findDisplaySettings(string);
            if (this.folder instanceof ContactsFolder) {
                int n = this.getContactTypeFromUI();
                if (folderDisplaySettings == null) {
                    try {
                        this.saveNewSettings(string, string2, n, columnInfos, bl2, bl3, bl4);
                        bl = true;
                    }
                    catch (GWCommandException gWCommandException) {
                        logger.error((Object)gWCommandException);
                        logger.debug((Object)gWCommandException, (Throwable)gWCommandException);
                    }
                } else {
                    this.updateSettingsInfo(folderDisplaySettings, string2, n, columnInfos, bl2, bl3, bl4);
                    bl = true;
                }
            } else {
                int n = this.getItemTypeFromUI();
                int n2 = this.getBoxTypeFromUI();
                int n3 = this.getViewModeFromUI();
                if (folderDisplaySettings == null) {
                    try {
                        this.saveNewSettings(string, string2, n, columnInfos, n2, n3, bl2, bl3, bl4);
                        bl = true;
                    }
                    catch (GWCommandException gWCommandException) {
                        logger.error((Object)gWCommandException);
                        logger.debug((Object)gWCommandException, (Throwable)gWCommandException);
                    }
                } else {
                    this.updateSettingsInfo(folderDisplaySettings, string2, n, n2, n3, columnInfos, bl2, bl3, bl4);
                    bl = true;
                }
            }
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ChangableTextArea
    extends GWTextArea {
        public ChangableTextArea() {
            super(4, 10);
            this.getDocument().addDocumentListener(new DocumentListener(this, FolderPropertiesDialog.this){
                private final /* synthetic */ FolderPropertiesDialog val$this$0;
                private final /* synthetic */ ChangableTextArea this$1;
                {
                    this.this$1 = changableTextArea;
                    this.val$this$0 = folderPropertiesDialog;
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    ChangableTextArea.access$2400(this.this$1).setSettingsChanged();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    ChangableTextArea.access$2400(this.this$1).setSettingsChanged();
                }
            });
        }

        static /* synthetic */ FolderPropertiesDialog access$2400(ChangableTextArea changableTextArea) {
            return changableTextArea.FolderPropertiesDialog.this;
        }
    }

    private class ChangableComboBox
    extends OrientableComboBox {
        public ChangableComboBox() {
            this.initChangeListener();
        }

        public ChangableComboBox(Object[] objectArray) {
            super(objectArray);
            this.initChangeListener();
        }

        private void initChangeListener() {
            this.addActionListener(new ActionListener(this){
                private final /* synthetic */ ChangableComboBox this$1;
                {
                    this.this$1 = changableComboBox;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ChangableComboBox.access$2300(this.this$1).setSettingsChanged();
                }
            });
        }

        static /* synthetic */ FolderPropertiesDialog access$2300(ChangableComboBox changableComboBox) {
            return changableComboBox.FolderPropertiesDialog.this;
        }
    }

    private class ChangableCheckBox
    extends OrientableCheckBox {
        public ChangableCheckBox(String string) {
            super(string);
            this.addActionListener(new ActionListener(FolderPropertiesDialog.this){
                private final /* synthetic */ FolderPropertiesDialog val$this$0;
                {
                    this.val$this$0 = folderPropertiesDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    FolderPropertiesDialog.this.setSettingsChanged();
                }
            });
        }
    }

    private class DisplaySettingsRenderer
    extends DefaultListCellRenderer {
        private DisplaySettingsRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            FolderDisplaySettings folderDisplaySettings = (FolderDisplaySettings)object;
            FolderDisplaySettings folderDisplaySettings2 = FolderPropertiesDialog.this.currentSettings;
            if (folderDisplaySettings != null && folderDisplaySettings.equals(folderDisplaySettings2)) {
                jLabel.setFont(jLabel.getFont().deriveFont(1));
            }
            return jLabel;
        }
    }

    private class ChangeSettingsActionListener
    implements ItemListener {
        private ChangeSettingsActionListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            FolderPropertiesDialog folderPropertiesDialog = FolderPropertiesDialog.this;
            if (itemEvent.getStateChange() == 1 && !folderPropertiesDialog.isReloadingSettings()) {
                logger.debug((Object)"--- CHANGE SETTINGS");
                if (itemEvent.getItem() instanceof FolderDisplaySettings) {
                    FolderDisplaySettings folderDisplaySettings = (FolderDisplaySettings)itemEvent.getItem();
                    folderPropertiesDialog.displaySettings = folderDisplaySettings;
                    folderPropertiesDialog.columnInfos = folderDisplaySettings.getColumnInfos();
                    folderPropertiesDialog.setDisplayPropertiesToUI();
                }
            }
        }
    }

    private class EditColumnActionListener
    implements ActionListener {
        private EditColumnActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                FolderPropertiesDialog folderPropertiesDialog = FolderPropertiesDialog.this;
                ColumnInfos columnInfos = (ColumnInfos)folderPropertiesDialog.columnInfos.clone();
                ColumnInfos columnInfos2 = ColumnInfos.getDifferenceByFieldID(folderPropertiesDialog.allColumnInfos, columnInfos);
                ColumnsDialog columnsDialog = new ColumnsDialog(folderPropertiesDialog, columnInfos, columnInfos2);
                columnsDialog.showMe();
                if (columnsDialog.isActionCompleteSuccessfully() && !folderPropertiesDialog.columnInfos.equals(columnInfos)) {
                    folderPropertiesDialog.columnInfos = columnInfos;
                    FolderPropertiesDialog.this.refreshColumnInfos();
                    folderPropertiesDialog.setSettingsChanged();
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
            }
        }
    }

    protected class TabChangeListener
    implements ChangeListener {
        protected TabChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (FolderPropertiesDialog.this.tabProperties.getSelectedComponent() instanceof SharingPropertyPane) {
                // empty if block
            }
        }
    }

    protected class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(StringResources.CANCEL);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FolderPropertiesDialog.this.getParent().setEnabled(true);
            FolderPropertiesDialog.this.setActionCompleteSuccessfully(false);
            GWDialog.disposeDialog(FolderPropertiesDialog.this);
        }
    }

    private class SaveAsAction
    extends AbstractAction {
        public SaveAsAction() {
            super(StringResources.SAVE_AS_D);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FolderPropertiesDialog.this.saveChangedSettings();
        }
    }

    private class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            super(StringResources.DELETE);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FolderPropertiesDialog folderPropertiesDialog = FolderPropertiesDialog.this;
            FolderDisplaySettings folderDisplaySettings = (FolderDisplaySettings)folderPropertiesDialog.cbDisplaySettings.getSelectedItem();
            if (folderDisplaySettings != null) {
                folderDisplaySettings.getNativeDisplaySettings().deleteSettings();
                folderPropertiesDialog.displaySettings = folderPropertiesDialog.folder.getFolderDisplaySettings();
                folderPropertiesDialog.columnInfos = folderPropertiesDialog.displaySettings.getColumnInfos();
                folderPropertiesDialog.initSystemDisplaySettings();
                folderPropertiesDialog.loadDisplaySettingComboBoxInfo();
                folderPropertiesDialog.setDisplayPropertiesToUI();
            }
        }
    }

    private class OkAction
    extends AbstractAction {
        public OkAction() {
            super(StringResources.OK);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FolderPropertiesDialog folderPropertiesDialog = FolderPropertiesDialog.this;
            if (folderPropertiesDialog.isSettingsChanged() && !folderPropertiesDialog.saveChangedSettings()) {
                return;
            }
            folderPropertiesDialog.setActionCompleteSuccessfully(true);
            folderPropertiesDialog.getParent().setEnabled(true);
            if (folderPropertiesDialog.folder instanceof ContactsFolder && folderPropertiesDialog.cbAddressBooks.getSelectedItem() instanceof PersonalAddressBook) {
                PersonalAddressBook personalAddressBook = (PersonalAddressBook)folderPropertiesDialog.cbAddressBooks.getSelectedItem();
                ((ContactsFolder)folderPropertiesDialog.folder).setAddressBook(personalAddressBook);
                FolderPropertiesDialog.this.getController().processCommand(new Command(1200, folderPropertiesDialog.folder));
                FolderPropertiesDialog.this.getController().processCommand(new Command(360, personalAddressBook));
            }
            if (folderPropertiesDialog.folder.getNativeFolder().canSelectFirstUnreadPropertyOption()) {
                folderPropertiesDialog.folder.setSelectFirstUnreadItemState(folderPropertiesDialog.chkAutoselect.isSelected());
            }
            folderPropertiesDialog.folder.setDescription(folderPropertiesDialog.taDescription.getText());
            if (folderPropertiesDialog.folder.getNativeFolder().isSharedFolderReference()) {
                GWDialog.disposeDialog(folderPropertiesDialog);
                return;
            }
            if (folderPropertiesDialog.pnlSharingProperty != null) {
                if (folderPropertiesDialog.pnlSharingProperty.isFolderShared()) {
                    FolderPropertiesDialog.this.pnlSharingProperty.saveSharedList();
                } else {
                    FolderPropertiesDialog.this.pnlSharingProperty.unShareFolder();
                }
            }
            this.storeDisplayChanges();
            GWDialog.disposeDialog(folderPropertiesDialog);
        }

        private void storeDisplayChanges() {
            FolderPropertiesDialog folderPropertiesDialog = FolderPropertiesDialog.this;
            if (!folderPropertiesDialog.currentSettings.equals(folderPropertiesDialog.displaySettings)) {
                folderPropertiesDialog.folder.setFolderDisplaySettings(folderPropertiesDialog.displaySettings);
                folderPropertiesDialog.fireFolderSettingsChanged();
            }
        }
    }
}

