/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.folderproperties;

import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.ab.Addressable;
import com.novell.gw.folder.FolderAccessRights;
import com.novell.gw.folder.FolderSharedEntry;
import com.novell.gw.folder.FolderSharedList;
import com.novell.gw.jclient.application.controls.ColoredScrollPane;
import com.novell.gw.jclient.application.controls.addressbook.AddressSelectorDialog;
import com.novell.gw.jclient.application.controls.addressbook.SearchEvent;
import com.novell.gw.jclient.application.controls.addressbook.SearchResultListener;
import com.novell.gw.jclient.application.controls.addressbook.SearchTextField;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.dialogs.folderproperties.SharingPropertyPaneController;
import com.novell.gw.jclient.application.dialogs.newfolder.ShareListTable;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class SharingPropertyPane
extends OrientablePanel
implements MVCView {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$dialogs$folderproperties$SharingPropertyPane == null ? (class$com$novell$gw$jclient$application$dialogs$folderproperties$SharingPropertyPane = SharingPropertyPane.class$("com.novell.gw.jclient.application.dialogs.folderproperties.SharingPropertyPane")) : class$com$novell$gw$jclient$application$dialogs$folderproperties$SharingPropertyPane));
    protected ShareListTable tableContactList;
    private JButton btnAddUser = new JButton(new AddUserAction());
    private JButton btnRemoveUser = new JButton(new RemoveUserAction());
    private JButton btnViewAddressBook = new JButton(new ViewAddressBookAction());
    private SearchTextField tfName;
    private AbstractButton cbAdd = new OrientableCheckBox(new AccessAddAction());
    private AbstractButton cbEdit = new OrientableCheckBox(new AccessEditAction());
    private AbstractButton cbDelete = new OrientableCheckBox(new AccessDeleteAction());
    private SharingPropertyPaneController controller;
    protected boolean isReadOnly;
    private GWDialog parentDialog;
    private JScrollPane scrollTable;
    protected AbstractFolder folder;
    private JButton btnDefault;
    protected JPanel pnlBottom = new OrientablePanel(new GridBagLayout());
    static /* synthetic */ Class class$com$novell$gw$jclient$application$dialogs$folderproperties$SharingPropertyPane;

    public SharingPropertyPane(GWDialog gWDialog, MVCController mVCController, AbstractFolder abstractFolder) {
        super(new BorderLayout());
        this.folder = abstractFolder;
        this.parentDialog = gWDialog;
        this.btnDefault = this.parentDialog.getRootPane().getDefaultButton();
        this.controller = new SharingPropertyPaneController(this, mVCController);
        this.tableContactList = new ShareListTable(this.controller);
        this.tfName = new SearchTextField();
        this.tfName.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                SharingPropertyPane.this.enableAddButton();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                SharingPropertyPane.this.enableAddButton();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                SharingPropertyPane.this.enableAddButton();
            }
        });
        this.buildUI();
        this.tfName.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.tableContactList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int n = OptionManager.getInstance().getGeneralOptions().getItemDeleteKey();
                if (keyEvent.getKeyCode() == n) {
                    SharingPropertyPane.this.btnRemoveUser.getAction().actionPerformed(null);
                }
            }
        });
        this.tfName.setListener(new SearchResultListener(){

            public void searchFinished(SearchEvent searchEvent) {
                if (searchEvent.getFoundContact() != null) {
                    ArrayList<Addressable> arrayList = new ArrayList<Addressable>(1);
                    arrayList.add(searchEvent.getFoundContact());
                    SharingPropertyPane.this.tableContactList.addContacts(arrayList);
                } else {
                    JOptionPane.showMessageDialog(SharingPropertyPane.this, StringResources.formatString(StringResources.IS_NOT_A_VALID_GROUPWISE_USER, new String[]{SharingPropertyPane.this.tfName.getText(), SharingPropertyPane.this.tfName.getText()}), StringResources.NOVELL_GROUPWISE, 2);
                }
                SharingPropertyPane.this.tfName.setText("");
                SharingPropertyPane.this.tfName.requestFocus();
            }
        });
    }

    public SharingPropertyPane(GWDialog gWDialog, MVCController mVCController) {
        this(gWDialog, mVCController, null);
    }

    private void enableAddButton() {
        if (this.tfName.getText().trim().equals("")) {
            this.btnAddUser.setEnabled(false);
            this.parentDialog.getRootPane().setDefaultButton(this.btnDefault);
        } else {
            this.btnAddUser.setEnabled(true);
            this.parentDialog.getRootPane().setDefaultButton(this.btnAddUser);
        }
    }

    public void buildUI() {
        this.setPreferredSize(new Dimension(420, 370));
        this.add((Component)this.buildBottomPane(), "Center");
    }

    public void saveSharedList() {
        this.tableContactList.saveSharedList(this.folder);
    }

    public void unShareFolder() {
        this.tableContactList.unShareFolder(this.folder);
    }

    private JPanel buildBottomPane() {
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.anchor = 21;
        orientablePanel.add((Component)new JLabel(StringResources.NAME_C), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        orientablePanel.add((Component)this.tfName, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.btnViewAddressBook.setPreferredSize(new Dimension(23, 23));
        orientablePanel.add((Component)this.btnViewAddressBook, gridBagConstraints);
        OrientablePanel orientablePanel2 = new OrientablePanel(new GridLayout(2, 1, 0, 5));
        orientablePanel2.add(this.btnAddUser);
        orientablePanel2.add(this.btnRemoveUser);
        OrientablePanel orientablePanel3 = new OrientablePanel(new BorderLayout());
        orientablePanel3.add((Component)orientablePanel, "Center");
        orientablePanel3.add((Component)orientablePanel2, "After");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.fill = 2;
        this.pnlBottom.add((Component)orientablePanel3, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.scrollTable = new ColoredScrollPane(this.tableContactList);
        this.pnlBottom.add((Component)this.scrollTable, gridBagConstraints);
        JPanel jPanel = this.buildAccessPanel();
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.pnlBottom.add((Component)jPanel, gridBagConstraints);
        return this.pnlBottom;
    }

    private JPanel buildAccessPanel() {
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets.left = 30;
        orientablePanel.add((Component)this.cbAdd, gridBagConstraints);
        gridBagConstraints.insets.left = 0;
        orientablePanel.add((Component)this.cbEdit, gridBagConstraints);
        gridBagConstraints.insets.right = 0;
        orientablePanel.add((Component)this.cbDelete, gridBagConstraints);
        orientablePanel.setBorder(BorderFactory.createTitledBorder(StringResources.ADDITIONAL_ACCESS));
        return orientablePanel;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    protected void enableShareControls(boolean bl) {
        this.btnViewAddressBook.setEnabled(bl);
        this.tfName.setEditable(bl);
        if (bl) {
            if (this.tableContactList.getRowCount() > 0 && !this.isReadOnly) {
                this.enableCheckBoxes(true);
                this.btnRemoveUser.setEnabled(true);
            }
        } else {
            this.enableCheckBoxes(false);
            this.btnRemoveUser.setEnabled(false);
        }
        this.tableContactList.setEnabled(bl);
        this.tableContactList.setBackground(this.tfName.getBackground());
        this.scrollTable.getViewport().setBackground(this.tfName.getBackground());
        if (this.isReadOnly) {
            this.tableContactList.setEnabled(true);
        }
    }

    public void setController(MVCController mVCController) {
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object object) {
        if (object instanceof FolderSharedEntry) {
            FolderAccessRights folderAccessRights = ((FolderSharedEntry)object).getAccessRights();
            if (!this.isReadOnly) {
                this.enableCheckBoxes(true);
                this.btnRemoveUser.setEnabled(true);
            }
            this.cbAdd.setSelected(folderAccessRights.hasAddAccess());
            this.cbDelete.setSelected(folderAccessRights.hasDeleteAccess());
            this.cbEdit.setSelected(folderAccessRights.hasEditAccess());
        }
    }

    private void enableCheckBoxes(boolean bl) {
        this.cbAdd.setEnabled(bl);
        this.cbDelete.setEnabled(bl);
        this.cbEdit.setEnabled(bl);
    }

    public Object getMVCModel() {
        return null;
    }

    public FolderSharedList getFolderSharedAccessList() {
        return this.tableContactList.getAccessList();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class ViewAddressBookAction
    extends AbstractAction {
        public ViewAddressBookAction() {
            super("", ImageResources.ICON_ACT_VIEW_ADDRESS_SELECTOR);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AddressSelectorDialog addressSelectorDialog = new AddressSelectorDialog((JDialog)SharingPropertyPane.this.parentDialog, SharingPropertyPane.this.getController());
            addressSelectorDialog.showMe();
            if (addressSelectorDialog.isActionCompleteSuccessfully()) {
                SharingPropertyPane.this.tableContactList.addContacts(addressSelectorDialog.getSelectedContacts());
            }
        }
    }

    protected class AccessDeleteAction
    extends AbstractAction {
        public AccessDeleteAction() {
            super(StringResources.DELETE);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SharingPropertyPane.this.tableContactList.changeDeleteRights(((JCheckBox)actionEvent.getSource()).isSelected());
        }
    }

    protected class AccessEditAction
    extends AbstractAction {
        public AccessEditAction() {
            super(StringResources.EDIT);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SharingPropertyPane.this.tableContactList.changeEditRights(((JCheckBox)actionEvent.getSource()).isSelected());
        }
    }

    protected class AccessAddAction
    extends AbstractAction {
        public AccessAddAction() {
            super(StringResources.ADD);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SharingPropertyPane.this.tableContactList.changeAddRights(((JCheckBox)actionEvent.getSource()).isSelected());
        }
    }

    protected class RemoveUserAction
    extends AbstractAction {
        public RemoveUserAction() {
            super(StringResources.REMOVE_USER);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SharingPropertyPane.this.tableContactList.removeSelectedUser();
            if (SharingPropertyPane.this.tableContactList.getRowCount() == 0) {
                SharingPropertyPane.this.enableCheckBoxes(false);
                SharingPropertyPane.this.cbAdd.setSelected(false);
                SharingPropertyPane.this.cbDelete.setSelected(false);
                SharingPropertyPane.this.cbEdit.setSelected(false);
                SharingPropertyPane.this.btnRemoveUser.setEnabled(false);
            }
        }
    }

    protected class AddUserAction
    extends AbstractAction {
        public AddUserAction() {
            super(StringResources.ADD_USER);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SharingPropertyPane.this.tfName.updateListener();
        }
    }
}

