/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.fontchooser;

import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.BasicDialog;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontChooserDialog
extends BasicDialog {
    private JLabel lbPreview;
    private JList listFonts;
    private JList listFontStyles;
    private JList listSizes;
    private String[] fontNamesArray = UIUtils.getSystemFonts();
    private String[] fontStylesArray = new String[]{StringResources.PLAIN, StringResources.BOLD, StringResources.ITALIC, StringResources.BOLD_ITALIC};
    private String[] sizesArray = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "30"};
    private Font font;
    private FontListSelectionListener selectionListener;

    public FontChooserDialog(Dialog dialog) {
        super(dialog);
        this.build();
    }

    public FontChooserDialog(Frame frame) {
        super(frame);
        this.build();
    }

    protected void build() {
        this.setTitle(StringResources.SELECT_FONT);
        this.createButtonPanel();
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        container.add((Component)this.createMainPanel(), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 10, 5, 11);
        gridBagConstraints.weighty = 0.0;
        container.add((Component)this.createButtonPanel(), gridBagConstraints);
    }

    private JPanel createMainPanel() {
        int n = 10;
        this.lbPreview = new OrientableLabel(StringResources.PREVIEW_FONT_AA_BB_CC, 0);
        this.lbPreview.setBackground(Color.white);
        this.lbPreview.setForeground(Color.black);
        this.lbPreview.setOpaque(true);
        this.lbPreview.setBorder(new LineBorder(Color.black));
        this.selectionListener = new FontListSelectionListener();
        this.listFonts = new OrientableList(this.fontNamesArray);
        this.listFonts.setSelectedIndex(0);
        this.listFontStyles = new OrientableList(this.fontStylesArray);
        this.listFontStyles.setSelectedIndex(0);
        this.listSizes = new OrientableList(this.sizesArray);
        this.listSizes.setSelectedIndex(this.sizesArray.length / 2);
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        orientablePanel.setBorder(BorderFactory.createEtchedBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(7, 10, 3, 10);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        orientablePanel.add((Component)new OrientableLabel(StringResources.FONT), gridBagConstraints);
        ++gridBagConstraints.gridx;
        orientablePanel.add((Component)new OrientableLabel(StringResources.FONT_STYLE), gridBagConstraints);
        ++gridBagConstraints.gridx;
        orientablePanel.add((Component)new OrientableLabel(StringResources.SIZE), gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, n, n, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 4.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 10;
        orientablePanel.add((Component)new OrientableScrollPane(this.listFonts), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 2.0;
        orientablePanel.add((Component)new OrientableScrollPane(this.listFontStyles), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, n, n, n);
        orientablePanel.add((Component)new OrientableScrollPane(this.listSizes), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(0, n, n, n);
        gridBagConstraints.anchor = 10;
        orientablePanel.add((Component)this.lbPreview, gridBagConstraints);
        return orientablePanel;
    }

    private JPanel createButtonPanel() {
        OrientablePanel orientablePanel = new OrientablePanel();
        JButton jButton = new JButton(new BtnOkAction());
        JButton jButton2 = new JButton(new BtnCancelAction());
        orientablePanel.add(jButton);
        orientablePanel.add(jButton2);
        this.setDefaultButton(jButton);
        this.setCancelButton(jButton2);
        return orientablePanel;
    }

    public Font getChoosenFont() {
        return this.font;
    }

    public void setFont(Font font, String[] stringArray) {
        this.sizesArray = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.sizesArray, 0, stringArray.length);
        this.listSizes.removeListSelectionListener(this.selectionListener);
        this.listSizes.setModel(new AbstractListModel(){

            public int getSize() {
                return FontChooserDialog.this.sizesArray.length;
            }

            public Object getElementAt(int n) {
                return FontChooserDialog.this.sizesArray[n];
            }
        });
        this.setFont(font);
    }

    public void setFont(Font font) {
        int n;
        this.removeListeners();
        if (font == null) {
            return;
        }
        super.setFont(font);
        for (n = 0; n < this.fontNamesArray.length; ++n) {
            if (!this.fontNamesArray[n].equals(font.getName())) continue;
            this.listFonts.setSelectedIndex(n);
            break;
        }
        n = font.getStyle();
        int n2 = 0;
        if ((n & 0) != 0) {
            n2 = 0;
        }
        if ((n & 1) != 0) {
            n2 = 1;
        }
        if ((n & 2) != 0) {
            n2 = 2;
        }
        if ((n & 2) != 0 && (n & 1) != 0) {
            n2 = 3;
        }
        this.listFontStyles.setSelectedIndex(n2);
        String string = String.valueOf(font.getSize());
        this.listSizes.setSelectedValue(string, true);
        this.font = font;
        this.updateView();
        this.addListeners();
    }

    private void addListeners() {
        this.listFonts.addListSelectionListener(this.selectionListener);
        this.listFontStyles.addListSelectionListener(this.selectionListener);
        this.listSizes.addListSelectionListener(this.selectionListener);
    }

    private void removeListeners() {
        this.listFonts.removeListSelectionListener(this.selectionListener);
        this.listFontStyles.removeListSelectionListener(this.selectionListener);
        this.listSizes.removeListSelectionListener(this.selectionListener);
    }

    public void updateView() {
        this.lbPreview.setFont(this.font);
        this.lbPreview.repaint();
        this.listFonts.ensureIndexIsVisible(this.listFonts.getSelectedIndex());
        this.listFontStyles.ensureIndexIsVisible(this.listFontStyles.getSelectedIndex());
        this.listSizes.ensureIndexIsVisible(this.listSizes.getSelectedIndex());
    }

    public class BtnCancelAction
    extends AbstractAction {
        public BtnCancelAction() {
            super(StringResources.CANCEL);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FontChooserDialog.this.font = null;
            FontChooserDialog.this.hide();
        }
    }

    public class BtnOkAction
    extends AbstractAction {
        public BtnOkAction() {
            super(StringResources.OK);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FontChooserDialog.this.hide();
        }
    }

    public class FontListSelectionListener
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            String string = (String)FontChooserDialog.this.listFonts.getSelectedValue();
            String string2 = (String)FontChooserDialog.this.listSizes.getSelectedValue();
            int n = FontChooserDialog.this.listFontStyles.getSelectedIndex();
            if (string != null && string2 != null && n >= 0) {
                int n2 = 0;
                switch (n) {
                    case 0: {
                        n2 = 0;
                        break;
                    }
                    case 1: {
                        n2 = 1;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                    case 3: {
                        n2 = 3;
                    }
                }
                int n3 = Integer.valueOf(string2);
                FontChooserDialog.this.font = new Font(string, n2, n3);
                FontChooserDialog.this.updateView();
            }
        }
    }
}

