/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.installfolder;

import com.appframework.ApplicationFrame;
import com.appframework.components.ActionEnablerTextField;
import com.appframework.components.GWTextArea;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.dialogs.installfolder.InstallFolderDialogController;
import com.novell.gw.jclient.application.frames.search.PlainFoldersTree;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.impl.cache.FoldersCache;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.GWSharedFolderNotification;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Logger;

public class InstallFolderDialog
extends GWDialog {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$dialogs$installfolder$InstallFolderDialog == null ? (class$com$novell$gw$jclient$application$dialogs$installfolder$InstallFolderDialog = InstallFolderDialog.class$("com.novell.gw.jclient.application.dialogs.installfolder.InstallFolderDialog")) : class$com$novell$gw$jclient$application$dialogs$installfolder$InstallFolderDialog));
    public static final String MESSAGE_PANE = "MessagePane";
    public static final String ACCEPT_PANE = "AcceptPane";
    private JButton btnNextFinish;
    private JButton btnCancel;
    private GWSharedFolderNotification item;
    private JTextField tfName;
    private JTextArea taDescription;
    private PlainFoldersTree foldersTree;
    private JPanel pnlMessage;
    private JButton btnPrev;
    private JPanel pnlCard;
    private ActionNext actionNext = new ActionNext();
    private ActionFinish actionFinish = new ActionFinish();
    private ActionPrev actionPrev = new ActionPrev();
    private JPanel pnlAccept;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$dialogs$installfolder$InstallFolderDialog;
    static /* synthetic */ Class class$com$novell$gw$jclient$bl$om$folders$CabinetFolder;

    public InstallFolderDialog(ApplicationFrame applicationFrame, GWSharedFolderNotification gWSharedFolderNotification) {
        super(applicationFrame, true);
        this.setController(new InstallFolderDialogController(this, applicationFrame.getController()));
        this.item = gWSharedFolderNotification;
        this.build();
        this.tfName.grabFocus();
        this.tfName.selectAll();
        this.tfName.grabFocus();
    }

    private void build() {
        this.setTitle(StringResources.INSTALL_SHARED_FOLDER);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.pnlCard = new OrientablePanel(new CardLayout());
        OrientablePanel orientablePanel = new OrientablePanel(new FlowLayout(4, 0, 15));
        this.btnPrev = new JButton(this.actionPrev);
        orientablePanel.add(this.btnPrev);
        this.btnNextFinish = new JButton(this.actionNext);
        orientablePanel.add(this.btnNextFinish);
        this.btnCancel = new JButton(new CancelAction());
        OrientablePanel orientablePanel2 = new OrientablePanel(new BorderLayout());
        orientablePanel2.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        orientablePanel2.add(this.btnCancel);
        orientablePanel.add(orientablePanel2);
        this.buildMessagePane();
        this.buildAcceptPane();
        this.pnlCard.add((Component)this.pnlAccept, ACCEPT_PANE);
        this.pnlCard.add((Component)this.pnlMessage, MESSAGE_PANE);
        this.pnlCard.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        ((CardLayout)this.pnlCard.getLayout()).show(this.pnlCard, MESSAGE_PANE);
        OrientablePanel orientablePanel3 = new OrientablePanel(new BorderLayout());
        orientablePanel3.add((Component)new JSeparator(), "North");
        orientablePanel3.add((Component)orientablePanel, "South");
        orientablePanel3.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 10));
        container.add((Component)orientablePanel3, "South");
        container.add((Component)this.pnlCard, "Center");
        this.setDefaultButton(this.btnNextFinish);
        this.setCancelButton(this.btnCancel);
    }

    private void next() {
        ((CardLayout)this.pnlCard.getLayout()).next(this.pnlCard);
    }

    private void previous() {
        ((CardLayout)this.pnlCard.getLayout()).previous(this.pnlCard);
    }

    private void buildMessagePane() {
        this.pnlMessage = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        String string = StringResources.formatString(StringResources.HAS_SHARED_A_FOLDER, new String[]{this.item.getSender().getDisplayText(), this.item.getSharedFolderName()});
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.pnlMessage.add((Component)new JLabel(string), gridBagConstraints);
        this.pnlMessage.add((Component)new JLabel(StringResources.TO_INSTALL_THIS_FOLDER), gridBagConstraints);
        String string2 = StringResources.formatString(StringResources.MESSAGE_FROM_PC, new String[]{this.item.getSender().getDisplayText()});
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.top = 20;
        this.pnlMessage.add((Component)new JLabel(string2), gridBagConstraints);
        JTextArea jTextArea = new JTextArea(6, 1);
        jTextArea.setEditable(false);
        jTextArea.setBackground(this.pnlMessage.getBackground());
        jTextArea.setText(this.item.getMessage().getMessage());
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.insets.top = 3;
        OrientableScrollPane orientableScrollPane = new OrientableScrollPane(jTextArea);
        orientableScrollPane.setVerticalScrollBarPolicy(22);
        this.pnlMessage.add((Component)orientableScrollPane, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.top = 5;
        this.pnlMessage.add((Component)new JLabel(StringResources.YOU_HAVE_BEEN_GRANTED), gridBagConstraints);
        this.pnlMessage.add((Component)new JLabel(this.item.getTextGrantedRights()), gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        this.pnlMessage.add((Component)new JPanel(), gridBagConstraints);
    }

    private void buildAcceptPane() {
        this.pnlAccept = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.pnlAccept.add((Component)new JLabel(StringResources.NAME_THE_NEW_FOLDER), gridBagConstraints);
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.top = 5;
        this.pnlAccept.add((Component)new JLabel(StringResources.NAME_C), gridBagConstraints);
        this.tfName = new ActionEnablerTextField(this.actionFinish);
        this.tfName.setText(this.item.getSharedFolderName());
        this.tfName.selectAll();
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.insets.top = 3;
        gridBagConstraints.fill = 2;
        this.pnlAccept.add((Component)this.tfName, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.top = 5;
        this.pnlAccept.add((Component)new JLabel(StringResources.DESCRIPTION_C), gridBagConstraints);
        this.taDescription = new GWTextArea(3, 1);
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.insets.top = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 20.0;
        OrientableScrollPane orientableScrollPane = new OrientableScrollPane(this.taDescription);
        orientableScrollPane.setVerticalScrollBarPolicy(22);
        this.pnlAccept.add((Component)orientableScrollPane, gridBagConstraints);
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        this.pnlAccept.add((Component)new JLabel(StringResources.POSITION_C), gridBagConstraints);
        String string = ControlsUtils.getUserGuid(this.controller);
        this.foldersTree = new PlainFoldersTree(this.getController(), string);
        this.foldersTree.addTreeSelectionListener(new IFTreeSelectionListener());
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.insets.top = 3;
        gridBagConstraints.weighty = 70.0;
        gridBagConstraints.fill = 1;
        OrientableScrollPane orientableScrollPane2 = new OrientableScrollPane(this.foldersTree);
        orientableScrollPane2.setPreferredSize(new Dimension(orientableScrollPane2.getPreferredSize().width, 200));
        this.pnlAccept.add((Component)orientableScrollPane2, gridBagConstraints);
        AbstractFolder abstractFolder = FoldersCache.getFolder(class$com$novell$gw$jclient$bl$om$folders$CabinetFolder == null ? (class$com$novell$gw$jclient$bl$om$folders$CabinetFolder = InstallFolderDialog.class$("com.novell.gw.jclient.bl.om.folders.CabinetFolder")) : class$com$novell$gw$jclient$bl$om$folders$CabinetFolder, string);
        if (abstractFolder != null) {
            this.foldersTree.selectFolder(abstractFolder);
        }
    }

    public void installSharedFolder() {
        try {
            AbstractFolder abstractFolder = this.foldersTree.getSelectedFolder();
            this.item.accept(this.tfName.getText(), abstractFolder, 0, this.taDescription.getText());
            this.controller.getActionList().performAction("Refresh");
            GWDialog.disposeDialog(this);
        }
        catch (EngineException engineException) {
            logger.error((Object)engineException, (Throwable)engineException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class IFTreeSelectionListener
    implements TreeSelectionListener {
        private IFTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            Object object = ((DefaultMutableTreeNode)treeSelectionEvent.getPath().getLastPathComponent()).getUserObject();
            if (!((AbstractFolder)object).canHaveChildren() || ((AbstractFolder)object).isCalendarFolder() || ((AbstractFolder)object).isJunkMailFolder()) {
                InstallFolderDialog.this.actionFinish.setEnabled(false);
            } else if (!InstallFolderDialog.this.tfName.getText().trim().equals("")) {
                InstallFolderDialog.this.actionFinish.setEnabled(true);
            }
        }
    }

    protected class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(StringResources.CANCEL);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InstallFolderDialog.this.setActionCompleteSuccessfully(false);
            GWDialog.disposeDialog(InstallFolderDialog.this);
        }
    }

    class ActionPrev
    extends AbstractAction {
        public ActionPrev() {
            super(StringResources.PREV);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InstallFolderDialog.this.previous();
            InstallFolderDialog.this.btnNextFinish.setAction(InstallFolderDialog.this.actionNext);
            this.setEnabled(false);
        }
    }

    class ActionFinish
    extends AbstractAction {
        public ActionFinish() {
            super(StringResources.FINISH);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InstallFolderDialog.this.setActionCompleteSuccessfully(true);
            InstallFolderDialog.this.installSharedFolder();
        }
    }

    class ActionNext
    extends AbstractAction {
        public ActionNext() {
            super(StringResources.NEXT_G);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InstallFolderDialog.this.next();
            InstallFolderDialog.this.btnNextFinish.setAction(InstallFolderDialog.this.actionFinish);
            InstallFolderDialog.this.actionPrev.setEnabled(true);
        }
    }
}

