/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.junkmail;

import com.appframework.components.GWTextArea;
import com.appframework.utils.OS;
import com.novell.gw.engine.JunkMailAddParams;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.dialogs.junkmail.HTMLLabel;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextArea;

public class JunkMailAddDialog
extends GWDialog {
    protected JTextArea taAddress = new GWTextArea();
    protected JRadioButton rbEmailAddress = new JMnemonicRadioButton();
    protected JRadioButton rbDomain = new JMnemonicRadioButton(){

        public void setText(String string) {
            super.setText("<html>" + string + "</html>");
        }
    };
    protected JRadioButton rbNone = new JMnemonicRadioButton();
    protected JLabel lbAddAddress = new HTMLLabel();
    protected JLabel lbListDisabled = new OrientableLabel();
    protected JCheckBox cbMoveItem = new JMnemonicCheckBox();
    protected JCheckBox cbEnableList = new JMnemonicCheckBox();
    protected boolean bDisplayEnableList = false;
    protected String emailAddressAdd;
    protected String domainAddressAdd;
    protected String noneAddressAdd;
    private JunkMailAddParams mailAddParams;

    public JunkMailAddDialog(JFrame jFrame, JunkMailAddParams junkMailAddParams) {
        this.setModal(true);
        this.mailAddParams = junkMailAddParams;
        this.setTitle(this.getString(1));
        this.initActions();
        this.init();
        this.buildUI();
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JunkMailAddDialog.this.performOkAction();
            }
        });
        ((JPanel)this.getContentPane()).setPreferredSize(new Dimension(450, 380));
    }

    public void showMe() {
        this.rbEmailAddress.doClick();
        super.showMe();
    }

    private void initActions() {
        this.rbEmailAddress.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JunkMailAddDialog.this.lbAddAddress.setText(JunkMailAddDialog.this.emailAddressAdd);
                JunkMailAddDialog.this.taAddress.setText(JunkMailAddDialog.this.mailAddParams.getAddresses());
            }
        });
        this.rbDomain.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JunkMailAddDialog.this.lbAddAddress.setText(JunkMailAddDialog.this.domainAddressAdd);
                JunkMailAddDialog.this.taAddress.setText(JunkMailAddDialog.this.mailAddParams.getDomains());
            }
        });
        this.rbNone.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JunkMailAddDialog.this.lbAddAddress.setText(JunkMailAddDialog.this.noneAddressAdd);
                JunkMailAddDialog.this.taAddress.setText("");
            }
        });
    }

    private String getString(int n) {
        String string = this.mailAddParams.getDlgString(n);
        return StringResources.readMnemonicInfo(string);
    }

    private void init() {
        String string;
        this.emailAddressAdd = this.getString(4);
        this.domainAddressAdd = this.getString(5);
        this.noneAddressAdd = this.getString(13);
        this.rbEmailAddress.setText(this.getString(6));
        this.rbDomain.setText(this.getString(7));
        this.rbNone.setText(this.getString(12));
        this.cbMoveItem.setText(this.getString(8));
        this.cbMoveItem.setSelected((this.mailAddParams.getFlags() & 0x1000) > 0);
        this.taAddress.setText(this.mailAddParams.getAddresses());
        if ((this.mailAddParams.getFlags() & 0x400000) == 0 && (string = this.getString(11)) != null && string.length() > 0) {
            this.bDisplayEnableList = true;
            this.cbEnableList.setText(string);
            boolean bl = (this.mailAddParams.getFlags() & 0x100000) > 0;
            this.cbEnableList.setSelected(bl);
            boolean bl2 = (this.mailAddParams.getFlags() & 0x200000) > 0;
            this.cbEnableList.setEnabled(!bl2);
            this.lbListDisabled.setText(this.getString(10));
        }
    }

    protected void buildUI() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbEmailAddress);
        buttonGroup.add(this.rbDomain);
        buttonGroup.add(this.rbNone);
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.removeAll();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets.bottom = 3;
        gridBagConstraints.anchor = 21;
        jPanel.add((Component)new OrientableLabel(this.getString(2)), gridBagConstraints);
        this.taAddress.setEditable(false);
        this.taAddress.setRows(4);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.ipady = 55;
        jPanel.add((Component)new OrientableScrollPane(this.taAddress), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.bottom = 20;
        jPanel.add((Component)this.lbAddAddress, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.bottom = 1;
        jPanel.add((Component)this.rbEmailAddress, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.rbDomain, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.rbNone, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JSeparator(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 23;
        if (!this.bDisplayEnableList) {
            gridBagConstraints.weighty = 1.0;
        }
        jPanel.add((Component)this.cbMoveItem, gridBagConstraints);
        ++gridBagConstraints.gridy;
        if (this.bDisplayEnableList) {
            gridBagConstraints.insets.top = 20;
            gridBagConstraints.anchor = 23;
            jPanel.add((Component)new JSeparator(), gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets.bottom = 3;
            gridBagConstraints.insets.top = 0;
            jPanel.add((Component)this.lbListDisabled, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets.bottom = 5;
            gridBagConstraints.weighty = 1.0;
            jPanel.add((Component)this.cbEnableList, gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        OrientablePanel orientablePanel = new OrientablePanel(new FlowLayout(4));
        OS.addButtons(orientablePanel, this.btnOK, this.btnCancel);
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)orientablePanel, gridBagConstraints);
    }

    private void performOkAction() {
        if (this.rbDomain.isSelected()) {
            this.mailAddParams.setAddressType(2);
        } else if (this.rbEmailAddress.isSelected()) {
            this.mailAddParams.setAddressType(1);
        } else {
            this.mailAddParams.setAddressType(-1);
        }
        if ((this.mailAddParams.getFlags() & 0x4000) == 0) {
            this.mailAddParams.setMoveItem(this.cbMoveItem.isSelected());
        }
        if ((this.mailAddParams.getFlags() & 0x400000) == 0) {
            this.mailAddParams.setListEnable(this.cbEnableList.isSelected());
        }
    }
}

