/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.junkmail;

import com.appframework.ApplicationFrame;
import com.appframework.components.AbstractApplyAction;
import com.appframework.components.AbstractOKAction;
import com.appframework.utils.OS;
import com.novell.gw.engine.EngineException;
import com.novell.gw.engine.JunkMailList;
import com.novell.gw.engine.JunkMailListManager;
import com.novell.gw.engine.JunkMailSettings;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTabbedPane;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.dialogs.junkmail.AddressesListPane;
import com.novell.gw.jclient.application.dialogs.junkmail.BlockListPanel;
import com.novell.gw.jclient.application.dialogs.junkmail.JunkListPanel;
import com.novell.gw.jclient.application.dialogs.junkmail.JunkSettingsPanel;
import com.novell.gw.jclient.application.dialogs.junkmail.TrustListPanel;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

public class JunkMailDialog
extends GWDialog {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$dialogs$junkmail$JunkMailDialog == null ? (class$com$novell$gw$jclient$application$dialogs$junkmail$JunkMailDialog = JunkMailDialog.class$("com.novell.gw.jclient.application.dialogs.junkmail.JunkMailDialog")) : class$com$novell$gw$jclient$application$dialogs$junkmail$JunkMailDialog));
    public static final int ADDRESS_TYPE_ALL = 3;
    private JTabbedPane tabOptions = new OrientableTabbedPane();
    private JButton btnApply;
    private JunkMailSettings junkMailSettings;
    private JunkSettingsPanel junkSettingsPanel;
    private JunkMailListManager junkMailListManager;
    private JPanel junkListPanel;
    private final ActionListener settingChangeListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            JunkMailDialog.this.checkModel();
        }
    };
    private final ActionListener listsChangeListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            JunkMailDialog.this.modelChanged();
        }
    };
    static /* synthetic */ Class class$com$novell$gw$jclient$application$dialogs$junkmail$JunkMailDialog;
    static /* synthetic */ Class class$com$appframework$ApplicationFrame;

    public JunkMailDialog(JFrame jFrame) throws HeadlessException {
        super(jFrame);
        this.init();
    }

    public static void show(Window window) {
        JunkMailDialog junkMailDialog = new JunkMailDialog((JFrame)window);
        junkMailDialog.pack();
        int n = junkMailDialog.junkListPanel.getSize().height;
        int n2 = junkMailDialog.junkSettingsPanel.getPreferredSize().height;
        junkMailDialog.junkSettingsPanel.setPreferredSize(new Dimension(junkMailDialog.junkListPanel.getSize().width, n2));
        junkMailDialog.showMe();
    }

    private void init() {
        String string = ((ApplicationFrame)SwingUtilities.getAncestorOfClass(class$com$appframework$ApplicationFrame == null ? (class$com$appframework$ApplicationFrame = JunkMailDialog.class$("com.appframework.ApplicationFrame")) : class$com$appframework$ApplicationFrame, this)).getUserGuid();
        try {
            this.junkMailListManager = GWCommandManager.getInstance(string).getJunkMailListManager();
        }
        catch (EngineException engineException) {
            logger.error((Object)engineException);
        }
        this.buildUI();
        this.junkMailSettings = GWCommandManager.getInstance(string).getJunkMailSettings();
        this.junkSettingsPanel.setSettings(this.junkMailSettings);
    }

    private void buildUI() {
        this.setTitle(StringResources.JUNK_MAIL_HANDLING);
        this.tabOptions.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.junkSettingsPanel = new JunkSettingsPanel(this.settingChangeListener);
        this.tabOptions.addTab(StringResources.SETTINGS, new OrientableScrollPane(this.junkSettingsPanel));
        try {
            JunkMailList junkMailList = this.junkMailListManager.createList(3, 3);
            this.junkListPanel = new JunkListPanel(junkMailList);
            this.tabOptions.addTab(this.junkListPanel.getName(), new OrientableScrollPane(this.junkListPanel));
            junkMailList = this.junkMailListManager.createList(2, 3);
            AddressesListPane addressesListPane = new BlockListPanel(junkMailList);
            this.tabOptions.addTab(addressesListPane.getName(), new OrientableScrollPane(addressesListPane));
            junkMailList = this.junkMailListManager.createList(1, 3);
            addressesListPane = new TrustListPanel(junkMailList);
            this.tabOptions.addTab(addressesListPane.getName(), new OrientableScrollPane(addressesListPane));
        }
        catch (EngineException engineException) {
            logger.error((Object)engineException, (Throwable)engineException);
        }
        this.getContentPane().add((Component)this.tabOptions, "Center");
        this.getContentPane().add((Component)this.createButonsPanel(), "South");
    }

    private void checkModel() {
        if (this.junkMailSettings != null) {
            JunkMailSettings junkMailSettings = this.junkSettingsPanel.getSettings();
            this.btnApply.setEnabled(!this.junkMailSettings.equals((Object)junkMailSettings));
        } else {
            this.btnApply.setEnabled(true);
        }
    }

    private void modelChanged() {
        this.btnApply.setEnabled(true);
    }

    private void applyChanges() {
        String string = ((ApplicationFrame)SwingUtilities.getAncestorOfClass(class$com$appframework$ApplicationFrame == null ? (class$com$appframework$ApplicationFrame = JunkMailDialog.class$("com.appframework.ApplicationFrame")) : class$com$appframework$ApplicationFrame, this)).getUserGuid();
        this.junkMailSettings = this.junkSettingsPanel.getSettings();
        try {
            GWCommandManager.getInstance(string).setJunkMailSettings(this.junkMailSettings);
            this.junkMailListManager.apply();
        }
        catch (GWCommandException gWCommandException) {
            gWCommandException.printStackTrace();
            JOptionPane.showMessageDialog(this, StringResources.JUNK_MAIL_SETTINGS_ERROR, "", 0);
        }
        this.btnApply.setEnabled(false);
    }

    private boolean askForChangesLose() {
        int n = JOptionPane.showConfirmDialog(this, StringResources.JUNK_SETTINGS_LOSE_CHANGES_Q, StringResources.WARNING, 2, 2);
        return n == 0;
    }

    private JPanel createButonsPanel() {
        this.btnOK.addActionListener(new AbstractOKAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JunkMailDialog.this.applyChanges();
            }
        });
        this.btnCancel.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JunkMailDialog.this.btnApply.isEnabled() && !JunkMailDialog.this.askForChangesLose()) {
                    return;
                }
                JunkMailDialog.this.dispose();
            }
        });
        this.btnCancel.setText(StringResources.CANCEL);
        this.btnApply = new JButton(new AbstractApplyAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JunkMailDialog.this.applyChanges();
            }
        });
        this.btnApply.addActionListener(this.settingChangeListener);
        this.btnApply.setEnabled(false);
        OrientablePanel orientablePanel = new OrientablePanel(new FlowLayout(4));
        OS.addButtons(orientablePanel, this.btnOK, this.btnCancel, this.btnApply);
        return orientablePanel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

