/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.junkmail;

import com.appframework.components.GWTextArea;
import com.novell.gw.engine.JunkMailSettings;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableSpinner;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class JunkSettingsPanel
extends OrientablePanel {
    private JCheckBox cbJunkList = new JMnemonicCheckBox(StringResources.ENABLE_JUNK_LIST);
    private JCheckBox cbJunkPAB = new JMnemonicCheckBox(StringResources.ENABLE_JUNK_PAB);
    private JCheckBox cbJunkICalPAB = new JMnemonicCheckBox(StringResources.ENABLE_JUNK_ICAL_PAB);
    private JCheckBox cbAutoDelete = new JMnemonicCheckBox(StringResources.AUTOMATICALLY_DELETE_ITEMS);
    private JCheckBox cbBlockList = new JMnemonicCheckBox(StringResources.ENABLE_BLOCK_LIST);
    private JSpinner spinnerDays = new OrientableSpinner(new SpinnerNumberModel(new Integer(0), new Integer(0), new Integer(999), new Integer(1)));
    private static int shift = 21;
    private ActionListener changesListener;
    private boolean locked = false;
    private JLabel labelAutoDelete;

    public JunkSettingsPanel(ActionListener actionListener) {
        if (actionListener == null) {
            throw new NullPointerException();
        }
        this.changesListener = actionListener;
        this.buildUI();
    }

    void setSettings(JunkMailSettings junkMailSettings) {
        if (junkMailSettings != null) {
            this.locked = true;
            this.cbJunkList.setSelected(junkMailSettings.isJunkListEnabled());
            this.cbJunkList.setEnabled(!junkMailSettings.isJunkListEnabledLocked());
            this.cbJunkPAB.setSelected(junkMailSettings.isJunkPABEnabled());
            this.cbJunkPAB.setEnabled(!junkMailSettings.isJunkPABEnabledLocked());
            this.cbJunkICalPAB.setSelected(junkMailSettings.isJunkICalPABEnabled());
            this.cbJunkICalPAB.setEnabled(!junkMailSettings.isJunkICalPABEnabledLocked());
            this.cbAutoDelete.setSelected(junkMailSettings.isFolderAutoRemoveEnabled());
            this.cbAutoDelete.setEnabled(!junkMailSettings.isFolderAutoRemoveEnabledLocked());
            this.spinnerDays.setEnabled(!junkMailSettings.isFolderAutoRemoveEnabledLocked() && junkMailSettings.isFolderAutoRemoveEnabled());
            this.labelAutoDelete.setEnabled(!junkMailSettings.isFolderAutoRemoveEnabledLocked());
            this.cbBlockList.setSelected(junkMailSettings.isBlockListEnabled());
            this.cbBlockList.setEnabled(!junkMailSettings.isBlockListEnabledLocked());
            this.spinnerDays.setValue(new Integer(junkMailSettings.getFolderRetention()));
            this.locked = false;
        }
    }

    JunkMailSettings getSettings() {
        JunkMailSettings junkMailSettings = new JunkMailSettings();
        junkMailSettings.setJunkListEnabled(this.cbJunkList.isSelected());
        junkMailSettings.setJunkPABEnabled(this.cbJunkPAB.isSelected());
        junkMailSettings.setJunkICalPABEnabled(this.cbJunkICalPAB.isSelected());
        junkMailSettings.setBlockListEnabled(this.cbBlockList.isSelected());
        junkMailSettings.setFolderAutoRemoveEnabled(this.cbAutoDelete.isSelected());
        junkMailSettings.setFolderRetention(((Integer)this.spinnerDays.getValue()).intValue());
        return junkMailSettings;
    }

    private void buildUI() {
        this.cbJunkList.addActionListener(this.changesListener);
        this.cbJunkPAB.addActionListener(this.changesListener);
        this.cbJunkICalPAB.addActionListener(this.changesListener);
        this.cbAutoDelete.addActionListener(this.changesListener);
        this.cbBlockList.addActionListener(this.changesListener);
        this.setName(StringResources.SETTINGS);
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.top = 15;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)new FlatTextArea(StringResources.JUNK_MAIL_HANDLING_PROVIDES), gridBagConstraints);
        this.add((Component)this.createJunkMailPanel(), gridBagConstraints);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.createBlockedMailPanel(), gridBagConstraints);
    }

    private JPanel createJunkMailPanel() {
        this.cbAutoDelete.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JunkSettingsPanel.this.spinnerDays.setEnabled(JunkSettingsPanel.this.cbAutoDelete.isSelected());
            }
        });
        this.spinnerDays.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (JunkSettingsPanel.this.locked) {
                    return;
                }
                JunkSettingsPanel.this.changesListener.actionPerformed(null);
            }
        });
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(StringResources.JUNK_MAIL), BorderFactory.createEmptyBorder(1, 5, 5, 5));
        orientablePanel.setBorder(compoundBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        orientablePanel.add((Component)new FlatTextArea(StringResources.YOU_CAN_SPECIFY), gridBagConstraints);
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 5;
        orientablePanel.add((Component)this.cbJunkList, gridBagConstraints);
        gridBagConstraints.fill = 2;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.left = shift;
        orientablePanel.add((Component)new FlatTextArea(StringResources.ENABLE_JUNK_LIST_COMMENT), gridBagConstraints);
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 0;
        orientablePanel.add((Component)this.cbJunkPAB, gridBagConstraints);
        gridBagConstraints.fill = 2;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.left = shift;
        orientablePanel.add((Component)new FlatTextArea(StringResources.ENABLE_JUNK_PAB_COMMENT), gridBagConstraints);
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 0;
        orientablePanel.add((Component)this.cbJunkICalPAB, gridBagConstraints);
        gridBagConstraints.fill = 2;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.left = shift;
        orientablePanel.add((Component)new FlatTextArea(StringResources.ENABLE_JUNK_ICAL_PAB_COMMENT), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.left = 0;
        orientablePanel.add((Component)new JLabel(StringResources.JUNK_MAIL_FOLDER_C), gridBagConstraints);
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        orientablePanel.add((Component)this.cbAutoDelete, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        orientablePanel.add((Component)this.spinnerDays, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets.left = shift;
        gridBagConstraints.weightx = 1.0;
        this.labelAutoDelete = new JLabel(StringResources.DAYS_AFTER_DELIVERY);
        orientablePanel.add((Component)this.labelAutoDelete, gridBagConstraints);
        return orientablePanel;
    }

    private JPanel createBlockedMailPanel() {
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(StringResources.JUNK_MAIL), BorderFactory.createEmptyBorder(1, 5, 5, 5));
        orientablePanel.setBorder(compoundBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        orientablePanel.add((Component)this.cbBlockList, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.left = shift;
        orientablePanel.add((Component)new FlatTextArea("" + StringResources.ENABLE_BLOCK_LIST_COMMENT), gridBagConstraints);
        return orientablePanel;
    }

    private class FlatTextArea
    extends GWTextArea {
        public FlatTextArea(String string) {
            this();
            this.setText(string);
        }

        public FlatTextArea() {
            this.setEditable(false);
            this.setOpaque(false);
        }
    }
}

