/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.login;

import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.filechoser.GWMacFileChooser;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;

public class FilePathSelectEditPanel
extends JPanel {
    private JButton btnCachingPath;
    private JTextField txtCachingPath;
    private String path;
    private Dimension prefSize;

    public FilePathSelectEditPanel(String string, Dimension dimension) {
        this.path = string;
        this.prefSize = dimension;
        this.buildUI();
    }

    private void buildUI() {
        this.setComponentOrientation(UIUtils.getComponentOrientation());
        this.setLayout(new BorderLayout(0, 0));
        if (this.prefSize != null) {
            this.setMinimumSize(this.prefSize);
            this.setPreferredSize(this.prefSize);
        }
        this.txtCachingPath = new OrientableTextField(this.path);
        this.btnCachingPath = new JButton(ImageResources.ACT_DRAFT_OPEN);
        this.btnCachingPath.setPreferredSize(new Dimension(24, 16));
        this.btnCachingPath.addActionListener(new BrowseButtonActionListener(StringResources.SELECT_DIRECTORY, 0));
        this.add((Component)this.txtCachingPath, "Center");
        this.add((Component)this.btnCachingPath, "After");
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.txtCachingPath.getDocument().addDocumentListener(documentListener);
    }

    public void addFocusListener(FocusListener focusListener) {
        if (this.txtCachingPath != null) {
            this.txtCachingPath.addFocusListener(focusListener);
        }
    }

    public void setEnabled(boolean bl) {
        this.txtCachingPath.setEnabled(bl);
        this.btnCachingPath.setEnabled(bl);
    }

    public void setEditable(boolean bl) {
        this.txtCachingPath.setEditable(bl);
    }

    public String getPath() {
        return this.txtCachingPath.getText();
    }

    public void grabFocus() {
        this.txtCachingPath.grabFocus();
    }

    class BrowseButtonActionListener
    implements ActionListener {
        private int type;
        private String message;

        public BrowseButtonActionListener(String string, int n) {
            this.message = string;
            this.type = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FilePathSelectEditPanel filePathSelectEditPanel = FilePathSelectEditPanel.this;
            String string = "";
            if (this.type == 0) {
                string = filePathSelectEditPanel.txtCachingPath.getText();
            }
            if (OS.isMacOS()) {
                File file;
                boolean bl;
                String string2 = StringResources.SELECT_DIRECTORY;
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
                Frame frame = ControlsUtils.getFrameForComponent(filePathSelectEditPanel);
                if (frame == null) {
                    return;
                }
                Object object = new File(string);
                GWMacFileChooser gWMacFileChooser = new GWMacFileChooser(frame, string2, (File)object, 0);
                gWMacFileChooser.setVisible(true);
                object = gWMacFileChooser.getFile();
                String string3 = gWMacFileChooser.getDirectory();
                if (object != null && (bl = (file = new File(string3 + (String)object)).isDirectory())) {
                    filePathSelectEditPanel.txtCachingPath.setText(file.getPath());
                }
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
            } else {
                JFileChooser jFileChooser = new JFileChooser(string);
                jFileChooser.setDialogTitle(this.message);
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setApproveButtonText(StringResources.SELECT);
                int n = jFileChooser.showOpenDialog(FilePathSelectEditPanel.this.getParent());
                if (n == 0) {
                    String string4 = jFileChooser.getSelectedFile().getPath();
                    if (this.type == 0) {
                        filePathSelectEditPanel.txtCachingPath.setText(string4);
                    }
                }
            }
        }
    }
}

