/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.newfolder;

import com.appframework.ApplicationFrame;
import com.appframework.mvc.MVCController;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.dialogs.folderproperties.SharingPropertyPane;
import com.novell.gw.jclient.application.dialogs.newfolder.CreateFolderDialogController;
import com.novell.gw.jclient.application.dialogs.newfolder.FolderNamePane;
import com.novell.gw.jclient.application.dialogs.newfolder.FolderTypePane;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.apache.log4j.Logger;

public class CreateFolderDialog
extends GWDialog {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$dialogs$newfolder$CreateFolderDialog == null ? (class$com$novell$gw$jclient$application$dialogs$newfolder$CreateFolderDialog = CreateFolderDialog.class$("com.novell.gw.jclient.application.dialogs.newfolder.CreateFolderDialog")) : class$com$novell$gw$jclient$application$dialogs$newfolder$CreateFolderDialog));
    public static final String FOLDER_TYPE_PANE = "FolderTypePane";
    public static final String FOLDER_NAME_PANE = "FolderNamePane";
    public static final String FOLDER_PROPERTIES_PANE = "FolderPropertiesPane";
    public static final String FOLDER_SHARING_PANE = "FolderSharingPane";
    private JPanel pnlPanes = new OrientablePanel(new CardLayout());
    private AbstractAction nextAction = new NextAction();
    private AbstractAction finishAction = new FinishAction();
    private AbstractButton btnNext = new JMnemonicButton(this.nextAction);
    private AbstractButton btnPrev = new JMnemonicButton(new PrevAction());
    private FolderTypePane folderTypePane;
    private SharingPropertyPane sharingPropertyPane;
    private FolderNamePane folderNamePane;
    private String currentPane = "FolderTypePane";
    static /* synthetic */ Class class$com$novell$gw$jclient$application$dialogs$newfolder$CreateFolderDialog;

    public CreateFolderDialog(JFrame jFrame, AbstractFolder abstractFolder) {
        super(jFrame);
        MVCController mVCController = ((ApplicationFrame)jFrame).getController();
        this.controller = new CreateFolderDialogController(this, mVCController);
        this.sharingPropertyPane = new SharingPropertyPane(this, this.controller);
        this.folderNamePane = new FolderNamePane(this.controller, abstractFolder, this.btnNext);
        this.folderTypePane = new FolderTypePane(this.controller, this.folderNamePane);
        this.buildUI();
        this.folderTypePane.setPersonalFolderType();
    }

    private void buildUI() {
        this.pnlPanes.add((Component)this.folderTypePane, FOLDER_TYPE_PANE);
        this.pnlPanes.add((Component)this.buildSharingPane(), FOLDER_SHARING_PANE);
        this.pnlPanes.add((Component)this.folderNamePane, FOLDER_NAME_PANE);
        JPanel jPanel = (JPanel)this.getContentPane();
        OrientablePanel orientablePanel = new OrientablePanel(new GridLayout(-1, 2));
        orientablePanel.add(this.btnPrev);
        orientablePanel.add(this.btnNext);
        OrientablePanel orientablePanel2 = new OrientablePanel(new FlowLayout(4, 0, 0));
        orientablePanel2.add(orientablePanel);
        OrientablePanel orientablePanel3 = new OrientablePanel(new FlowLayout(1, 0, 0));
        orientablePanel3.add(this.btnCancel);
        orientablePanel3.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        orientablePanel2.add(orientablePanel3);
        OrientablePanel orientablePanel4 = new OrientablePanel(new BorderLayout());
        orientablePanel4.add((Component)new JSeparator(), "North");
        orientablePanel4.add((Component)orientablePanel2, "South");
        orientablePanel2.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        orientablePanel4.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        jPanel.add((Component)this.pnlPanes, "Center");
        jPanel.add((Component)orientablePanel4, "South");
    }

    private JPanel buildSharingPane() {
        OrientablePanel orientablePanel = new OrientablePanel(new BorderLayout(0, 10));
        orientablePanel.add((Component)new OrientableLabel(StringResources.ENTER_THE_NAMES_OF_PEOPLE), "North");
        orientablePanel.add((Component)this.sharingPropertyPane, "Center");
        orientablePanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 40, 40));
        return orientablePanel;
    }

    private void next() {
        String string = "";
        if (this.currentPane.equals(FOLDER_TYPE_PANE)) {
            string = FOLDER_NAME_PANE;
            if (!this.folderTypePane.isSharingFolderType()) {
                this.btnNext.setAction(this.finishAction);
            }
        } else if (this.folderTypePane.isSharingFolderType()) {
            string = FOLDER_SHARING_PANE;
            this.btnNext.setAction(this.finishAction);
        }
        this.showPane(string);
        this.btnPrev.setEnabled(true);
    }

    private void prev() {
        String string;
        if (this.currentPane.equals(FOLDER_SHARING_PANE)) {
            string = FOLDER_NAME_PANE;
        } else {
            string = FOLDER_TYPE_PANE;
            this.btnPrev.setEnabled(false);
        }
        this.btnNext.setAction(this.nextAction);
        this.showPane(string);
    }

    private void showPane(String string) {
        ((CardLayout)this.pnlPanes.getLayout()).show(this.pnlPanes, string);
        this.currentPane = string;
    }

    private void createFolder() {
        block6: {
            String string = this.folderNamePane.getFolderName();
            String string2 = this.folderNamePane.getFolderDescription();
            AbstractFolder abstractFolder = this.folderNamePane.getParentFolder();
            int n = this.folderNamePane.getFolderPosition();
            String string3 = ControlsUtils.getUserGuid(this.controller);
            try {
                if (this.folderTypePane.isSharingFolderType()) {
                    GWCommandManager.getInstance(string3).createSharedFolder(string, string2, abstractFolder, n, this.sharingPropertyPane.getFolderSharedAccessList());
                } else {
                    GWCommandManager.getInstance(string3).createFolder(string, string2, abstractFolder, n);
                }
                this.dispose();
            }
            catch (EngineException engineException) {
                logger.error((Object)engineException);
                if (engineException.getErrorCode() != 53331 || 0 != JOptionPane.showConfirmDialog(this, StringResources.YOU_SHARE_LIST_IS_EMPTY, StringResources.NOVELL_GROUPWISE, 0)) break block6;
                try {
                    GWCommandManager.getInstance(string3).createFolder(string, string2, abstractFolder, n);
                    this.dispose();
                }
                catch (EngineException engineException2) {
                    logger.error((Object)engineException2);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class PrevAction
    extends AbstractAction {
        public PrevAction() {
            super(StringResources.PREV);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CreateFolderDialog.this.prev();
        }
    }

    private class NextAction
    extends AbstractAction {
        public NextAction() {
            super(StringResources.NEXT_G);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CreateFolderDialog.this.next();
        }
    }

    private class FinishAction
    extends AbstractAction {
        public FinishAction() {
            super(StringResources.FINISH);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CreateFolderDialog.this.createFolder();
        }
    }
}

