/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.newfolder;

import com.appframework.components.GWTextArea;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.newfolder.FolderNamePane;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

class FolderTypePane
extends OrientablePanel {
    private AbstractButton rbPersonalFolder = new JMnemonicRadioButton(StringResources.PERSONAL_FOLDER);
    private AbstractButton rbSharedFolder = new JMnemonicRadioButton(StringResources.SHARED_FOLDER);
    private MVCController controller;
    private FolderNamePane folderNamePane;

    public FolderTypePane(MVCController mVCController, FolderNamePane folderNamePane) {
        this.setLayout(new GridBagLayout());
        this.folderNamePane = folderNamePane;
        this.controller = mVCController;
        this.buildUI();
    }

    private void buildUI() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GWTextArea gWTextArea = new GWTextArea();
        gWTextArea.setEditable(false);
        gWTextArea.setText(StringResources.SELECT_THE_KIND_OF_FOLDER);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.bottom = 10;
        this.add((Component)gWTextArea, gridBagConstraints);
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        this.add((Component)this.buildTypeRow(new JLabel(ImageResources.FLD_FOLDER), this.rbPersonalFolder), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 23;
        this.add((Component)this.buildTypeRow(new JLabel(ImageResources.FLD_SHAREDDIR), this.rbSharedFolder), gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbSharedFolder);
        buttonGroup.add(this.rbPersonalFolder);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.rbPersonalFolder.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1 || itemEvent.getStateChange() == 2) {
                    FolderTypePane.this.folderNamePane.setMVCModel(new Boolean(itemEvent.getStateChange() != 1));
                }
            }
        });
    }

    public boolean isSharingFolderType() {
        return this.rbSharedFolder.isSelected();
    }

    public void setPersonalFolderType() {
        this.rbPersonalFolder.setSelected(true);
    }

    private JComponent buildTypeRow(JComponent jComponent, final AbstractButton abstractButton) {
        OrientablePanel orientablePanel = new OrientablePanel(new BorderLayout(10, 0));
        orientablePanel.add((Component)jComponent, "Before");
        orientablePanel.add((Component)abstractButton, "Center");
        abstractButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    JDialog jDialog = (JDialog)SwingUtilities.getWindowAncestor(abstractButton);
                    jDialog.setTitle(StringResources.CREATE + ' ' + abstractButton.getText());
                }
            }
        });
        return orientablePanel;
    }
}

