/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.newfolder;

import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.ab.Addressable;
import com.novell.gw.ab.UserContact;
import com.novell.gw.folder.FolderAccessRights;
import com.novell.gw.folder.FolderSharedEntry;
import com.novell.gw.folder.FolderSharedList;
import com.novell.gw.jclient.application.OrientableTable;
import com.novell.gw.jclient.application.controls.addressbook.properties.AbstractShareListTableModel;
import com.novell.gw.jclient.application.dialogs.newfolder.ShareListTableController;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class ShareListTable
extends OrientableTable
implements MVCView {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$dialogs$newfolder$ShareListTable == null ? (class$com$novell$gw$jclient$application$dialogs$newfolder$ShareListTable = ShareListTable.class$("com.novell.gw.jclient.application.dialogs.newfolder.ShareListTable")) : class$com$novell$gw$jclient$application$dialogs$newfolder$ShareListTable));
    private ShareListTableController controller;
    ShareListTableModel model;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$dialogs$newfolder$ShareListTable;

    public ShareListTable(MVCController mVCController) {
        this.controller = new ShareListTableController(this, mVCController);
        this.model = new ShareListTableModel();
        this.setModel(this.model);
        this.getSelectionModel().setSelectionMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        listSelectionModel.addListSelectionListener(new MyListSelectionListener());
        this.setShowGrid(false);
    }

    private void selectNearestIndex(int n) {
        int n2 = this.model.getRowCount();
        if (n2 == 0) {
            return;
        }
        int n3 = n >= n2 ? n2 - 1 : n;
        this.setRowSelectionInterval(n3, n3);
    }

    public void removeSelectedUser() {
        int n = this.getSelectedRow();
        if (n != -1) {
            this.model.removeUser(n);
            this.model.fireTableDataChanged();
            this.selectNearestIndex(n);
        }
    }

    public void setController(MVCController mVCController) {
        if (mVCController instanceof ShareListTableController) {
            this.controller = (ShareListTableController)mVCController;
        }
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object object) {
        if (object instanceof FolderSharedList) {
            FolderSharedList folderSharedList = (FolderSharedList)object;
            this.model.setData(folderSharedList);
            if (folderSharedList.getSize() > 0) {
                this.selectEntry(0);
            }
        } else {
            throw new IllegalArgumentException("Incorrect MVC model was passed " + object);
        }
    }

    public void addContacts(List list) {
        for (int i = 0; i < list.size(); ++i) {
            this.model.addContact((Addressable)list.get(i));
        }
        if (this.model.getRowCount() > 0) {
            this.selectEntry(0);
        }
    }

    private void selectEntry(int n) {
        if (this.getSelectedRow() == n) {
            Command command = new Command(280, this.model.getAccessList().get(n));
            this.getController().processCommand(command);
        } else {
            this.setRowSelectionInterval(n, n);
        }
    }

    public Object getMVCModel() {
        return null;
    }

    public void changeAddRights(boolean bl) {
        this.model.getAccessList().get(this.getSelectedRow()).getAccessRights().setAddAccess(bl);
        this.repaint();
    }

    public void changeEditRights(boolean bl) {
        this.model.getAccessList().get(this.getSelectedRow()).getAccessRights().setEditAccess(bl);
        this.repaint();
    }

    public void changeDeleteRights(boolean bl) {
        this.model.getAccessList().get(this.getSelectedRow()).getAccessRights().setDeleteAccess(bl);
        this.repaint();
    }

    public void saveSharedList(AbstractFolder abstractFolder) {
        try {
            abstractFolder.setSharedList(this.model.getAccessList());
            this.controller.processCommand(new Command(200));
        }
        catch (GWCommandException gWCommandException) {
            JOptionPane.showMessageDialog(this, StringResources.UNABLE_TO_SHARE_FOLDER, StringResources.ADDRESS_BOOK_ERROR, 2);
        }
    }

    public void unShareFolder(AbstractFolder abstractFolder) {
        try {
            abstractFolder.setSharedList(null);
            this.controller.processCommand(new Command(200));
        }
        catch (GWCommandException gWCommandException) {
            JOptionPane.showMessageDialog(this, StringResources.UNABLE_TO_SHARE_FOLDER, StringResources.ADDRESS_BOOK_ERROR, 2);
        }
    }

    public FolderSharedList getAccessList() {
        return this.model.getAccessList();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class ShareListTableModel
    extends AbstractShareListTableModel {
        private FolderSharedList accessList = new FolderSharedList();
        public Vector columns = new Vector();

        public ShareListTableModel() {
            this.columns.add(StringResources.NAME);
            this.columns.add(StringResources.STATUS);
            this.columns.add(StringResources.ACCESS);
            this.columns.add("");
        }

        protected void addContactToShareList(UserContact userContact) {
            FolderAccessRights folderAccessRights = new FolderAccessRights(false, false);
            FolderSharedEntry folderSharedEntry = new FolderSharedEntry((Addressable)userContact, folderAccessRights);
            this.accessList.add(folderSharedEntry);
            this.fireTableDataChanged();
        }

        public void setData(FolderSharedList folderSharedList) {
            for (int i = 0; i < folderSharedList.getSize(); ++i) {
                this.accessList.add(folderSharedList.get(i));
            }
            this.fireTableDataChanged();
        }

        public void removeUser(int n) {
            this.accessList.remove(n);
        }

        public String getColumnName(int n) {
            return (String)this.columns.get(n);
        }

        public int getRowCount() {
            return this.accessList.getSize();
        }

        public int getColumnCount() {
            return this.columns.size();
        }

        private String getUserRights(FolderSharedEntry folderSharedEntry) {
            FolderAccessRights folderAccessRights = folderSharedEntry.getAccessRights();
            StringBuffer stringBuffer = new StringBuffer();
            if (folderAccessRights.hasReadAccess()) {
                stringBuffer.append(StringResources.READ);
                stringBuffer.append(", ");
            }
            if (folderAccessRights.hasAddAccess()) {
                stringBuffer.append(StringResources.ADD);
                stringBuffer.append(", ");
            }
            if (folderAccessRights.hasDeleteAccess()) {
                stringBuffer.append(StringResources.DELETE);
                stringBuffer.append(", ");
            }
            if (folderAccessRights.hasEditAccess()) {
                stringBuffer.append(StringResources.EDIT);
                stringBuffer.append(", ");
            }
            if (stringBuffer.length() > 2) {
                stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
            }
            return stringBuffer.toString();
        }

        public Object getValueAt(int n, int n2) {
            FolderSharedEntry folderSharedEntry = this.accessList.get(n);
            switch (n2) {
                case 0: {
                    return folderSharedEntry.getName();
                }
                case 1: {
                    return folderSharedEntry.getStatus();
                }
                case 2: {
                    return this.getUserRights(folderSharedEntry);
                }
            }
            return "";
        }

        public FolderSharedList getAccessList() {
            return this.accessList;
        }
    }

    protected class MyListSelectionListener
    implements ListSelectionListener {
        protected MyListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = ((DefaultListSelectionModel)listSelectionEvent.getSource()).getAnchorSelectionIndex();
            if (n >= 0 && n < ShareListTable.this.getRowCount()) {
                Command command = new Command(280, ShareListTable.this.model.getAccessList().get(n));
                ShareListTable.this.getController().processCommand(command);
            }
        }
    }
}

