/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.passworddialog;

import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.dialogs.passworddialog.PasswordPanel;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class PasswordChangeDialog
extends GWDialog {
    private PasswordPanel passwordPanel;
    private boolean changeOnlineFromCaching = false;
    private boolean performChange = true;
    private boolean disableOldPass = false;
    private String userGuid;

    public PasswordChangeDialog(JDialog jDialog, String string, boolean bl) {
        super(jDialog, true);
        this.userGuid = EngineCommandManager.getUserGuid();
        this.changeOnlineFromCaching = bl;
        this.performChange = true;
        this.init();
        this.build();
        this.setTitle(string);
    }

    public PasswordChangeDialog(JFrame jFrame, String string, boolean bl, boolean bl2) {
        super(jFrame);
        this.changeOnlineFromCaching = false;
        this.performChange = bl;
        this.disableOldPass = bl2;
        this.userGuid = EngineCommandManager.getUserGuid();
        this.build();
        this.setTitle(string);
    }

    public PasswordChangeDialog(JDialog jDialog, String string) {
        super(jDialog);
        this.userGuid = string;
        this.init();
        this.build();
    }

    private void init() {
        if (!this.changeOnlineFromCaching) {
            DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
            this.disableOldPass = !dataStoreSettings.isPasswordSet();
        }
    }

    private void build() {
        int n = EngineCommandManager.getCurrentMode();
        if (n == 1) {
            this.setTitle(StringResources.CHANGE_ONLINE_MAILBOX_PASSWORD);
        } else if (n == 6) {
            this.setTitle(StringResources.CHANGE_CACHING_MAILBOX_PASSWORD);
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.passwordPanel = new PasswordPanel(this.changeOnlineFromCaching, this.performChange, this.disableOldPass, this.userGuid);
        this.getContentPane().add((Component)this.passwordPanel, "Center");
        this.setSize(400, 200);
    }

    public String getOldPass() {
        return this.passwordPanel.getOldPass();
    }

    public String getNewPass() {
        return this.passwordPanel.getNewPass();
    }

    public boolean wasCancelled() {
        return this.passwordPanel.wasCancelled();
    }
}

