/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.passworddialog;

import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class PasswordPanel
extends OrientablePanel {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$dialogs$passworddialog$PasswordPanel == null ? (class$com$novell$gw$jclient$application$dialogs$passworddialog$PasswordPanel = PasswordPanel.class$("com.novell.gw.jclient.application.dialogs.passworddialog.PasswordPanel")) : class$com$novell$gw$jclient$application$dialogs$passworddialog$PasswordPanel));
    private JPasswordField pfOldPass = new JPasswordField();
    private JPasswordField pfNewPass = new JPasswordField();
    private JPasswordField pfNewPassConfirm = new JPasswordField();
    private JButton btnOK;
    private JButton btnCancel;
    private int iSizeBetweenRows;
    private boolean changeOnline;
    private boolean performChange;
    private boolean disableOldPass = false;
    private boolean cancelled = true;
    private String userGuid;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$dialogs$passworddialog$PasswordPanel;

    public PasswordPanel(boolean bl, boolean bl2, boolean bl3, String string) {
        this.userGuid = string;
        this.changeOnline = bl;
        this.performChange = bl2;
        this.disableOldPass = bl3;
        this.build();
    }

    private void build() {
        this.iSizeBetweenRows = 5;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.buildFieldsPane(), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 1);
        this.add((Component)this.buildButtonsPane(), gridBagConstraints);
    }

    private JPanel buildFieldsPane() {
        OrientablePanel orientablePanel = new OrientablePanel();
        Border border = BorderFactory.createEtchedBorder();
        border = BorderFactory.createTitledBorder(border, StringResources.CHANGE_PASSWORD);
        orientablePanel.setBorder(border);
        FieldsDocumentListener fieldsDocumentListener = new FieldsDocumentListener();
        this.pfOldPass.enableInputMethods(true);
        this.pfNewPass.enableInputMethods(true);
        this.pfNewPassConfirm.enableInputMethods(true);
        this.pfOldPass.setColumns(8);
        this.pfOldPass.getDocument().addDocumentListener(fieldsDocumentListener);
        this.pfNewPass.getDocument().addDocumentListener(fieldsDocumentListener);
        this.pfNewPassConfirm.getDocument().addDocumentListener(fieldsDocumentListener);
        this.pfNewPass.setColumns(8);
        this.pfNewPassConfirm.setColumns(8);
        this.pfOldPass.setEnabled(!this.disableOldPass);
        this.pfOldPass.setEditable(!this.disableOldPass);
        ComponentOrientation componentOrientation = UIUtils.getComponentOrientation();
        this.pfOldPass.setComponentOrientation(componentOrientation);
        this.pfNewPass.setComponentOrientation(componentOrientation);
        this.pfNewPassConfirm.setComponentOrientation(componentOrientation);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        orientablePanel.setLayout(new GridBagLayout());
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, this.iSizeBetweenRows, 5);
        gridBagConstraints.weightx = 0.0;
        orientablePanel.add((Component)new OrientableLabel(StringResources.OLD_PASSWORD), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        orientablePanel.add((Component)this.pfOldPass, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(5, 5, this.iSizeBetweenRows, 5);
        gridBagConstraints.weightx = 0.0;
        orientablePanel.add((Component)new OrientableLabel(StringResources.NEW_PASSWORD), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        orientablePanel.add((Component)this.pfNewPass, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        orientablePanel.add((Component)new OrientableLabel(StringResources.CONFIRM_NEW_PASSWORD), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        orientablePanel.add((Component)this.pfNewPassConfirm, gridBagConstraints);
        return orientablePanel;
    }

    private JPanel buildButtonsPane() {
        OrientablePanel orientablePanel = new OrientablePanel();
        this.btnOK = new JButton(new BtnOkAction());
        this.btnCancel = new JButton(new BtnCancelAction());
        this.btnOK.setEnabled(false);
        OS.addButtons(orientablePanel, this.btnOK, this.btnCancel);
        this.btnCancel.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PasswordPanel.this.btnCancel.getAction().actionPerformed(actionEvent);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        return orientablePanel;
    }

    public Insets getInsets() {
        return new Insets(4, 6, 6, 6);
    }

    public String getOldPass() {
        char[] cArray = this.pfOldPass.getPassword();
        return cArray == null ? "" : String.valueOf(cArray);
    }

    public String getNewPass() {
        char[] cArray = this.pfNewPass.getPassword();
        return cArray == null ? "" : String.valueOf(cArray);
    }

    public String getNewPassConfirm() {
        char[] cArray = this.pfNewPassConfirm.getPassword();
        return cArray == null ? "" : String.valueOf(cArray);
    }

    public void clearFields() {
        this.pfNewPass.setText("");
        this.pfNewPassConfirm.setText("");
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    private void checkFieldsValue() {
        String string = this.getNewPass();
        String string2 = this.getNewPassConfirm();
        if (string.length() > 0 && string2.length() > 0 && string.equals(string2)) {
            this.btnOK.setEnabled(true);
            this.getRootPane().setDefaultButton(this.btnOK);
        } else {
            this.btnOK.setEnabled(false);
            this.getRootPane().setDefaultButton(this.btnCancel);
        }
    }

    private void changePassword() {
        block6: {
            if (this.performChange) {
                try {
                    if (EngineCommandManager.getCurrentMode() == 6 && this.changeOnline) {
                        EngineCommandManager.setOnlinePassword(this.getOldPass(), this.getNewPass());
                        ControlsUtils.getWindowForComponent(this).dispose();
                        break block6;
                    }
                    if (!GWCommandManager.getInstance(this.userGuid).changePassword(this.getOldPass(), this.getNewPass())) {
                        JOptionPane.showMessageDialog(this, StringResources.PASSWORD_WAS_NOT_CHANGED, StringResources.ERROR, 0);
                        return;
                    }
                    ControlsUtils.getWindowForComponent(this).dispose();
                }
                catch (GWCommandException gWCommandException) {
                    logger.error((Object)gWCommandException, (Throwable)gWCommandException);
                    ErrorDialog.processGWException(gWCommandException, this);
                    this.clearFields();
                }
            } else {
                ControlsUtils.getWindowForComponent(this).dispose();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class FieldsDocumentListener
    implements DocumentListener {
        private FieldsDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            PasswordPanel.this.checkFieldsValue();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            PasswordPanel.this.checkFieldsValue();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            PasswordPanel.this.checkFieldsValue();
        }
    }

    private class BtnCancelAction
    extends AbstractAction {
        public BtnCancelAction() {
            super(StringResources.CANCEL);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PasswordPanel.this.cancelled = true;
            ControlsUtils.getWindowForComponent(PasswordPanel.this).dispose();
        }
    }

    private class BtnOkAction
    extends AbstractAction {
        public BtnOkAction() {
            super(StringResources.OK);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PasswordPanel.this.cancelled = false;
            PasswordPanel.this.changePassword();
        }
    }
}

