/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.proxy;

import com.novell.gw.ab.Addressable;
import com.novell.gw.engine.ProxyHistoryEntry;
import com.novell.gw.engine.ProxyHistoryList;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import javax.swing.table.AbstractTableModel;

class UserListTableModel
extends AbstractTableModel {
    public String[] columns = new String[]{StringResources.USER_NAME, StringResources.ADDRESS};
    private ProxyHistoryList proxyHistoryList = EngineCommandManager.getProxyHistoryList();

    public String getColumnName(int n) {
        return this.columns[n];
    }

    public int getRowCount() {
        return this.proxyHistoryList.size();
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.proxyHistoryList.get(n).getDisplayName();
            }
            case 1: {
                return this.proxyHistoryList.get(n).getEmailAddress();
            }
        }
        return "";
    }

    public ProxyHistoryEntry getEntryAt(int n) {
        return this.proxyHistoryList.get(n);
    }

    public boolean removeEntryAt(int n) {
        boolean bl = this.proxyHistoryList.remove(n);
        if (bl) {
            this.fireTableRowsDeleted(n, n);
        }
        return bl;
    }

    public int addEntry(Addressable addressable) {
        return this.addEntry(new ProxyHistoryEntry(addressable));
    }

    public int addEntry(ProxyHistoryEntry proxyHistoryEntry) {
        int n = this.proxyHistoryList.add(proxyHistoryEntry);
        if (n != -1) {
            this.fireTableDataChanged();
        }
        return n;
    }

    public void saveChanges() {
        this.proxyHistoryList.commit();
    }
}

