/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.rules;

import com.appframework.utils.UIUtils;
import com.novell.gw.engine.Filter;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBoxMenuItem;
import com.novell.gw.jclient.application.dialogs.rules.ConstantListConditionField;
import com.novell.gw.jclient.application.dialogs.rules.DateConditionField;
import com.novell.gw.jclient.application.dialogs.rules.RowPaneInfo;
import com.novell.gw.jclient.application.dialogs.rules.TextConditionField;
import com.novell.gw.jclient.application.resources.ImageResources;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import org.apache.log4j.Logger;

public abstract class AbstractConditionField {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$dialogs$rules$AbstractConditionField == null ? (class$com$novell$gw$jclient$application$dialogs$rules$AbstractConditionField = AbstractConditionField.class$("com.novell.gw.jclient.application.dialogs.rules.AbstractConditionField")) : class$com$novell$gw$jclient$application$dialogs$rules$AbstractConditionField));
    private String name;
    protected ConditionButton btnCondition = new ConditionButton();
    protected JPopupMenu popupCondition = new JPopupMenu();
    protected Filter.RowInfo rowInfo;
    protected Filter.FilterData fieldData;
    protected Filter filter;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$dialogs$rules$AbstractConditionField;

    public AbstractConditionField(Filter.FilterData filterData, Filter filter) {
        this.name = filterData.getDisplayText();
        this.fieldData = filterData;
        this.filter = filter;
        this.btnCondition.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JButton jButton = (JButton)actionEvent.getSource();
                AbstractConditionField.this.popupCondition.show(jButton, 0, 0);
            }
        });
        this.btnCondition.setIcon(ImageResources.ADV_FILTER_UP_DOWN);
        this.btnCondition.setHorizontalTextPosition(10);
        UIUtils.setButtonPreferedSize(this.btnCondition, new String[]{">= "});
        this.btnCondition.setOperator(this.filter.getValidOperators(this.fieldData.getId())[0]);
    }

    protected Filter.ValidValueType getValidValueType() {
        return this.filter.getValidValueType(this.fieldData.getId(), this.btnCondition.getOperator().getId());
    }

    protected ValidValueWrapper[] getValidValues() {
        Filter.FilterData[] filterDataArray = this.getValidValueType().getValidValues();
        ValidValueWrapper[] validValueWrapperArray = new ValidValueWrapper[filterDataArray.length];
        for (int i = 0; i < filterDataArray.length; ++i) {
            validValueWrapperArray[i] = new ValidValueWrapper(filterDataArray[i]);
        }
        return validValueWrapperArray;
    }

    public abstract Container getConditionPane();

    protected ValidValueWrapper getSelectedValue() {
        Filter.FilterValue filterValue = this.rowInfo.getValue().getValue();
        Filter filter = this.filter;
        filter.getClass();
        Filter.FilterData filterData = new Filter.FilterData(filter, filterValue.getId(), filterValue.getStringValue());
        ValidValueWrapper validValueWrapper = new ValidValueWrapper(filterData);
        return validValueWrapper;
    }

    public String toString() {
        return this.name;
    }

    protected void updateRowInfo() {
        int n = this.rowInfo.getOperator().getId();
        MenuElement[] menuElementArray = this.popupCondition.getSubElements();
        for (int i = 0; i < menuElementArray.length; ++i) {
            ConditionAction conditionAction;
            JMenuItem jMenuItem;
            MenuElement menuElement = menuElementArray[i];
            if (!(menuElement instanceof JMenuItem) || !((jMenuItem = (JMenuItem)menuElement).getAction() instanceof ConditionAction) || (conditionAction = (ConditionAction)jMenuItem.getAction()).getOperator().getId() != n) continue;
            jMenuItem.doClick();
        }
    }

    public void setRowInfo(Filter.RowInfo rowInfo) {
        this.rowInfo = rowInfo;
    }

    public RowPaneInfo getRowInfo() {
        RowPaneInfo rowPaneInfo = new RowPaneInfo();
        rowPaneInfo.setOperatorID(this.btnCondition.getOperator().getId());
        rowPaneInfo.setFieldID(this.fieldData.getId());
        return rowPaneInfo;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractConditionField)) {
            return false;
        }
        AbstractConditionField abstractConditionField = (AbstractConditionField)object;
        return abstractConditionField.fieldData.getId() == this.fieldData.getId();
    }

    protected void buildPopup() {
        ButtonGroup buttonGroup = new ButtonGroup();
        Filter.FilterData[] filterDataArray = this.filter.getValidOperators(this.fieldData.getId());
        for (int i = 0; i < filterDataArray.length; ++i) {
            OrientableCheckBoxMenuItem orientableCheckBoxMenuItem = new OrientableCheckBoxMenuItem(new ConditionAction(filterDataArray[i], null));
            if (i == 0) {
                orientableCheckBoxMenuItem.doClick();
            }
            this.popupCondition.add(orientableCheckBoxMenuItem);
            buttonGroup.add(orientableCheckBoxMenuItem);
        }
        if (this.rowInfo != null) {
            this.updateRowInfo();
        }
    }

    protected void operatorChanged(Filter.FilterData filterData) {
    }

    public static AbstractConditionField createConditionField(Filter.FilterData filterData, Filter filter) {
        Filter.ValidValueType validValueType = filter.getValidValueType(filterData.getId(), filter.getValidOperators(filterData.getId())[0].getId());
        if (validValueType.getType() == 2) {
            return new TextConditionField(filterData, filter);
        }
        if (validValueType.getType() == 1) {
            return new ConstantListConditionField(filterData, filter);
        }
        return new DateConditionField(filterData, filter);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class ValidValueWrapper {
        Filter.FilterData validValue;

        public ValidValueWrapper(Filter.FilterData filterData) {
            this.validValue = filterData;
        }

        public String toString() {
            return this.validValue.getDisplayText();
        }

        public Filter.FilterData getValue() {
            return this.validValue;
        }

        public int getValueId() {
            return this.validValue.getId();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ValidValueWrapper)) {
                return false;
            }
            ValidValueWrapper validValueWrapper = (ValidValueWrapper)object;
            return this.getValueId() == validValueWrapper.getValueId();
        }
    }

    protected static class ConditionButton
    extends OrientableButton {
        private Filter.FilterData operator;

        public Filter.FilterData getOperator() {
            return this.operator;
        }

        public void setOperator(Filter.FilterData filterData) {
            this.operator = filterData;
        }
    }

    protected class ConditionAction
    extends AbstractAction {
        private Filter.FilterData operator;

        ConditionAction(String string, Icon icon) {
            super(string, icon);
        }

        ConditionAction(Filter.FilterData filterData, Icon icon) {
            super(filterData.getDisplayText(), icon);
            this.operator = filterData;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getText();
            int n = string.indexOf("\t");
            if (n == -1) {
                n = string.indexOf("\\t");
            }
            if (n != -1) {
                string = string.substring(0, n);
            }
            AbstractConditionField.this.btnCondition.setText(string);
            AbstractConditionField.this.btnCondition.setOperator(this.operator);
            AbstractConditionField.this.operatorChanged(this.operator);
        }

        public Filter.FilterData getOperator() {
            return this.operator;
        }
    }
}

