/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.rules;

import com.appframework.IActionList;
import com.appframework.components.GWTextArea;
import com.appframework.utils.OS;
import com.novell.gw.engine.Filter;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBoxMenuItem;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.dialogs.rules.AdvancedConditionsDialogActionList;
import com.novell.gw.jclient.application.dialogs.rules.GroupPane;
import com.novell.gw.jclient.application.dialogs.rules.OperatorButton;
import com.novell.gw.jclient.application.dialogs.rules.RowPane;
import com.novell.gw.jclient.application.dialogs.rules.RowPaneInfo;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.text.JTextComponent;

public class AdvancedConditionsDialog
extends GWDialog {
    public static final int MIN_ROW_COUNT_TO_SCROLL = 8;
    public static final int PREFERRED_WIDTH = 635;
    private OperatorButton btnOperator;
    private JPanel pnlCenter = new OrientablePanel(new GridLayout(0, 1, 0, 10));
    private RowPane selectedRow;
    private RemoveRowAction actionRemoveRow = new RemoveRowAction();
    private JPopupMenu popupCondition = new JPopupMenu();
    private NewGroupAction actionNewGroup = new NewGroupAction();
    private AddRowAction actionAddRow = new AddRowAction();
    private Filter filter;
    private String userGuid;

    public AdvancedConditionsDialog(GWDialog gWDialog, Filter filter, String string) {
        super(gWDialog);
        this.userGuid = string;
        this.filter = filter;
        this.setController(new AdvancedConditionsDialogActionList(this, gWDialog.getController()));
        this.setTitle(StringResources.DEFINE_CONDITIONS);
        this.buildUI();
    }

    private void buildPopup() {
        ButtonGroup buttonGroup = new ButtonGroup();
        JMenuItem jMenuItem = new OrientableCheckBoxMenuItem(new AndOrAction(0));
        jMenuItem.setText(StringResources.AND);
        this.popupCondition.add(jMenuItem);
        buttonGroup.add(jMenuItem);
        jMenuItem = new OrientableCheckBoxMenuItem(new AndOrAction(1));
        jMenuItem.setText(StringResources.OR);
        this.popupCondition.add(jMenuItem);
        buttonGroup.add(jMenuItem);
        this.popupCondition.addSeparator();
        jMenuItem = OS.createMenuItemForAction(this.actionAddRow);
        this.popupCondition.add(jMenuItem);
        buttonGroup.add(jMenuItem);
        jMenuItem = OS.createMenuItemForAction(this.actionRemoveRow);
        this.popupCondition.add(jMenuItem);
        buttonGroup.add(jMenuItem);
        this.popupCondition.addSeparator();
        jMenuItem = OS.createMenuItemForAction(this.actionNewGroup);
        this.popupCondition.add(jMenuItem);
        buttonGroup.add(jMenuItem);
        jMenuItem = new OrientableCheckBoxMenuItem(new EndAction());
        this.popupCondition.add(jMenuItem);
        buttonGroup.add(jMenuItem);
    }

    private void readFilterData() {
        this.filter = new Filter(GWCommandManager.getInstance(this.userGuid).getCurrentDataStore(), true);
        GroupPane[] groupPaneArray = this.getGroups();
        for (int i = 0; i < groupPaneArray.length; ++i) {
            GroupPane groupPane = groupPaneArray[i];
            if (!groupPane.isFirstGroup()) {
                this.filter.addRowGroup(groupPane.getGroupOperator());
            }
            RowPaneInfo[] rowPaneInfoArray = groupPane.getRowPanesInfo();
            for (int j = 0; j < rowPaneInfoArray.length; ++j) {
                RowPaneInfo rowPaneInfo = rowPaneInfoArray[j];
                this.filter.addRow(rowPaneInfo.getFieldID(), rowPaneInfo.getOperatorID(), rowPaneInfo.getValueType(), rowPaneInfo.getValue(), rowPaneInfo.getRowOperator());
            }
        }
    }

    private GroupPane[] getGroups() {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (int i = 0; i < this.pnlCenter.getComponentCount(); ++i) {
            if (!(this.pnlCenter.getComponent(i) instanceof GroupPane)) continue;
            arrayList.add(this.pnlCenter.getComponent(i));
        }
        return arrayList.toArray(new GroupPane[0]);
    }

    private void buildUI() {
        OrientablePanel orientablePanel;
        OrientablePanel orientablePanel2 = new OrientablePanel(){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (dimension.width < 635) {
                    dimension.width = 635;
                }
                return dimension;
            }
        };
        this.setContentPane(orientablePanel2);
        this.buildPopup();
        orientablePanel2.setLayout(new BorderLayout(5, 5));
        this.pnlCenter.setLayout(new BoxLayout(this.pnlCenter, 1));
        int n = this.filter.getRowCount();
        ArrayList<RowPane> arrayList = new ArrayList<RowPane>(n);
        boolean bl = true;
        int n2 = -1;
        if (n == 0) {
            arrayList.add(this.buildRow());
        }
        for (int i = 0; i < n; ++i) {
            if (this.filter.isGroup(i)) {
                orientablePanel = new GroupPane(bl, arrayList);
                if (n2 != -1) {
                    ((GroupPane)orientablePanel).setGroupOperator(n2);
                }
                n2 = this.filter.getGroupOperator(i);
                this.pnlCenter.add(orientablePanel);
                bl = false;
                arrayList.clear();
                continue;
            }
            arrayList.add(new RowPane((IActionList)((Object)this.getController()), this.filter, this.filter.getRow(i)));
        }
        GroupPane groupPane = new GroupPane(bl, arrayList);
        if (n2 != -1) {
            groupPane.setGroupOperator(n2);
        }
        this.pnlCenter.add(groupPane);
        orientablePanel = new OrientablePanel(new BorderLayout());
        orientablePanel.add((Component)this.pnlCenter, "North");
        CalendarScrollPane calendarScrollPane = new CalendarScrollPane(orientablePanel);
        calendarScrollPane.setBorder(null);
        orientablePanel2.add((Component)calendarScrollPane, "Center");
        orientablePanel2.add((Component)this.buildButtonsPane(), "After");
        GWTextArea gWTextArea = new GWTextArea();
        ((JTextComponent)gWTextArea).setText(StringResources.INCLUDE_ENTRIES_WHERE_D);
        ((JTextComponent)gWTextArea).setEditable(false);
        gWTextArea.setOpaque(false);
        orientablePanel2.add((Component)gWTextArea, "North");
        orientablePanel2.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
    }

    private RowPane buildRow() {
        return new RowPane((IActionList)((Object)this.getController()), this.filter, null);
    }

    public void showMe() {
        super.showMe();
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void processRowSelection(JButton jButton) {
        this.btnOperator = (OperatorButton)jButton;
        this.selectedRow = (RowPane)jButton.getParent();
        this.selectPopupMenuItem(jButton.getText());
        GroupPane groupPane = this.findGroupPane(this.selectedRow);
        boolean bl = groupPane.getRowCount() == 1 && groupPane.isFirstGroup();
        this.actionRemoveRow.setEnabled(!bl);
        this.popupCondition.show(jButton, 0, 0);
    }

    private Container buildButtonsPane() {
        OrientablePanel orientablePanel = new OrientablePanel(new BorderLayout());
        OrientablePanel orientablePanel2 = new OrientablePanel(new GridLayout(0, 1, 0, 5));
        OrientableButton orientableButton = new OrientableButton(new OkAction());
        OrientableButton orientableButton2 = new OrientableButton(new ClearAction());
        OrientableButton orientableButton3 = new OrientableButton(new CancelAction());
        this.setDefaultButton(orientableButton);
        this.setCancelButton(orientableButton3);
        OS.addButtons(orientablePanel2, orientableButton, orientableButton3, orientableButton2);
        orientablePanel.add((Component)orientablePanel2, "North");
        return orientablePanel;
    }

    private void selectPopupMenuItem(String string) {
        for (int i = 0; i < this.popupCondition.getSubElements().length; ++i) {
            JMenuItem jMenuItem;
            MenuElement menuElement = this.popupCondition.getSubElements()[i];
            if (!(menuElement instanceof JMenuItem) || !(jMenuItem = (JMenuItem)menuElement).getText().equals(string)) continue;
            jMenuItem.setSelected(true);
            break;
        }
    }

    private GroupPane findGroupPane(RowPane rowPane) {
        Container container;
        for (container = rowPane.getParent(); container != null && !(container instanceof GroupPane); container = container.getParent()) {
        }
        return (GroupPane)container;
    }

    private int getGroupPaneIndex(GroupPane groupPane) {
        Component component;
        int n = 0;
        int n2 = this.pnlCenter.getComponentCount();
        for (int i = 0; i < n2 && !(component = this.pnlCenter.getComponent(i)).equals(groupPane); ++i) {
            if (!(component instanceof GroupPane)) continue;
            ++n;
        }
        return n;
    }

    private GroupPane getNextGroup(GroupPane groupPane) {
        int n = this.getGroupPaneIndex(groupPane);
        if (n < this.pnlCenter.getComponentCount() - 1) {
            return (GroupPane)this.pnlCenter.getComponent(++n);
        }
        return null;
    }

    private GroupPane getPrevGroup(GroupPane groupPane) {
        int n = this.getGroupPaneIndex(groupPane);
        if (n > 0) {
            return (GroupPane)this.pnlCenter.getComponent(--n);
        }
        return null;
    }

    private int getTotalRowsCount() {
        int n = 0;
        GroupPane[] groupPaneArray = this.getGroups();
        for (int i = 0; i < groupPaneArray.length; ++i) {
            GroupPane groupPane = groupPaneArray[i];
            if (!groupPane.isFirstGroup()) {
                ++n;
            }
            n += groupPane.getRowCount();
        }
        return n;
    }

    private void scrollToVisible() {
        this.pnlCenter.scrollRectToVisible(new Rectangle(0, this.pnlCenter.getHeight(), 10, 100));
    }

    private void updateSize() {
        if (this.getTotalRowsCount() <= 8) {
            this.pack();
        } else {
            this.scrollToVisible();
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(StringResources.CANCEL);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AdvancedConditionsDialog.this.dispose();
        }
    }

    private class OkAction
    extends AbstractAction {
        public OkAction() {
            super(StringResources.OK);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AdvancedConditionsDialog.this.setActionCompleteSuccessfully(true);
            AdvancedConditionsDialog.this.readFilterData();
            AdvancedConditionsDialog.this.dispose();
        }
    }

    private class ClearAction
    extends AbstractAction {
        public ClearAction() {
            super(StringResources.CLEAR);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AdvancedConditionsDialog.this.pnlCenter.removeAll();
            RowPane[] rowPaneArray = new RowPane[]{AdvancedConditionsDialog.this.buildRow()};
            AdvancedConditionsDialog.this.pnlCenter.add(new GroupPane(true, Arrays.asList(rowPaneArray)));
            AdvancedConditionsDialog.this.pnlCenter.updateUI();
            AdvancedConditionsDialog.this.pack();
        }
    }

    private class RemoveRowAction
    extends AbstractAction {
        public RemoveRowAction() {
            super(StringResources.DELETE_ROW);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GroupPane groupPane = AdvancedConditionsDialog.this.findGroupPane(AdvancedConditionsDialog.this.selectedRow);
            if (groupPane.getRowCount() == 1) {
                AdvancedConditionsDialog.this.getPrevGroup(groupPane).getLastRowPane().setRowOperator(2);
                AdvancedConditionsDialog.this.pnlCenter.remove(groupPane);
            } else {
                groupPane.deleteRow(AdvancedConditionsDialog.this.selectedRow);
                if (AdvancedConditionsDialog.this.getNextGroup(groupPane) == null) {
                    groupPane.getLastRowPane().setRowOperator(2);
                } else {
                    groupPane.getLastRowPane().setRowOperator(3);
                }
            }
            AdvancedConditionsDialog.this.pnlCenter.updateUI();
            if (AdvancedConditionsDialog.this.getTotalRowsCount() <= 8) {
                AdvancedConditionsDialog.this.pack();
            }
        }
    }

    private class NewGroupAction
    extends AbstractAction {
        public NewGroupAction() {
            super(StringResources.NEW_GROUP);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GroupPane groupPane = AdvancedConditionsDialog.this.findGroupPane(AdvancedConditionsDialog.this.selectedRow);
            RowPane[] rowPaneArray = groupPane.removeRowsAfter(AdvancedConditionsDialog.this.selectedRow);
            if (rowPaneArray.length == 0) {
                rowPaneArray = new RowPane[]{AdvancedConditionsDialog.this.buildRow()};
            }
            AdvancedConditionsDialog.this.pnlCenter.add((Component)new GroupPane(false, Arrays.asList(rowPaneArray)), AdvancedConditionsDialog.this.getGroupPaneIndex(groupPane) + 1);
            AdvancedConditionsDialog.this.updateSize();
            groupPane.getLastRowPane().setRowOperator(3);
        }
    }

    private class AddRowAction
    extends AbstractAction {
        public AddRowAction() {
            super(StringResources.INSERT_ROW);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GroupPane groupPane = AdvancedConditionsDialog.this.findGroupPane(AdvancedConditionsDialog.this.selectedRow);
            RowPane rowPane = AdvancedConditionsDialog.this.buildRow();
            groupPane.insertRow(AdvancedConditionsDialog.this.selectedRow, rowPane);
            AdvancedConditionsDialog.this.updateSize();
            if (!AdvancedConditionsDialog.this.btnOperator.getText().equals(StringResources.OR)) {
                AdvancedConditionsDialog.this.selectedRow.setRowOperator(0);
            }
            if (AdvancedConditionsDialog.this.getNextGroup(groupPane) != null) {
                groupPane.getLastRowPane().setRowOperator(3);
            }
        }
    }

    private class EndAction
    extends AbstractAction {
        public EndAction() {
            super(StringResources.END);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GroupPane groupPane = AdvancedConditionsDialog.this.findGroupPane(AdvancedConditionsDialog.this.selectedRow);
            GroupPane groupPane2 = AdvancedConditionsDialog.this.getNextGroup(groupPane);
            while (groupPane2 != null) {
                AdvancedConditionsDialog.this.pnlCenter.remove(groupPane2);
                groupPane2 = AdvancedConditionsDialog.this.getNextGroup(groupPane);
            }
            while (!groupPane.getLastRowPane().equals(AdvancedConditionsDialog.this.selectedRow)) {
                groupPane.deleteRow(groupPane.getLastRowPane());
            }
            AdvancedConditionsDialog.this.selectedRow.setRowOperator(2);
        }
    }

    private class AndOrAction
    extends AbstractAction {
        int operator;

        public AndOrAction(int n) {
            this.operator = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AdvancedConditionsDialog.this.btnOperator.setOperator(this.operator);
            GroupPane groupPane = AdvancedConditionsDialog.this.findGroupPane(AdvancedConditionsDialog.this.selectedRow);
            int n = groupPane.getRowCount();
            int n2 = groupPane.getRowIndex(AdvancedConditionsDialog.this.selectedRow);
            if (--n == n2) {
                AdvancedConditionsDialog.this.actionAddRow.actionPerformed(null);
            }
        }
    }
}

