/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.rules;

import com.appframework.ActionList;
import com.appframework.components.EmptyStringDocumentListener;
import com.appframework.components.GWTextArea;
import com.appframework.mvc.Command;
import com.appframework.utils.OS;
import com.novell.gw.folder.Folder;
import com.novell.gw.jclient.application.controls.FoldersDialog;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.dialogs.rules.AdvancedConditionsDialog;
import com.novell.gw.jclient.application.dialogs.rules.AppointmentConflictWrapper;
import com.novell.gw.jclient.application.dialogs.rules.CreateRuleDialogActionList;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.rules.Rule;
import com.novell.gw.rules.RuleAction;
import com.novell.gw.rules.RuleActionAccept;
import com.novell.gw.rules.RuleActionDelegate;
import com.novell.gw.rules.RuleActionDelete;
import com.novell.gw.rules.RuleActionForward;
import com.novell.gw.rules.RuleActionLink;
import com.novell.gw.rules.RuleActionList;
import com.novell.gw.rules.RuleActionMove;
import com.novell.gw.rules.RuleActionReply;
import com.novell.gw.rules.RuleActionSend;
import com.novell.gw.rules.RuleList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.log4j.Logger;

public class CreateRuleDialog
extends GWDialog {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$dialogs$rules$CreateRuleDialog == null ? (class$com$novell$gw$jclient$application$dialogs$rules$CreateRuleDialog = CreateRuleDialog.class$("com.novell.gw.jclient.application.dialogs.rules.CreateRuleDialog")) : class$com$novell$gw$jclient$application$dialogs$rules$CreateRuleDialog));
    private Rule rule;
    private int eventExecutionType = 5;
    private ActionList actionList;
    private RuleActionList ruleActionList;
    private Folder selectedFolder;
    private JButton btnSave = new JMnemonicButton(new SaveAction());
    private JButton btnEvent = new OrientableButton(new EventAction());
    private JButton btnAddAction = new JMnemonicButton(new AddAction());
    private JButton btnEditAction = new JMnemonicButton(new EditAction());
    private JButton btnDeleteAction = new JMnemonicButton(new DeleteAction());
    private JButton btnConditions = new JMnemonicButton(StringResources.DEFINE_CONDITIONS_D);
    private JTextField tfRuleName = new OrientableTextField();
    private JTextField tfFolder = new OrientableTextField();
    private JTextArea taConditions = new GWTextArea();
    private JPanel pnlEventItem = new OrientablePanel(new FlowLayout(3));
    private JPanel pnlEventFolder = new OrientablePanel(new BorderLayout(5, 0));
    private JPopupMenu popupEvent = new JPopupMenu();
    private JPopupMenu popupAddAction = new JPopupMenu();
    private JCheckBox cbItemTypeMail = new JMnemonicCheckBox(new ItemTypeAction(StringResources.MAIL));
    private JCheckBox cbItemTypeAppointment = new JMnemonicCheckBox(new ItemTypeAction(StringResources.APPOINTMENT));
    private JCheckBox cbItemTypeTask = new JMnemonicCheckBox(new ItemTypeAction(StringResources.TASK));
    private JCheckBox cbItemTypeReminderNote = new JMnemonicCheckBox(new ItemTypeAction(StringResources.REMINDER_NOTE));
    private JCheckBox cbItemTypePhoneMessage = new JMnemonicCheckBox(new ItemTypeAction(StringResources.PHONE_MESSAGE));
    private JCheckBox cbBoxTypeReceived = new JMnemonicCheckBox(StringResources.RECEIVED);
    private JCheckBox cbBoxTypeSent = new JMnemonicCheckBox(StringResources.SENT);
    private JCheckBox cbBoxTypePosted = new JMnemonicCheckBox(StringResources.POSTED);
    private JCheckBox cbBoxTypeDraft = new JMnemonicCheckBox(StringResources.DRAFT);
    private JComboBox cmbConflict = new OrientableComboBox(new Object[]{new AppointmentConflictWrapper(0), new AppointmentConflictWrapper(1), new AppointmentConflictWrapper(2)});
    private JList listRuleActions = new OrientableList();
    private DefaultListModel ruleActionListModel = new DefaultListModel();
    private boolean isRuleEdited;
    private String userGuid;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$dialogs$rules$CreateRuleDialog;

    public CreateRuleDialog(GWDialog gWDialog, Rule rule, String string) {
        super(gWDialog);
        this.userGuid = string;
        this.rule = rule;
        this.ruleActionList = this.rule.getActionList();
        this.isRuleEdited = true;
        this.init(gWDialog);
        this.setTitle(StringResources.EDIT_RULE);
        this.readRule(this.rule);
    }

    public CreateRuleDialog(GWDialog gWDialog, String string) {
        super(gWDialog);
        this.userGuid = string;
        this.rule = GWCommandManager.getInstance(this.userGuid).createRule();
        this.ruleActionList = this.rule.getActionList();
        this.init(gWDialog);
        this.setTitle(StringResources.NEW_RULE);
    }

    private void init(GWDialog gWDialog) {
        this.actionList = new CreateRuleDialogActionList(this, gWDialog.getController());
        this.setController(this.actionList);
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.removeAll();
        this.rebuildAddActionPopup();
        this.buildUI();
        this.taConditions.setText(StringResources.ACT_ON + ' ' + StringResources.All_ITEMS);
        this.listRuleActions.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                boolean bl;
                JList jList = (JList)listSelectionEvent.getSource();
                boolean bl2 = bl = jList.getModel().getSize() > 0;
                if (bl) {
                    RuleAction ruleAction = (RuleAction)jList.getSelectedValue();
                    if (ruleAction != null) {
                        CreateRuleDialog.this.btnEditAction.setEnabled(ruleAction.isEditable());
                    }
                    boolean bl3 = CreateRuleDialog.this.tfRuleName.getText().trim().equals("");
                    CreateRuleDialog.this.btnSave.setEnabled(!bl3);
                } else {
                    CreateRuleDialog.this.btnEditAction.setEnabled(false);
                    CreateRuleDialog.this.btnSave.setEnabled(false);
                }
                CreateRuleDialog.this.btnDeleteAction.setEnabled(bl);
            }
        });
        this.listRuleActions.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (OS.isDoubleClick(mouseEvent)) {
                    CreateRuleDialog.this.editSelectedAction();
                }
            }
        });
    }

    public void addRuleAction(RuleAction ruleAction) {
        RuleActionList ruleActionList = this.rule.getActionList();
        this.ruleActionList.addAction(ruleAction, ruleActionList.getSize());
        this.ruleActionListModel.addElement(ruleAction);
        this.listRuleActions.setSelectedValue(ruleAction, true);
    }

    private void selectNearestValue(int n) {
        int n2 = this.ruleActionListModel.getSize();
        if (n2 == 0) {
            return;
        }
        int n3 = n >= n2 ? n2 - 1 : n;
        this.listRuleActions.setSelectedIndex(n3);
    }

    public Rule getRule() {
        return this.rule;
    }

    private void rebuildAddActionPopup() {
        this.popupAddAction.removeAll();
        this.popupAddAction.add(this.actionList.getAction("Rule send mail").getMenuItem());
        this.popupAddAction.add(this.actionList.getAction("Rule forward").getMenuItem());
        this.popupAddAction.add(this.actionList.getAction("Rule delegate").getMenuItem());
        this.popupAddAction.add(this.actionList.getAction("Rule reply").getMenuItem());
        this.popupAddAction.add(this.actionList.getAction("Rule accept").getMenuItem());
        this.popupAddAction.add(this.actionList.getAction("Rule decline").getMenuItem());
        this.popupAddAction.add(this.actionList.getAction("Rule empty item").getMenuItem());
        this.popupAddAction.add(this.actionList.getAction("Rule move to folder").getMenuItem());
        this.popupAddAction.add(this.actionList.getAction("Rule link to folder").getMenuItem());
        this.popupAddAction.add(this.actionList.getAction("Rule mark as private").getMenuItem());
        this.popupAddAction.add(this.actionList.getAction("Rule mark as read").getMenuItem());
        if (this.eventExecutionType != 5 && this.eventExecutionType != 10) {
            this.popupAddAction.add(this.actionList.getAction("rule action archive").getMenuItem());
        }
        this.popupAddAction.add(this.actionList.getAction("Rule mark as unread").getMenuItem());
        this.popupAddAction.add(this.actionList.getAction("Rule stop").getMenuItem());
    }

    private void buildEventPanes() {
        this.pnlEventItem.add(new OrientableLabel(StringResources.AND_ITEMS_ARE_C));
        this.pnlEventItem.add(this.cbBoxTypeReceived);
        this.pnlEventItem.add(this.cbBoxTypeSent);
        this.pnlEventItem.add(this.cbBoxTypePosted);
        this.pnlEventItem.add(this.cbBoxTypeDraft);
        this.pnlEventFolder.add((Component)new OrientableLabel(StringResources.SELECT_FOLDER_C), "Before");
        this.tfFolder.setEditable(false);
        this.pnlEventFolder.add((Component)this.tfFolder, "Center");
        OrientableButton orientableButton = new OrientableButton(new SelectFolderAction());
        Dimension dimension = new Dimension(orientableButton.getPreferredSize().width, this.tfRuleName.getPreferredSize().height);
        orientableButton.setPreferredSize(dimension);
        this.pnlEventFolder.add((Component)orientableButton, "After");
    }

    private void rebuildDescriptionText() {
        this.taConditions.setText(this.getRule().getFilterDescription(this.getItemTypeMask()));
        this.taConditions.repaint();
    }

    private void rebuildEventPane(boolean bl, String string) {
        this.btnEvent.setText(string);
        JPanel jPanel = (JPanel)this.getContentPane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.right = 10;
        if (bl) {
            jPanel.remove(this.pnlEventItem);
            jPanel.add((Component)this.pnlEventFolder, gridBagConstraints);
        } else {
            jPanel.remove(this.pnlEventFolder);
            jPanel.add((Component)this.pnlEventItem, gridBagConstraints);
        }
    }

    private void buildUI() {
        this.popupEvent.add(OS.createMenuItemForAction(new SelectEventAction(5)));
        this.popupEvent.add(OS.createMenuItemForAction(new SelectEventAction(10)));
        this.popupEvent.add(OS.createMenuItemForAction(new SelectEventAction(4)));
        this.popupEvent.add(OS.createMenuItemForAction(new SelectEventAction(3)));
        this.popupEvent.add(OS.createMenuItemForAction(new SelectEventAction(1)));
        this.popupEvent.add(OS.createMenuItemForAction(new SelectEventAction(2)));
        this.popupEvent.add(OS.createMenuItemForAction(new SelectEventAction(9)));
        this.listRuleActions.setModel(this.ruleActionListModel);
        this.buildEventPanes();
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new GridBagLayout());
        OrientablePanel orientablePanel = new OrientablePanel(new BorderLayout(5, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        this.tfRuleName.getDocument().addDocumentListener(new EmptyStringDocumentListener(this.btnSave.getAction()){

            protected void setActionEnable(Document document) {
                try {
                    String string = document.getText(0, document.getLength());
                    boolean bl = string.trim().equals("");
                    int n = CreateRuleDialog.this.ruleActionListModel.getSize();
                    CreateRuleDialog.this.btnSave.setEnabled(!bl && n > 0);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        orientablePanel.add((Component)new JMnemonicLabel(StringResources.RULE_NAME_C, this.tfRuleName), "Before");
        orientablePanel.add((Component)this.tfRuleName, "Center");
        jPanel.add((Component)orientablePanel, gridBagConstraints);
        orientablePanel = new OrientablePanel(new BorderLayout(10, 0));
        orientablePanel.add((Component)new JMnemonicLabel(StringResources.WHEN_EVENT_IS, this.btnEvent), "Before");
        orientablePanel.add((Component)new JSeparator(), "Center");
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)orientablePanel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        this.btnEvent.setHorizontalTextPosition(10);
        jPanel.add((Component)this.btnEvent, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.pnlEventItem, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        orientablePanel = new OrientablePanel(new BorderLayout(10, 0));
        orientablePanel.add((Component)new OrientableLabel(StringResources.IF_CONDITIONS_ARE), "Before");
        orientablePanel.add((Component)new JSeparator(), "Center");
        jPanel.add((Component)orientablePanel, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)this.buildConditionsPane(), gridBagConstraints);
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridx = 0;
        orientablePanel = new OrientablePanel(new FlowLayout(4));
        OS.addButtons(orientablePanel, this.btnSave, this.btnCancel);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.anchor = 24;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)orientablePanel, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 5));
        this.setDefaultButton(this.btnSave);
        this.setCancelButton(this.btnCancel);
    }

    private JComponent buildConditionsPane() {
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets.left = 10;
        orientablePanel.add((Component)new OrientableLabel(StringResources.ITEM_TYPE_C), gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.bottom = 10;
        this.btnConditions.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedConditionsDialog advancedConditionsDialog = new AdvancedConditionsDialog(CreateRuleDialog.this, CreateRuleDialog.this.rule.getFilter(), CreateRuleDialog.this.userGuid);
                advancedConditionsDialog.showMe();
                if (advancedConditionsDialog.isActionCompleteSuccessfully()) {
                    CreateRuleDialog.this.rule.setFilter(advancedConditionsDialog.getFilter());
                    CreateRuleDialog.this.rebuildDescriptionText();
                }
            }
        });
        this.btnConditions.setText(StringResources.DEFINE_CONDITIONS_D);
        orientablePanel.add((Component)this.btnConditions, gridBagConstraints);
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        orientablePanel.add((Component)this.cbItemTypeMail, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        orientablePanel.add((Component)this.cbItemTypeAppointment, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        orientablePanel.add((Component)this.cbItemTypeTask, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        orientablePanel.add((Component)this.cbItemTypeReminderNote, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        orientablePanel.add((Component)this.cbItemTypePhoneMessage, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.taConditions.setEditable(false);
        this.taConditions.setBackground(orientablePanel.getBackground());
        orientablePanel.add((Component)new OrientableScrollPane(this.taConditions), gridBagConstraints);
        OrientablePanel orientablePanel2 = new OrientablePanel(new BorderLayout(5, 0));
        orientablePanel2.add((Component)new JMnemonicLabel(StringResources.APPOINTMENT_CONFLICT_EXIST, this.cmbConflict), "Before");
        orientablePanel2.add((Component)this.cmbConflict, "Center");
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 10;
        orientablePanel.add((Component)orientablePanel2, gridBagConstraints);
        orientablePanel2 = new OrientablePanel(new BorderLayout(10, 0));
        orientablePanel2.add((Component)new OrientableLabel(StringResources.THE_ACTIONS_ARE_C), "Before");
        orientablePanel2.add((Component)new JSeparator(), "Center");
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = 0;
        orientablePanel.add((Component)orientablePanel2, gridBagConstraints);
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 10;
        this.btnAddAction.setHorizontalTextPosition(10);
        orientablePanel.add((Component)this.btnAddAction, gridBagConstraints);
        gridBagConstraints.gridy = 9;
        orientablePanel.add((Component)this.btnEditAction, gridBagConstraints);
        gridBagConstraints.gridy = 10;
        orientablePanel.add((Component)this.btnDeleteAction, gridBagConstraints);
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        OrientableScrollPane orientableScrollPane = new OrientableScrollPane(this.listRuleActions);
        orientableScrollPane.setPreferredSize(new Dimension(20, 20));
        orientablePanel.add((Component)orientableScrollPane, gridBagConstraints);
        return orientablePanel;
    }

    private boolean isSelectFolderEventType() {
        return this.eventExecutionType == 10 || this.eventExecutionType == 4 || this.eventExecutionType == 3;
    }

    private void writeRule() {
        this.rule.setName(this.tfRuleName.getText());
        this.rule.setEventExecutionType(this.eventExecutionType);
        this.rule.setItemTypeMask(this.getItemTypeMask());
        this.rule.setConflict(((AppointmentConflictWrapper)this.cmbConflict.getSelectedItem()).getAppointmentConflictType());
        if (this.isSelectFolderEventType()) {
            if (this.selectedFolder != null) {
                this.rule.setFolder(this.selectedFolder);
            }
        } else {
            this.rule.setBoxTypeMask(this.getBoxTypeMask());
        }
        this.rule.setActionList(this.ruleActionList);
    }

    private void readRule(Rule rule) {
        this.tfRuleName.setText(rule.getName());
        this.tfFolder.setText(rule.getFolderName());
        this.selectedFolder = rule.getFolder();
        SelectEventAction selectEventAction = new SelectEventAction(rule.getEventExecutionType());
        this.rebuildEventPane(selectEventAction.isSelectFolder(), selectEventAction.toString());
        this.eventExecutionType = selectEventAction.getEventExecutionType();
        this.setItemTypeMask(rule.getItemTypeMask());
        this.cmbConflict.setSelectedItem(new AppointmentConflictWrapper(rule.getConflict()));
        if (this.eventExecutionType == 5 || this.eventExecutionType == 1 || this.eventExecutionType == 9 || this.eventExecutionType == 2) {
            this.setBoxTypeMask(rule.getBoxTypeMask());
        }
        int n = this.ruleActionList.getSize();
        for (int i = 0; i < n; ++i) {
            this.ruleActionListModel.addElement(this.ruleActionList.getActionAt(i));
        }
        if (this.ruleActionList.getSize() > 0) {
            this.listRuleActions.setSelectedIndex(0);
        }
        this.rebuildDescriptionText();
    }

    private int getBoxTypeMask() {
        int n = 0;
        if (this.cbBoxTypeReceived.isSelected()) {
            n |= 1;
        }
        if (this.cbBoxTypeSent.isSelected()) {
            n |= 2;
        }
        if (this.cbBoxTypeDraft.isSelected()) {
            n |= 8;
        }
        if (this.cbBoxTypePosted.isSelected()) {
            n |= 4;
        }
        return n;
    }

    private void setBoxTypeMask(int n) {
        if ((n & 1) != 0) {
            this.cbBoxTypeReceived.setSelected(true);
        }
        if ((n & 2) != 0) {
            this.cbBoxTypeSent.setSelected(true);
        }
        if ((n & 8) != 0) {
            this.cbBoxTypeDraft.setSelected(true);
        }
        if ((n & 4) != 0) {
            this.cbBoxTypePosted.setSelected(true);
        }
    }

    private int getItemTypeMask() {
        int n = 0;
        if (this.cbItemTypeMail.isSelected()) {
            n |= 1;
        }
        if (this.cbItemTypeAppointment.isSelected()) {
            n |= 8;
        }
        if (this.cbItemTypePhoneMessage.isSelected()) {
            n |= 0x10;
        }
        if (this.cbItemTypeReminderNote.isSelected()) {
            n |= 2;
        }
        if (this.cbItemTypeTask.isSelected()) {
            n |= 4;
        }
        return n;
    }

    private void setItemTypeMask(int n) {
        if ((n & 1) != 0) {
            this.cbItemTypeMail.setSelected(true);
        }
        if ((n & 8) != 0) {
            this.cbItemTypeAppointment.setSelected(true);
        }
        if ((n & 0x10) != 0) {
            this.cbItemTypePhoneMessage.setSelected(true);
        }
        if ((n & 2) != 0) {
            this.cbItemTypeReminderNote.setSelected(true);
        }
        if ((n & 4) != 0) {
            this.cbItemTypeTask.setSelected(true);
        }
    }

    private void deleteSelectedAction() {
        int n = this.listRuleActions.getSelectedIndex();
        if (this.ruleActionList.deleteAction(n)) {
            this.ruleActionListModel.remove(n);
        }
        this.selectNearestValue(n);
    }

    private void editSelectedAction() {
        RuleAction ruleAction = (RuleAction)this.listRuleActions.getSelectedValue();
        ActionEvent actionEvent = new ActionEvent(ruleAction, 0, "");
        if (ruleAction instanceof RuleActionForward) {
            this.actionList.getAction("Rule forward").actionPerformed(actionEvent);
        } else if (ruleAction instanceof RuleActionSend) {
            this.actionList.getAction("Rule send mail").actionPerformed(actionEvent);
        } else if (ruleAction instanceof RuleActionDelegate) {
            this.actionList.getAction("Rule delegate").actionPerformed(actionEvent);
        } else if (ruleAction instanceof RuleActionAccept) {
            this.actionList.getAction("Rule accept").actionPerformed(actionEvent);
        } else if (ruleAction instanceof RuleActionDelete) {
            this.actionList.getAction("Rule decline").actionPerformed(actionEvent);
        } else if (ruleAction instanceof RuleActionReply) {
            this.actionList.getAction("Rule reply").actionPerformed(actionEvent);
        } else if (ruleAction instanceof RuleActionLink) {
            this.actionList.getAction("Rule link to folder").actionPerformed(actionEvent);
        } else if (ruleAction instanceof RuleActionMove) {
            this.actionList.getAction("Rule move to folder").actionPerformed(actionEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SelectFolderAction
    extends AbstractAction {
        public SelectFolderAction() {
            super("", ImageResources.ICON_OPEN_FOLDER);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractFolder abstractFolder = null;
            if (CreateRuleDialog.this.selectedFolder == null) {
                try {
                    abstractFolder = GWCommandManager.getInstance(CreateRuleDialog.this.userGuid).getRootFolder();
                }
                catch (GWCommandException gWCommandException) {
                    logger.error((Object)gWCommandException);
                    logger.debug((Object)gWCommandException, (Throwable)gWCommandException);
                }
            } else {
                abstractFolder = GWCommandManager.getInstance(CreateRuleDialog.this.userGuid).getGWFolder(CreateRuleDialog.this.selectedFolder);
            }
            FoldersDialog foldersDialog = new FoldersDialog(CreateRuleDialog.this, abstractFolder, StringResources.SELECT_THE_FOLDER_BELOW);
            foldersDialog.showMe();
            if (foldersDialog.isActionCompleteSuccessfully()) {
                Folder folder = foldersDialog.getSelectedFolder().getNativeFolder();
                CreateRuleDialog.this.selectedFolder = folder;
                CreateRuleDialog.this.tfFolder.setText(folder.getFullPath());
            }
        }
    }

    private class ItemTypeAction
    extends AbstractAction {
        public ItemTypeAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CreateRuleDialog.this.rebuildDescriptionText();
        }
    }

    private class SelectEventAction
    extends AbstractAction {
        private boolean isSelectFolder;
        private int eventExecutionType;

        private void init() {
            switch (this.eventExecutionType) {
                case 5: {
                    this.putValue("Name", StringResources.NEW_ITEM);
                    this.isSelectFolder = false;
                    break;
                }
                case 10: {
                    this.putValue("Name", StringResources.FILED_ITEM);
                    this.isSelectFolder = true;
                    break;
                }
                case 4: {
                    this.putValue("Name", StringResources.OPEN_FOLDER);
                    this.isSelectFolder = true;
                    break;
                }
                case 3: {
                    this.putValue("Name", StringResources.CLOSE_FOLDER);
                    this.isSelectFolder = true;
                    break;
                }
                case 1: {
                    this.putValue("Name", StringResources.STARTUP);
                    this.isSelectFolder = false;
                    break;
                }
                case 2: {
                    this.putValue("Name", StringResources.EXIT);
                    this.isSelectFolder = false;
                    break;
                }
                case 9: {
                    this.putValue("Name", StringResources.USER_ACTIVATED);
                    this.isSelectFolder = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        public SelectEventAction(int n) {
            this.eventExecutionType = n;
            this.init();
        }

        public boolean isSelectFolder() {
            return this.isSelectFolder;
        }

        public int getEventExecutionType() {
            return this.eventExecutionType;
        }

        public String toString() {
            return (String)this.getValue("Name");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            CreateRuleDialog.this.eventExecutionType = this.eventExecutionType;
            CreateRuleDialog.this.rebuildEventPane(this.isSelectFolder, jMenuItem.getText());
        }
    }

    private class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            super(StringResources.DELETE_ACTION);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CreateRuleDialog.this.deleteSelectedAction();
        }
    }

    private class EditAction
    extends AbstractAction {
        public EditAction() {
            super(StringResources.EDIT_ACTION);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CreateRuleDialog.this.editSelectedAction();
        }
    }

    private class AddAction
    extends AbstractAction {
        public AddAction() {
            super(StringResources.ADD_ACTION, ImageResources.ADV_FILTER_UP_DOWN);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            CreateRuleDialog.this.rebuildAddActionPopup();
            CreateRuleDialog.this.popupAddAction.show(jButton, 0, jButton.getHeight());
        }
    }

    private class EventAction
    extends AbstractAction {
        public EventAction() {
            super(StringResources.NEW_ITEM, ImageResources.ADV_FILTER_UP_DOWN);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            CreateRuleDialog.this.popupEvent.show(jButton, 0, 0);
        }
    }

    protected class SaveAction
    extends AbstractAction {
        public SaveAction() {
            super(StringResources.SAVE);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CreateRuleDialog.this.writeRule();
            boolean bl = CreateRuleDialog.this.rule.save();
            if (bl && !CreateRuleDialog.this.isRuleEdited) {
                RuleList ruleList = GWCommandManager.getInstance(CreateRuleDialog.this.userGuid).getRuleList();
                int n = ruleList.addRule(CreateRuleDialog.this.rule, -1);
                ruleList.saveRule(n);
            }
            CreateRuleDialog.this.getController().processCommand(new Command(980));
            CreateRuleDialog.this.dispose();
        }
    }
}

